/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.safari;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.internal.Base64Encoder;
import org.openqa.selenium.io.TemporaryFilesystem;
import org.openqa.selenium.remote.DesiredCapabilities;

public class SafariOptions {
    public static final String CAPABILITY = "safari.options";
    private Optional<File> dataDir = Optional.absent();
    private List<File> extensionFiles = Lists.newArrayList();
    private int port = 0;
    private boolean skipExtensionInstallation = false;
    private boolean useCleanSession = false;
    private boolean useCustomDriverExtension = false;

    public static SafariOptions fromCapabilities(Capabilities capabilities) throws WebDriverException {
        Object cap = capabilities.getCapability(CAPABILITY);
        if (cap instanceof SafariOptions) {
            return (SafariOptions)cap;
        }
        if (cap instanceof Map) {
            try {
                return SafariOptions.fromJsonMap((Map)cap);
            }
            catch (IOException e) {
                throw new WebDriverException(e);
            }
        }
        return new SafariOptions();
    }

    public void addExtensions(File ... paths) {
        this.addExtensions((List<File>)ImmutableList.copyOf((Object[])paths));
    }

    public void addExtensions(List<File> paths) {
        for (File path : paths) {
            SafariOptions.verifyPathIsSafariextz(path);
        }
        this.extensionFiles.addAll(paths);
    }

    public void setDataDir(File dataDir) {
        this.dataDir = Optional.fromNullable((Object)dataDir);
    }

    public void setDriverExtension(File driverExtension) {
        if (this.useCustomDriverExtension) {
            this.extensionFiles.remove(0);
            this.useCustomDriverExtension = false;
        }
        if (driverExtension != null) {
            SafariOptions.verifyPathIsSafariextz(driverExtension);
            this.extensionFiles.add(0, driverExtension);
            this.useCustomDriverExtension = true;
        }
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setSkipExtensionInstallation(boolean skipExtensionInstallation) {
        this.skipExtensionInstallation = skipExtensionInstallation;
    }

    public void setUseCleanSession(boolean useCleanSession) {
        this.useCleanSession = useCleanSession;
    }

    public Optional<File> getDataDir() {
        return this.dataDir;
    }

    public List<File> getExtensions() {
        if (this.skipExtensionInstallation) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf(this.extensionFiles);
    }

    public int getPort() {
        return this.port;
    }

    public boolean getSkipExtensionInstallation() {
        return this.skipExtensionInstallation;
    }

    public boolean getUseCustomDriverExtension() {
        return this.useCustomDriverExtension || this.skipExtensionInstallation;
    }

    public boolean getUseCleanSession() {
        return this.useCleanSession;
    }

    public JsonElement toJson() throws IOException {
        JsonObject options = new JsonObject();
        if (this.dataDir.isPresent()) {
            options.addProperty("dataDir", ((File)this.dataDir.get()).getPath());
        }
        options.add("extensions", (JsonElement)this.extensionsToJson());
        options.addProperty("port", (Number)this.port);
        options.addProperty("skipExtensionInstallation", Boolean.valueOf(this.skipExtensionInstallation));
        options.addProperty("cleanSession", Boolean.valueOf(this.useCleanSession));
        options.addProperty("customDriverExtension", Boolean.valueOf(this.useCustomDriverExtension));
        return options;
    }

    private static SafariOptions fromJsonMap(Map options) throws IOException {
        Boolean useCustomDriverExtension;
        Boolean useCleanSession;
        Boolean skipExtensionInstallation;
        Number port;
        List extensions;
        SafariOptions safariOptions = new SafariOptions();
        String path = (String)options.get("dataDir");
        if (path != null) {
            safariOptions.setDataDir(new File(path));
        }
        if ((extensions = (List)options.get("extensions")) != null) {
            safariOptions.addExtensionsFromJsonList(extensions);
        }
        if ((port = (Number)options.get("port")) != null) {
            safariOptions.setPort(port.intValue());
        }
        if ((skipExtensionInstallation = (Boolean)options.get("skipExtensionInstallation")) != null) {
            safariOptions.setSkipExtensionInstallation(skipExtensionInstallation);
        }
        if ((useCleanSession = (Boolean)options.get("cleanSession")) != null) {
            safariOptions.setUseCleanSession(useCleanSession);
        }
        if ((useCustomDriverExtension = (Boolean)options.get("customDriverExtension")) != null) {
            safariOptions.useCustomDriverExtension = useCustomDriverExtension;
        }
        return safariOptions;
    }

    private static void verifyPathIsSafariextz(File path) {
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkArgument((boolean)path.exists(), (String)"%s does not exist", (Object[])new Object[]{path.getAbsolutePath()});
        Preconditions.checkArgument((!path.isDirectory() ? 1 : 0) != 0, (String)"%s is a directory", (Object[])new Object[]{path.getAbsolutePath()});
        Preconditions.checkArgument((boolean)path.getName().endsWith(".safariextz"), (String)"%s does not end with .safariextz", (Object[])new Object[]{path.getName()});
    }

    private JsonArray extensionsToJson() throws IOException {
        JsonArray extensionsList = new JsonArray();
        for (File path : this.extensionFiles) {
            JsonObject extensionInfo = new JsonObject();
            extensionInfo.addProperty("filename", path.getName());
            String encoded = new Base64Encoder().encode(Files.toByteArray((File)path));
            extensionInfo.addProperty("contents", encoded);
            extensionsList.add((JsonElement)extensionInfo);
        }
        return extensionsList;
    }

    private void addExtensionsFromJsonList(List<Map<String, String>> extensions) throws IOException {
        File dir = TemporaryFilesystem.getDefaultTmpFS().createTempDir("SafariOptions", "safaridriver");
        for (Map<String, String> extensionInfo : extensions) {
            String path = extensionInfo.get("filename");
            String encoded = extensionInfo.get("contents");
            byte[] decoded = new Base64Encoder().decode(encoded);
            File file = new File(dir, path);
            Files.write((byte[])decoded, (File)file);
            this.addExtensions(file);
        }
    }

    DesiredCapabilities toCapabilities() {
        DesiredCapabilities capabilities = DesiredCapabilities.safari();
        capabilities.setCapability(CAPABILITY, this);
        return capabilities;
    }

    public boolean equals(Object other) {
        if (!(other instanceof SafariOptions)) {
            return false;
        }
        SafariOptions that = (SafariOptions)other;
        return Objects.equal(this.dataDir, that.dataDir) && Objects.equal(this.extensionFiles, that.extensionFiles) && this.port == that.port && this.skipExtensionInstallation == that.skipExtensionInstallation && this.useCleanSession == that.useCleanSession && this.useCustomDriverExtension == that.useCustomDriverExtension;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.dataDir, this.extensionFiles, this.port, this.skipExtensionInstallation, this.useCleanSession, this.useCustomDriverExtension});
    }

    private static class Option {
        private static final String CLEAN_SESSION = "cleanSession";
        private static final String CUSTOM_DRIVER_EXENSION = "customDriverExtension";
        private static final String DATA_DIR = "dataDir";
        private static final String EXTENSIONS = "extensions";
        private static final String PORT = "port";
        private static final String SKIP_EXTENSION_INSTALLATION = "skipExtensionInstallation";

        private Option() {
        }
    }
}

