/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.FilePanel;

import com.rhinosoft.FilePanel.CFileModel;
import com.rhinosoft.base.CConversionUtils;
import com.rhinosoft.base.files.CFile;
import com.rhinosoft.base.gui.CColorUtils;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class CFileListCellRenderer
extends DefaultListCellRenderer {
    private static final int TRANSPARENCY_VALUE = 128;
    private boolean m_bHasFocusClrs = false;

    @Override
    public Component getListCellRendererComponent(JList rList, Object rVal, int nIndex, boolean bIsSelected, boolean bHasFocus) {
        if (CFileListCellRenderer.IsDropLocDir(rList, nIndex)) {
            bIsSelected = true;
        }
        super.getListCellRendererComponent((JList<?>)rList, rVal, nIndex, bIsSelected, bHasFocus);
        this.UpdateHasFocusColor(bIsSelected, rList, this);
        this.setOpaque(rList.isOpaque());
        this.setHorizontalAlignment(2);
        this.setVerticalAlignment(0);
        this.setHorizontalTextPosition(4);
        this.setVerticalTextPosition(0);
        if (rVal instanceof CFile) {
            CFile fFile = (CFile)rVal;
            this.setIcon(fFile.GetIcon16());
            this.setText(fFile.GetDisplayName());
        }
        return this;
    }

    public static boolean IsDropLocDir(JList rList, int nIndex) {
        boolean bIsDropLocDir = false;
        if (rList != null) {
            CFileModel rFileModel;
            CFile fRowFile;
            ListModel rModel;
            Object objDropIndex = rList.getClientProperty("DropRow");
            int nDropIndex = CConversionUtils.ConvertToInt(objDropIndex);
            if (CConversionUtils.IsValidInt(nDropIndex) && nDropIndex == nIndex && (rModel = rList.getModel()) instanceof CFileModel && (fRowFile = (rFileModel = (CFileModel)rModel).GetFileAt(nIndex)) != null && fRowFile.IsDirectory()) {
                bIsDropLocDir = true;
            }
        } else if (CMainFrame.GetDebugLogger() != null) {
            CMainFrame.GetDebugLogger().Info("ASSERT:  Programming error, rList = null");
        }
        return bIsDropLocDir;
    }

    public Rectangle GetEditorRect(JList rList, int nIndex) {
        Rectangle rScreenCoords = new Rectangle(0, 0, 0, 0);
        if (rList != null) {
            Icon rIcon;
            Insets rInsets;
            Point ptScreenLoc = new Point(0, 0);
            Rectangle rCellRect = rList.getCellBounds(nIndex, nIndex);
            ptScreenLoc.setLocation(rCellRect.x, rCellRect.y);
            SwingUtilities.convertPointToScreen(ptScreenLoc, rList);
            rScreenCoords.x = ptScreenLoc.x;
            rScreenCoords.y = ptScreenLoc.y;
            rScreenCoords.width = rCellRect.width;
            rScreenCoords.height = rCellRect.height;
            int x2 = rScreenCoords.x;
            int nWidth2 = rScreenCoords.width;
            Border rBorder = this.getBorder();
            if (rBorder != null && (rInsets = rBorder.getBorderInsets(this)) != null) {
                x2 += rInsets.left;
                nWidth2 -= rInsets.left;
            }
            if ((rIcon = this.getIcon()) != null) {
                int nImageWidth = rIcon.getIconWidth();
                x2 += nImageWidth;
                nWidth2 -= nImageWidth;
            }
            int nImageGap = 1;
            rScreenCoords.x = x2 += nImageGap;
            if ((nWidth2 -= nImageGap) > 0) {
                rScreenCoords.width = nWidth2;
            }
        } else if (CMainFrame.GetDebugLogger() != null) {
            CMainFrame.GetDebugLogger().Info("ASSERT:  Programming error, rList = null");
        }
        return rScreenCoords;
    }

    public void SetHasFocusClrs(boolean bHasFocusClrs) {
        this.m_bHasFocusClrs = bHasFocusClrs;
    }

    public boolean GetHasFocusClrs() {
        return this.m_bHasFocusClrs;
    }

    private void UpdateHasFocusColor(boolean bIsSelected, JList rList, Component ... arComps) {
        Color clrListFore = UIManager.getColor("List.foreground");
        Color clrListBack = UIManager.getColor("List.background");
        Color clrListForeSel = UIManager.getColor("List.selectionForeground");
        Color clrListBackSel = UIManager.getColor("List.selectionBackground");
        Color clrFore = clrListFore;
        Color clrBack = clrListBack;
        if (bIsSelected) {
            clrFore = clrListForeSel;
            clrBack = clrListBackSel;
            if (!this.GetHasFocusClrs()) {
                clrBack = Color.LIGHT_GRAY;
                if (!CColorUtils.IsADarkColor(clrFore) && !CColorUtils.IsADarkColor(clrBack)) {
                    clrFore = clrListFore.getRGB() < clrListForeSel.getRGB() ? clrListFore : clrListForeSel;
                } else if (CColorUtils.IsADarkColor(clrFore) && CColorUtils.IsADarkColor(clrBack)) {
                    clrFore = clrListFore.getRGB() > clrListForeSel.getRGB() ? clrListFore : clrListForeSel;
                }
            }
        }
        if (arComps != null) {
            for (int nIdx = 0; nIdx < arComps.length; ++nIdx) {
                Component rNextComp = arComps[nIdx];
                if (rNextComp == null) continue;
                rNextComp.setForeground(clrFore);
                rNextComp.setBackground(clrBack);
            }
        }
        this.setForeground(clrFore);
        this.setBackground(clrBack);
    }
}

