/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.FilePanel;

import com.jidesoft.docking.DockableFrame;
import com.rhinosoft.FilePanel.CDragDropRightClickMenu;
import com.rhinosoft.FilePanel.CFileCellEditor;
import com.rhinosoft.FilePanel.CFileListCellImageRenderer;
import com.rhinosoft.FilePanel.CFileListCellRenderer;
import com.rhinosoft.FilePanel.CFileModel;
import com.rhinosoft.FilePanel.CFileSelModel;
import com.rhinosoft.FilePanel.CFileTableCellRenderer;
import com.rhinosoft.FilePanel.CFileTableHeaderRenderer;
import com.rhinosoft.FilePanel.CFileTableSorter;
import com.rhinosoft.FilePanel.CTypeAhead;
import com.rhinosoft.base.files.CFile;
import com.rhinosoft.base.files.CFileSystemUtils;
import com.rhinosoft.base.files.CPath;
import com.rhinosoft.base.gui.CColorUtils;
import com.rhinosoft.base.gui.components.files.preview.CFilePreviewPane;
import com.rhinosoft.base.gui.events.CBaseAction;
import com.rhinosoft.base.gui.events.CRhinoEvent;
import com.rhinosoft.base.gui.frames.CBaseStatusBar;
import com.rhinosoft.base.gui.tables.CTableUtils;
import com.rhinosoft.base.gui.tables.CTableViewport;
import com.rhinosoft.base.gui.tables.CViewport;
import com.rhinosoft.fvjv.gui.dialogs.CRenameDlg;
import com.rhinosoft.fvjv.gui.events.CMainEventQueue;
import com.rhinosoft.fvjv.gui.events.CTransferMenuItem;
import com.rhinosoft.fvjv.gui.events.dragdrop.CDragDropHandler;
import com.rhinosoft.fvjv.gui.events.dragdrop.ICompleteDragDrop;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.gui.frames.IArchive;
import com.rhinosoft.fvjv.gui.frames.browser.CBrowserPanel;
import com.rhinosoft.fvjv.gui.frames.browser.CSearchStateEvent;
import com.rhinosoft.fvjv.gui.frames.browser.ISearchStateListener;
import com.rhinosoft.fvjv.strings.CString;
import com.rhinosoft.fvjv.threads.CBaseThread;
import com.rhinosoft.fvjv.threads.CThreadMsg;
import com.rhinosoft.fvjv.threads.CThreadMsgThumb;
import com.rhinosoft.fvjv.threads.CThreadMsgTransfer;
import com.rhinosoft.fvjv.threads.remote.CRemoteThread;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.text.NumberFormat;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public abstract class CFilePanel
extends JScrollPane
implements MouseListener,
ComponentListener,
KeyListener,
ChangeListener,
ListSelectionListener,
TableModelListener,
ListDataListener,
MouseMotionListener,
TableColumnModelListener,
FocusListener,
ActionListener,
ICompleteDragDrop {
    protected static boolean DEBUG = CMainFrame.DEBUG;
    protected static boolean DEBUG_TRACE_METHODS;
    protected static boolean DEBUG_LOAD_COLS;
    protected static boolean DEBUG_TRACK_DND_DRAG_EVENTS;
    protected static boolean DEBUG_TRACK_DND_DROP_EVENTS;
    protected static boolean DEBUG_TRACK_IMPORT_DATA;
    protected static boolean DEBUG_RENAME_EDITOR;
    public static String HTML_FMT_BOLD;
    public static final String DELIMITER_COL_WIDTHS = ",";
    public static final int DEF_COL_WIDTH = 90;
    public static final int ON_RENAME_CLICK_TIMER = 500;
    private boolean m_bInitialized;
    private JViewport m_ListViewport;
    private JViewport m_TableViewport;
    private JTable m_Table;
    private JList m_List;
    private CFileModel m_DataModel;
    private CFileSelModel m_SelModel;
    private CFileTableHeaderRenderer m_jHeaderRenderer;
    private CFileTableSorter m_jTableSorter;
    private CFileListCellRenderer m_ListCellRenderer;
    private CFileListCellImageRenderer m_ListThumbRenderer;
    private int m_nCurView;
    private CFileCellEditor m_jCellEditor;
    private CDragDropHandler m_DragDropHandler;
    private MouseEvent m_FirstMouseEvent;
    private boolean m_bStateChangeHideEditor;
    private CBaseThread m_rtGeneralThread;
    private CBaseThread m_rtThumbThread;
    private CFilePreviewPane m_rcPreviewPane;
    private JPopupMenu m_cPopupMenu;
    private JMenuItem m_cDownloadPopupMenuItem;
    private JMenu m_cDownloadToPopupMenu;
    private JMenuItem m_cUploadPopupMenuItem;
    private JMenu m_cUploadToPopupMenu;
    private JMenuItem m_cSyncFoldersMenuItem;
    private JMenu m_cSyncFoldersToMenu;
    private long m_lUniqueID = -1L;
    private int m_nThumbWidth;
    private int m_nThumbHeight;
    private Timer m_RenameTimer;
    private String m_sFrameKey;
    private CTypeAhead m_TypeAhead;
    private Vector<ISearchStateListener> m_aSearchStateListeners;
    private TableColumn m_rParentPathCol;
    private CSearchStateEvent.SEARCH_STATE m_nSearchState;
    private int m_nViewColParentPathIdx;
    private int m_nSelLeadRow;
    private String m_sLeadSelAbsPath;
    private String[] m_asSelAbsPaths;

    public CFilePanel(CBaseThread rtGeneralThread, CBaseThread rtThumbThread, long lUniqueID) {
        this.InitVars(rtGeneralThread, rtThumbThread, lUniqueID);
    }

    protected abstract String GetKeyColWidth(int var1);

    protected abstract String GetKeyColIndex(int var1);

    protected abstract String GetKeySortCol();

    protected abstract String GetKeySortDir();

    protected abstract String GetKeyViewMode();

    protected abstract void LoadSyncFoldersToMenuItems(JMenu var1);

    protected long GetUniqueID() {
        return this.m_lUniqueID;
    }

    private void InitVars(CBaseThread rtGeneralThread, CBaseThread rtThumbThread, long lUniqueID) {
        this.m_aSearchStateListeners = new Vector();
        this.SetGeneralThread(rtGeneralThread);
        this.SetThumbThread(rtThumbThread);
        this.m_lUniqueID = lUniqueID;
        this.m_bStateChangeHideEditor = true;
        this.m_bInitialized = false;
        this.InitPopupMenu();
        this.m_nThumbWidth = 100;
        this.m_nThumbHeight = 100;
        this.m_RenameTimer = new Timer(500, this);
        this.m_TypeAhead = new CTypeAhead(this);
        this.m_nViewColParentPathIdx = 4;
    }

    public void OnCreate() {
        Integer nVal;
        this.m_nCurView = 3;
        this.m_bInitialized = false;
        this.m_DragDropHandler = new CDragDropHandler();
        this.m_DataModel = new CFileModel();
        if (CColorUtils.IsADarkColor(this.getBackground())) {
            this.setBorder(BorderFactory.createLineBorder(Color.WHITE));
        } else {
            this.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        }
        if (this.GetModel() != null) {
            this.m_Table = new JTable(this.GetModel());
            this.m_List = new JList(this.GetModel());
            this.m_SelModel = new CFileSelModel();
            this.GetModel().SetSelModel(this.GetSelModel());
            if (this.GetTable() != null) {
                TableColumnModel rColModel;
                if (this.GetSelModel() != null) {
                    this.GetTable().setSelectionModel(this.GetSelModel());
                }
                this.GetModel().SetOwnerTable(this.GetTable());
                this.GetTable().addMouseListener(this);
                this.m_TableViewport = new CTableViewport(this.GetTable());
                if (this.GetTableViewport() != null) {
                    ((CTableViewport)this.GetTableViewport()).SetModelCol(0);
                    this.GetTableViewport().addMouseListener(this);
                    this.m_jTableSorter = new CFileTableSorter(((CTableViewport)this.GetTableViewport()).GetModelCol());
                }
                if ((rColModel = this.GetTable().getColumnModel()) != null) {
                    if (rColModel.getColumnCount() != this.GetModel().getColumnCount()) {
                        JOptionPane.showConfirmDialog(null, "These have to match in order for us to set the appropriate column identifiers");
                    }
                    for (int nIdx = 0; nIdx < rColModel.getColumnCount(); ++nIdx) {
                        TableColumn rColumn = rColModel.getColumn(nIdx);
                        if (rColumn == null) continue;
                        rColumn.setCellRenderer(new CFileTableCellRenderer(this.GetTable(), this.GetTableViewport(), this.GetArchive()));
                        rColumn.setIdentifier(nIdx);
                        if (nIdx != 4) continue;
                        this.SetParentPathTableColumn(rColumn);
                        this.HideParentPathColumn();
                    }
                    rColModel.addColumnModelListener(this);
                }
                this.GetTable().setAutoResizeMode(0);
                JTableHeader jHeader = this.GetTable().getTableHeader();
                if (jHeader != null) {
                    this.m_jHeaderRenderer = new CFileTableHeaderRenderer(this.m_jTableSorter);
                    this.m_jHeaderRenderer.UpdateUIRenderer();
                    jHeader.setDefaultRenderer(this.m_jHeaderRenderer);
                    jHeader.addMouseListener(this);
                }
                this.GetTable().addComponentListener(this);
                this.GetTable().addKeyListener(this);
                if (this.GetTableViewport() != null) {
                    this.GetTableViewport().addKeyListener(this);
                }
                if (this.GetTableViewport() != null) {
                    this.GetTableViewport().addChangeListener(this);
                }
                if (this.m_DragDropHandler != null) {
                    this.GetTable().addMouseMotionListener(this);
                    this.GetTable().setTransferHandler(this.m_DragDropHandler);
                    this.GetTable().setDragEnabled(true);
                    this.GetTable().setDropMode(DropMode.USE_SELECTION);
                    if (this.GetTableViewport() != null) {
                        this.GetTableViewport().setTransferHandler(this.m_DragDropHandler);
                    }
                }
            }
            if (this.GetList() != null) {
                if (this.GetSelModel() != null) {
                    this.GetList().setSelectionModel(this.GetSelModel());
                }
                this.GetModel().SetOwnerList(this.GetList());
                this.GetList().addMouseListener(this);
                this.m_ListViewport = new CViewport(this.GetList());
                this.m_ListCellRenderer = new CFileListCellRenderer();
                this.m_ListThumbRenderer = new CFileListCellImageRenderer(this.m_nCurView, this);
                this.GetList().setCellRenderer(this.GetListCellRenderer(this.m_nCurView));
                if (this.GetListViewport() != null) {
                    this.GetListViewport().addComponentListener(this);
                }
                this.GetList().addKeyListener(this);
                if (this.GetListViewport() != null) {
                    this.GetListViewport().addKeyListener(this);
                    this.GetListViewport().addChangeListener(this);
                }
                if (this.m_DragDropHandler != null) {
                    this.GetList().addMouseMotionListener(this);
                    this.GetList().setTransferHandler(this.m_DragDropHandler);
                    this.GetList().setDragEnabled(true);
                    this.GetList().setDropMode(DropMode.USE_SELECTION);
                }
            }
            this.GetModel().addTableModelListener(this);
            this.GetModel().addListDataListener(this);
            if (this.GetSelModel() != null) {
                this.GetSelModel().addListSelectionListener(this);
            }
            this.m_jCellEditor = new CFileCellEditor(this, this.GetGeneralThread());
        }
        if (this.GetTable() != null) {
            this.GetTable().addFocusListener(this);
        }
        if (this.GetList() != null) {
            this.GetList().addFocusListener(this);
        }
        this.addFocusListener(this);
        IArchive rArchive = this.GetArchive();
        if (rArchive != null && (nVal = rArchive.GetValueInt(this.GetKeyViewMode(), 3)) != null) {
            this.m_nCurView = nVal;
        }
        this.SetView(this.m_nCurView);
        this.addKeyListener(this);
        if (rArchive != null) {
            this.LoadColIndices();
            if (this.m_jTableSorter != null) {
                nVal = rArchive.GetValueInt(this.GetKeySortCol(), this.GetDefSortCol());
                if (nVal != null) {
                    this.m_jTableSorter.SetSortModelCol(nVal);
                    if (this.GetTableViewport() != null) {
                        ((CTableViewport)this.GetTableViewport()).SetModelCol(nVal);
                    }
                }
                if ((nVal = rArchive.GetValueInt(this.GetKeySortDir(), this.GetDefSortDir())) != null) {
                    this.m_jTableSorter.SetSortDirection(nVal);
                }
            }
        }
        this.m_bInitialized = true;
    }

    public void OnInitialUpdate() {
        if (DEBUG_TRACE_METHODS) {
            System.out.println("CFilePanel.OnInitialUpdate -->");
        }
        this.m_bInitialized = false;
        this.SetView(this.m_nCurView);
        this.m_bInitialized = true;
        this.SortModelRetainSelection();
        this.ShowInitialCaret();
        this.LoadColWidths();
        if (DEBUG_TRACE_METHODS) {
            System.out.println("CFilePanel.OnInitialUpdate <--");
        }
    }

    private void ShowInitialCaret() {
        int nSelIdx;
        if (this.GetModel() != null && this.GetSelModel() != null && this.GetModel().getRowCount() > 0 && ((nSelIdx = this.GetSelModel().getLeadSelectionIndex()) < 0 || nSelIdx >= this.GetModel().getRowCount())) {
            this.GetSelModel().setLeadAnchorNotificationEnabled(false);
            this.GetSelModel().moveLeadSelectionIndex(0);
            this.GetSelModel().setLeadAnchorNotificationEnabled(true);
        }
    }

    public void SetView(int nView) {
        String sActiveKey;
        if (this.m_bInitialized && nView == this.m_nCurView) {
            return;
        }
        this.StopLoadingThumbs();
        this.m_nCurView = nView;
        this.UpdateBtnStates();
        this.UpdateBtnSelections();
        if (this.GetArchive() != null) {
            this.GetArchive().SetValue(this.GetKeyViewMode(), this.m_nCurView, 3);
        }
        boolean bSetFocus = false;
        CBrowserPanel rPanel = (CBrowserPanel)SwingUtilities.getAncestorOfClass(CBrowserPanel.class, this);
        if (rPanel != null && ((sActiveKey = rPanel.getDockingManager().getActiveFrameKey()) == null || sActiveKey.isEmpty())) {
            bSetFocus = true;
        }
        if (nView == 3) {
            if (this.GetListViewport() != null) {
                this.remove(this.GetListViewport());
            }
            this.setViewport(this.GetTableViewport());
            if (bSetFocus) {
                this.GetTable().grabFocus();
            }
            this.m_jCellEditor.SetOwner(this.GetTable());
            this.UpdateScrollBars(this.GetTableViewport(), this.GetTable());
        } else {
            this.GetList().setCellRenderer(this.GetListCellRenderer(nView));
            this.remove(this.GetTableViewport());
            if (this.GetListViewport() != null) {
                this.setViewport(this.GetListViewport());
            }
            if (bSetFocus) {
                this.GetList().grabFocus();
            }
            this.m_jCellEditor.SetOwner(this.GetList());
            this.GetList().setFixedCellHeight(-1);
            this.GetList().setFixedCellWidth(-1);
            int nCurLayout = 1;
            if (nView != 2) {
                nCurLayout = 2;
            }
            if (nView == 4 || nView == 0) {
                this.RefreshThumbCells(false);
            } else {
                int nCellWidth = 50;
                char[] aChars = new char[25];
                for (int nIdx = 0; nIdx < aChars.length; ++nIdx) {
                    aChars[nIdx] = 87;
                }
                String sText = new String(aChars);
                Dimension dimTxtSize = CString.GetTextSize(sText, this.GetList().getFont(), this.GetList().getGraphics());
                if (dimTxtSize != null) {
                    nCellWidth = Math.max(nCellWidth, dimTxtSize.width);
                }
                this.GetList().setFixedCellWidth(nCellWidth);
                this.GetList().setFixedCellHeight(-1);
            }
            this.m_ListThumbRenderer.SetView(this.m_nCurView);
            this.GetList().setLayoutOrientation(nCurLayout);
            this.RefreshListCellLayout();
            this.UpdateScrollBars(this.GetListViewport(), this.GetList());
        }
        this.updateUI();
    }

    public int GetNextViewEvent() {
        int nNextViewEvent = this.m_nCurView + 1;
        if (nNextViewEvent > 4) {
            nNextViewEvent = 0;
        }
        switch (nNextViewEvent) {
            case 0: {
                nNextViewEvent = 2101;
                break;
            }
            case 1: {
                nNextViewEvent = 2102;
                break;
            }
            case 2: {
                nNextViewEvent = 2103;
                break;
            }
            case 3: {
                nNextViewEvent = 2104;
                break;
            }
            case 4: {
                nNextViewEvent = 2105;
            }
        }
        return nNextViewEvent;
    }

    private void UpdateScrollBars(JViewport rViewport, JComponent rComp) {
        if (rViewport != null && rComp != null) {
            JScrollBar rHorzScrollBar = this.getHorizontalScrollBar();
            JScrollBar rVertScrollBar = this.getVerticalScrollBar();
            rHorzScrollBar.setMinimum(0);
            rHorzScrollBar.setVisibleAmount(rViewport.getWidth());
            rHorzScrollBar.setMaximum(rComp.getWidth());
            rVertScrollBar.setMinimum(0);
            rVertScrollBar.setVisibleAmount(rViewport.getHeight());
            rVertScrollBar.setMaximum(rComp.getHeight());
        } else if (CMainFrame.GetDebugLogger() != null) {
            CMainFrame.GetDebugLogger().Info("ASSERT:  Programming error, invalid method parms");
        }
    }

    public void SetDisplayFile(CFile fDisplayFile) {
        this.SetDisplayFile(fDisplayFile, true);
    }

    public void SetDisplayFile(CFile fDisplayFile, boolean bGetUpToDateFileList) {
        Rectangle rScrollTo;
        if (DEBUG_TRACE_METHODS) {
            System.out.println("CFilePanel.SetDisplayFile -->");
        }
        this.StopLoadingThumbs();
        this.GetModel().SetDisplayFile(fDisplayFile, bGetUpToDateFileList);
        this.SortModel();
        if (this.m_nCurView == 4) {
            this.StartLoadingThumbs(fDisplayFile, bGetUpToDateFileList);
        }
        if ((rScrollTo = this.GetTable().getCellRect(0, 0, true)) != null) {
            this.GetTable().scrollRectToVisible(rScrollTo);
        }
        if ((rScrollTo = this.GetList().getCellBounds(0, 0)) != null) {
            this.GetList().scrollRectToVisible(rScrollTo);
        }
        this.ShowInitialCaret();
        if (this.GetPreviewPane() != null) {
            this.GetPreviewPane().SetFile(null);
        }
        this.PostStatusInfo();
        if (DEBUG_TRACE_METHODS) {
            System.out.println("CFilePanel.SetDisplayFile <--");
        }
    }

    @Override
    public void mouseClicked(MouseEvent jEvent) {
        if (jEvent != null) {
            Object objSource = jEvent.getSource();
            boolean bCtrlKeyDown = jEvent.isControlDown();
            boolean bShiftKeyDown = jEvent.isShiftDown();
            int nClickCount = jEvent.getClickCount();
            if (nClickCount == 2) {
                if (SwingUtilities.isLeftMouseButton(jEvent)) {
                    this.StopRenameTimer();
                    this.OnLeftDoubleClick(jEvent);
                }
            } else if (nClickCount == 1) {
                if (SwingUtilities.isLeftMouseButton(jEvent)) {
                    JTableHeader jTableHeader = this.GetTable().getTableHeader();
                    int nCursorType = jTableHeader.getCursor().getType();
                    if (nCursorType == 0) {
                        if (objSource == jTableHeader) {
                            Point ptMouse = jEvent.getPoint();
                            int nModelColClicked = CTableUtils.GetModelColFromPoint(this.GetTable(), ptMouse);
                            if (nModelColClicked > -1 && nModelColClicked < this.GetTable().getColumnCount()) {
                                this.OnSortCol(nModelColClicked);
                            }
                        } else if (this.GetEditor().GetMarker() + 1000L < System.currentTimeMillis()) {
                            Point ptLoc = jEvent.getPoint();
                            if (this.GetView() == 3) {
                                if (this.GetTable() != null) {
                                    Rectangle rCellRect;
                                    TableColumn rCol;
                                    int nViewColIdx;
                                    int nSelRow;
                                    int nMouseCol = this.GetTable().columnAtPoint(ptLoc);
                                    int nMouseRow = this.GetTable().rowAtPoint(ptLoc);
                                    if (this.GetTable().getSelectedRowCount() == 1 && (nSelRow = this.GetTable().getSelectedRow()) == nMouseRow && (nViewColIdx = this.GetTable().convertColumnIndexToView(0)) == nMouseCol && (rCol = this.GetTable().getColumnModel().getColumn(nViewColIdx)) != null && (rCellRect = this.GetTable().getCellRect(nSelRow, nViewColIdx, true)).contains(ptLoc)) {
                                        this.StartRenameTimer();
                                    }
                                }
                            } else if (this.GetList() != null) {
                                Rectangle rCellRect;
                                int nSelIdx;
                                int nMouseIdx = this.GetList().locationToIndex(ptLoc);
                                if ((this.GetList().getSelectedIndices() == null || this.GetList().getSelectedIndices().length == 1) && (nSelIdx = this.GetTable().getSelectedRow()) == nMouseIdx && (rCellRect = this.GetList().getCellBounds(nSelIdx, nSelIdx)).contains(ptLoc)) {
                                    this.StartRenameTimer();
                                }
                            }
                        }
                    }
                } else if (SwingUtilities.isRightMouseButton(jEvent)) {
                    if (this.GetTable() != null) {
                        this.GetTable().requestFocus();
                    }
                    if (objSource == this.GetTable() || objSource == this.GetTableViewport() || objSource == this.GetList() || objSource == this.GetListViewport()) {
                        Point pt = jEvent.getPoint();
                        int nRow = this.GetRowAtPoint(pt);
                        if (this.IsValidRow(nRow) && !this.GetSelModel().isSelectedIndex(nRow)) {
                            this.GetSelModel().clearSelection();
                            this.GetSelModel().addSelectionInterval(nRow, nRow);
                        }
                        if (objSource instanceof Component) {
                            pt = SwingUtilities.convertPoint((Component)objSource, pt, this);
                        }
                        if (this.GetPopupMenu() != null) {
                            this.GetPopupMenu().show(this, pt.x, pt.y);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent jEvent) {
        this.m_FirstMouseEvent = jEvent;
        this.HideEditor(true);
        if (this.GetTable() != null) {
            this.GetTable().requestFocus();
        }
    }

    @Override
    public void mouseReleased(MouseEvent jEvent) {
        this.m_FirstMouseEvent = null;
    }

    @Override
    public void mouseEntered(MouseEvent jEvent) {
    }

    @Override
    public void mouseExited(MouseEvent jEvent) {
    }

    public void OnLeftDoubleClick(MouseEvent jEvent) {
        Object objSource = jEvent.getSource();
        JTableHeader jTableHeader = this.GetTable().getTableHeader();
        if (objSource.equals(this.GetTable()) || objSource.equals(this.GetList())) {
            int nRow = -1;
            nRow = this.m_nCurView == 3 ? this.GetTable().rowAtPoint(jEvent.getPoint()) : this.GetList().locationToIndex(jEvent.getPoint());
            if (this.GetModel() != null) {
                CFile fFile = this.GetModel().GetFileAt(nRow);
                CFile[] afFiles = new CFile[]{fFile};
                if (this.GetDisplayFile() != null) {
                    this.GetDisplayFile().OpenChildFiles(this.GetGeneralThread(), this, afFiles);
                }
            }
        } else if (objSource.equals(jTableHeader)) {
            int nViewColToExpand = CTableUtils.GetViewColToExpand(this.GetTable(), jEvent.getPoint());
            this.ExpandViewCol(nViewColToExpand);
        }
    }

    public CFile GetDisplayFile() {
        return this.GetModel().GetDisplayFile();
    }

    private void OnSortCol(int nSortModelCol) {
        if (nSortModelCol > -1 && nSortModelCol < this.GetTable().getColumnCount()) {
            int nCurSortCol = this.m_jTableSorter.GetSortModelCol();
            if (nCurSortCol == nSortModelCol) {
                int nCurSortDir = this.m_jTableSorter.GetSortDirection();
                nCurSortDir = nCurSortDir == 1 ? 2 : 1;
                this.m_jTableSorter.SetSortDirection(nCurSortDir);
                if (this.GetArchive() != null) {
                    this.GetArchive().SetValue(this.GetKeySortDir(), nCurSortDir, this.GetDefSortDir());
                }
            } else {
                this.m_jTableSorter.SetSortDirection(1);
                ((CTableViewport)this.GetTableViewport()).SetModelCol(nSortModelCol);
                this.m_jTableSorter.SetSortModelCol(nSortModelCol);
                if (this.GetArchive() != null) {
                    this.GetArchive().SetValue(this.GetKeySortCol(), nSortModelCol, this.GetDefSortCol());
                }
            }
        }
        this.SortModelRetainSelection();
    }

    private void SortModelRetainSelection() {
        if (DEBUG_TRACE_METHODS) {
            System.out.println("CFilePanel.SortModelRetainSelection -->");
        }
        this.SaveSelections();
        this.SortModel();
        this.LoadSelections();
        if (DEBUG_TRACE_METHODS) {
            System.out.println("CFilePanel.SortModelRetainSelection <--");
        }
    }

    protected void SortModel() {
        if (DEBUG_TRACE_METHODS) {
            System.out.println("CFilePanel.SortModel -->");
        }
        if (this.GetSelModel() != null) {
            this.GetSelModel().clearSelection();
            this.GetSelModel().setAnchorSelectionIndex(-1);
            this.GetSelModel().setLeadSelectionIndex(-1);
        }
        if (this.GetModel() != null) {
            this.GetModel().Sort(this.m_jTableSorter);
        }
        if (DEBUG_TRACE_METHODS) {
            System.out.println("CFilePanel.SortModel <--");
        }
    }

    @Override
    public void componentResized(ComponentEvent jEvent) {
        Object objSource = jEvent.getSource();
        if (objSource == this.GetTable()) {
            this.GetTableViewport().repaint();
        } else if (objSource == this.GetListViewport()) {
            this.RefreshListCellLayout();
        }
    }

    @Override
    public void componentMoved(ComponentEvent jEvent) {
    }

    @Override
    public void componentShown(ComponentEvent jEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent jEvent) {
        if (DEBUG) {
            System.out.println("CFilePanel.componentHidden");
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.GetTable(false) != null) {
            this.GetTable().updateUI();
            if (this.m_jHeaderRenderer != null) {
                this.m_jHeaderRenderer.UpdateUIRenderer();
            }
        }
        if (this.GetList(false) != null) {
            this.GetList().updateUI();
            ListCellRenderer rCellRenderer = this.GetList().getCellRenderer();
            if (rCellRenderer != null && this.m_ListCellRenderer != null && this.m_ListThumbRenderer != null) {
                if (rCellRenderer == this.m_ListCellRenderer) {
                    this.m_ListThumbRenderer.updateUI();
                } else {
                    this.m_ListCellRenderer.updateUI();
                }
            }
        }
        if (this.GetEditor() != null) {
            this.GetEditor().updateUI();
        }
        if (this.m_cPopupMenu != null) {
            SwingUtilities.updateComponentTreeUI(this.m_cPopupMenu);
        }
    }

    private void ExpandViewCol(int nViewCol) {
        TableColumn jCol;
        TableColumnModel jColModel;
        if (nViewCol > -1 && nViewCol < this.GetTable().getColumnCount() && (jColModel = this.GetTable().getColumnModel()) != null && (jCol = jColModel.getColumn(nViewCol)) != null) {
            int nMaxCellWidth = CTableUtils.GetMaxCellWidth(this.GetTable(), nViewCol, this.GetArchive());
            jCol.setPreferredWidth(nMaxCellWidth);
        }
    }

    private void RefreshListCellLayout() {
        if (this.GetList() != null) {
            try {
                this.GetList().setVisibleRowCount(-1);
            }
            catch (Exception e) {
                if (CMainFrame.GetDebugLogger() != null) {
                    CMainFrame.GetDebugLogger().Warning("EXCEPTION:  GetList().setVisibleRowCount failed");
                }
            }
        } else if (CMainFrame.GetDebugLogger() != null) {
            CMainFrame.GetDebugLogger().Info("ASSERT:  Programming error, GetList() = null");
        }
    }

    private boolean ItemSearch(String sSearchStr, int nSortColumn, int nStart, int nStop) {
        boolean bFound = false;
        for (int nIndex = nStart; nIndex < nStop; ++nIndex) {
            CFile fFile = this.GetModel().GetFileAt(nIndex);
            if (fFile == null) continue;
            String sTemp = fFile.GetDisplayName();
            if (this.GetView() == 3) {
                switch (nSortColumn) {
                    case 1: {
                        if (fFile.IsDirectory()) break;
                        sTemp = CFile.FormatFileSize(fFile.GetSize(), false);
                        break;
                    }
                    case 2: {
                        sTemp = fFile.GetType();
                        break;
                    }
                    case 3: {
                        break;
                    }
                    default: {
                        sTemp = fFile.GetDisplayName();
                    }
                }
            }
            if (sTemp == null) continue;
            if (sTemp.length() > sSearchStr.length()) {
                sTemp = sTemp.substring(0, sSearchStr.length());
            }
            if (sTemp.isEmpty() || !(sTemp = sTemp.toLowerCase()).equals(sSearchStr)) continue;
            this.GetSelModel().setSelectionInterval(nIndex, nIndex);
            this.EnsureVisible(nIndex, nSortColumn);
            bFound = true;
            break;
        }
        return bFound;
    }

    protected void EnsureVisible(int nRow, int nColumn) {
        Rectangle rRect;
        if (this.GetView() == 3) {
            if (this.GetTable() != null) {
                Rectangle rRect2 = this.GetTable().getCellRect(nRow, nColumn, true);
                this.GetTable().scrollRectToVisible(rRect2);
            }
        } else if (this.GetList() != null && (rRect = this.GetList().getCellBounds(nRow, nRow)) != null) {
            this.GetList().scrollRectToVisible(rRect);
        }
    }

    @Override
    public void keyTyped(KeyEvent jEvent) {
    }

    @Override
    public void keyPressed(KeyEvent rEvent) {
        Object objSource = rEvent.getSource();
        int nKeyCode = rEvent.getKeyCode();
        block0 : switch (nKeyCode) {
            case 127: {
                if (!rEvent.isShiftDown()) break;
                this.OnDelete();
                rEvent.consume();
                break;
            }
            case 113: {
                if (rEvent.getModifiers() != 0) break;
                this.OnRename();
                rEvent.consume();
                break;
            }
            case 27: {
                this.HideEditor(false);
                rEvent.consume();
                break;
            }
            case 10: {
                if (rEvent.isAltDown()) {
                    this.OnProperties();
                    rEvent.consume();
                    break;
                }
                this.OpenCurrentSelection();
                rEvent.consume();
                break;
            }
            case 35: 
            case 36: {
                if (rEvent.getSource() != this.GetTable()) break;
                if (this.GetModel() != null && this.GetSelModel() != null) {
                    if (rEvent.isShiftDown()) {
                        if (nKeyCode == 36) {
                            this.GetSelModel().setSelectionInterval(this.GetSelModel().getAnchorSelectionIndex(), 0);
                        } else {
                            this.GetSelModel().setSelectionInterval(this.GetSelModel().getAnchorSelectionIndex(), this.GetModel().getSize() - 1);
                        }
                    } else if (rEvent.isControlDown()) {
                        if (nKeyCode == 36) {
                            this.GetSelModel().moveLeadSelectionIndex(0);
                        } else {
                            this.GetSelModel().moveLeadSelectionIndex(this.GetModel().getSize() - 1);
                        }
                    } else if (nKeyCode == 36) {
                        this.GetSelModel().setSelectionInterval(0, 0);
                    } else {
                        this.GetSelModel().setSelectionInterval(this.GetModel().getSize() - 1, this.GetModel().getSize() - 1);
                    }
                    this.EnsureVisible(this.GetSelModel().getLeadSelectionIndex(), 0);
                }
                rEvent.consume();
                break;
            }
            case 33: 
            case 34: {
                if (this.GetModel() == null || this.GetSelModel() == null || this.m_jTableSorter == null) break;
                boolean bUp = false;
                if (nKeyCode == 33) {
                    bUp = true;
                }
                boolean bHandled = false;
                bHandled = !bUp ? (this.GetView() == 3 ? this.OnPageDownTable(rEvent.isControlDown(), rEvent.isShiftDown()) : this.OnPageDownList(rEvent.isControlDown(), rEvent.isShiftDown())) : (this.GetView() == 3 ? this.OnPageUpTable(rEvent.isControlDown(), rEvent.isShiftDown()) : this.OnPageUpList(rEvent.isControlDown(), rEvent.isShiftDown()));
                if (!bHandled) break;
                rEvent.consume();
                break;
            }
            case 8: {
                CBrowserPanel rPanel = (CBrowserPanel)SwingUtilities.getAncestorOfClass(CBrowserPanel.class, this);
                if (rPanel == null) break;
                CRhinoEvent rSendEvent = new CRhinoEvent(this, 2114);
                rPanel.dispatchEvent(rSendEvent);
                break;
            }
            case 115: {
                if (rEvent.getModifiers() != 0) break;
                CRhinoEvent CrumbEditEvent = new CRhinoEvent(this, 9201);
                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(CrumbEditEvent);
                break;
            }
            default: {
                if (rEvent.isControlDown()) {
                    switch (nKeyCode) {
                        case 65: {
                            CRhinoEvent Event2 = new CRhinoEvent(this, 2021);
                            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(Event2);
                            rEvent.consume();
                            break block0;
                        }
                        case 73: {
                            CRhinoEvent Event3 = new CRhinoEvent(this, 2022);
                            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(Event3);
                            rEvent.consume();
                            break block0;
                        }
                    }
                    break;
                }
                if (this.GetTypeAhead() == null || !this.GetTypeAhead().CanTypeAhead(rEvent)) break;
                int nSortModelCol = 0;
                if (this.m_jTableSorter != null) {
                    nSortModelCol = this.m_jTableSorter.GetSortModelCol();
                }
                if (this.GetView() == 3) {
                    this.GetTypeAhead().OnTypeAhead(KeyEvent.getKeyText(rEvent.getKeyCode()), nSortModelCol, this.GetTable(), this.GetModel(), (ListSelectionModel)this.GetSelModel());
                } else {
                    this.GetTypeAhead().OnTypeAhead(KeyEvent.getKeyText(rEvent.getKeyCode()), nSortModelCol, this.GetList(), this.GetModel(), (ListSelectionModel)this.GetSelModel());
                }
                rEvent.consume();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent jEvent) {
    }

    public int GetView() {
        return this.m_nCurView;
    }

    @Override
    public void stateChanged(ChangeEvent rChangeEvent) {
        if (DEBUG_TRACE_METHODS) {
            System.out.println("CFilePanel.stateChanged -->");
        }
        if (this.m_bStateChangeHideEditor) {
            this.HideEditor(false);
        }
        this.m_bStateChangeHideEditor = true;
        if (DEBUG_TRACE_METHODS) {
            System.out.println("CFilePanel.stateChanged <--");
        }
    }

    public int GetNumOfFiles() {
        return this.GetModel().getRowCount();
    }

    public int GetNumOfSelectedFiles() {
        return this.GetTable().getSelectedRowCount();
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        Component rFocusOwner;
        if (!event.getValueIsAdjusting()) {
            this.SetRenameMarker(System.currentTimeMillis());
            if (this.GetSelModel() != null) {
                if (this.GetSelModel().isSelectionEmpty()) {
                    if (this.GetPreviewPane() != null) {
                        this.GetPreviewPane().SetFile(null);
                    }
                } else {
                    CFile fFile;
                    int nLeadRow = this.GetSelModel().getLeadSelectionIndex();
                    if (this.GetModel() != null && (fFile = this.GetModel().GetFileAt(nLeadRow)) != null && this.GetPreviewPane() != null) {
                        this.GetPreviewPane().SetFile(fFile);
                    }
                }
            }
        }
        if ((rFocusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner()) != null && this.IsEventSource(rFocusOwner)) {
            this.UpdateBtnStates();
            this.UpdateBtnSelections();
        }
        this.PostStatusInfo();
    }

    @Override
    public void tableChanged(TableModelEvent rTableChangedEvent) {
        this.RepaintRow(rTableChangedEvent.getFirstRow());
    }

    @Override
    public void intervalAdded(ListDataEvent jEvent) {
    }

    @Override
    public void intervalRemoved(ListDataEvent jEvent) {
    }

    @Override
    public void contentsChanged(ListDataEvent jEvent) {
        this.RepaintRow(jEvent.getIndex0());
    }

    private void SelectAll() {
        if (DEBUG) {
            System.out.println("CFilePanel.SelectAll -->");
        }
        this.GetTable().selectAll();
        if (DEBUG) {
            System.out.println("CFilePanel.SelectAll <--");
        }
    }

    private void InvertSelection() {
        int nLeadIdx = this.GetSelModel().getLeadSelectionIndex();
        for (int nRow = 0; nRow < this.GetTable().getRowCount(); ++nRow) {
            if (this.GetSelModel().isSelectedIndex(nRow)) {
                this.GetSelModel().removeSelectionInterval(nRow, nRow);
                continue;
            }
            this.GetSelModel().addSelectionInterval(nRow, nRow);
        }
        this.GetSelModel().moveLeadSelectionIndex(nLeadIdx);
    }

    private String GetLeadSelectionAbsPath() {
        String sAbsPath = null;
        int nSelLeadRow = this.GetSelModel().getLeadSelectionIndex();
        CFile fFile = this.GetModel().GetFileAt(nSelLeadRow);
        if (fFile != null) {
            sAbsPath = fFile.GetAbsFileName();
        }
        return sAbsPath;
    }

    private void SetLeadSelection(String sLeadSelAbsPath, int nCurLeadSelAbsPath) {
        if (sLeadSelAbsPath != null && !sLeadSelAbsPath.isEmpty() && nCurLeadSelAbsPath > -1) {
            int nMinSelIdx;
            int nLeadSelIdx = this.GetModel().GetRowIndex(sLeadSelAbsPath);
            int nFileCount = this.GetModel().getRowCount();
            if (nLeadSelIdx < 0 || nLeadSelIdx >= nFileCount) {
                for (int nNextIdx = nCurLeadSelAbsPath; nNextIdx < nFileCount; ++nNextIdx) {
                    if (!this.GetSelModel().isSelectedIndex(nNextIdx)) continue;
                    nLeadSelIdx = nNextIdx;
                    break;
                }
            }
            if ((nLeadSelIdx < 0 || nLeadSelIdx >= nFileCount) && (nMinSelIdx = this.GetSelModel().getMinSelectionIndex()) >= 0 && nMinSelIdx < nFileCount) {
                nLeadSelIdx = nMinSelIdx;
            }
            if (nLeadSelIdx >= 0 && nLeadSelIdx < nFileCount) {
                this.GetSelModel().moveLeadSelectionIndex(nLeadSelIdx);
            }
        }
    }

    private String[] GetSelectedAbsPaths() {
        return this.GetSelectedAbsPaths(null);
    }

    private String[] GetSelectedAbsPaths(String sExcludePath) {
        int[] anSelRows = null;
        anSelRows = this.GetView() == 3 ? this.GetTable().getSelectedRows() : this.GetList().getSelectedIndices();
        String[] asSelAbsPaths = new String[anSelRows.length];
        for (int nIdx = 0; nIdx < anSelRows.length; ++nIdx) {
            int nSelRow = anSelRows[nIdx];
            CFile fNextFile = this.GetModel().GetFileAt(nSelRow);
            if (fNextFile == null) continue;
            String sAbsPath = fNextFile.GetAbsFileName();
            if (sExcludePath != null && sExcludePath.equals(sAbsPath)) continue;
            asSelAbsPaths[nIdx] = sAbsPath;
        }
        return asSelAbsPaths;
    }

    private void SetSelectedAbsPaths(String[] asSelAbsPaths) {
        if (asSelAbsPaths != null) {
            for (int nIdx = 0; nIdx < asSelAbsPaths.length; ++nIdx) {
                int nSelRow;
                String sAbsPath = asSelAbsPaths[nIdx];
                if (sAbsPath == null || (nSelRow = this.GetModel().GetRowIndex(sAbsPath)) <= -1 || nSelRow >= this.GetModel().getRowCount()) continue;
                this.GetSelModel().addSelectionInterval(nSelRow, nSelRow);
            }
        }
    }

    private void OnRename() {
        if (this.GetSelModel() != null) {
            int nSelIdx = this.GetSelModel().getLeadSelectionIndex();
            this.OnRename(nSelIdx);
        }
    }

    private void OnRename(int nRow) {
        Boolean bPromptReadOnly;
        Rectangle rScreenCoords = null;
        CFile fCellFile = null;
        if (this.GetSelModel() != null) {
            this.GetSelModel().moveLeadSelectionIndex(nRow);
        }
        if (this.GetModel() != null) {
            fCellFile = this.GetModel().GetFileAt(nRow);
        }
        this.EnsureVisible(nRow, 0);
        JComponent rCellRenderer = null;
        IArchive rArchive = this.GetArchive();
        if (rArchive != null && (bPromptReadOnly = rArchive.GetValueBool("ConfirmFileReadOnly", true)) != null && this.GetEditor() != null) {
            this.GetEditor().SetWarnOnReadOnly(bPromptReadOnly);
        }
        if (this.m_nCurView == 3) {
            int nViewCol = this.GetTable().convertColumnIndexToView(0);
            rCellRenderer = (JComponent)((Object)this.GetTable().getCellRenderer(nRow, nViewCol));
        } else {
            rCellRenderer = (JComponent)((Object)this.GetList().getCellRenderer());
        }
        if (rCellRenderer instanceof CFileListCellImageRenderer) {
            CFileListCellImageRenderer rRenderer = (CFileListCellImageRenderer)rCellRenderer;
            rScreenCoords = rRenderer.GetEditorRect(this.GetList(), nRow);
        } else if (rCellRenderer instanceof CFileListCellRenderer) {
            CFileListCellRenderer rRenderer = (CFileListCellRenderer)rCellRenderer;
            rScreenCoords = rRenderer.GetEditorRect(this.GetList(), nRow);
        } else if (rCellRenderer instanceof CFileTableCellRenderer) {
            CFileTableCellRenderer rRenderer = (CFileTableCellRenderer)rCellRenderer;
            int nViewCol = this.GetTable().convertColumnIndexToView(0);
            rScreenCoords = rRenderer.GetEditorRect(this.GetTable(), nViewCol, nRow);
        } else if (CMainFrame.GetDebugLogger() != null) {
            CMainFrame.GetDebugLogger().Info("ASSERT:  Programming error, CellRenderer wrong class type");
        }
        if (fCellFile != null && fCellFile.IsRenameAllowed() && rScreenCoords != null && rScreenCoords.width > 0 && rScreenCoords.height > 0) {
            if (DEBUG_RENAME_EDITOR) {
                System.out.println(String.format("Show CellEditor at (%s)", rScreenCoords.toString()));
            }
            this.ShowEditor(rScreenCoords, fCellFile);
        }
    }

    public CFile[] GetSelectedFiles() {
        int[] anSelRows;
        CFile[] afSelFiles = null;
        if (this.GetTable() != null && (anSelRows = this.GetTable().getSelectedRows()) != null && anSelRows.length > 0) {
            CFile fNextFile = null;
            afSelFiles = new CFile[anSelRows.length];
            for (int nIdx = 0; nIdx < anSelRows.length; ++nIdx) {
                int nSelRow = anSelRows[nIdx];
                fNextFile = this.GetModel().GetFileAt(nSelRow);
                if (fNextFile == null) continue;
                afSelFiles[nIdx] = fNextFile;
            }
        }
        return afSelFiles;
    }

    public Point ConvertPoint(Point pt, Component jComp) {
        Point ptRet = pt;
        ptRet = this.m_nCurView == 3 ? SwingUtilities.convertPoint(this.GetTable(), pt, jComp) : SwingUtilities.convertPoint(this.GetList(), pt, jComp);
        return ptRet;
    }

    @Override
    public void mouseDragged(MouseEvent rMouseEvent) {
        if (DEBUG_TRACK_DND_DRAG_EVENTS) {
            System.out.println("mouseDragged");
        }
        if (SwingUtilities.isRightMouseButton(rMouseEvent)) {
            int nRow;
            if (!(this.m_FirstMouseEvent == null || this.IsValidRow(nRow = this.GetRowAtPoint(this.m_FirstMouseEvent.getPoint())) && this.GetSelModel().isSelectedIndex(nRow))) {
                if (DEBUG) {
                    System.out.println("Cancel drag b/c mousePressed row was not selected.");
                }
                return;
            }
            rMouseEvent.consume();
            Object rSourceObj = rMouseEvent.getSource();
            if (rSourceObj instanceof JComponent) {
                JComponent rSource = (JComponent)rSourceObj;
                if (this.m_FirstMouseEvent != null) {
                    int nAction = 1;
                    int dXExtent = Math.abs(rMouseEvent.getX() - this.m_FirstMouseEvent.getX());
                    int dYExtent = Math.abs(rMouseEvent.getY() - this.m_FirstMouseEvent.getY());
                    if (dXExtent > 5 || dYExtent > 5) {
                        rSource.putClientProperty("DndRightClick", true);
                        TransferHandler rHandler = rSource.getTransferHandler();
                        if (rHandler != null && CFileSystemUtils.GetFileSysUtils() != null && !CFileSystemUtils.GetFileSysUtils().IsNIX()) {
                            rHandler.exportAsDrag(rSource, this.m_FirstMouseEvent, nAction);
                        }
                        this.m_FirstMouseEvent = null;
                    }
                }
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent jEvent) {
    }

    private int GetRowAtPoint(Point pt) {
        int nRow = -1;
        nRow = this.m_nCurView == 3 ? this.GetTable().rowAtPoint(pt) : this.GetList().locationToIndex(pt);
        return nRow;
    }

    private boolean IsValidRow(int nRow) {
        boolean bValid = false;
        if (nRow > -1 && nRow < this.GetModel().getSize()) {
            bValid = true;
        }
        return bValid;
    }

    private void RemoveRow(String sAbsPath) {
        CFileModel rModel = this.GetModel();
        if (rModel != null) {
            String[] asSelAbsPaths = this.GetSelectedAbsPaths(sAbsPath);
            rModel.RemoveRow(rModel.GetRowIndex(sAbsPath));
            this.GetSelModel().clearSelection();
            this.SetSelectedAbsPaths(asSelAbsPaths);
        }
    }

    protected void StartLoadingThumbs(CFile fDisplayFile, boolean bRefresh) {
        if (this.GetModel() != null) {
            for (int nRow = 0; nRow < this.GetModel().getRowCount(); ++nRow) {
                CFile fFile = this.GetModel().GetFileAt(nRow);
                if (fFile == null) continue;
                fFile.GetThumb(this.GetThumbThread(), this, bRefresh, this.GetThumbWidth(), this.GetThumbHeight(), false, false, true);
            }
        }
    }

    protected void StopLoadingThumbs() {
        if (this.GetDisplayFile() != null) {
            this.GetDisplayFile().CancelChildThumbs(this.GetThumbThread());
        }
    }

    private ListCellRenderer GetListCellRenderer(int nViewMode) {
        JComponent rRenderer = this.m_ListCellRenderer;
        if (nViewMode == 4 || nViewMode == 0) {
            rRenderer = this.m_ListThumbRenderer;
        }
        return rRenderer;
    }

    private JViewport GetListViewport() {
        return this.m_ListViewport;
    }

    private JViewport GetTableViewport() {
        if (this.m_TableViewport == null && CMainFrame.GetDebugLogger() != null) {
            CMainFrame.GetDebugLogger().Info("ASSERT:  Programming error, m_TableViewport = null");
        }
        return this.m_TableViewport;
    }

    public JTable GetTable() {
        return this.GetTable(true);
    }

    private JTable GetTable(boolean bShowAssert) {
        if (this.m_Table == null && bShowAssert && CMainFrame.GetDebugLogger() != null) {
            CMainFrame.GetDebugLogger().Info("ASSERT:  Programming error, m_Table = null");
        }
        return this.m_Table;
    }

    public JList GetList() {
        return this.GetList(true);
    }

    private JList GetList(boolean bShowAssert) {
        if (this.m_List == null && bShowAssert && CMainFrame.GetDebugLogger() != null) {
            CMainFrame.GetDebugLogger().Info("ASSERT:  Programming error, m_List = null");
        }
        return this.m_List;
    }

    protected CFileModel GetModel() {
        if (this.m_DataModel == null && CMainFrame.GetDebugLogger() != null) {
            CMainFrame.GetDebugLogger().Info("ASSERT:  Programming error, m_DataModel = null");
        }
        return this.m_DataModel;
    }

    private CFileSelModel GetSelModel() {
        return this.m_SelModel;
    }

    protected IArchive GetArchive() {
        IArchive rArchive = null;
        if (CMainFrame.GET_APP() != null) {
            rArchive = CMainFrame.GET_APP().GetArchive();
        }
        return rArchive;
    }

    @Override
    public void columnAdded(TableColumnModelEvent e) {
    }

    @Override
    public void columnRemoved(TableColumnModelEvent event) {
    }

    @Override
    public void columnMoved(TableColumnModelEvent e) {
        this.SaveColIndices();
    }

    @Override
    public void columnMarginChanged(ChangeEvent e) {
        this.SaveColWidths();
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent e) {
    }

    protected String GetDefColWidths() {
        String sRet = "";
        for (int nIdx = 0; nIdx < 5; ++nIdx) {
            if (nIdx != 0) {
                sRet = sRet + DELIMITER_COL_WIDTHS;
            }
            sRet = sRet + 90;
        }
        return sRet;
    }

    protected String GetDefColIndices() {
        return String.format("%d,%d,%d,%d", 0, 1, 2, 3);
    }

    protected int GetDefSortCol() {
        return 0;
    }

    protected int GetDefSortDir() {
        return 1;
    }

    public void OpenCurrentSelection() {
        if (this.GetSelModel().IsSingleRowSelected()) {
            int nLeadRow = this.GetSelModel().getLeadSelectionIndex();
            CFile fFile = this.GetModel().GetFileAt(nLeadRow);
            if (fFile != null) {
                CFile[] afFiles = new CFile[]{fFile};
                if (this.GetDisplayFile() != null) {
                    this.GetDisplayFile().OpenChildFiles(this.GetGeneralThread(), this, afFiles);
                }
            }
        }
    }

    private void PostStatusInfo() {
        if (CBaseStatusBar.DEBUG_STATUS_TXT) {
            Component cOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            Component cPermOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
            System.out.printf("CFilePanel.PostStatusInfo | FocusOwner: %s | PermFocusOwner: %s\r\n", cOwner.getClass().toString(), cPermOwner.getClass().toString());
        }
        String sStatus = null;
        if (this.GetModel() != null && this.GetTable() != null && this.GetDisplayFile() != null) {
            int nNumOfItems = this.GetModel().getSize();
            int nNumOfSelItems = this.GetTable().getSelectedRowCount();
            String sAbsPath = this.GetDisplayFile().GetAbsFileName();
            if (this.GetDisplayFile().IsLocal() && this.GetDisplayFile().IsARoot()) {
                sAbsPath = this.GetDisplayFile().GetDisplayName();
            }
            NumberFormat Formatter = NumberFormat.getInstance();
            sStatus = nNumOfSelItems > 0 ? String.format(CString.LoadString("IDS_STATUS_FMT_NUM_OF_ITEMS_SELECTED"), Formatter.format(nNumOfItems), Formatter.format(nNumOfSelItems), sAbsPath) : String.format(CString.LoadString("IDS_STATUS_FMT_NUM_OF_ITEMS"), Formatter.format(nNumOfItems), sAbsPath);
        }
        CRhinoEvent rEvent = new CRhinoEvent(this, 9205, sStatus);
        Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(rEvent);
    }

    protected void RepaintRow(int nRow) {
        if (this.GetModel() != null && nRow >= 0 && nRow < this.GetModel().getSize()) {
            if (this.GetView() == 3) {
                if (this.GetTable() != null) {
                    for (int nCol = 0; nCol < 5; ++nCol) {
                        Rectangle rRect = this.GetTable().getCellRect(nRow, nCol, true);
                        this.GetTable().repaint(rRect);
                    }
                }
            } else if (this.GetList() != null) {
                Rectangle rRect = this.GetList().getCellBounds(nRow, nRow);
                this.GetList().repaint(rRect);
            }
        }
    }

    @Override
    public void focusGained(FocusEvent event) {
        if (DEBUG) {
            System.out.println("CFilePanel.focusGained -->");
        }
        this.PostStatusInfo();
        if (event.getComponent() != null && CMainFrame.GET_APP() != null) {
            CRhinoEvent rUpdateEvent = new CRhinoEvent(event.getComponent(), 9021);
            CMainFrame.GET_APP().dispatchEvent(rUpdateEvent);
            rUpdateEvent = new CRhinoEvent(event.getComponent(), 9023);
            CMainFrame.GET_APP().dispatchEvent(rUpdateEvent);
        }
        if (DEBUG) {
            System.out.println("CFilePanel.focusGained <--");
        }
    }

    @Override
    public void focusLost(FocusEvent rEvent) {
    }

    public boolean RemoveRow(CPath rPath) {
        boolean bRemoved = true;
        this.RemoveRow(rPath.GetPath());
        return bRemoved;
    }

    public boolean RemoveRowEx(CFile rRemove) {
        boolean bRemoved = false;
        if (rRemove != null && this.GetModel() != null) {
            if (this.IsSearch()) {
                String sRemove = rRemove.GetPath();
                if (sRemove != null && !sRemove.isEmpty()) {
                    for (int nRow = this.GetModel().getRowCount() - 1; nRow >= 0; --nRow) {
                        String sNext;
                        CFile rNext = this.GetModel().GetFileAt(nRow);
                        if (rNext == null || (sNext = rNext.GetPath()) == null || sNext.isEmpty() || !sNext.startsWith(sRemove)) continue;
                        this.GetModel().RemoveRow(nRow);
                    }
                }
            } else {
                int nRow = this.GetModel().GetRowIndex(rRemove);
                this.GetModel().RemoveRow(nRow);
            }
        }
        return bRemoved;
    }

    protected void SetGeneralThread(CBaseThread rtThread) {
        this.m_rtGeneralThread = rtThread;
    }

    protected void SetThumbThread(CBaseThread rtThread) {
        this.m_rtThumbThread = rtThread;
    }

    protected CBaseThread GetGeneralThread() {
        return this.m_rtGeneralThread;
    }

    protected CBaseThread GetThumbThread() {
        return this.m_rtThumbThread;
    }

    protected CFilePreviewPane GetPreviewPane() {
        return this.m_rcPreviewPane;
    }

    public void SetPreviewPane(CFilePreviewPane rcPreviewPane) {
        this.m_rcPreviewPane = rcPreviewPane;
    }

    @Override
    protected void processEvent(AWTEvent event) {
        block80: {
            block79: {
                if (DEBUG_TRACE_METHODS) {
                    System.out.println("CFilePanel.processEvent -->");
                }
                if (!(event instanceof CRhinoEvent)) break block79;
                CRhinoEvent rEvent = (CRhinoEvent)event;
                switch (event.getID()) {
                    case 6008: {
                        Object[] arObjs = (Object[])rEvent.GetEventObj();
                        CFile fFile = null;
                        if (arObjs[0] != null && arObjs[0] instanceof CFile) {
                            fFile = (CFile)arObjs[0];
                        }
                        this.SetDisplayFile(fFile, false);
                        break;
                    }
                    case 2100: {
                        int nCurView = this.GetView();
                        switch (nCurView) {
                            case 0: {
                                nCurView = 1;
                                break;
                            }
                            case 1: {
                                nCurView = 2;
                                break;
                            }
                            case 3: {
                                nCurView = 4;
                                break;
                            }
                            case 4: {
                                nCurView = 0;
                                break;
                            }
                            default: {
                                nCurView = 3;
                            }
                        }
                        this.SetView(nCurView);
                        break;
                    }
                    case 2101: {
                        this.SetView(0);
                        break;
                    }
                    case 2102: {
                        this.SetView(1);
                        break;
                    }
                    case 2103: {
                        this.SetView(2);
                        break;
                    }
                    case 2104: {
                        this.SetView(3);
                        break;
                    }
                    case 2105: {
                        this.SetView(4);
                        break;
                    }
                    case 2106: 
                    case 2107: 
                    case 2108: 
                    case 2109: 
                    case 2110: {
                        this.SetView(4);
                        this.OnThumbSizeEvent(event.getID());
                        break;
                    }
                    case 6009: {
                        Object[] aItems;
                        if (this.IsEventSource(rEvent.getSource()) && (aItems = (Object[])rEvent.GetEventObj()) != null && aItems.length == 3 && aItems[0] instanceof CFile) {
                            CFile fFile = (CFile)aItems[0];
                            if (this.GetModel() != null) {
                                CFile fTemp;
                                int nRowIdx = this.GetModel().GetRowIndex(fFile.GetPath());
                                if (this.m_nSearchState == CSearchStateEvent.SEARCH_STATE.ON && (fTemp = this.GetModel().GetFileAt(nRowIdx)) != null) {
                                    if (DEBUG) {
                                        System.out.printf("CFilePanel.ON_UPDATE_GUI_FILE_THUMB | Thread:  %s | Set thumb for:  %s\r\n", Thread.currentThread().getName(), fTemp.GetPath());
                                    }
                                    fTemp.SetIconThumb(this, this.GetThumbWidth(), this.GetThumbHeight(), fFile.GetIconThumb(this.GetThumbWidth(), this.GetThumbHeight()), false);
                                }
                                this.RepaintRow(nRowIdx);
                                break;
                            }
                        }
                        break block80;
                    }
                    case 6002: {
                        CFile fParent = (CFile)rEvent.getSource();
                        if (fParent != null && this.GetDisplayFile() != null) {
                            String sParentPath = fParent.GetPath();
                            String sDisplayPath = this.GetDisplayFile().GetPath();
                            if (sParentPath != null && !sParentPath.isEmpty() && sDisplayPath != null && !sDisplayPath.isEmpty() && sParentPath.equals(sDisplayPath)) {
                                this.SortModel();
                                if (this.GetModel() != null) {
                                    this.GetModel().fireTableDataChanged(true);
                                    break;
                                }
                            }
                        }
                        break block80;
                    }
                    case 6004: {
                        String sParentPath;
                        this.SaveSelections();
                        CFile rParent = (CFile)rEvent.GetEventObj();
                        if (this.GetModel() != null && rParent != null && (sParentPath = rParent.GetPath()) != null && !sParentPath.isEmpty() && this.GetDisplayFile() != null && sParentPath.equals(this.GetDisplayFile().GetPath())) {
                            this.GetModel().RemoveAllRows();
                            break;
                        }
                        break block80;
                    }
                    case 6001: {
                        Object[] aItems = (Object[])rEvent.GetEventObj();
                        if (aItems != null) {
                            String sParentPath;
                            CFile fChild = (CFile)aItems[0];
                            boolean bUpdateUI = true;
                            Boolean bVal = (Boolean)aItems[1];
                            if (bVal != null) {
                                bUpdateUI = bVal;
                            }
                            if (fChild != null && this.GetModel() != null && (sParentPath = fChild.GetParentPath(true)) != null && !sParentPath.isEmpty() && this.GetDisplayFile() != null && sParentPath.equals(this.GetDisplayFile().GetPath())) {
                                this.GetModel().AddRow(fChild, bUpdateUI);
                                if (this.GetView() == 4) {
                                    fChild.GetThumb(this.GetThumbThread(), this, false, this.GetThumbWidth(), this.GetThumbHeight(), false, false, true);
                                    break;
                                }
                            }
                        }
                        break block80;
                    }
                    case 6005: {
                        Object[] aItems = (Object[])rEvent.GetEventObj();
                        if (aItems != null) {
                            String sParentPath;
                            CFile fChild = (CFile)aItems[0];
                            boolean bUpdateUI = true;
                            Boolean bVal = (Boolean)aItems[1];
                            if (bVal != null) {
                                bUpdateUI = bVal;
                            }
                            if (fChild != null && this.GetModel() != null && (sParentPath = fChild.GetParentPath(true)) != null && !sParentPath.isEmpty() && this.GetDisplayFile() != null && sParentPath.equals(this.GetDisplayFile().GetPath())) {
                                this.GetModel().UpdateRow(this.GetModel().GetRowIndex(fChild));
                                if (this.GetView() == 4) {
                                    fChild.GetThumb(this.GetThumbThread(), this, false, this.GetThumbWidth(), this.GetThumbHeight(), false, false, true);
                                    break;
                                }
                            }
                        }
                        break block80;
                    }
                    case 6003: {
                        String sParentPath;
                        CFile fChild = (CFile)rEvent.GetEventObj();
                        if (fChild != null && this.GetModel() != null && (sParentPath = fChild.GetParentPath(true)) != null && !sParentPath.isEmpty() && this.GetDisplayFile() != null && sParentPath.equals(this.GetDisplayFile().GetPath())) {
                            this.RemoveRowEx(fChild);
                            break;
                        }
                        break block80;
                    }
                    case 6006: {
                        String sParentPath;
                        CFile fChildFile = (CFile)rEvent.GetEventObj();
                        if (fChildFile != null && this.GetModel() != null && (sParentPath = fChildFile.GetParentPath(true)) != null && !sParentPath.isEmpty() && this.GetDisplayFile() != null && sParentPath.equals(this.GetDisplayFile().GetPath())) {
                            String sPath = fChildFile.GetPath();
                            int nIndex = this.GetModel().GetRowIndex(sPath);
                            this.GetModel().UpdateRow(nIndex);
                            this.RepaintRow(nIndex);
                            break;
                        }
                        break block80;
                    }
                    case 6007: {
                        String sParentPath;
                        CFile fChildFile = (CFile)rEvent.GetEventObj();
                        if (fChildFile != null && this.GetModel() != null && (sParentPath = fChildFile.GetParentPath(true)) != null && !sParentPath.isEmpty() && this.GetDisplayFile() != null && sParentPath.equals(this.GetDisplayFile().GetPath())) {
                            String sPrevPath = fChildFile.GetPrevPath();
                            int nPrevIndex = this.GetModel().GetRowIndexPrevPath(sPrevPath);
                            this.GetModel().UpdateRow(nPrevIndex);
                            this.RepaintRow(nPrevIndex);
                            break;
                        }
                        break block80;
                    }
                    case 2005: {
                        this.OnDelete();
                        break;
                    }
                    case 2003: {
                        if (this.GetDisplayFile() != null) {
                            this.GetDisplayFile().CreateNewFolder(this.GetGeneralThread(), this, true);
                            break;
                        }
                        break block80;
                    }
                    case 2006: {
                        if (CFileSystemUtils.GetFileSysUtils() != null && CFileSystemUtils.GetFileSysUtils().IsNIX()) {
                            this.StartRenameTimer();
                            break;
                        }
                        this.OnRename();
                        break;
                    }
                    case 2004: {
                        this.OnOpen();
                        break;
                    }
                    case 2021: {
                        this.SelectAll();
                        break;
                    }
                    case 2022: {
                        this.InvertSelection();
                        break;
                    }
                    case 2008: 
                    case 2009: {
                        Object obj = rEvent.GetEventObj();
                        if (obj instanceof CPath) {
                            CPath rTransferTo = (CPath)obj;
                            this.OnTransferFilesTo(rTransferTo, this.IsSearch());
                            break;
                        }
                        break block80;
                    }
                    case 9021: {
                        this.UpdateBtnStates();
                        break;
                    }
                    case 9023: {
                        this.UpdateBtnSelections();
                        break;
                    }
                    case 9025: {
                        this.OnInitialUpdate();
                        break;
                    }
                    case 2007: {
                        this.OnProperties();
                        break;
                    }
                    case 9111: {
                        Object[] anItems = (Object[])rEvent.GetEventObj();
                        CFile fCreatedDir = (CFile)anItems[0];
                        Boolean bEnterRenameMode = (Boolean)anItems[1];
                        bEnterRenameMode = false;
                        if (fCreatedDir != null && this.GetModel() != null) {
                            int nRow = this.GetModel().GetRowIndex(fCreatedDir);
                            if (CMainFrame.GET_APP().IsActiveFrame(this)) {
                                if (this.GetView() == 3) {
                                    if (this.GetTable() != null) {
                                        this.GetTable().requestFocus();
                                        this.GetTable().getSelectionModel().setSelectionInterval(nRow, nRow);
                                    }
                                } else if (this.GetList() != null) {
                                    this.GetList().requestFocus();
                                    this.GetList().getSelectionModel().setSelectionInterval(nRow, nRow);
                                }
                                if (!this.GetShowRenameDlg() && fCreatedDir.IsLocal() && bEnterRenameMode.booleanValue()) {
                                    this.SetRenameMarker(System.currentTimeMillis() - 1500L);
                                    this.OnRename(nRow);
                                    break;
                                }
                            }
                        }
                        break block80;
                    }
                    case 9142: {
                        this.OnDockFrameRemoved(rEvent);
                        break;
                    }
                    case 9146: {
                        if (this.m_DragDropHandler != null) {
                            this.m_DragDropHandler.InitVars();
                        }
                        this.putClientProperty("DndRightClick", null);
                        if (this.GetTableViewport() != null) {
                            this.GetTableViewport().putClientProperty("DndRightClick", null);
                        }
                        if (this.GetTable() != null) {
                            this.GetTable().putClientProperty("DndRightClick", null);
                        }
                        if (this.GetList() != null) {
                            this.GetList().putClientProperty("DndRightClick", null);
                            break;
                        }
                        break block80;
                    }
                    case 9206: {
                        this.PostStatusInfo();
                        break;
                    }
                    case 8100: {
                        CFile[] afSelFiles = this.GetSelectedFiles();
                        if (afSelFiles != null) {
                            CRhinoEvent rhinoEvent = new CRhinoEvent(this, 8101, afSelFiles);
                            CMainEventQueue.PostEvent(rhinoEvent);
                            break;
                        }
                        break block80;
                    }
                    case 3021: {
                        if (rEvent.GetEventObj() instanceof CThreadMsg) {
                            CThreadMsg rThreadMsg = (CThreadMsg)rEvent.GetEventObj();
                            this.OnRecvThreadOpItemDone(rEvent, rThreadMsg);
                            break;
                        }
                        break block80;
                    }
                    default: {
                        super.processEvent(event);
                    }
                }
                break block80;
            }
            super.processEvent(event);
        }
        if (DEBUG_TRACE_METHODS) {
            System.out.println("CFilePanel.processEvent <--");
        }
    }

    public boolean IsEventSource(Object objSource) {
        boolean bIsEventSource = false;
        if (objSource == this) {
            bIsEventSource = true;
        }
        if (!bIsEventSource && this.GetTableViewport() != null && objSource == this.GetTableViewport()) {
            bIsEventSource = true;
        }
        if (!bIsEventSource && this.GetTable() != null && objSource == this.GetTable()) {
            bIsEventSource = true;
        }
        if (!bIsEventSource && this.GetListViewport() != null && objSource == this.GetListViewport()) {
            bIsEventSource = true;
        }
        if (!bIsEventSource && this.GetList() != null && objSource == this.GetList()) {
            bIsEventSource = true;
        }
        return bIsEventSource;
    }

    private void RefreshThumbCells(boolean bStopLoadingThumbs) {
        if (bStopLoadingThumbs) {
            this.StopLoadingThumbs();
        }
        boolean bIsThumb = this.GetView() == 4;
        int nCellWidth = 32;
        int nCellHeight = 32;
        if (bIsThumb) {
            this.StartLoadingThumbs(this.GetDisplayFile(), false);
            nCellWidth = this.GetThumbWidth();
            nCellHeight = this.GetThumbHeight();
        }
        char[] aChars = new char[15];
        for (int nIdx = 0; nIdx < aChars.length; ++nIdx) {
            aChars[nIdx] = 87;
        }
        String sText = new String(aChars);
        Dimension dimTxtSize = CString.GetTextSize(sText, this.GetList().getFont(), this.GetList().getGraphics());
        if (dimTxtSize != null) {
            if (!bIsThumb) {
                nCellWidth = Math.max(nCellWidth, dimTxtSize.width);
            }
            nCellHeight += dimTxtSize.height;
        } else {
            nCellHeight += 20;
        }
        Insets rInsets = this.m_ListThumbRenderer.GetTotalInsets();
        if (rInsets != null) {
            nCellWidth += rInsets.left + rInsets.right;
            nCellHeight += rInsets.top + rInsets.bottom;
        }
        this.GetList().setFixedCellWidth(nCellWidth);
        this.GetList().setFixedCellHeight(nCellHeight);
    }

    private void InitPopupMenu() {
        this.m_cPopupMenu = new JPopupMenu();
        JMenuItem cBtn = null;
        if (CMainFrame.GET_APP() != null) {
            cBtn = new JMenuItem(CMainFrame.GET_APP().GetAction(2004));
            this.m_cPopupMenu.add((Component)cBtn);
        }
        this.m_cPopupMenu.addSeparator();
        if (CMainFrame.GET_APP() != null) {
            this.m_cDownloadPopupMenuItem = new JMenuItem(CMainFrame.GET_APP().GetAction(2009));
            this.m_cPopupMenu.add(this.m_cDownloadPopupMenuItem);
        }
        this.m_cDownloadToPopupMenu = new JMenu(CString.LoadString("IDS_DOWNLOAD_TO_MENU"));
        this.m_cPopupMenu.add(this.m_cDownloadToPopupMenu);
        if (CMainFrame.GET_APP() != null) {
            this.m_cUploadPopupMenuItem = new JMenuItem(CMainFrame.GET_APP().GetAction(2008));
            this.m_cPopupMenu.add(this.m_cUploadPopupMenuItem);
        }
        this.m_cUploadToPopupMenu = new JMenu(CString.LoadString("IDS_UPLOAD_TO_MENU"));
        this.m_cPopupMenu.add(this.m_cUploadToPopupMenu);
        this.m_cPopupMenu.addSeparator();
        if (CMainFrame.GET_APP() != null) {
            this.m_cSyncFoldersMenuItem = new JMenuItem(CMainFrame.GET_APP().GetAction(2011));
            this.m_cPopupMenu.add(this.m_cSyncFoldersMenuItem);
        }
        this.m_cSyncFoldersToMenu = new JMenu(CString.LoadString("IDS_SYNC_FOLDERS_TO_MENU"));
        this.m_cPopupMenu.add(this.m_cSyncFoldersToMenu);
        this.m_cPopupMenu.addSeparator();
        if (CMainFrame.GET_APP() != null) {
            cBtn = new JMenuItem(CMainFrame.GET_APP().GetAction(2005));
            this.m_cPopupMenu.add((Component)cBtn);
        }
        if (CMainFrame.GET_APP() != null) {
            cBtn = new JMenuItem(CMainFrame.GET_APP().GetAction(2003));
            this.m_cPopupMenu.add((Component)cBtn);
        }
        if (CMainFrame.GET_APP() != null) {
            cBtn = new JMenuItem(CMainFrame.GET_APP().GetAction(2006));
            this.m_cPopupMenu.add((Component)cBtn);
        }
        this.m_cPopupMenu.addSeparator();
        if (CMainFrame.GET_APP() != null) {
            cBtn = new JMenuItem(CMainFrame.GET_APP().GetAction(2115));
            this.m_cPopupMenu.add((Component)cBtn);
        }
        if (CMainFrame.GET_APP() != null) {
            cBtn = new JMenuItem(CMainFrame.GET_APP().GetAction(2007));
            this.m_cPopupMenu.add((Component)cBtn);
        }
        if (CMainFrame.DEBUG_MEDIA) {
            this.m_cPopupMenu.addSeparator();
            if (CMainFrame.GET_APP() != null) {
                cBtn = new JMenuItem(CMainFrame.GET_APP().GetAction(8100));
                this.m_cPopupMenu.add((Component)cBtn);
            }
        }
    }

    private JPopupMenu GetPopupMenu() {
        this.LoadDownloadToMenuItems(this.GetDownloadToPopupMenu());
        this.LoadUploadToMenuItems(this.GetUploadToPopupMenu());
        this.LoadSyncFoldersToMenuItems(this.GetSyncFoldersToMenu());
        if (this.GetDisplayFile() != null) {
            boolean bShowDownloadBtns = this.GetDisplayFile().IsLocal();
            if (this.GetDownloadPopupMenuItem() != null) {
                this.GetDownloadPopupMenuItem().setVisible(!bShowDownloadBtns);
            }
            if (this.GetDownloadToPopupMenu() != null) {
                this.GetDownloadToPopupMenu().setVisible(!bShowDownloadBtns);
            }
            if (this.GetUploadPopupMenuItem() != null) {
                this.GetUploadPopupMenuItem().setVisible(bShowDownloadBtns);
            }
            if (this.GetUploadToPopupMenu() != null) {
                this.GetUploadToPopupMenu().setVisible(bShowDownloadBtns);
            }
        }
        return this.m_cPopupMenu;
    }

    private AbstractButton GetPopupMenuBtn(int nEventID) {
        AbstractButton rBtn = null;
        JPopupMenu rPopMenu = this.GetPopupMenu();
        if (rPopMenu != null) {
            for (int nIdx = 0; nIdx < rPopMenu.getComponentCount() && rBtn == null; ++nIdx) {
                CBaseAction rBaseAction;
                AbstractButton cBtn;
                Action rAction;
                Component cComp = rPopMenu.getComponent(nIdx);
                if (cComp instanceof JMenu) {
                    rBtn = this.GetMenuBtn((JMenu)cComp, nEventID);
                    continue;
                }
                if (!(cComp instanceof AbstractButton) || !((rAction = (cBtn = (AbstractButton)cComp).getAction()) instanceof CBaseAction) || (rBaseAction = (CBaseAction)rAction).GetEventID() != nEventID) continue;
                rBtn = cBtn;
            }
        }
        return rBtn;
    }

    private AbstractButton GetMenuBtn(JMenu rMenu, int nEventID) {
        AbstractButton rBtn = null;
        if (rMenu != null) {
            for (int nIdx = 0; nIdx < rMenu.getComponentCount() && rBtn == null; ++nIdx) {
                CBaseAction rBaseAction;
                AbstractButton cBtn;
                Action rAction;
                Component cComp = rMenu.getComponent(nIdx);
                if (cComp instanceof JMenu) {
                    rBtn = this.GetMenuBtn((JMenu)cComp, nEventID);
                    continue;
                }
                if (!(cComp instanceof AbstractButton) || !((rAction = (cBtn = (AbstractButton)cComp).getAction()) instanceof CBaseAction) || (rBaseAction = (CBaseAction)rAction).GetEventID() != nEventID) continue;
                rBtn = cBtn;
            }
        }
        return rBtn;
    }

    private JMenuItem GetDownloadPopupMenuItem() {
        return this.m_cDownloadPopupMenuItem;
    }

    private JMenu GetDownloadToPopupMenu() {
        return this.m_cDownloadToPopupMenu;
    }

    private JMenuItem GetUploadPopupMenuItem() {
        return this.m_cUploadPopupMenuItem;
    }

    private JMenu GetUploadToPopupMenu() {
        return this.m_cUploadToPopupMenu;
    }

    private JMenuItem GetSyncFoldersMenuItem() {
        return this.m_cSyncFoldersMenuItem;
    }

    private JMenu GetSyncFoldersToMenu() {
        return this.m_cSyncFoldersToMenu;
    }

    private void LoadTransferToMenuItems(JMenu rMenu, Vector<CFile> afWorkingDirs, CTransferMenuItem.TYPE nType) {
        if (rMenu != null) {
            rMenu.removeAll();
            if (afWorkingDirs != null) {
                for (CFile fNext : afWorkingDirs) {
                    if (fNext == null || rMenu == null) continue;
                    CTransferMenuItem cMenuItem = new CTransferMenuItem(fNext, nType);
                    rMenu.add(cMenuItem);
                    cMenuItem.addActionListener(this);
                }
            }
        }
    }

    protected void LoadTransferToMenuItems(JMenu rMenu, Vector<CFile> afWorkingDirs) {
        this.LoadTransferToMenuItems(rMenu, afWorkingDirs, CTransferMenuItem.TYPE.TRANSFER_TO);
    }

    protected void LoadSyncFoldersToMenuItems(JMenu rMenu, Vector<CFile> afWorkingDirs) {
        this.LoadTransferToMenuItems(rMenu, afWorkingDirs, CTransferMenuItem.TYPE.SYNC_FOLDERS_TO);
    }

    private void LoadDownloadToMenuItems(JMenu rMenu) {
        if (CMainFrame.GET_APP() != null) {
            this.LoadTransferToMenuItems(rMenu, CMainFrame.GET_APP().GetLocalWorkingDirs());
        }
    }

    private void LoadUploadToMenuItems(JMenu rMenu) {
        if (CMainFrame.GET_APP() != null) {
            this.LoadTransferToMenuItems(rMenu, CMainFrame.GET_APP().GetRemoteWorkingDirs());
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() instanceof CTransferMenuItem) {
            CTransferMenuItem rMenuItem = (CTransferMenuItem)event.getSource();
            CFile fTransferTo = rMenuItem.GetFile();
            if (rMenuItem.GetType() == CTransferMenuItem.TYPE.TRANSFER_TO) {
                this.OnTransferFilesTo(fTransferTo, this.IsSearch());
            } else if (rMenuItem.GetType() == CTransferMenuItem.TYPE.SYNC_FOLDERS_TO) {
                this.OnSyncFoldersTo(fTransferTo);
            }
        } else if (event.getSource() == this.m_RenameTimer) {
            this.StopRenameTimer();
            this.OnRename();
        }
    }

    private void OnTransferFilesTo(CPath rTransferTo, boolean bIsSearch) {
        CFilePanel.TransferFilesEx(this, this.GetDisplayFile().CreatePath(), rTransferTo, CFile.CreatePaths(this.GetSelectedFiles(), false), false, bIsSearch);
    }

    public static void TransferFilesEx(Object objSource, CPath rTransferFrom, CPath rTransferTo, CPath[] afSourceFiles, boolean bIsMove, boolean bIsSearch) {
        if (CMainFrame.GET_APP() != null && objSource != null && rTransferFrom != null && rTransferTo != null && afSourceFiles != null) {
            if (rTransferFrom.IsLocal() && rTransferTo.IsLocal() || !rTransferFrom.IsLocal() && !rTransferTo.IsLocal()) {
                CBaseThread tThread = null;
                tThread = rTransferFrom.IsLocal() ? CMainFrame.GET_APP().CreateLocalThread("RemoteCopyThread") : CMainFrame.GET_APP().CreateRemoteThread("RemoteCopyThread");
                rTransferFrom.CopyFiles(tThread, objSource, rTransferTo.GetPath(), afSourceFiles, bIsMove);
            } else if (!rTransferTo.IsLocal()) {
                CRemoteThread tThread = CMainFrame.GET_APP().CreateRemoteThread("RemoteUploadThread");
                rTransferFrom.UploadFiles(tThread, objSource, rTransferTo.GetPath(), afSourceFiles, bIsMove, bIsSearch);
            } else {
                CRemoteThread tThread = CMainFrame.GET_APP().CreateRemoteThread("RemoteDownloadThread");
                rTransferFrom.DownloadFiles(tThread, objSource, rTransferTo.GetPath(), afSourceFiles, bIsMove, bIsSearch);
            }
        }
    }

    private void UpdateBtnStates() {
        int[] anSelIndices = null;
        if (this.GetList() != null) {
            anSelIndices = this.GetList().getSelectedIndices();
        }
        if (anSelIndices != null) {
            boolean bHasLocal = false;
            boolean bHasARoot = false;
            boolean bHasADrive = false;
            for (int nIdx = 0; nIdx < anSelIndices.length; ++nIdx) {
                int nRow = anSelIndices[nIdx];
                CFile fNext = this.GetModel().GetFileAt(nRow);
                if (fNext == null) continue;
                if (fNext.IsARoot()) {
                    bHasARoot = true;
                }
                if (fNext.IsDrive()) {
                    bHasADrive = true;
                }
                if (!fNext.IsLocal()) continue;
                bHasLocal = true;
            }
            boolean bEnableOpen = true;
            boolean bEnableNewDir = true;
            boolean bEnableRename = false;
            boolean bEnableDelete = false;
            boolean bEnableUpload = false;
            boolean bEnableDownload = false;
            boolean bEnableProperties = true;
            if (anSelIndices.length == 1) {
                int nRow = anSelIndices[0];
                CFile fNext = this.GetModel().GetFileAt(nRow);
                if (fNext != null) {
                    bEnableRename = fNext.IsRenameAllowed();
                }
            }
            if (!bHasARoot && !bHasADrive) {
                if (bHasLocal) {
                    bEnableUpload = true;
                } else {
                    bEnableDownload = true;
                }
                if (anSelIndices.length > 0) {
                    bEnableDelete = true;
                }
            } else if (bHasARoot) {
                bEnableNewDir = false;
            }
            if (this.IsSearch()) {
                bEnableNewDir = false;
            }
            this.SetBtnEnabled(2004, bEnableOpen);
            this.SetBtnEnabled(2003, bEnableNewDir);
            this.SetBtnEnabled(2006, bEnableRename);
            this.SetBtnEnabled(2008, bEnableUpload);
            this.SetBtnEnabled(2009, bEnableDownload);
            this.SetBtnEnabled(2005, bEnableDelete);
            this.SetBtnEnabled(2007, bEnableProperties);
        }
    }

    private void UpdateBtnSelections() {
        this.UpdateBtnViews();
        this.UpdateBtnThumbs();
    }

    private void UpdateBtnViews() {
        int nEventID = 2104;
        switch (this.GetView()) {
            case 0: {
                nEventID = 2101;
                break;
            }
            case 1: {
                nEventID = 2102;
                break;
            }
            case 2: {
                nEventID = 2103;
                break;
            }
            case 4: {
                nEventID = 2105;
                break;
            }
            default: {
                nEventID = 2104;
            }
        }
        this.SetBtnSelected(2101, false);
        this.SetBtnSelected(2102, false);
        this.SetBtnSelected(2103, false);
        this.SetBtnSelected(2104, false);
        this.SetBtnSelected(2105, false);
        this.SetBtnSelected(nEventID, true);
    }

    private void UpdateBtnThumbs() {
        int nEventID = 2107;
        if (CMainFrame.GET_APP() != null) {
            nEventID = CMainFrame.GET_APP().GetThumbSizeEventID(this.GetThumbWidth(), this.GetThumbHeight());
        }
        this.SetBtnSelected(2106, false);
        this.SetBtnSelected(2107, false);
        this.SetBtnSelected(2108, false);
        this.SetBtnSelected(2109, false);
        this.SetBtnSelected(2110, false);
        this.SetBtnSelected(nEventID, true);
    }

    private void SetBtnEnabled(int nEventID, boolean bEnabled) {
        Object[] anItems = new Object[]{nEventID, bEnabled};
        CRhinoEvent rEvent = new CRhinoEvent(this, 9020, anItems);
        if (CMainFrame.GET_APP() != null) {
            CMainFrame.GET_APP().dispatchEvent(rEvent);
        }
        this.OnUpdateBtnState(nEventID, bEnabled);
    }

    private void SetBtnSelected(int nEventID, boolean bSelected) {
        Object[] anItems = new Object[]{nEventID, bSelected};
        CRhinoEvent rEvent = new CRhinoEvent(this, 9022, anItems);
        if (CMainFrame.GET_APP() != null) {
            CMainFrame.GET_APP().dispatchEvent(rEvent);
        }
        this.OnUpdateBtnSelection(nEventID, bSelected);
    }

    private void OnUpdateBtnState(int nEventID, boolean bEnabled) {
        AbstractButton rBtn = this.GetPopupMenuBtn(nEventID);
        if (rBtn != null) {
            rBtn.setEnabled(bEnabled);
        }
        if (nEventID == 2008 && this.GetUploadToPopupMenu() != null) {
            this.GetUploadToPopupMenu().setEnabled(bEnabled);
        } else if (nEventID == 2009 && this.GetDownloadToPopupMenu() != null) {
            this.GetDownloadToPopupMenu().setEnabled(bEnabled);
        } else if (nEventID == 2011 && this.GetSyncFoldersToMenu() != null) {
            this.GetSyncFoldersToMenu().setEnabled(bEnabled);
        }
    }

    private void OnUpdateBtnSelection(int nEventID, boolean bSelected) {
        AbstractButton rBtn = this.GetPopupMenuBtn(nEventID);
        if (rBtn != null) {
            rBtn.setSelected(bSelected);
        }
    }

    private void OnDelete() {
        boolean bCanDelete;
        CFile[] afSelFiles;
        boolean bConfirmFileDelete = true;
        boolean bConfirmFolderDelete = true;
        if (this.GetArchive() != null) {
            Boolean bVal = this.GetArchive().GetValueBool("ConfirmFileDel", true);
            if (bVal != null) {
                bConfirmFileDelete = bVal;
            }
            if ((bVal = this.GetArchive().GetValueBool("ConfirmFolderDel", true)) != null) {
                bConfirmFolderDelete = bVal;
            }
        }
        if (this.GetDisplayFile() != null && (afSelFiles = this.GetSelectedFiles()) != null && afSelFiles.length > 0 && (bCanDelete = this.ShowConfirmDeleteDlg(true, bConfirmFolderDelete, bConfirmFileDelete, afSelFiles))) {
            this.GetDisplayFile().DeleteFiles(this.GetGeneralThread(), this, afSelFiles);
        }
    }

    public boolean ShowConfirmDeleteDlg(boolean bPermanentDel, boolean bConfirmFolderDelete, boolean bConfirmFileDelete, CFile[] afSelFiles) {
        boolean bRet = false;
        if (CMainFrame.GET_APP() != null) {
            bRet = CMainFrame.GET_APP().ShowConfirmDeleteDlg(bPermanentDel, bConfirmFolderDelete, bConfirmFileDelete, afSelFiles);
        }
        return bRet;
    }

    private void OnOpen() {
        if (this.GetDisplayFile() != null) {
            this.GetDisplayFile().OpenChildFiles(this.GetGeneralThread(), this, this.GetSelectedFiles());
        }
    }

    private void OnProperties() {
        if (CMainFrame.GET_APP() != null) {
            CFile[] afFiles = this.GetSelectedFiles();
            if (afFiles == null || afFiles.length < 1) {
                afFiles = new CFile[]{this.GetDisplayFile()};
            }
            CMainFrame.GET_APP().ShowPropertiesDlg(afFiles);
        }
    }

    public int GetThumbWidth() {
        return this.m_nThumbWidth;
    }

    public int GetThumbHeight() {
        return this.m_nThumbHeight;
    }

    protected boolean SetThumbWidth(int nThumbWidth) {
        boolean bChanged = false;
        if (this.m_nThumbWidth != nThumbWidth) {
            bChanged = true;
            this.m_nThumbWidth = nThumbWidth;
        }
        return bChanged;
    }

    protected boolean SetThumbHeight(int nThumbHeight) {
        boolean bChanged = false;
        if (this.m_nThumbHeight != nThumbHeight) {
            bChanged = true;
            this.m_nThumbHeight = nThumbHeight;
        }
        return bChanged;
    }

    protected int GetThumbSizeEventID() {
        int nEventID = 2107;
        if (CMainFrame.GET_APP() != null) {
            nEventID = CMainFrame.GET_APP().GetThumbSizeEventID(this.GetThumbWidth(), this.GetThumbHeight());
        }
        return nEventID;
    }

    protected boolean OnThumbSizeEvent(int nEventID) {
        boolean bChanged = false;
        if (CMainFrame.GET_APP() != null) {
            int nThumbWidth = CMainFrame.GET_APP().GetThumbSizeWidth(nEventID);
            int nThumbHeight = CMainFrame.GET_APP().GetThumbSizeHeight(nEventID);
            if (this.SetThumbWidth(nThumbWidth)) {
                bChanged = true;
            }
            if (this.SetThumbHeight(nThumbHeight)) {
                bChanged = true;
            }
            if (bChanged) {
                this.UpdateBtnThumbs();
                this.RefreshThumbCells(true);
                this.StartLoadingThumbs(this.GetDisplayFile(), false);
            }
        }
        return bChanged;
    }

    public void SetHasFocusClrs(boolean bHasFocusClrs) {
        if (this.m_ListCellRenderer != null) {
            this.m_ListCellRenderer.SetHasFocusClrs(bHasFocusClrs);
        }
        if (this.m_ListThumbRenderer != null) {
            this.m_ListThumbRenderer.SetHasFocusClrs(bHasFocusClrs);
        }
        if (this.GetTable() != null) {
            for (int nCol = 0; nCol < this.GetModel().getColumnCount(); ++nCol) {
                int[] anSelRows;
                int nCurLnF;
                TableColumn rColInfo = this.GetColumn(nCol);
                if (rColInfo == null || !(rColInfo.getCellRenderer() instanceof CFileTableCellRenderer)) continue;
                CFileTableCellRenderer rTableRenderer = (CFileTableCellRenderer)rColInfo.getCellRenderer();
                rTableRenderer.SetHasFocusClrs(bHasFocusClrs);
                if (bHasFocusClrs || (nCurLnF = CMainFrame.GET_APP().GetArchive().GetValueInt("LnFEventID", CMainFrame.GET_APP().GetDefLnFID()).intValue()) != 2060 || (anSelRows = this.GetTable().getSelectedRows()) == null) continue;
                for (int nIdx2 = 0; nIdx2 < anSelRows.length; ++nIdx2) {
                    int nRow = anSelRows[nIdx2];
                    Rectangle rRect = this.GetTable().getCellRect(nRow, nCol, true);
                    this.GetTable().repaint(rRect);
                }
            }
        }
    }

    private void StartRenameTimer() {
        if (!this.GetShowRenameDlg()) {
            if (this.m_RenameTimer != null && !this.m_RenameTimer.isRunning()) {
                this.m_RenameTimer.start();
            } else {
                this.m_RenameTimer.restart();
            }
        }
    }

    private void StopRenameTimer() {
        if (this.m_RenameTimer != null && this.m_RenameTimer.isRunning()) {
            this.m_RenameTimer.stop();
        }
    }

    protected DockableFrame GetListFrame() {
        DockableFrame rFrame = (DockableFrame)SwingUtilities.getAncestorOfClass(DockableFrame.class, this);
        return rFrame;
    }

    public void SetThumbSize(int nThumbWidth, int nThumbHeight, boolean bUpdateGUI) {
        boolean bChanged = false;
        this.StopLoadingThumbs();
        if (this.SetThumbWidth(nThumbWidth)) {
            bChanged = true;
        }
        if (this.SetThumbHeight(nThumbHeight)) {
            bChanged = true;
        }
        if (bChanged && bUpdateGUI && this.GetView() == 4) {
            this.UpdateBtnThumbs();
            this.RefreshThumbCells(true);
            this.StartLoadingThumbs(this.GetDisplayFile(), false);
        }
    }

    protected void OnDockFrameRemoved(CRhinoEvent rEvent) {
        IArchive rArchive = this.GetArchive();
        if (rArchive != null) {
            rArchive.RemoveKey(this.GetKeyViewMode());
            rArchive.RemoveKey(this.GetKeySortDir());
            rArchive.RemoveKey(this.GetKeySortCol());
        }
    }

    protected String GetFrameKey() {
        return this.m_sFrameKey;
    }

    public void SetFrameKey(String sKey) {
        this.m_sFrameKey = sKey;
    }

    private CFileCellEditor GetEditor() {
        return this.m_jCellEditor;
    }

    private void ShowEditor(Rectangle rBounds, CFile fRename) {
        if (this.GetShowRenameDlg()) {
            CRenameDlg dlg = new CRenameDlg((Frame)CMainFrame.GET_APP(), (Component)this, this.GetGeneralThread());
            dlg.SetRenameFile(fRename);
            dlg.setVisible(true);
        } else if (this.GetEditor() != null) {
            this.m_bStateChangeHideEditor = false;
            this.GetEditor().ShowEditor(rBounds.x, rBounds.y, rBounds.width, rBounds.height, fRename);
        }
    }

    private void HideEditor(boolean bCommit) {
        if (this.GetEditor() != null) {
            this.GetEditor().HideEditor(bCommit);
        }
    }

    public void SetRenameMarker(long lTime) {
        if (this.GetEditor() != null) {
            this.GetEditor().SetMarker(lTime);
        }
    }

    public boolean IsPointInScrollArea(Point ptMouseLoc, Object rSource) {
        boolean bIsScrollArea = false;
        if (this.GetView() == 3) {
            bIsScrollArea = CFilePanel.IsPointInScrollArea(ptMouseLoc, rSource, this.GetTable(), this);
        }
        return bIsScrollArea;
    }

    public static boolean IsPointInScrollArea(Point ptMouseLoc, Object rSource, JTable rTable, JScrollPane rScrollPane) {
        boolean bIsScrollArea = false;
        if (rSource != null && rTable != null && rScrollPane != null && rSource instanceof Component) {
            Component rComp = (Component)rSource;
            ptMouseLoc = SwingUtilities.convertPoint(rComp, ptMouseLoc, rScrollPane);
            Rectangle rScrollRect = rScrollPane.getBounds();
            Rectangle rViewRect = rScrollPane.getViewport().getBounds();
            Rectangle rTableRect = rTable.getBounds();
            JTableHeader jHeader = rTable.getTableHeader();
            Rectangle rHeaderRect = jHeader.getBounds();
            if (rHeaderRect.height + rTableRect.height < rScrollRect.height) {
                int nOffset;
                rScrollRect.y = nOffset = rTableRect.y + rTableRect.height + rHeaderRect.height;
                rScrollRect.height -= nOffset;
                if (rScrollRect.contains(ptMouseLoc)) {
                    bIsScrollArea = true;
                }
            }
        }
        return bIsScrollArea;
    }

    @Override
    public boolean CompleteDragDrop(CPath rDragSourceDir, CPath rDropTargetDir, CPath[] arDragSourceFiles, boolean bIsMove, boolean bIsSearch, boolean bShowDropMenu, Point ptDropLoc) {
        return CFilePanel.CompleteDragDrop(this, rDragSourceDir, rDropTargetDir, arDragSourceFiles, bIsMove, bIsSearch, bShowDropMenu, ptDropLoc, this.GetCompressionType());
    }

    public static boolean CompleteDragDrop(JComponent rSource, CPath rDragSourceDir, CPath rDropTargetDir, CPath[] arDragSourceFiles, boolean bIsMove, boolean bIsSearch, boolean bShowDropMenu, Point ptDropLoc, int nCompressionType) {
        boolean bComplete = false;
        if (rSource != null && rDragSourceDir != null && rDropTargetDir != null && arDragSourceFiles != null) {
            if (bShowDropMenu && ptDropLoc != null && rSource instanceof ICompleteDragDrop) {
                CDragDropRightClickMenu rDropMenu = new CDragDropRightClickMenu((ICompleteDragDrop)((Object)rSource));
                rDropMenu.SetIsSearch(bIsSearch);
                rDropMenu.SetIsMove(bIsMove);
                rDropMenu.SetDragSourceDir(rDragSourceDir);
                rDropMenu.SetDragSourceFiles(arDragSourceFiles);
                rDropMenu.SetDropTargetDir(rDropTargetDir);
                rDropMenu.show(rSource, ptDropLoc.x, ptDropLoc.y);
            } else {
                if (DEBUG_TRACK_IMPORT_DATA) {
                    if (rDragSourceDir.IsLocal() && !rDropTargetDir.IsLocal()) {
                        System.out.printf("UPLOAD (%s) selected files of %s to %s\r\n", bIsMove ? "MOVE" : "COPY", rDragSourceDir.GetPath(), rDropTargetDir.GetPath());
                    } else if (!rDragSourceDir.IsLocal() && rDropTargetDir.IsLocal()) {
                        System.out.printf("DOWNLOAD (%s) selected files of %s to %s\r\n", bIsMove ? "MOVE" : "COPY", rDragSourceDir.GetPath(), rDropTargetDir.GetPath());
                    } else {
                        System.out.printf("%s selected files of %s to %s\r\n", bIsMove ? "MOVE" : "COPY", rDragSourceDir.GetPath(), rDropTargetDir.GetPath());
                    }
                }
                CFilePanel.TransferFilesEx(rSource, rDragSourceDir, rDropTargetDir, arDragSourceFiles, bIsMove, bIsSearch);
                bComplete = true;
            }
        }
        return bComplete;
    }

    private boolean GetShowRenameDlg() {
        String sLnFClassName;
        boolean bShowDlg = false;
        if (CFileSystemUtils.GetFileSysUtils().IsMac() && (sLnFClassName = UIManager.getLookAndFeel().getClass().getName()).equals("apple.laf.AquaLookAndFeel")) {
            bShowDlg = true;
        }
        return bShowDlg;
    }

    public JComponent GetActiveComponent() {
        JComponent rActiveComp = this.GetList();
        if (this.GetView() == 3) {
            rActiveComp = this.GetTable();
        }
        return rActiveComp;
    }

    private CTypeAhead GetTypeAhead() {
        return this.m_TypeAhead;
    }

    private Vector<ISearchStateListener> GetSearchStateListeners() {
        return this.m_aSearchStateListeners;
    }

    public void AddSearchStateListener(ISearchStateListener rListener) {
        if (this.GetSearchStateListeners() != null) {
            this.GetSearchStateListeners().add(rListener);
        }
    }

    public void RemoveSearchStateListener(ISearchStateListener rListener) {
        if (this.GetSearchStateListeners() != null) {
            this.GetSearchStateListeners().remove(rListener);
        }
    }

    private void FireOnChangedSearchState(CSearchStateEvent.SEARCH_STATE nSearchState) {
        CSearchStateEvent rSearchEvent = new CSearchStateEvent(this, nSearchState);
        if (this.GetSearchStateListeners() != null) {
            for (ISearchStateListener rListener : this.GetSearchStateListeners()) {
                if (rListener == null) continue;
                rListener.OnChangedSearchState(rSearchEvent);
            }
        }
    }

    public boolean IsSearch() {
        return this.m_nSearchState == CSearchStateEvent.SEARCH_STATE.ON;
    }

    public void SetSearchState(CSearchStateEvent.SEARCH_STATE nSearchState) {
        this.m_nSearchState = nSearchState;
        if (nSearchState == CSearchStateEvent.SEARCH_STATE.ON) {
            this.ShowParentPathColumn();
            for (int nRow = this.GetModel().getRowCount() - 1; nRow >= 0; --nRow) {
                this.GetModel().RemoveRow(nRow);
            }
        } else {
            this.HideParentPathColumn();
            this.SetDisplayFile(this.GetDisplayFile(), false);
        }
        this.UpdateBtnStates();
    }

    public void AddSearchFile(CFile rFile) {
        if (this.GetModel() != null && this.IsSearch()) {
            this.GetModel().AddRow(rFile, true);
            if (this.GetView() == 4) {
                rFile.GetThumb(this.GetThumbThread(), this, false, this.GetThumbWidth(), this.GetThumbHeight(), false, false, true);
            }
        }
    }

    private TableColumn GetParentPathTableColumn() {
        return this.m_rParentPathCol;
    }

    private void SetParentPathTableColumn(TableColumn rTableCol) {
        this.m_rParentPathCol = rTableCol;
    }

    private void HideParentPathColumn() {
        TableColumnModel rColModel;
        if (this.GetParentPathTableColumn() != null && (rColModel = this.GetTable().getColumnModel()) != null) {
            rColModel.removeColumn(this.GetParentPathTableColumn());
        }
    }

    private void ShowParentPathColumn() {
        TableColumnModel rColModel;
        if (this.GetParentPathTableColumn() != null && (rColModel = this.GetTable().getColumnModel()) != null && rColModel.getColumnCount() <= 4) {
            rColModel.addColumn(this.GetParentPathTableColumn());
            if (this.m_nViewColParentPathIdx < 0 || this.m_nViewColParentPathIdx > this.GetModel().getColumnCount() - 1) {
                this.m_nViewColParentPathIdx = 4;
            }
            if (this.m_nViewColParentPathIdx > -1 && this.m_nViewColParentPathIdx < this.GetModel().getColumnCount()) {
                rColModel.moveColumn(4, this.m_nViewColParentPathIdx);
            }
        }
    }

    protected void OnRecvThreadOpItemDone(CRhinoEvent rEvent, CThreadMsg rThreadMsg) {
        if (rThreadMsg != null) {
            switch (rThreadMsg.GetMsgID()) {
                case 22: {
                    this.OnRecvThumb(rEvent, rThreadMsg);
                    break;
                }
                case 5: {
                    this.LoadSelections();
                    break;
                }
            }
        }
    }

    private void OnRecvThumb(CRhinoEvent rEvent, CThreadMsg rThreadMsg) {
        if (this.IsEventSource(rEvent.getSource()) && this.m_nSearchState == CSearchStateEvent.SEARCH_STATE.ON && rThreadMsg != null && rThreadMsg instanceof CThreadMsgTransfer) {
            CThreadMsgTransfer rMsg = (CThreadMsgTransfer)rThreadMsg;
            String sPath = null;
            boolean bIsDir = true;
            CPath rFromPath = rMsg.GetFromPath(rMsg.GetPathIndex());
            sPath = rFromPath.GetPath();
            bIsDir = rFromPath.IsDir();
            if (sPath != null && !sPath.isEmpty()) {
                if (rFromPath.IsLink()) {
                    sPath = rFromPath.GetPrevPath();
                }
                if (this.GetModel() != null) {
                    int nRowIdx = this.GetModel().GetRowIndex(sPath);
                    CFile fTemp = this.GetModel().GetFileAt(nRowIdx);
                    if (fTemp != null && rMsg instanceof CThreadMsgThumb) {
                        CThreadMsgThumb rThumbMsg = (CThreadMsgThumb)rMsg;
                        if (DEBUG) {
                            System.out.printf("CFilePanel.OnRecvTransfer - Thread:  %s | UI file: %s\r\n", Thread.currentThread().getName(), fTemp.GetPath());
                        }
                        fTemp.SetIconThumb(this, rThumbMsg.GetThumbWidth(), rThumbMsg.GetThumbHeight(), rThumbMsg.GetThumbImage(), false);
                        this.RepaintRow(nRowIdx);
                    }
                }
            }
        }
    }

    private JScrollBar GetVerticalScrollBar() {
        JScrollBar rScrollBar = null;
        int nCompCount = this.getComponentCount();
        for (int nIdx = 0; nIdx < nCompCount && rScrollBar == null; ++nIdx) {
            JScrollBar rTempScrollBar;
            Component rNextComp = this.getComponent(nIdx);
            if (rNextComp == null || !(rNextComp instanceof JScrollBar) || (rTempScrollBar = (JScrollBar)rNextComp).getOrientation() != 1) continue;
            rScrollBar = rTempScrollBar;
        }
        return rScrollBar;
    }

    private int GetVerticalScrollBarWidth(boolean bGetUIDefaultValue) {
        int nWidth = 0;
        if (bGetUIDefaultValue) {
            try {
                Object objWidth = UIManager.getDefaults().get("ScrollBar.width");
                Integer nScrollBarWidth = (Integer)objWidth;
                nWidth = nScrollBarWidth;
            }
            catch (Exception exception) {}
        } else if (this.GetVerticalScrollBar() != null) {
            nWidth = this.GetVerticalScrollBar().getWidth();
        }
        return nWidth;
    }

    private boolean IsVerticalScrollBarVisible() {
        boolean bIsVisible = false;
        if (this.GetVerticalScrollBar() != null) {
            bIsVisible = this.GetVerticalScrollBar().isVisible();
        }
        return bIsVisible;
    }

    private int GetTableViewportWidth() {
        int nWidth = 0;
        if (this.m_TableViewport != null) {
            nWidth = this.m_TableViewport.getWidth();
        }
        return nWidth -= this.GetVerticalScrollBarWidth(true);
    }

    private TableColumn GetColumn(int nColID) {
        TableColumnModel rColModel;
        TableColumn rColumn = null;
        if (this.GetTable() != null && (rColModel = this.GetTable().getColumnModel()) != null) {
            Integer nID;
            try {
                int nColIdx = rColModel.getColumnIndex(nColID);
                rColumn = rColModel.getColumn(nColIdx);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (rColumn == null && this.GetParentPathTableColumn() != null && (nID = (Integer)this.GetParentPathTableColumn().getIdentifier()) != null && nID == nColID) {
                rColumn = this.GetParentPathTableColumn();
            }
        }
        return rColumn;
    }

    private int GetDefColWidth() {
        int nViewportWidth;
        int nColWidth = 90;
        int nDivideBy = 5;
        TableColumnModel rColModel = this.GetTable().getColumnModel();
        if (rColModel != null) {
            nDivideBy = rColModel.getColumnCount();
        }
        if ((nColWidth = (nViewportWidth = this.GetTableViewportWidth()) / nDivideBy) < 1) {
            nColWidth = 90;
        }
        return nColWidth;
    }

    private void LoadColWidths() {
        if (this.GetTable() != null && this.GetTable().getColumnModel() != null) {
            this.GetTable().getColumnModel().removeColumnModelListener(this);
        }
        for (int nModelCol = 0; nModelCol < this.GetModel().getColumnCount(); ++nModelCol) {
            TableColumn rColumn;
            String sKey;
            Integer nStoredColWidth;
            int nColWidth = this.GetDefColWidth();
            IArchive rArchive = this.GetArchive();
            if (rArchive != null && (nStoredColWidth = rArchive.GetValueInt(sKey = this.GetKeyColWidth(nModelCol), nColWidth)) != null) {
                nColWidth = nStoredColWidth;
            }
            if ((rColumn = this.GetColumn(nModelCol)) == null) continue;
            rColumn.setPreferredWidth(nColWidth);
        }
        if (this.GetTable() != null && this.GetTable().getColumnModel() != null) {
            this.GetTable().getColumnModel().addColumnModelListener(this);
        }
    }

    private void SaveColWidths() {
        for (int nModelCol = 0; nModelCol < this.GetModel().getColumnCount(); ++nModelCol) {
            IArchive rArchive;
            int nDefColWidth;
            int nColWidth = nDefColWidth = this.GetDefColWidth();
            TableColumn rColumn = this.GetColumn(nModelCol);
            if (rColumn != null) {
                nColWidth = rColumn.getWidth();
            }
            if ((rArchive = this.GetArchive()) == null) continue;
            String sKey = this.GetKeyColWidth(nModelCol);
            rArchive.SetValue(sKey, nColWidth, nDefColWidth);
        }
    }

    private void LoadColIndices() {
        if (this.GetTable() != null && this.GetTable().getColumnModel() != null) {
            this.GetTable().getColumnModel().removeColumnModelListener(this);
        }
        if (this.GetModel().getColumnCount() > 0) {
            int[] anViewIndices = new int[this.GetModel().getColumnCount()];
            for (int i = 0; i < anViewIndices.length; ++i) {
                anViewIndices[i] = -1;
            }
            for (int nModelCol = 0; nModelCol < this.GetModel().getColumnCount(); ++nModelCol) {
                String sKey;
                Integer nStoredColIndex;
                IArchive rArchive = this.GetArchive();
                if (rArchive == null || (nStoredColIndex = rArchive.GetValueInt(sKey = this.GetKeyColIndex(nModelCol), nModelCol)) == null) continue;
                anViewIndices[nModelCol] = nStoredColIndex;
                if (nModelCol != 4) continue;
                this.m_nViewColParentPathIdx = nStoredColIndex;
            }
            int nSubtractHiddenCol = 0;
            int nMoveToColumn = 0;
            for (int nNextColumn = 0; nNextColumn < this.GetModel().getColumnCount(); ++nNextColumn) {
                nMoveToColumn = nNextColumn;
                int nModelIdx = -1;
                for (int nNextIdx = 0; nNextIdx < anViewIndices.length && nModelIdx == -1; ++nNextIdx) {
                    int nNextViewIdx = anViewIndices[nNextIdx];
                    if (nNextViewIdx != nNextColumn) continue;
                    nModelIdx = nNextIdx;
                }
                int nCurViewColumn = this.GetTable().convertColumnIndexToView(nModelIdx);
                if (nCurViewColumn < 0 || nCurViewColumn > this.GetModel().getColumnCount() - 1) {
                    --nSubtractHiddenCol;
                }
                nMoveToColumn += nSubtractHiddenCol;
                if (DEBUG_LOAD_COLS) {
                    System.out.printf("NextColumn: %d | ModelColumn: %d | CurViewColumn: %d | MoveToColumn: %d\r\n", nNextColumn, nModelIdx, nCurViewColumn, nMoveToColumn);
                }
                if (nCurViewColumn <= -1 || nCurViewColumn >= this.GetModel().getColumnCount() || nCurViewColumn == nMoveToColumn) continue;
                try {
                    this.GetTable().moveColumn(nCurViewColumn, nMoveToColumn);
                    continue;
                }
                catch (Exception e) {
                    if (!DEBUG) continue;
                    e.printStackTrace();
                }
            }
        }
        if (this.GetTable() != null && this.GetTable().getColumnModel() != null) {
            this.GetTable().getColumnModel().addColumnModelListener(this);
        }
    }

    private void SaveColIndices() {
        for (int nModelCol = 0; nModelCol < this.GetModel().getColumnCount(); ++nModelCol) {
            IArchive rArchive;
            int nDefColIndex = nModelCol;
            int nViewColIdx = -1;
            try {
                nViewColIdx = this.GetTable().convertColumnIndexToView(nModelCol);
            }
            catch (Exception e) {
                nViewColIdx = nModelCol;
            }
            if (nModelCol == 4) {
                if (nViewColIdx == -1) {
                    nViewColIdx = nModelCol;
                }
                if (nModelCol == 4) {
                    this.m_nViewColParentPathIdx = nViewColIdx;
                }
            }
            if ((rArchive = this.GetArchive()) == null) continue;
            String sKey = this.GetKeyColIndex(nModelCol);
            rArchive.SetValue(sKey, nViewColIdx, nDefColIndex);
        }
    }

    public void RequestFocus() {
        if (this.GetView() == 3) {
            if (this.GetTable() != null) {
                this.GetTable().requestFocusInWindow();
            }
        } else if (this.GetList() != null) {
            this.GetList().requestFocus();
        }
    }

    private void SetPageSelectionInterval(int nSelRow, boolean bIsCtrlDown, boolean bIsShiftDown) {
        if (this.GetModel() != null && this.GetSelModel() != null && nSelRow >= 0 && nSelRow < this.GetModel().getRowCount()) {
            if (bIsCtrlDown) {
                this.GetSelModel().moveLeadSelectionIndex(nSelRow);
            } else if (bIsShiftDown) {
                int nOldAnchorIdx = this.GetSelModel().getAnchorSelectionIndex();
                int nOldLeadIdx = this.GetSelModel().getLeadSelectionIndex();
                if (nOldLeadIdx > nOldAnchorIdx && nSelRow < nOldLeadIdx) {
                    this.GetSelModel().removeSelectionInterval(nSelRow, nOldLeadIdx);
                } else if (nOldLeadIdx < nOldAnchorIdx && nSelRow > nOldLeadIdx) {
                    this.GetSelModel().removeSelectionInterval(nOldLeadIdx, nSelRow);
                }
                this.GetSelModel().addSelectionInterval(nOldAnchorIdx, nSelRow);
                this.GetSelModel().moveLeadSelectionIndex(nSelRow);
                this.GetSelModel().setAnchorSelectionIndex(nOldAnchorIdx);
            } else {
                this.GetSelModel().setSelectionInterval(nSelRow, nSelRow);
            }
        }
    }

    private boolean OnPageAdjustTable(boolean bHeadingUpTheList, boolean bIsCtrlDown, boolean bIsShiftDown) {
        boolean bHandled = false;
        if (this.GetSelModel() != null && this.GetTable() != null && this.GetTableViewport() != null) {
            int nCurSelIndex = 0;
            if (this.GetSelModel() != null) {
                nCurSelIndex = this.GetSelModel().getLeadSelectionIndex();
            }
            Rectangle rVisibleRect = this.GetTable().getVisibleRect();
            int nFirstRowLoc = rVisibleRect.y;
            Point pt = new Point(1, nFirstRowLoc + 1);
            int nFirstVisibleRow = this.GetTable().rowAtPoint(pt);
            Rectangle rCellRect = this.GetTable().getCellRect(nFirstVisibleRow, 0, false);
            if (rCellRect.y < rVisibleRect.y) {
                ++nFirstVisibleRow;
            }
            int nLastRowLoc = rVisibleRect.y + rVisibleRect.height;
            pt = new Point(1, nLastRowLoc - 1);
            int nLastVisibleRow = this.GetTable().rowAtPoint(pt);
            rCellRect = this.GetTable().getCellRect(nLastVisibleRow, 0, false);
            if (rCellRect.y + rCellRect.height > rVisibleRect.y + rVisibleRect.height) {
                --nLastVisibleRow;
            }
            if (nFirstVisibleRow < 0 || nFirstVisibleRow > this.GetTable().getRowCount() - 1) {
                nFirstVisibleRow = 0;
            }
            if (nLastVisibleRow < 0 || nLastVisibleRow > this.GetTable().getRowCount() - 1) {
                nLastVisibleRow = this.GetTable().getRowCount() - 1;
            }
            if (DEBUG) {
                System.out.printf("Visible Row Range: %d - %d\r\n", nFirstVisibleRow, nLastVisibleRow);
            }
            if (bHeadingUpTheList) {
                if (nCurSelIndex > nFirstVisibleRow) {
                    this.SetPageSelectionInterval(nFirstVisibleRow, bIsCtrlDown, bIsShiftDown);
                } else {
                    int nScrollRow = nFirstVisibleRow - (nLastVisibleRow - nFirstVisibleRow);
                    if (nScrollRow < 0) {
                        nScrollRow = 0;
                    }
                    if (DEBUG) {
                        System.out.printf("ScrollToRow: %d\r\n", nScrollRow);
                    }
                    if ((rCellRect = this.GetTable().getCellRect(nScrollRow, 0, false)) != null) {
                        this.GetTable().scrollRectToVisible(rCellRect);
                    }
                    this.SetPageSelectionInterval(nScrollRow, bIsCtrlDown, bIsShiftDown);
                }
                bHandled = true;
            } else {
                if (nCurSelIndex < nLastVisibleRow) {
                    this.SetPageSelectionInterval(nLastVisibleRow, bIsCtrlDown, bIsShiftDown);
                } else {
                    int nScrollRow = nLastVisibleRow + (nLastVisibleRow - nFirstVisibleRow);
                    if (nScrollRow > this.GetTable().getRowCount()) {
                        nScrollRow = this.GetTable().getRowCount() - 1;
                    }
                    if (DEBUG) {
                        System.out.printf("ScrollToRow: %d\r\n", nScrollRow);
                    }
                    if ((rCellRect = this.GetTable().getCellRect(nScrollRow, 0, false)) != null) {
                        this.GetTable().scrollRectToVisible(rCellRect);
                    }
                    this.SetPageSelectionInterval(nScrollRow, bIsCtrlDown, bIsShiftDown);
                }
                bHandled = true;
            }
        }
        return bHandled;
    }

    private boolean OnPageDownTable(boolean bIsCtrlDown, boolean bIsShiftDown) {
        return this.OnPageAdjustTable(false, bIsCtrlDown, bIsShiftDown);
    }

    private boolean OnPageUpTable(boolean bIsCtrlDown, boolean bIsShiftDown) {
        return this.OnPageAdjustTable(true, bIsCtrlDown, bIsShiftDown);
    }

    private boolean OnPageAdjustList(boolean bHeadingUpTheList, boolean bIsCtrlDown, boolean bIsShiftDown) {
        boolean bHandled = false;
        if (this.GetSelModel() != null && this.GetList() != null && this.GetListViewport() != null) {
            int nCurSelIndex = 0;
            if (this.GetSelModel() != null) {
                nCurSelIndex = this.GetSelModel().getLeadSelectionIndex();
            }
            Rectangle rVisibleRect = this.GetList().getVisibleRect();
            int nFirstRowLoc = rVisibleRect.y;
            Point pt = new Point(1, nFirstRowLoc + 1);
            int nFirstVisibleRow = this.GetList().locationToIndex(pt);
            Rectangle rCellRect = this.GetList().getCellBounds(nFirstVisibleRow, nFirstVisibleRow);
            if (rCellRect.y < rVisibleRect.y) {
                ++nFirstVisibleRow;
            }
            int nLastRowLoc = rVisibleRect.y + rVisibleRect.height;
            pt = new Point(1, nLastRowLoc - 1);
            int nLastVisibleRow = this.GetList().locationToIndex(pt);
            rCellRect = this.GetList().getCellBounds(nLastVisibleRow, nLastVisibleRow);
            if (rCellRect.y + rCellRect.height > rVisibleRect.y + rVisibleRect.height) {
                --nLastVisibleRow;
            }
            if (nFirstVisibleRow < 0 || nFirstVisibleRow > this.GetModel().getSize() - 1) {
                nFirstVisibleRow = 0;
            }
            if (nLastVisibleRow < 0 || nLastVisibleRow > this.GetModel().getSize() - 1) {
                nLastVisibleRow = this.GetModel().getSize() - 1;
            }
            if (DEBUG) {
                System.out.printf("Visible Row Range: %d - %d\r\n", nFirstVisibleRow, nLastVisibleRow);
            }
            if (bHeadingUpTheList) {
                if (nCurSelIndex > nFirstVisibleRow) {
                    this.SetPageSelectionInterval(nFirstVisibleRow, bIsCtrlDown, bIsShiftDown);
                } else {
                    int nScrollRow = nFirstVisibleRow - (nLastVisibleRow - nFirstVisibleRow);
                    if (nScrollRow < 0) {
                        nScrollRow = 0;
                    }
                    if (DEBUG) {
                        System.out.printf("ScrollToRow: %d\r\n", nScrollRow);
                    }
                    if ((rCellRect = this.GetList().getCellBounds(nScrollRow, nScrollRow)) != null) {
                        this.GetList().scrollRectToVisible(rCellRect);
                    }
                    this.SetPageSelectionInterval(nScrollRow, bIsCtrlDown, bIsShiftDown);
                }
                bHandled = true;
            } else {
                if (nCurSelIndex < nLastVisibleRow) {
                    this.SetPageSelectionInterval(nLastVisibleRow, bIsCtrlDown, bIsShiftDown);
                } else {
                    int nScrollRow = nLastVisibleRow + (nLastVisibleRow - nFirstVisibleRow);
                    if (nScrollRow > this.GetModel().getSize()) {
                        nScrollRow = this.GetModel().getSize() - 1;
                    }
                    if (DEBUG) {
                        System.out.printf("ScrollToRow: %d\r\n", nScrollRow);
                    }
                    if ((rCellRect = this.GetList().getCellBounds(nScrollRow, nScrollRow)) != null) {
                        this.GetList().scrollRectToVisible(rCellRect);
                    }
                    this.SetPageSelectionInterval(nScrollRow, bIsCtrlDown, bIsShiftDown);
                }
                bHandled = true;
            }
        }
        return bHandled;
    }

    private boolean OnPageAdjustListHorz(boolean bHeadingUpTheList, boolean bIsCtrlDown, boolean bIsShiftDown) {
        boolean bHandled = false;
        return bHandled;
    }

    private boolean OnPageDownList(boolean bIsCtrlDown, boolean bIsShiftDown) {
        boolean bHandled = false;
        if (this.GetList() != null) {
            int nWrap = this.GetList().getLayoutOrientation();
            bHandled = nWrap == 1 || this.GetView() == 4 ? this.OnPageAdjustListHorz(false, bIsCtrlDown, bIsShiftDown) : this.OnPageAdjustList(false, bIsCtrlDown, bIsShiftDown);
        }
        return bHandled;
    }

    private boolean OnPageUpList(boolean bIsCtrlDown, boolean bIsShiftDown) {
        boolean bHandled = false;
        if (this.GetList() != null) {
            int nWrap = this.GetList().getLayoutOrientation();
            bHandled = nWrap == 1 || this.GetView() == 4 ? this.OnPageAdjustListHorz(true, bIsCtrlDown, bIsShiftDown) : this.OnPageAdjustList(true, bIsCtrlDown, bIsShiftDown);
        }
        return bHandled;
    }

    protected void OnSyncFoldersTo(CFile rSyncFoldersTo) {
        CPath rLocalPath = null;
        CPath rRemotePath = null;
        if (this.GetDisplayFile() != null) {
            if (this.GetDisplayFile().IsLocal()) {
                rLocalPath = this.GetDisplayFile().CreatePath();
            } else {
                rRemotePath = this.GetDisplayFile().CreatePath();
            }
        }
        if (rSyncFoldersTo != null) {
            if (rSyncFoldersTo.IsLocal()) {
                rLocalPath = rSyncFoldersTo.CreatePath();
            } else {
                rRemotePath = rSyncFoldersTo.CreatePath();
            }
        }
        if (DEBUG) {
            String sLocal = "";
            String sRemote = "";
            if (rLocalPath != null) {
                sLocal = rLocalPath.GetPath();
            }
            if (rRemotePath != null) {
                sRemote = rRemotePath.GetPath();
            }
            System.out.printf("SyncFolders - Local: %s | Remote: %s\r\n", sLocal, sRemote);
        }
        CPath[] arPaths = new CPath[]{rLocalPath, rRemotePath};
        CRhinoEvent rEvent = new CRhinoEvent(this, 2011, arPaths);
        CMainEventQueue.PostEvent(rEvent);
    }

    public int GetCompressionType() {
        int nCompressionType = 0;
        if (CMainFrame.GET_APP() != null) {
            nCompressionType = CMainFrame.GET_APP().GetCompressionType();
        }
        return nCompressionType;
    }

    private void SaveSelections() {
        this.m_nSelLeadRow = this.GetSelModel().getLeadSelectionIndex();
        this.m_sLeadSelAbsPath = this.GetLeadSelectionAbsPath();
        this.m_asSelAbsPaths = this.GetSelectedAbsPaths();
    }

    private void LoadSelections() {
        if (DEBUG_TRACE_METHODS) {
            System.out.println("CFilePanel.SortModelRetainSelection (overloaded) -->");
        }
        this.SetSelectedAbsPaths(this.m_asSelAbsPaths);
        this.SetLeadSelection(this.m_sLeadSelAbsPath, this.m_nSelLeadRow);
        if (DEBUG_TRACE_METHODS) {
            System.out.println("CFilePanel.SortModelRetainSelection (overloaded) <--");
        }
    }

    static {
        if (DEBUG) {
            // empty if block
        }
        DEBUG_TRACE_METHODS = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_LOAD_COLS = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_TRACK_DND_DRAG_EVENTS = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_TRACK_DND_DROP_EVENTS = false;
        DEBUG_TRACK_IMPORT_DATA = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_RENAME_EDITOR = false;
        HTML_FMT_BOLD = "<html><span style=\"font-weight: bold;\">%s</span></html>";
    }
}

