/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.FilePanel;

import com.rhinosoft.FilePanel.CLnFTableHeaderRenderer;
import com.rhinosoft.FilePanel.ITableSorter;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class CFileTableHeaderRenderer
extends CLnFTableHeaderRenderer {
    public static final int HEADER_LABEL_ICON_GAP = 4;
    private ITableSorter m_rSorter;

    public CFileTableHeaderRenderer(ITableSorter rSorter) {
        this.m_rSorter = rSorter;
    }

    @Override
    protected Component FormatLnFCell(JTable rTable, Object rValObj, boolean bIsSelected, boolean bHasFocus, int nRow, int nCol) {
        Component rRenderedCell = super.FormatLnFCell(rTable, rValObj, bIsSelected, bHasFocus, nRow, nCol);
        if (rRenderedCell instanceof DefaultTableCellRenderer) {
            DefaultTableCellRenderer rDefCell = (DefaultTableCellRenderer)rRenderedCell;
            rDefCell.setHorizontalTextPosition(2);
            rDefCell.setIconTextGap(4);
            int nModelCol = rTable.convertColumnIndexToModel(nCol);
            ImageIcon icoIcon = this.GetSortIcon(this.m_rSorter.GetSortDirection(), nModelCol, rTable);
            rDefCell.setIcon(icoIcon);
            if (nModelCol == 1) {
                rDefCell.setHorizontalAlignment(4);
            }
        }
        return rRenderedCell;
    }

    private ImageIcon GetSortIcon(int nSortDirection, int nModelColToRender, JTable rTable) {
        ImageIcon icoSortArrow = null;
        boolean bGetSortIcon = false;
        if (nModelColToRender == this.m_rSorter.GetSortModelCol()) {
            bGetSortIcon = true;
        }
        if (bGetSortIcon) {
            icoSortArrow = this.GetSortIcon(nSortDirection, rTable);
        }
        return icoSortArrow;
    }

    private ImageIcon GetSortIcon(int nSortDirection, JTable rTable) {
        ImageIcon icoSortArrow = null;
        if (rTable != null) {
            if (nSortDirection == 1) {
                icoSortArrow = CMainFrame.GetJARImage("SortUpArrow.png");
            } else if (nSortDirection == 2) {
                icoSortArrow = CMainFrame.GetJARImage("SortDownArrow.png");
            }
        }
        return icoSortArrow;
    }
}

