/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.FilePanel;

import com.rhinosoft.FilePanel.ITableSorter;
import com.rhinosoft.base.files.CFile;
import com.rhinosoft.base.files.CFileSystemUtils;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import javax.swing.filechooser.FileSystemView;

public class CFileTableSorter
implements Comparator<CFile>,
ITableSorter {
    public static final int SORT_OFF = 0;
    public static final int SORT_ASCENDING = 1;
    public static final int SORT_DESCENDING = 2;
    public static final boolean DEBUG = CMainFrame.DEBUG;
    public static final boolean DEBUG_TRACE_METHODS;
    private int m_nSortModelCol;
    private int m_nSortDirection = 1;

    public CFileTableSorter(int nSortModelCol) {
        this.m_nSortModelCol = nSortModelCol;
    }

    @Override
    public final int GetSortModelCol() {
        return this.m_nSortModelCol;
    }

    @Override
    public boolean SetSortModelCol(int nSortModelCol) {
        boolean bDirty = false;
        if (this.m_nSortModelCol != nSortModelCol) {
            bDirty = true;
            this.m_nSortModelCol = nSortModelCol;
        }
        return bDirty;
    }

    @Override
    public boolean IsAscending() {
        return this.m_nSortDirection == 1;
    }

    @Override
    public boolean IsDescending() {
        return this.m_nSortDirection == 2;
    }

    @Override
    public int GetSortDirection() {
        return this.m_nSortDirection;
    }

    @Override
    public boolean SetSortDirection(int nSortDirection) {
        boolean bDirty = false;
        if (this.m_nSortDirection != nSortDirection) {
            bDirty = true;
            this.m_nSortDirection = nSortDirection;
        }
        return bDirty;
    }

    @Override
    public int compare(CFile f1, CFile f2) {
        if (DEBUG_TRACE_METHODS) {
            System.out.println("CFileTableSorter.compare -->");
        }
        int nRet = 0;
        if (f1 != null && f2 != null) {
            int nSortCol = this.GetSortModelCol();
            if (nSortCol == 0) {
                nRet = this.SortName(f1, f2);
            } else if (nSortCol == 1) {
                nRet = this.SortSize(f1, f2);
            } else if (nSortCol == 2) {
                nRet = this.SortType(f1, f2);
            } else if (nSortCol == 3) {
                nRet = this.SortDateModified(f1, f2);
            } else if (nSortCol == 4) {
                nRet = this.SortParentPath(f1, f2);
            }
        }
        if (DEBUG_TRACE_METHODS) {
            System.out.println("CFileTableSorter.compare <--");
        }
        return nRet;
    }

    private int SortName(CFile f1, CFile f2) {
        return CFileTableSorter.SortName(this.IsAscending(), f1, f2);
    }

    public static int SortName(boolean bIsAscending, CFile f1, CFile f2) {
        int nRet = 0;
        boolean bIsDir1 = f1.IsDirectory();
        boolean bIsDir2 = f2.IsDirectory();
        if (bIsDir1 && !bIsDir2) {
            nRet = bIsAscending ? -1 : 1;
        } else if (!bIsDir1 && bIsDir2) {
            nRet = bIsAscending ? 1 : -1;
        } else {
            String sAbsPath1 = f1.GetPath();
            String sAbsPath2 = f2.GetPath();
            CFileSystemUtils fsu = CFileSystemUtils.GetFileSysUtils();
            boolean bIsVirtualDir1 = fsu.IsRoot(sAbsPath1);
            boolean bIsVirtualDir2 = fsu.IsRoot(sAbsPath2);
            if (bIsVirtualDir1 && !bIsVirtualDir2) {
                nRet = bIsAscending ? -1 : 1;
            } else if (!bIsVirtualDir1 && bIsVirtualDir2) {
                nRet = bIsAscending ? 1 : -1;
            } else {
                String sDisplayName1 = f1.GetDisplayName();
                String sDisplayName2 = f2.GetDisplayName();
                if (f1.IsDrive() && f2.IsDrive()) {
                    nRet = CFileTableSorter.Compare(bIsAscending, sAbsPath1, sAbsPath2, true);
                } else {
                    String sDisplayName;
                    if (bIsVirtualDir1 && (sDisplayName = FileSystemView.getFileSystemView().getSystemDisplayName(fsu.GetRoot(sDisplayName1))) != null && sDisplayName.length() > 0) {
                        sDisplayName1 = sDisplayName;
                    }
                    if (bIsVirtualDir2 && (sDisplayName = FileSystemView.getFileSystemView().getSystemDisplayName(fsu.GetRoot(sDisplayName2))) != null && sDisplayName.length() > 0) {
                        sDisplayName2 = sDisplayName;
                    }
                    nRet = CFileTableSorter.Compare(bIsAscending, sDisplayName1, sDisplayName2, true);
                }
            }
        }
        return nRet;
    }

    public static int Compare(boolean bIsAscending, String sText1, String sText2, boolean bCompareNoCase) {
        int nRet = 0;
        if (sText1 != null && sText2 != null) {
            if (bCompareNoCase) {
                sText1 = sText1.toLowerCase();
                sText2 = sText2.toLowerCase();
            }
            if (CMainFrame.GET_APP() != null && CMainFrame.GET_APP().GetClientInfo() != null) {
                String sLanguageCode = CMainFrame.GET_APP().GetClientInfo().GetLanguageCode();
                String sCountryCode = CMainFrame.GET_APP().GetClientInfo().GetCountryCode();
                Locale rUserLocale = new Locale(sLanguageCode, sCountryCode);
                Collator colr = Collator.getInstance(rUserLocale);
                nRet = bIsAscending ? colr.compare(sText1, sText2) : colr.compare(sText2, sText1);
            }
        }
        return nRet;
    }

    private int SortSize(CFile f1, CFile f2) {
        int nRet = 0;
        boolean bIsDir1 = f1.IsDirectory();
        boolean bIsDir2 = f2.IsDirectory();
        boolean bIsAscending = this.IsAscending();
        if (bIsDir1 && !bIsDir2) {
            nRet = bIsAscending ? -1 : 1;
        } else if (!bIsDir1 && bIsDir2) {
            nRet = bIsAscending ? 1 : -1;
        } else {
            long nSize2;
            long nSize1 = f1.GetSize();
            nRet = nSize1 < (nSize2 = f2.GetSize()) ? (bIsAscending ? -1 : 1) : (nSize1 > nSize2 ? (bIsAscending ? 1 : -1) : 0);
            if (nRet == 0) {
                nRet = this.SortName(f1, f2);
            }
        }
        return nRet;
    }

    private int SortType(CFile f1, CFile f2) {
        int nRet = 0;
        boolean bIsDir1 = f1.IsDirectory();
        boolean bIsDir2 = f2.IsDirectory();
        boolean bIsAscending = this.IsAscending();
        if (bIsDir1 && !bIsDir2) {
            nRet = bIsAscending ? -1 : 1;
        } else if (!bIsDir1 && bIsDir2) {
            nRet = bIsAscending ? 1 : -1;
        } else {
            nRet = CFileTableSorter.Compare(bIsAscending, f1.GetType(), f2.GetType(), true);
            if (nRet == 0) {
                nRet = this.SortName(f1, f2);
            }
        }
        return nRet;
    }

    private int SortDateModified(CFile f1, CFile f2) {
        int nRet = 0;
        boolean bIsDir1 = f1.IsDirectory();
        boolean bIsDir2 = f2.IsDirectory();
        boolean bIsAscending = this.IsAscending();
        if (bIsDir1 && !bIsDir2) {
            nRet = bIsAscending ? -1 : 1;
        } else if (!bIsDir1 && bIsDir2) {
            nRet = bIsAscending ? 1 : -1;
        } else {
            long nTime2;
            long nTime1 = f1.GetLastModified();
            nRet = nTime1 < (nTime2 = f2.GetLastModified()) ? (bIsAscending ? -1 : 1) : (nTime1 > nTime2 ? (bIsAscending ? 1 : -1) : 0);
            if (nRet == 0) {
                nRet = this.SortName(f1, f2);
            }
        }
        return nRet;
    }

    private int SortParentPath(CFile f1, CFile f2) {
        int nRet = 0;
        boolean bIsDir1 = f1.IsDirectory();
        boolean bIsDir2 = f2.IsDirectory();
        boolean bIsAscending = this.IsAscending();
        if (bIsDir1 && !bIsDir2) {
            nRet = bIsAscending ? -1 : 1;
        } else if (!bIsDir1 && bIsDir2) {
            nRet = bIsAscending ? 1 : -1;
        } else {
            CFileSystemUtils fsu = CFileSystemUtils.GetFileSysUtils();
            String sTest1 = f1.GetParentPath(true);
            String sTest2 = f2.GetParentPath(true);
            boolean bIsVirtualDir1 = fsu.IsRoot(sTest1);
            boolean bIsVirtualDir2 = fsu.IsRoot(sTest2);
            if (bIsVirtualDir1 && !bIsVirtualDir2) {
                nRet = bIsAscending ? -1 : 1;
            } else if (!bIsVirtualDir1 && bIsVirtualDir2) {
                nRet = bIsAscending ? 1 : -1;
            } else if (f1.IsDrive() && f2.IsDrive()) {
                nRet = CFileTableSorter.Compare(bIsAscending, sTest1, sTest2, true);
            } else {
                String sDisplayName;
                if (bIsVirtualDir1 && (sDisplayName = FileSystemView.getFileSystemView().getSystemDisplayName(fsu.GetRoot(sTest1))) != null && sDisplayName.length() > 0) {
                    sTest1 = sDisplayName;
                }
                if (bIsVirtualDir2 && (sDisplayName = FileSystemView.getFileSystemView().getSystemDisplayName(fsu.GetRoot(sTest2))) != null && sDisplayName.length() > 0) {
                    sTest2 = sDisplayName;
                }
                nRet = CFileTableSorter.Compare(bIsAscending, sTest1, sTest2, true);
            }
        }
        return nRet;
    }

    static {
        if (DEBUG) {
            // empty if block
        }
        DEBUG_TRACE_METHODS = false;
    }
}

