/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.FilePanel;

import com.rhinosoft.FilePanel.CFileModel;
import com.rhinosoft.base.files.CFile;
import com.rhinosoft.base.gui.components.files.tree.CFileTreeModel;
import com.rhinosoft.base.gui.components.files.tree.CFileTreeNode;
import com.rhinosoft.fvjv.gui.frames.browser.CBrowserTree;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.text.Position;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class CTypeAhead {
    protected static boolean DEBUG_CHANGE_TYPE_AHEAD = true;
    private Component m_rSource;
    private long m_nDateLastSearch;
    private String m_sSearchStr;

    public CTypeAhead(Component rSource) {
        this.InitVars(rSource);
    }

    private void InitVars(Component rSource) {
        this.m_rSource = rSource;
        this.m_nDateLastSearch = 0L;
        this.m_sSearchStr = "";
    }

    private Component GetSource() {
        return this.m_rSource;
    }

    public boolean CanTypeAhead(KeyEvent rEvent) {
        boolean bCanTypeAhead = false;
        if (rEvent != null && !rEvent.isAltDown()) {
            bCanTypeAhead = true;
            int[] anExcludeInSearch = new int[]{112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 155, 127, 36, 35, 33, 34, 37, 39, 38, 40, 10, 8, 20, 9, 27, 154, 145, 19, 144, Integer.MIN_VALUE};
            for (int nIdx = 0; nIdx < anExcludeInSearch.length; ++nIdx) {
                int nExcludedKeyCode = anExcludeInSearch[nIdx];
                if (nExcludedKeyCode != rEvent.getKeyCode() && nExcludedKeyCode != Integer.MIN_VALUE) continue;
                if (nExcludedKeyCode != rEvent.getKeyCode()) break;
                bCanTypeAhead = false;
                break;
            }
        }
        return bCanTypeAhead;
    }

    public void OnTypeAhead(String sSearchChar, int nSortCol, JTable rTable, CFileModel rModel, ListSelectionModel rSelModel) {
        this.OnTypeAheadEx(sSearchChar, nSortCol, rTable, rModel, rSelModel);
    }

    public void OnTypeAhead(String sSearchChar, int nSortCol, JList rList, CFileModel rModel, ListSelectionModel rSelModel) {
        this.OnTypeAheadEx(sSearchChar, nSortCol, rList, rModel, rSelModel);
    }

    private void OnTypeAhead(String sSearchChar, JTree rTree, CFileTreeModel rModel, TreeSelectionModel rSelModel, CBrowserTree rBrowserTree) {
        if (sSearchChar != null && !sSearchChar.isEmpty() && sSearchChar.length() == 1 && rTree != null && rModel != null && rSelModel != null && rBrowserTree != null) {
            sSearchChar = sSearchChar.toLowerCase();
            StringBuilder sbTemp = new StringBuilder();
            sbTemp.append(sSearchChar);
            String sKey = sbTemp.toString();
            long nDateNow = System.currentTimeMillis();
            if (sKey != null && !sKey.isEmpty()) {
                int nStartIdx = rTree.getLeadSelectionRow();
                if (nDateNow - this.m_nDateLastSearch > 750L) {
                    this.m_sSearchStr = sKey;
                    if (nStartIdx >= 0) {
                        ++nStartIdx;
                    }
                } else {
                    this.m_sSearchStr = this.m_sSearchStr + sKey;
                }
                this.m_nDateLastSearch = nDateNow;
                if (this.m_sSearchStr != null) {
                    TreePath rNextMatch;
                    rBrowserTree.SetIsTypeAhead(true);
                    if (nStartIdx >= rTree.getRowCount()) {
                        nStartIdx = 0;
                    }
                    if ((rNextMatch = rTree.getNextMatch(this.m_sSearchStr, nStartIdx, Position.Bias.Forward)) == null) {
                        rNextMatch = rTree.getNextMatch(this.m_sSearchStr, 0, Position.Bias.Forward);
                    }
                    rBrowserTree.SetIsTypeAhead(false);
                    if (rNextMatch != null) {
                        if (DEBUG_CHANGE_TYPE_AHEAD) {
                            System.out.printf("Looking for: %s | ", this.m_sSearchStr);
                            Object objLast = rNextMatch.getLastPathComponent();
                            if (objLast instanceof CFileTreeNode) {
                                CFileTreeNode rNode = (CFileTreeNode)objLast;
                                CFile fFile = rNode.GetFile();
                                if (fFile != null) {
                                    System.out.printf("Next match: %s\r\n", fFile.GetDisplayName());
                                } else {
                                    System.out.printf("Next match: %s\r\n", rNextMatch.toString());
                                }
                            } else {
                                System.out.printf("Next match: %s\r\n", rNextMatch.toString());
                            }
                        }
                        rBrowserTree.StartChangeTimer(2000);
                        this.EnsureVisible(rTree, rNextMatch);
                        rTree.setSelectionPath(rNextMatch);
                    }
                }
            } else {
                this.m_sSearchStr = "";
                this.m_nDateLastSearch = 0L;
            }
        }
    }

    private void OnTypeAheadEx(String sSearchChar, int nSortCol, Component rComp, CFileModel rModel, ListSelectionModel rSelModel) {
        if (sSearchChar != null && !sSearchChar.isEmpty() && sSearchChar.length() == 1 && rComp != null && rModel != null && rSelModel != null) {
            sSearchChar = sSearchChar.toLowerCase();
            StringBuilder sbTemp = new StringBuilder();
            sbTemp.append(sSearchChar);
            String sKey = sbTemp.toString();
            long nDateNow = System.currentTimeMillis();
            if (sKey != null && !sKey.isEmpty() && nSortCol >= 0) {
                int nStartIdx = rSelModel.getLeadSelectionIndex();
                boolean bFound = false;
                String sTemp = "";
                if (nDateNow - this.m_nDateLastSearch > 750L) {
                    this.m_sSearchStr = sKey;
                    if (nStartIdx >= 0) {
                        ++nStartIdx;
                    }
                } else {
                    this.m_sSearchStr = this.m_sSearchStr + sKey;
                }
                this.m_nDateLastSearch = nDateNow;
                if (!this.ItemSearch(this.m_sSearchStr, nSortCol, nStartIdx, rModel.getRowCount(), rComp, rModel, rSelModel) && nStartIdx > 0) {
                    this.ItemSearch(this.m_sSearchStr, nSortCol, 0, nStartIdx, rComp, rModel, rSelModel);
                }
            } else {
                this.m_sSearchStr = "";
                this.m_nDateLastSearch = 0L;
            }
        }
    }

    private boolean ItemSearch(String sSearchStr, int nSortCol, int nStartIdx, int nStopIdx, Component rComp, CFileModel rModel, ListSelectionModel rSelModel) {
        boolean bFound = false;
        if (rComp != null && rModel != null && rSelModel != null) {
            for (int nIdx = nStartIdx; nIdx < nStopIdx; ++nIdx) {
                CFile fFile = rModel.GetFileAt(nIdx);
                if (fFile == null) continue;
                String sTemp = null;
                switch (nSortCol) {
                    case 1: {
                        if (fFile.IsDirectory()) break;
                        sTemp = CFile.FormatFileSize(fFile.GetSize(), false);
                        break;
                    }
                    case 2: {
                        sTemp = fFile.GetType();
                        break;
                    }
                    case 3: {
                        break;
                    }
                    default: {
                        sTemp = fFile.GetDisplayName();
                    }
                }
                if (sTemp == null || sTemp.isEmpty()) continue;
                if (sTemp.length() > sSearchStr.length()) {
                    sTemp = sTemp.substring(0, sSearchStr.length());
                }
                if (sTemp.isEmpty() || !(sTemp = sTemp.toLowerCase()).equals(sSearchStr)) continue;
                rSelModel.setSelectionInterval(nIdx, nIdx);
                this.EnsureVisible(rComp, nIdx, nSortCol);
                bFound = true;
                break;
            }
        }
        return bFound;
    }

    protected void EnsureVisible(Component rComp, int nRow, int nCol) {
        if (rComp != null) {
            if (rComp instanceof JTable) {
                this.EnsureVisible((JTable)rComp, nRow, nCol);
            } else if (rComp instanceof JList) {
                this.EnsureVisible((JList)rComp, nRow, nCol);
            } else if (rComp instanceof JTree) {
                this.EnsureVisible((JTree)rComp, nRow, nCol);
            }
        }
    }

    private void EnsureVisible(JTable rTable, int nRow, int nCol) {
        if (rTable != null) {
            Rectangle rRect = rTable.getCellRect(nRow, nCol, true);
            rTable.scrollRectToVisible(rRect);
        }
    }

    private void EnsureVisible(JList rList, int nRow, int nCol) {
        Rectangle rRect;
        if (rList != null && (rRect = rList.getCellBounds(nRow, nRow)) != null) {
            rList.scrollRectToVisible(rRect);
        }
    }

    protected void EnsureVisible(JTree rTree, TreePath rTreePath) {
        if (rTree != null && rTreePath != null) {
            rTree.scrollPathToVisible(rTreePath);
            rTree.requestFocusInWindow();
        }
    }
}

