/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.TransferPanel;

import com.rhinosoft.FilePanel.CFilePanel;
import com.rhinosoft.FilePanel.CTableCellRenderer;
import com.rhinosoft.TransferPanel.CTransferRow;
import com.rhinosoft.TransferPanel.CTransferRowEvent;
import com.rhinosoft.TransferPanel.CTransferTableCellRenderer;
import com.rhinosoft.TransferPanel.CTransferTableHeaderRenderer;
import com.rhinosoft.TransferPanel.CTransferTableModel;
import com.rhinosoft.TransferPanel.ITransferRowListener;
import com.rhinosoft.base.CConversionUtils;
import com.rhinosoft.base.gui.events.CBaseAction;
import com.rhinosoft.base.gui.events.CRhinoEvent;
import com.rhinosoft.base.gui.tables.CTableViewport;
import com.rhinosoft.base.threads.CWorkerThread;
import com.rhinosoft.fvjv.gui.dialogs.CConfirmTransferCancelDlg;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.gui.frames.IArchive;
import com.rhinosoft.fvjv.strings.CString;
import com.rhinosoft.fvjv.threads.CThreadMsgTransfer;
import com.rhinosoft.fvjv.threads.remote.CThreadMsgSyncFoldersExecute;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class CTransferScrollPane
extends JScrollPane
implements MouseListener,
ListSelectionListener,
TableColumnModelListener,
ITransferRowListener,
KeyListener {
    protected static final boolean DEBUG_LOAD_COLS;
    public static final String DELIMITER_COL_WIDTHS = ",";
    public static final int DEF_COL_WIDTH = 110;
    private JTable m_Table;
    private CTransferTableCellRenderer m_TableCellRenderer;
    private CTransferTableModel m_DataModel;
    private CTransferTableHeaderRenderer m_TableHeaderRenderer;
    private JPopupMenu m_cPopupMenu;
    private JMenuItem m_cRemoveMenuItem;
    private ActionListener m_jOnUpdateListener;

    public CTransferScrollPane() {
        this.InitVars();
    }

    private void InitVars() {
        this.InitPopupMenu();
    }

    public void OnCreate() {
        this.m_DataModel = new CTransferTableModel();
        if (this.GetModel() != null) {
            this.m_Table = new JTable(this.GetModel());
        } else if (CMainFrame.GetDebugLogger() != null) {
            CMainFrame.GetDebugLogger().Info("ASSERT:  Programming error, GetModel() = null");
        }
        CTableViewport rViewport = new CTableViewport(this.GetTable());
        this.setViewport(rViewport);
        this.m_TableCellRenderer = new CTransferTableCellRenderer(this.GetTable(), rViewport);
        if (this.GetTable() != null) {
            TableColumnModel rColModel = this.GetTable().getColumnModel();
            if (rColModel != null) {
                for (int nIdx = 0; nIdx < rColModel.getColumnCount(); ++nIdx) {
                    TableColumn rColumn = rColModel.getColumn(nIdx);
                    if (rColumn == null) continue;
                    if (this.GetTableRenderer() != null) {
                        rColumn.setCellRenderer(this.GetTableRenderer());
                    }
                    rColumn.setIdentifier(nIdx);
                }
                rColModel.addColumnModelListener(this);
            }
            this.GetTable().setAutoResizeMode(0);
            JTableHeader rHeader = this.GetTable().getTableHeader();
            if (rHeader != null) {
                this.m_TableHeaderRenderer = new CTransferTableHeaderRenderer();
                if (this.GetTableHeaderRenderer() != null) {
                    this.GetTableHeaderRenderer().UpdateUIRenderer();
                    rHeader.setDefaultRenderer(this.GetTableHeaderRenderer());
                } else if (CMainFrame.GetDebugLogger() != null) {
                    CMainFrame.GetDebugLogger().Info("ASSERT:  Programming error, GetTableHeaderRenderer() = null");
                }
            }
        } else if (CMainFrame.GetDebugLogger() != null) {
            CMainFrame.GetDebugLogger().Info("ASSERT:  Programming error, GetTable() = null");
        }
        this.addMouseListener(this);
        if (this.GetTable() != null) {
            this.GetTable().addMouseListener(this);
            if (this.GetTable().getSelectionModel() != null) {
                this.GetTable().getSelectionModel().addListSelectionListener(this);
            }
            this.GetTable().addKeyListener(this);
            this.addKeyListener(this);
        } else if (CMainFrame.GetDebugLogger() != null) {
            CMainFrame.GetDebugLogger().Info("ASSERT:  Programming error, GetTable() = null");
        }
        if (this.GetArchive() != null) {
            this.LoadColIndices("TransferColIndices", this.GetDefColIndices(), this.GetArchive());
        }
    }

    private boolean IsValidRow(int nRow) {
        boolean bValid = false;
        if (this.GetTable() != null) {
            if (nRow > -1 && nRow < this.GetTable().getRowCount()) {
                bValid = true;
            }
        } else if (CMainFrame.GetDebugLogger() != null) {
            CMainFrame.GetDebugLogger().Info("ASSERT:  Programming error, GetTable() = null");
        }
        return bValid;
    }

    @Override
    public void mouseClicked(MouseEvent rMouseEvent) {
        Object objSource = rMouseEvent.getSource();
        if (SwingUtilities.isRightMouseButton(rMouseEvent)) {
            if (this.GetTable() != null) {
                this.GetTable().requestFocus();
            }
            if (objSource == this.GetTable() || objSource == this.getViewport() || objSource == this) {
                Point pt = rMouseEvent.getPoint();
                int nRow = this.GetTable().rowAtPoint(pt);
                if (this.IsValidRow(nRow) && !this.GetSelModel().isSelectedIndex(nRow)) {
                    this.GetSelModel().clearSelection();
                    this.GetSelModel().addSelectionInterval(nRow, nRow);
                }
                if (objSource instanceof Component) {
                    pt = SwingUtilities.convertPoint((Component)objSource, pt, this);
                }
                if (this.GetPopupMenu() != null) {
                    this.GetPopupMenu().show(this, pt.x, pt.y);
                }
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent rMouseEvent) {
        if (this.GetTable() != null) {
            this.GetTable().requestFocus();
        }
    }

    @Override
    public void mouseReleased(MouseEvent rMouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent rMouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent rMouseEvent) {
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.GetTable() != null) {
            this.GetTable().updateUI();
            if (this.GetTableHeaderRenderer() != null) {
                this.GetTableHeaderRenderer().UpdateUIRenderer();
            } else if (CMainFrame.GetDebugLogger() != null) {
                CMainFrame.GetDebugLogger().Info("ASSERT:  Programming error, GetTableHeaderRenderer() = null");
            }
        } else if (CMainFrame.GetDebugLogger() != null) {
            CMainFrame.GetDebugLogger().Info("ASSERT:  Programming error, GetTable() = null");
        }
        if (this.m_cPopupMenu != null) {
            SwingUtilities.updateComponentTreeUI(this.m_cPopupMenu);
        }
    }

    private CTransferTableModel GetModel() {
        return this.m_DataModel;
    }

    public JTable GetTable() {
        return this.m_Table;
    }

    private CTransferTableHeaderRenderer GetTableHeaderRenderer() {
        return this.m_TableHeaderRenderer;
    }

    private ListSelectionModel GetSelModel() {
        ListSelectionModel rModel = null;
        if (this.GetTable() != null) {
            rModel = this.GetTable().getSelectionModel();
        } else if (CMainFrame.GetDebugLogger() != null) {
            CMainFrame.GetDebugLogger().Info("ASSERT:  Programming error, GetTable() = null");
        }
        return rModel;
    }

    private void PostThreadCommand(int nCmd) {
        if (this.GetTable() != null) {
            if (this.GetModel() != null) {
                Object[] aSelRows = this.GetSelRows();
                if (aSelRows != null) {
                    for (Object rRow : aSelRows) {
                        CWorkerThread tThread;
                        if (!(rRow instanceof CTransferRow) || (tThread = ((CTransferRow)rRow).GetThread()) == null) continue;
                        this.PostEvent(nCmd, tThread.getId());
                    }
                }
            } else if (CMainFrame.GetDebugLogger() != null) {
                CMainFrame.GetDebugLogger().Info("ASSERT:  Programming error, GetModel() = null");
            }
        } else if (CMainFrame.GetDebugLogger() != null) {
            CMainFrame.GetDebugLogger().Info("ASSERT:  Programming error, GetTable() = null");
        }
    }

    private Object[] GetSelRows() {
        CTransferRow[] aSelRows = null;
        int[] anSelRows = null;
        if (this.GetTable() != null) {
            anSelRows = this.GetTable().getSelectedRows();
        } else if (CMainFrame.GetDebugLogger() != null) {
            CMainFrame.GetDebugLogger().Info("ASSERT:  Programming error, GetTable() = null");
        }
        if (anSelRows != null && anSelRows.length > 0) {
            aSelRows = new CTransferRow[anSelRows.length];
            for (int nIdx = 0; nIdx < anSelRows.length; ++nIdx) {
                int nRow = anSelRows[nIdx];
                aSelRows[nIdx] = this.GetModel().GetRowObj(nRow);
            }
        }
        return aSelRows;
    }

    private void RemoveRow(Thread tThread) {
        if (this.GetModel() != null) {
            this.GetModel().RemoveRow(tThread, true);
        } else if (CMainFrame.GetDebugLogger() != null) {
            CMainFrame.GetDebugLogger().Info("ASSERT:  Programming error, GetModel() = null");
        }
    }

    private void SetThreadStatus(Thread tThread, int nStatus) {
        if (this.GetModel() != null) {
            int nRowIdx;
            CTransferRow rRow = this.GetModel().GetRowObj(tThread);
            if (rRow != null) {
                rRow.SetThreadStatus(nStatus);
            }
            if ((nRowIdx = this.GetModel().GetRowIdx(tThread)) > -1) {
                this.GetModel().fireTableRowsUpdated(nRowIdx, nRowIdx);
            }
        }
    }

    public void OnInitialUpdate() {
        this.UpdateBtnStates();
        this.UpdateBtnSelections();
        this.LoadColWidths();
    }

    private CTransferTableCellRenderer GetTableRenderer() {
        return this.m_TableCellRenderer;
    }

    protected IArchive GetArchive() {
        IArchive rArchive = null;
        if (CMainFrame.GET_APP() != null) {
            rArchive = CMainFrame.GET_APP().GetArchive();
        }
        return rArchive;
    }

    protected void LoadColIndices(String sKey, String sDef, IArchive rArchive) {
        TableColumnModel rColModel;
        String[] asItems;
        String sVals;
        if (rArchive != null && (sVals = rArchive.GetValue(sKey, sDef)) != null && !sVals.isEmpty() && (asItems = sVals.split(DELIMITER_COL_WIDTHS)).length == 7 && this.GetTable() != null && (rColModel = this.GetTable().getColumnModel()) != null) {
            block0: for (int nIdx = 0; nIdx < 7; ++nIdx) {
                Integer nPrevViewIdx;
                if (DEBUG_LOAD_COLS) {
                    System.out.println("--- Table Dump");
                    for (int nTemp = 0; nTemp < 7; ++nTemp) {
                        System.out.println(String.format("    %d, %d", nTemp, this.GetTable().convertColumnIndexToModel(nTemp)));
                    }
                }
                if (CConversionUtils.IsValidInt(nPrevViewIdx = Integer.valueOf(CConversionUtils.ConvertToInt(asItems[nIdx]))) && DEBUG_LOAD_COLS) {
                    System.out.println(String.format("Model idx:  %d should be put at view idx:  %d", nIdx, nPrevViewIdx));
                }
                for (int nIdx2 = nIdx; nIdx2 < 7; ++nIdx2) {
                    int nModelIdx = this.GetTable().convertColumnIndexToModel(nIdx2);
                    if (nModelIdx != nPrevViewIdx) continue;
                    this.GetTable().moveColumn(nIdx2, nIdx);
                    continue block0;
                }
            }
        }
    }

    protected void SaveColIndices(String sKey, String sDef, IArchive rArchive) {
        TableColumnModel rColModel;
        if (rArchive != null && this.GetTable() != null && (rColModel = this.GetTable().getColumnModel()) != null) {
            int[] anIndices = new int[7];
            for (int nIdx = 0; nIdx < 7; ++nIdx) {
                int nModelColIdx;
                anIndices[nIdx] = nModelColIdx = this.GetTable().convertColumnIndexToModel(nIdx);
            }
            StringBuilder sIndices = new StringBuilder();
            for (int nIdx = 0; nIdx < 7; ++nIdx) {
                sIndices.append(Integer.toString(anIndices[nIdx]));
                if (nIdx + 1 >= 7) continue;
                sIndices.append(DELIMITER_COL_WIDTHS);
            }
            rArchive.SetValue(sKey, sIndices.toString(), sDef);
        }
    }

    @Override
    public void columnAdded(TableColumnModelEvent e) {
    }

    @Override
    public void columnRemoved(TableColumnModelEvent e) {
    }

    @Override
    public void columnMoved(TableColumnModelEvent e) {
        this.SaveColIndices("TransferColIndices", this.GetDefColIndices(), this.GetArchive());
    }

    @Override
    public void columnMarginChanged(ChangeEvent e) {
        this.SaveColWidths();
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent e) {
    }

    protected String GetDefColWidths() {
        String sRet = "";
        for (int nIdx = 0; nIdx < 7; ++nIdx) {
            if (nIdx != 0) {
                sRet = sRet + DELIMITER_COL_WIDTHS;
            }
            sRet = sRet + 110;
        }
        return sRet;
    }

    protected String GetDefColIndices() {
        return String.format("%d,%d,%d,%d,%d,%d,%d", 0, 1, 2, 3, 4, 5, 6);
    }

    private void OnActionStopAtNextFile() {
        int[] anSelRows;
        if (this.GetTable() != null && this.GetModel() != null && (anSelRows = this.GetTable().getSelectedRows()) != null && anSelRows.length == 1) {
            this.GetModel().OnStopAtNextFile(anSelRows[0]);
        }
        this.UpdateBtnSelections();
    }

    private void PostEvent(int nEventID, Object objEvent) {
        CRhinoEvent rEvent = new CRhinoEvent(this, nEventID, objEvent);
        Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(rEvent);
    }

    @Override
    public void processEvent(AWTEvent event) {
        CRhinoEvent rEvent;
        if (event instanceof CRhinoEvent && (rEvent = (CRhinoEvent)event) != null) {
            int nEventID = rEvent.getID();
            switch (nEventID) {
                case 6050: {
                    CTransferRow rRow;
                    Object[] anItems = (Object[])rEvent.GetEventObj();
                    if (anItems == null || anItems.length != 2) break;
                    CThreadMsgTransfer rOriginalMsg = null;
                    CThreadMsgTransfer rClonedMsg = null;
                    if (anItems[0] instanceof CThreadMsgTransfer) {
                        rOriginalMsg = (CThreadMsgTransfer)anItems[0];
                    }
                    if (anItems[1] instanceof CThreadMsgTransfer) {
                        rClonedMsg = (CThreadMsgTransfer)anItems[1];
                    }
                    if ((rRow = new CTransferRow(rClonedMsg, rOriginalMsg)) != null) {
                        rRow.AddTransferRowListener(this);
                        if (this.GetModel() != null) {
                            this.GetModel().AddTransferRow(rRow);
                        }
                    }
                    this.UpdateBtnStates();
                    this.UpdateBtnSelections();
                    break;
                }
                case 6051: {
                    if (!(rEvent.GetEventObj() instanceof CTransferRow)) break;
                    CTransferRow rRow = (CTransferRow)rEvent.GetEventObj();
                    rRow.AddTransferRowListener(this);
                    if (this.GetModel() != null) {
                        this.GetModel().AddTransferRow(rRow);
                    }
                    this.UpdateBtnStates();
                    this.UpdateBtnSelections();
                    break;
                }
                case 6053: {
                    if (!(rEvent.GetEventObj() instanceof CThreadMsgSyncFoldersExecute)) break;
                    CThreadMsgSyncFoldersExecute rMsg = (CThreadMsgSyncFoldersExecute)rEvent.GetEventObj();
                    if (this.GetModel() == null) break;
                    this.GetModel().UpdateTransferRowVisualMsg(rMsg);
                    break;
                }
                case 6052: {
                    Object rObj = rEvent.GetEventObj();
                    if (!(rObj instanceof CThreadMsgTransfer) || this.GetModel() == null) break;
                    this.GetModel().OnTransferStats((CThreadMsgTransfer)rObj);
                    break;
                }
                case 9021: {
                    this.UpdateBtnStates();
                    break;
                }
                case 9023: 
                case 9024: {
                    this.UpdateBtnSelections();
                    break;
                }
                case 2160: {
                    this.OnActionStopAtNextFile();
                    break;
                }
                case 2161: {
                    this.OnActionTransferSkipFile();
                    break;
                }
                case 2162: {
                    this.OnActionTransferPause();
                    break;
                }
                case 2163: {
                    this.OnActionTransferResume();
                    break;
                }
                case 2164: {
                    this.OnActionTransferCancel();
                    break;
                }
                case 2165: {
                    this.OnActionTransferRemove();
                    break;
                }
                case 9025: {
                    this.OnInitialUpdate();
                    break;
                }
                case 3005: 
                case 3020: 
                case 3021: 
                case 3022: {
                    if (this.GetModel() != null) {
                        this.GetModel().processEvent(event);
                    }
                    this.UpdateBtnStates();
                    this.UpdateBtnSelections();
                    break;
                }
                case 2902: {
                    if (this.GetModel() != null) {
                        this.GetModel().processEvent(event);
                    }
                    this.UpdateBtnStates();
                    this.UpdateBtnSelections();
                    break;
                }
                case 2021: {
                    this.SelectAll();
                    break;
                }
                case 2022: {
                    this.InvertSelection();
                    break;
                }
                default: {
                    super.processEvent(event);
                }
            }
        }
    }

    public boolean IsEventSource(Object objSource) {
        boolean bIsEventSource = false;
        if (objSource == this) {
            bIsEventSource = true;
        }
        if (!bIsEventSource && this.getViewport() != null && objSource == this.getViewport()) {
            bIsEventSource = true;
        }
        if (!bIsEventSource && this.GetTable() != null && objSource == this.GetTable()) {
            bIsEventSource = true;
        }
        return bIsEventSource;
    }

    private void UpdateBtnStates() {
        boolean bEnabledStopAtNextFile = false;
        boolean bEnabledSkipFile = false;
        boolean bEnabledPause = false;
        boolean bEnabledResume = false;
        boolean bEnabledCancel = false;
        boolean bEnabledCancelAll = false;
        boolean bEnabledRemove = false;
        boolean bEnabledRemoveAll = false;
        boolean bRemoveWhenDone = this.GetRemoveWhenDone();
        if (this.GetTable() != null) {
            int[] anSelRows = this.GetTable().getSelectedRows();
            if (anSelRows.length > 0) {
                if (anSelRows.length == 1) {
                    CTransferRow rTransferRow;
                    int nRowSel = anSelRows[0];
                    if (this.GetModel() != null && (rTransferRow = this.GetModel().GetRowObj(nRowSel)) != null) {
                        switch (rTransferRow.GetThreadStatus()) {
                            case 1: {
                                if (rTransferRow.GetFromPathSize() > 1) {
                                    bEnabledStopAtNextFile = true;
                                    bEnabledSkipFile = true;
                                }
                                bEnabledPause = true;
                                bEnabledResume = false;
                                bEnabledCancel = true;
                                break;
                            }
                            case 2: 
                            case 3: 
                            case 5: {
                                bEnabledStopAtNextFile = true;
                                bEnabledSkipFile = false;
                                bEnabledPause = false;
                                bEnabledResume = true;
                                bEnabledCancel = true;
                                break;
                            }
                            case 4: {
                                bEnabledStopAtNextFile = false;
                                bEnabledSkipFile = false;
                                bEnabledPause = false;
                                bEnabledResume = false;
                                bEnabledCancel = false;
                                break;
                            }
                            case 7: {
                                bEnabledStopAtNextFile = false;
                                bEnabledSkipFile = false;
                                bEnabledPause = false;
                                bEnabledResume = false;
                                bEnabledCancel = false;
                                break;
                            }
                        }
                    }
                } else {
                    for (int nIdx = 0; nIdx < anSelRows.length; ++nIdx) {
                        int nRowIdx = anSelRows[nIdx];
                        CTransferRow rRow = this.GetModel().GetRowObj(nRowIdx);
                        if (rRow == null) continue;
                        if (rRow.GetThreadStatus() == 1) {
                            bEnabledStopAtNextFile = true;
                            bEnabledSkipFile = true;
                            bEnabledPause = true;
                            bEnabledCancel = true;
                        }
                        if (rRow.GetThreadStatus() == 3 || rRow.GetThreadStatus() == 2) {
                            bEnabledResume = true;
                        }
                        if (rRow.GetThreadStatus() == 4 || rRow.GetThreadStatus() == 7) continue;
                        bEnabledCancel = true;
                    }
                }
                boolean bl = bEnabledRemove = !bRemoveWhenDone;
            }
            if (this.GetTable().getRowCount() > 0) {
                bEnabledRemoveAll = !bRemoveWhenDone;
            }
        }
        this.SetBtnEnabled(2160, bEnabledStopAtNextFile);
        this.SetBtnEnabled(2161, bEnabledSkipFile);
        this.SetBtnEnabled(2162, bEnabledPause);
        this.SetBtnEnabled(2163, bEnabledResume);
        this.SetBtnEnabled(2164, bEnabledCancel);
        this.SetBtnEnabled(2165, bEnabledRemove);
    }

    private boolean GetRemoveWhenDone() {
        Boolean bVal;
        IArchive rArchive;
        boolean bRemoveWhenDone = false;
        if (CMainFrame.GET_APP() != null && (rArchive = CMainFrame.GET_APP().GetArchive()) != null && (bVal = rArchive.GetValueBool("TransferRemoveDone", false)) != null) {
            bRemoveWhenDone = bVal;
        }
        return bRemoveWhenDone;
    }

    private void UpdateBtnSelections() {
        int[] anSelRows;
        boolean bStopAtNextFile = false;
        if (this.GetTable() != null && (anSelRows = this.GetTable().getSelectedRows()).length == 1) {
            CTransferRow rTransferRow;
            int nRowSel = anSelRows[0];
            if (this.GetModel() != null && (rTransferRow = this.GetModel().GetRowObj(nRowSel)) != null) {
                bStopAtNextFile = rTransferRow.GetStopAtNextItem();
            }
        }
        this.SetBtnSelected(2160, bStopAtNextFile);
    }

    private void SetBtnEnabled(int nEventID, boolean bEnabled) {
        Object[] anItems = new Object[]{nEventID, bEnabled};
        CRhinoEvent rEvent = new CRhinoEvent(this, 9020, anItems);
        if (CMainFrame.GET_APP() != null) {
            CMainFrame.GET_APP().dispatchEvent(rEvent);
        }
        this.OnUpdateBtnState(nEventID, bEnabled);
    }

    private void SetBtnSelected(int nEventID, boolean bSelected) {
        Object[] anItems = new Object[]{nEventID, bSelected};
        CRhinoEvent rEvent = new CRhinoEvent(this, 9022, anItems);
        if (CMainFrame.GET_APP() != null) {
            CMainFrame.GET_APP().dispatchEvent(rEvent);
        }
        this.OnUpdateBtnSelection(nEventID, bSelected);
    }

    private void OnUpdateBtnState(int nEventID, boolean bEnabled) {
        AbstractButton rBtn = this.GetPopupMenuBtn(nEventID);
        if (rBtn != null) {
            rBtn.setEnabled(bEnabled);
        }
    }

    private void OnUpdateBtnSelection(int nEventID, boolean bSelected) {
        AbstractButton rBtn = this.GetPopupMenuBtn(nEventID);
        if (rBtn != null) {
            rBtn.setSelected(bSelected);
        }
    }

    private void InitPopupMenu() {
        this.m_cPopupMenu = new JPopupMenu();
        JMenuItem cBtn = new JCheckBoxMenuItem(CMainFrame.GET_APP().GetAction(2160));
        this.m_cPopupMenu.add((Component)cBtn);
        cBtn = new JMenuItem(CMainFrame.GET_APP().GetAction(2161));
        this.m_cPopupMenu.add((Component)cBtn);
        this.m_cPopupMenu.addSeparator();
        cBtn = new JMenuItem(CMainFrame.GET_APP().GetAction(2162));
        this.m_cPopupMenu.add((Component)cBtn);
        cBtn = new JMenuItem(CMainFrame.GET_APP().GetAction(2163));
        this.m_cPopupMenu.add((Component)cBtn);
        this.m_cPopupMenu.addSeparator();
        cBtn = new JMenuItem(CMainFrame.GET_APP().GetAction(2164));
        this.m_cPopupMenu.add((Component)cBtn);
        this.m_cRemoveMenuItem = new JMenuItem(CMainFrame.GET_APP().GetAction(2165));
        this.m_cPopupMenu.add(this.m_cRemoveMenuItem);
    }

    private JMenuItem GetRemovePopupMenuItem() {
        return this.m_cRemoveMenuItem;
    }

    private JPopupMenu GetPopupMenu() {
        boolean bRemoveWhenDone = this.GetRemoveWhenDone();
        if (this.GetRemovePopupMenuItem() != null) {
            this.GetRemovePopupMenuItem().setVisible(!bRemoveWhenDone);
        }
        return this.m_cPopupMenu;
    }

    private AbstractButton GetPopupMenuBtn(int nEventID) {
        AbstractButton rBtn = null;
        JPopupMenu rPopMenu = this.GetPopupMenu();
        if (rPopMenu != null) {
            for (int nIdx = 0; nIdx < rPopMenu.getComponentCount() && rBtn == null; ++nIdx) {
                CBaseAction rBaseAction;
                AbstractButton cBtn;
                Action rAction;
                Component cComp = rPopMenu.getComponent(nIdx);
                if (cComp instanceof JMenu) {
                    rBtn = this.GetMenuBtn((JMenu)cComp, nEventID);
                    continue;
                }
                if (!(cComp instanceof AbstractButton) || !((rAction = (cBtn = (AbstractButton)cComp).getAction()) instanceof CBaseAction) || (rBaseAction = (CBaseAction)rAction).GetEventID() != nEventID) continue;
                rBtn = cBtn;
            }
        }
        return rBtn;
    }

    private AbstractButton GetMenuBtn(JMenu rMenu, int nEventID) {
        AbstractButton rBtn = null;
        if (rMenu != null) {
            for (int nIdx = 0; nIdx < rMenu.getComponentCount() && rBtn == null; ++nIdx) {
                CBaseAction rBaseAction;
                AbstractButton cBtn;
                Action rAction;
                Component cComp = rMenu.getComponent(nIdx);
                if (cComp instanceof JMenu) {
                    rBtn = this.GetMenuBtn((JMenu)cComp, nEventID);
                    continue;
                }
                if (!(cComp instanceof AbstractButton) || !((rAction = (cBtn = (AbstractButton)cComp).getAction()) instanceof CBaseAction) || (rBaseAction = (CBaseAction)rAction).GetEventID() != nEventID) continue;
                rBtn = cBtn;
            }
        }
        return rBtn;
    }

    private void OnActionTransferSkipFile() {
        if (this.GetTable() != null && this.GetModel() != null) {
            int[] anSelRows = this.GetTable().getSelectedRows();
            this.GetModel().ProcessNextItem(anSelRows);
        }
    }

    private void OnActionTransferPause() {
        if (this.GetTable() != null && this.GetModel() != null) {
            int[] anSelRows = this.GetTable().getSelectedRows();
            this.GetModel().StopProcessing(anSelRows);
        }
    }

    private void OnActionTransferResume() {
        if (this.GetTable() != null && this.GetModel() != null) {
            int[] anSelRows = this.GetTable().getSelectedRows();
            this.GetModel().ResumeProcessing(anSelRows);
        }
    }

    private void OnActionTransferCancel() {
        if (this.GetTable() != null && this.GetModel() != null) {
            int[] anSelRows = this.GetTable().getSelectedRows();
            this.GetModel().CancelTransfers(anSelRows);
        }
    }

    private CTransferRow GetSelectedTransferRow() {
        int[] anSelRows;
        CTransferRow rTransferRow = null;
        if (this.GetTable() != null && (anSelRows = this.GetTable().getSelectedRows()).length == 1) {
            int nRowSel = anSelRows[0];
            if (this.GetModel() != null) {
                rTransferRow = this.GetModel().GetRowObj(nRowSel);
            }
        }
        return rTransferRow;
    }

    private void OnActionTransferRemove() {
        if (this.GetTable() != null && this.GetModel() != null) {
            this.GetModel().RemoveRows(this.GetTable().getSelectedRows());
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        this.UpdateBtnStates();
        this.UpdateBtnSelections();
        this.SendUpdateActionEvent();
    }

    private void SendUpdateActionEvent() {
        if (this.m_jOnUpdateListener != null) {
            this.m_jOnUpdateListener.actionPerformed(null);
        }
    }

    public void SetOnUpdateListener(ActionListener jListener) {
        this.m_jOnUpdateListener = jListener;
    }

    @Override
    public void OnChangeStatus(CTransferRowEvent rEvent) {
        this.UpdateBtnStates();
        this.UpdateBtnSelections();
    }

    public void SetHasFocusClrs(boolean bHasFocusClrs) {
        TableColumnModel rColModel;
        if (this.GetTable() != null && (rColModel = this.GetTable().getColumnModel()) != null) {
            for (int nIdx = 0; nIdx < rColModel.getColumnCount(); ++nIdx) {
                TableColumn rColInfo = rColModel.getColumn(nIdx);
                if (rColInfo == null || !(rColInfo.getCellRenderer() instanceof CTableCellRenderer)) continue;
                CTableCellRenderer rTableRenderer = (CTableCellRenderer)rColInfo.getCellRenderer();
                rTableRenderer.SetHasFocusClrs(bHasFocusClrs);
            }
        }
    }

    public boolean IsPointInScrollArea(Point ptMouseLoc, Object rSource) {
        return CFilePanel.IsPointInScrollArea(ptMouseLoc, rSource, this.GetTable(), this);
    }

    protected void EnsureVisible(int nRow, int nColumn) {
        if (this.GetTable() != null) {
            Rectangle rRect = this.GetTable().getCellRect(nRow, nColumn, true);
            this.GetTable().scrollRectToVisible(rRect);
        }
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }

    @Override
    public void keyPressed(KeyEvent event) {
        int nKeyCode = event.getKeyCode();
        switch (nKeyCode) {
            case 127: {
                if (!event.isShiftDown() && event.getModifiers() != 0) break;
                this.OnDelete();
                event.consume();
                break;
            }
            case 35: 
            case 36: {
                if (this.GetModel() != null && this.GetSelModel() != null) {
                    if (event.isShiftDown()) {
                        if (nKeyCode == 36) {
                            this.GetSelModel().setSelectionInterval(this.GetSelModel().getAnchorSelectionIndex(), 0);
                        } else {
                            this.GetSelModel().setSelectionInterval(this.GetSelModel().getAnchorSelectionIndex(), this.GetModel().getRowCount() - 1);
                        }
                    } else if (event.isControlDown()) {
                        if (nKeyCode == 36) {
                            this.GetSelModel().setLeadSelectionIndex(0);
                        } else {
                            this.GetSelModel().setLeadSelectionIndex(this.GetModel().getRowCount() - 1);
                        }
                    } else if (nKeyCode == 36) {
                        this.GetSelModel().setSelectionInterval(0, 0);
                    } else {
                        this.GetSelModel().setSelectionInterval(this.GetModel().getRowCount() - 1, this.GetModel().getRowCount() - 1);
                    }
                    this.EnsureVisible(this.GetSelModel().getLeadSelectionIndex(), 0);
                }
                event.consume();
                break;
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent event) {
    }

    private void OnDelete() {
        int[] anRows;
        this.OnActionTransferPause();
        if (this.GetTable() != null && this.GetModel() != null && (anRows = this.GetTable().getSelectedRows()) != null && anRows.length > 0) {
            boolean bApplyToAll = false;
            int nRetCode = 0;
            boolean bRemoveRow = true;
            for (int nIdx = anRows.length - 1; nIdx >= 0; --nIdx) {
                CWorkerThread rThread;
                bRemoveRow = true;
                CTransferRow rRow = this.GetModel().GetRowObj(anRows[nIdx]);
                if (rRow == null || (rThread = rRow.GetThread()) == null) continue;
                int nThreadStatus = rRow.GetThreadStatus();
                if (nThreadStatus != 4 && nThreadStatus != 7 && nThreadStatus != 5) {
                    if (!bApplyToAll) {
                        CConfirmTransferCancelDlg dlg = new CConfirmTransferCancelDlg((Frame)CMainFrame.GET_APP(), true, -1L);
                        String sMsg = "";
                        sMsg = rRow.GetToPath() != null && rRow.GetToPath().GetPath() != null ? String.format(CString.LoadString("IDS_CONFIRM_TRANSFER_CANCEL_DLG_MSG_FMT"), rRow.GetToPath().GetPath()) : CString.LoadString("IDS_CONFIRM_TRANSFER_CANCEL_DLG_MSG");
                        dlg.SetMainMsg(sMsg);
                        boolean bShowApplyToAll = nIdx > 0;
                        dlg.ShowApplyToAllBtn(bShowApplyToAll);
                        dlg.setVisible(true);
                        bApplyToAll = dlg.GetApplyToAll();
                        nRetCode = dlg.GetExitCode();
                    }
                    if (nRetCode != 0) {
                        bRemoveRow = false;
                    }
                }
                if (bRemoveRow) {
                    rThread.CancelAllJobs();
                    this.GetModel().RemoveRow(rThread, true);
                    continue;
                }
                rRow.ResumeProcessing();
            }
        }
    }

    private void SelectAll() {
        if (this.GetTable() != null) {
            this.GetTable().selectAll();
        }
    }

    private void InvertSelection() {
        if (this.GetSelModel() != null) {
            int nLeadIdx = this.GetSelModel().getLeadSelectionIndex();
            for (int nRow = 0; nRow < this.GetTable().getRowCount(); ++nRow) {
                if (this.GetSelModel().isSelectedIndex(nRow)) {
                    this.GetSelModel().removeSelectionInterval(nRow, nRow);
                    continue;
                }
                this.GetSelModel().addSelectionInterval(nRow, nRow);
            }
            if (this.GetSelModel() instanceof DefaultListSelectionModel) {
                ((DefaultListSelectionModel)this.GetSelModel()).moveLeadSelectionIndex(nLeadIdx);
            }
        }
    }

    private JScrollBar GetVerticalScrollBar() {
        JScrollBar rScrollBar = null;
        int nCompCount = this.getComponentCount();
        for (int nIdx = 0; nIdx < nCompCount && rScrollBar == null; ++nIdx) {
            JScrollBar rTempScrollBar;
            Component rNextComp = this.getComponent(nIdx);
            if (rNextComp == null || !(rNextComp instanceof JScrollBar) || (rTempScrollBar = (JScrollBar)rNextComp).getOrientation() != 1) continue;
            rScrollBar = rTempScrollBar;
        }
        return rScrollBar;
    }

    private int GetVerticalScrollBarWidth(boolean bGetUIDefaultValue) {
        int nWidth = 0;
        if (bGetUIDefaultValue) {
            try {
                Object objWidth = UIManager.getDefaults().get("ScrollBar.width");
                Integer nScrollBarWidth = (Integer)objWidth;
                nWidth = nScrollBarWidth;
            }
            catch (Exception exception) {}
        } else if (this.GetVerticalScrollBar() != null) {
            nWidth = this.GetVerticalScrollBar().getWidth();
        }
        return nWidth;
    }

    private boolean IsVerticalScrollBarVisible() {
        boolean bIsVisible = false;
        if (this.GetVerticalScrollBar() != null) {
            bIsVisible = this.GetVerticalScrollBar().isVisible();
        }
        return bIsVisible;
    }

    private int GetTableViewportWidth() {
        int nWidth = 0;
        if (this.getViewport() != null) {
            nWidth = this.getViewport().getWidth();
        }
        return nWidth -= this.GetVerticalScrollBarWidth(true);
    }

    private TableColumn GetColumn(int nColID) {
        TableColumnModel rColModel;
        TableColumn rColumn = null;
        if (this.GetTable() != null && (rColModel = this.GetTable().getColumnModel()) != null) {
            try {
                int nColIdx = rColModel.getColumnIndex(nColID);
                rColumn = rColModel.getColumn(nColIdx);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (rColumn == null) {
                // empty if block
            }
        }
        return rColumn;
    }

    private int GetDefColWidth() {
        int nViewportWidth;
        int nColWidth = 90;
        int nDivideBy = 7;
        TableColumnModel rColModel = this.GetTable().getColumnModel();
        if (rColModel != null) {
            nDivideBy = rColModel.getColumnCount();
        }
        if ((nColWidth = (nViewportWidth = this.GetTableViewportWidth()) / nDivideBy) < 1) {
            nColWidth = 90;
        }
        return nColWidth;
    }

    private void LoadColWidths() {
        if (this.GetTable() != null && this.GetTable().getColumnModel() != null) {
            this.GetTable().getColumnModel().removeColumnModelListener(this);
        }
        for (int nModelCol = 0; nModelCol < this.GetModel().getColumnCount(); ++nModelCol) {
            TableColumn rColumn;
            String sKey;
            Integer nStoredColWidth;
            int nColWidth = this.GetDefColWidth();
            IArchive rArchive = this.GetArchive();
            if (rArchive != null && (nStoredColWidth = rArchive.GetValueInt(sKey = this.GetKeyColWidth(nModelCol), nColWidth)) != null) {
                nColWidth = nStoredColWidth;
            }
            if ((rColumn = this.GetColumn(nModelCol)) == null) continue;
            rColumn.setPreferredWidth(nColWidth);
        }
        if (this.GetTable() != null && this.GetTable().getColumnModel() != null) {
            this.GetTable().getColumnModel().addColumnModelListener(this);
        }
    }

    private void SaveColWidths() {
        for (int nModelCol = 0; nModelCol < this.GetModel().getColumnCount(); ++nModelCol) {
            IArchive rArchive;
            int nDefColWidth;
            int nColWidth = nDefColWidth = this.GetDefColWidth();
            TableColumn rColumn = this.GetColumn(nModelCol);
            if (rColumn != null) {
                nColWidth = rColumn.getWidth();
            }
            if ((rArchive = this.GetArchive()) == null) continue;
            String sKey = this.GetKeyColWidth(nModelCol);
            rArchive.SetValue(sKey, nColWidth, nDefColWidth);
        }
    }

    protected String GetKeyColWidth(int nModelCol) {
        String sKey = null;
        switch (nModelCol) {
            case 0: {
                sKey = "TransferColWidthThreadStatus";
                break;
            }
            case 1: {
                sKey = "TransferColWidthName";
                break;
            }
            case 2: {
                sKey = "TransferColWidthStatus";
                break;
            }
            case 3: {
                sKey = "TransferColWidthCompletion";
                break;
            }
            case 4: {
                sKey = "TransferColWidthOverall";
                break;
            }
            case 5: {
                sKey = "TransferColWidthFrom";
                break;
            }
            case 6: {
                sKey = "TransferColWidthTo";
                break;
            }
        }
        return sKey;
    }

    static {
        if (CMainFrame.DEBUG) {
            // empty if block
        }
        DEBUG_LOAD_COLS = false;
    }
}

