/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.base;

import com.rhinosoft.base.files.CFile;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.net.CSUURLFactory;
import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;

public class CUtils {
    private static final boolean DEBUG = CMainFrame.DEBUG;
    public static final int AXIS_BOTH = 0;
    public static final int AXIS_X = 1;
    public static final int AXIS_Y = 2;
    private static int m_nExceptionCount = 0;
    private static final String KEY_PREV_TEXT = "PrevText";

    public static boolean ContainsOnScreenPoint(Point ptOnScreen, Component rComp) {
        boolean bRet = false;
        if (rComp != null && rComp.isShowing() && ptOnScreen != null) {
            Point ptTopLeft = rComp.getLocationOnScreen();
            Rectangle rOnScreenBounds = new Rectangle(ptTopLeft.x, ptTopLeft.y, rComp.getWidth(), rComp.getHeight());
            if (rOnScreenBounds.contains(ptOnScreen)) {
                bRet = true;
            }
        }
        return bRet;
    }

    public static String UrlEncode(String sEncode) {
        return CSUURLFactory.URLEncode(sEncode);
    }

    public static String UrlDecode(String sDecode) {
        return CSUURLFactory.URLDecode(sDecode);
    }

    public static long ConvertDateToTimeT(long lDate) {
        return lDate / 1000L;
    }

    public static long ConvertTimeT(long nTimeT) {
        return nTimeT * 1000L;
    }

    public static Date ConvertTimeTToDate(long nTimeT) {
        return new Date(CUtils.ConvertTimeT(nTimeT));
    }

    public static boolean IsPointInRect(Point pt, Rectangle rect, int nTestAxis) {
        boolean bRet = false;
        boolean bInX = false;
        boolean bInY = false;
        if (pt.x >= rect.x && pt.x <= rect.x + rect.width) {
            bInX = true;
        }
        if (pt.y >= rect.y && pt.y <= rect.y + rect.height) {
            bInY = true;
        }
        bRet = nTestAxis == 1 ? bInX : (nTestAxis == 2 ? bInY : bInX && bInY);
        return bRet;
    }

    public static Image CreateScaledImage(Image jOriginalImage, int nWidth, int nHeight, SCALE_OPTION nScaleOpt) {
        return CUtils.CreateScaledImage(null, jOriginalImage, nWidth, nHeight, nScaleOpt);
    }

    public static Image CreateScaledImage(Component rComp, Image rOriginalImage, int nWidth, int nHeight, SCALE_OPTION nScaleOpt) {
        Image rRetImage = null;
        if (rOriginalImage != null) {
            int nImageWidth = rOriginalImage.getWidth(null);
            int nImageHeight = rOriginalImage.getHeight(null);
            if (nImageWidth > 0 && nImageHeight > 0) {
                int nTargetHeight;
                int nTargetWidth;
                rRetImage = rOriginalImage;
                float fAspectRatio = (float)nImageWidth / (float)nImageHeight;
                if (nImageWidth > nImageHeight) {
                    nTargetWidth = nWidth;
                    nTargetHeight = (int)((float)nTargetWidth / fAspectRatio);
                    if (nTargetHeight > nHeight) {
                        nTargetHeight = nHeight;
                        nTargetWidth = (int)(fAspectRatio * (float)nTargetHeight);
                    }
                } else {
                    nTargetHeight = nHeight;
                    nTargetWidth = (int)(fAspectRatio * (float)nTargetHeight);
                    if (nTargetWidth > nWidth) {
                        nTargetWidth = nWidth;
                        nTargetHeight = (int)((float)nTargetWidth / fAspectRatio);
                    }
                }
                boolean bScaleIt = false;
                if (nScaleOpt == SCALE_OPTION.SHRINK && (nTargetWidth < nImageWidth || nTargetHeight < nImageWidth)) {
                    bScaleIt = true;
                } else if (nScaleOpt == SCALE_OPTION.ENLARGE && (nTargetWidth > nImageWidth || nTargetHeight > nImageWidth)) {
                    bScaleIt = true;
                } else if (nScaleOpt == SCALE_OPTION.FIT_TO_TARGET && (nTargetWidth != nImageWidth || nTargetHeight != nImageWidth)) {
                    bScaleIt = true;
                }
                if (bScaleIt) {
                    rRetImage = rOriginalImage.getScaledInstance(nTargetWidth, nTargetHeight, 16);
                }
            }
        }
        return rRetImage;
    }

    public static boolean IsShowing(JLayeredPane rLayeredComp, Integer nLayerID) {
        Component[] arComps;
        boolean bIsShowing = false;
        if (rLayeredComp != null && (arComps = rLayeredComp.getComponentsInLayer(nLayerID)).length > 0) {
            for (Component rNextComp : arComps) {
                if (rNextComp == null || !rNextComp.isShowing()) continue;
                bIsShowing = true;
                break;
            }
        }
        return bIsShowing;
    }

    public static void PrintMap(String sHeader, HashMap aMap) {
        if (aMap != null) {
            System.out.println(String.format("-----   DumpMap: %s   -----", sHeader));
            Set keySet = aMap.keySet();
            for (Object rKey : keySet) {
                Object rValue = aMap.get(rKey);
                System.out.println(String.format("%s | %s", rKey.toString(), rValue != null ? rValue.toString() : "null"));
            }
        }
    }

    public static HashMap SafeDeleteMap(HashMap rMap) {
        if (rMap != null) {
            Set rKeys = rMap.keySet();
            Iterator itr = rKeys.iterator();
            while (itr.hasNext()) {
                Object objKey = itr.next();
                Object rObj = rMap.get(objKey);
                rObj = null;
                itr.remove();
            }
            rMap = null;
        }
        return rMap;
    }

    public static void CopyDeep(HashMap<String, ImageIcon> arFrom, HashMap<String, ImageIcon> arTo) {
        if (arFrom != null && arTo != null) {
            Set<String> aKeys = arFrom.keySet();
            for (String sKey : aKeys) {
                ImageIcon rValue;
                if (sKey == null || sKey.isEmpty() || (rValue = arFrom.get(sKey)) == null) continue;
                arTo.put(sKey, new ImageIcon(rValue.getImage()));
            }
        }
    }

    public static void CopyDeepBools(HashMap<String, Boolean> arFrom, HashMap<String, Boolean> arTo) {
        if (arFrom != null && arTo != null) {
            Set<String> aKeys = arFrom.keySet();
            for (String sKey : aKeys) {
                Boolean rValue;
                if (sKey == null || sKey.isEmpty() || (rValue = arFrom.get(sKey)) == null) continue;
                arTo.put(sKey, new Boolean(rValue));
            }
        }
    }

    public static void CopyDeep(ArrayList<CFile> arFrom, ArrayList<CFile> arTo) {
        if (arFrom != null && arTo != null) {
            for (CFile fNext : arFrom) {
                if (fNext == null) continue;
                arTo.add(fNext.clone());
            }
        }
    }

    public static void CopyDeep(Vector<CFile> arFrom, Vector<CFile> arTo) {
        if (arFrom != null && arTo != null) {
            for (CFile fNext : arFrom) {
                if (fNext == null) continue;
                arTo.add(fNext.clone());
            }
        }
    }

    public static void CopyDeepFiles(HashMap<String, CFile> arFrom, HashMap<String, CFile> arTo) {
        if (arFrom != null && arTo != null) {
            Set<String> aKeys = arFrom.keySet();
            for (String sKey : aKeys) {
                CFile rValue;
                if (sKey == null || sKey.isEmpty() || (rValue = arFrom.get(sKey)) == null) continue;
                arTo.put(sKey, rValue.clone());
            }
        }
    }

    public static String GetLineNumber() {
        Exception e;
        String sLineNum = null;
        if (Thread.currentThread() != null && Thread.currentThread().getStackTrace() != null && Thread.currentThread().getStackTrace().length >= 3) {
            sLineNum = Integer.toString(Thread.currentThread().getStackTrace()[2].getLineNumber());
        }
        if ((sLineNum == null || sLineNum.isEmpty()) && (e = new Exception()) != null && e.getStackTrace() != null && e.getStackTrace().length >= 1) {
            sLineNum = Integer.toString(e.getStackTrace()[0].getLineNumber());
        }
        if (sLineNum == null || sLineNum.isEmpty()) {
            sLineNum = "N/A";
        }
        return sLineNum;
    }

    public static void ASSERT(String sClassName, String sLineNumber, String sMsg, boolean bShowMsgBox) {
        String sText = String.format("ASSERT (%s, %s) - %s", sClassName, sLineNumber, sMsg);
        System.out.println(sText);
        if (bShowMsgBox) {
            sText = String.format("ASSERT triggered!\r\n\r\nClass:  %s\r\nLine Number:  %s\r\n\r\n%s", sClassName, sLineNumber, sMsg);
            JOptionPane.showMessageDialog(null, sText, "ASSERTION", 2);
        }
    }

    public static enum SCALE_OPTION {
        FIT_TO_TARGET,
        SHRINK,
        ENLARGE;

    }
}

