/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.base.files;

import com.rhinosoft.base.CConversionUtils;
import com.rhinosoft.base.CUtils;
import com.rhinosoft.base.files.CFileSystemUtils;
import com.rhinosoft.base.files.CPath;
import com.rhinosoft.base.gui.events.CRhinoEvent;
import com.rhinosoft.fvjv.files.CRemoteFile;
import com.rhinosoft.fvjv.gui.CClientInfo;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.gui.frames.browser.CHistoryItem;
import com.rhinosoft.fvjv.strings.CString;
import com.rhinosoft.fvjv.threads.CBaseThread;
import com.rhinosoft.fvjv.threads.CThreadMsg;
import com.rhinosoft.fvjv.threads.CThreadMsgCopy;
import com.rhinosoft.fvjv.threads.CThreadMsgCreateDir;
import com.rhinosoft.fvjv.threads.CThreadMsgDelete;
import com.rhinosoft.fvjv.threads.CThreadMsgList;
import com.rhinosoft.fvjv.threads.CThreadMsgRename;
import com.rhinosoft.fvjv.threads.CThreadMsgThumb;
import com.rhinosoft.fvjv.threads.CThreadMsgTransfer;
import com.rhinosoft.fvjv.threads.local.CThreadMsgDownloadLocal;
import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.filechooser.FileSystemView;

public abstract class CFile
extends CPath {
    protected static final boolean TEST_QUICKTIME = false;
    protected static final boolean DEBUG = CMainFrame.DEBUG;
    protected static final boolean DEBUG_TRACK_THUMBNAILS;
    protected static final boolean DEBUG_ENABLE_DELETE = false;
    public static final int DURATION_DELETE_PRE_CANCEL = 2000;
    public static final int DURATION_DELETE_LAST_UPDATE = 1000;
    private String m_sDisplayName;
    private boolean m_bHasListing;
    private Vector<CFile> m_afChildFiles;
    private HashMap<String, CFile> m_afChildMap;
    private boolean m_bIsHidden;
    private boolean m_bIsArchived;
    private boolean m_bIsNormal;
    private HashMap<String, ImageIcon> m_aThumbs;
    private boolean m_bIsDrive;
    private Icon m_Icon16;
    private Icon m_Icon32;
    private CFile m_fParent;
    private long m_lTimestampLastAccessed;
    private long m_lTimestampCreated;

    public CFile(String sPath, boolean bIsDir, boolean bIsLocal) {
        super(sPath, bIsDir, bIsLocal);
        this.InitVars();
    }

    protected CFile(CFile fCopyFrom) {
        super(fCopyFrom);
        this.InitVars();
        if (fCopyFrom != null) {
            this.m_bHasListing = fCopyFrom.m_bHasListing;
            this.m_bIsHidden = fCopyFrom.m_bIsHidden;
            this.m_bIsArchived = fCopyFrom.m_bIsArchived;
            this.m_bIsNormal = fCopyFrom.m_bIsNormal;
            this.m_bIsDrive = fCopyFrom.m_bIsDrive;
            this.m_lTimestampLastAccessed = fCopyFrom.m_lTimestampLastAccessed;
            this.m_lTimestampCreated = fCopyFrom.m_lTimestampCreated;
            CUtils.CopyDeep(fCopyFrom.m_aThumbs, this.m_aThumbs);
            CUtils.CopyDeep(fCopyFrom.m_afChildFiles, this.m_afChildFiles);
            CUtils.CopyDeepFiles(fCopyFrom.m_afChildMap, this.m_afChildMap);
        }
    }

    public abstract char GetFileSeparatorChar();

    public abstract String GetFileSeparator();

    public abstract String GetParentPath(boolean var1);

    protected abstract void OpenFile(String var1);

    public abstract boolean IsUpDirEnabled();

    @Override
    public abstract CFile clone();

    public abstract boolean IsThumbSupported(boolean var1);

    public abstract String GetType();

    public abstract void CreateNewFolder(CBaseThread var1, Object var2, boolean var3);

    protected abstract CFile CreateFile(String var1, boolean var2);

    public abstract URL GetPreviewURL(boolean var1, int var2, int var3);

    protected abstract CThreadMsgList CreateListMsg(Thread var1, Object var2, CClientInfo var3, int var4);

    public abstract boolean IsTreeRoot();

    public abstract boolean IsARoot();

    private void InitVars() {
        this.m_bIsHidden = false;
        this.m_bIsArchived = false;
        this.m_bIsNormal = false;
        this.m_bIsDrive = false;
        this.m_bHasListing = false;
        this.m_afChildFiles = new Vector();
        this.m_afChildMap = new HashMap();
        this.m_aThumbs = new HashMap();
    }

    @Override
    public boolean SetPath(String sAbsPath) {
        sAbsPath = this.PrepPath(sAbsPath, this.IsDir(), this.IsLocal());
        boolean bUpdated = super.SetPath(sAbsPath);
        this.InitDisplayName();
        return bUpdated;
    }

    @Override
    public boolean SetIsDir(boolean bIsDir) {
        boolean bUpdated = super.SetIsDir(bIsDir);
        this.SetPath(this.GetPath());
        return bUpdated;
    }

    protected static File CreateJavaFile(String sAbsFileName) {
        File fFile = new File(sAbsFileName);
        return fFile;
    }

    protected boolean UpdateFileInfo(File fFile) {
        boolean bNeedRefresh = false;
        if (fFile != null) {
            FileSystemView fsv;
            if (this.SetIsDir(fFile.isDirectory())) {
                bNeedRefresh = true;
            }
            if (this.SetSize(fFile.length())) {
                bNeedRefresh = true;
            }
            if (this.SetLastModified(fFile.lastModified())) {
                bNeedRefresh = true;
            }
            if (this.SetIsReadOnly(!fFile.canWrite())) {
                bNeedRefresh = true;
            }
            if (this.SetIsHidden(fFile.isHidden())) {
                bNeedRefresh = true;
            }
            if (fFile.exists() && this.SetIsDrive((fsv = FileSystemView.getFileSystemView()).isDrive(fFile))) {
                bNeedRefresh = true;
            }
        }
        return bNeedRefresh;
    }

    protected String GetType(boolean bIsLocal) {
        String sType = "";
        if (CMainFrame.GET_APP() != null) {
            sType = CMainFrame.GET_APP().GetFileType(bIsLocal, this.IsDrive(), this.IsDirectory(), this.GetAbsFileName());
        }
        return sType;
    }

    public String GetExtension(boolean bIncludePeriod) {
        return CString.GetFileExtension(this.GetAbsFileName(), this.IsDirectory(), bIncludePeriod);
    }

    protected void InitDisplayName() {
        String sDisplayName = this.GetPath();
        if (sDisplayName != null && !sDisplayName.isEmpty()) {
            int nFound;
            int nLastIndex = sDisplayName.length() - 1;
            if (sDisplayName.charAt(sDisplayName.length() - 1) == this.GetFileSeparatorChar()) {
                --nLastIndex;
            }
            if ((nFound = sDisplayName.lastIndexOf(this.GetFileSeparatorChar(), nLastIndex)) > 1 || this.IsDrive()) {
                sDisplayName = this.GetPath().substring(nFound + 1, nLastIndex + 1);
                sDisplayName = CString.EnsureNotLastChar(Character.valueOf(this.GetFileSeparatorChar()), sDisplayName);
            } else if (nFound == 0 && nLastIndex > 0) {
                sDisplayName = CString.EnsureNotFirstChar(Character.valueOf(this.GetFileSeparatorChar()), sDisplayName);
                sDisplayName = CString.EnsureNotLastChar(Character.valueOf(this.GetFileSeparatorChar()), sDisplayName);
            }
            this.SetDisplayName(sDisplayName);
        }
    }

    public int hashCode() {
        String sAbsFileName = this.GetAbsFileName();
        return sAbsFileName.hashCode();
    }

    public static String FormatFileSize(long nFileSize, boolean bUseDecimal) {
        String sStr = !bUseDecimal ? CString.FormatNumOfBytes(nFileSize, false) : CString.FormatNumOfBytesDouble(nFileSize, false, 2);
        return sStr;
    }

    public static long NumerizeSize(String fSize) {
        long nSize;
        if (fSize.endsWith("KB")) {
            fSize = fSize.substring(0, fSize.length() - 2);
            nSize = Long.parseLong(fSize) * 1024L;
        } else if (fSize.endsWith("MB")) {
            fSize = fSize.substring(0, fSize.length() - 2);
            nSize = Long.parseLong(fSize) * 1024L * 1024L;
        } else if (fSize.endsWith("GB")) {
            fSize = fSize.substring(0, fSize.length() - 2);
            nSize = Long.parseLong(fSize) * 1024L * 1024L * 1024L;
        } else {
            nSize = Long.parseLong(fSize);
        }
        return nSize;
    }

    public Object GetSource() {
        return this.GetPath();
    }

    public Vector CloneFileList(boolean bGetUpToDateFileList) {
        Vector<CFile> aVect = null;
        if (this.m_afChildMap != null) {
            aVect = new Vector<CFile>();
            Set<String> aKeys = this.m_afChildMap.keySet();
            for (String sNextPath : aKeys) {
                CFile fChild;
                if (sNextPath == null || sNextPath.isEmpty() || (fChild = this.m_afChildMap.get(sNextPath)) == null) continue;
                aVect.add(fChild);
            }
        } else if (DEBUG) {
            System.out.println("ASSERT:  m_afChildMap = null");
        }
        return aVect;
    }

    protected Icon GetIcon(boolean bIsLocal, boolean bIs32x32) {
        Icon rRet = null;
        if (CMainFrame.GET_APP() != null) {
            rRet = CMainFrame.GET_APP().GetFileImage(bIsLocal, bIs32x32, this.IsDrive(), this.IsDirectory(), this.GetAbsFileName());
        }
        return rRet;
    }

    private String GetKeyThumbs(int nImageWidth, int nImageHeight) {
        return String.format("%dx%d", nImageWidth, nImageHeight);
    }

    private HashMap<String, ImageIcon> GetThumbMap() {
        return this.m_aThumbs;
    }

    private ImageIcon GetThumb(String sKey) {
        ImageIcon rRet = null;
        if (this.GetThumbMap() != null && sKey != null && !sKey.isEmpty()) {
            rRet = this.GetThumbMap().get(sKey);
        }
        return rRet;
    }

    private boolean SetIconThumb(CThreadMsgThumb rThreadMsgThumb, boolean bUpdateGUI) {
        boolean bRet = false;
        if (rThreadMsgThumb != null) {
            bRet = this.SetIconThumb(rThreadMsgThumb.GetSource(), rThreadMsgThumb.GetThumbWidth(), rThreadMsgThumb.GetThumbHeight(), rThreadMsgThumb.GetThumbImage(), bUpdateGUI);
        }
        return bRet;
    }

    public boolean SetIconThumb(Object objSource, int nThumbWidth, int nThumbHeight, ImageIcon rThumbImage, boolean bUpdateGUI) {
        boolean bRet = false;
        String sKey = this.GetKeyThumbs(nThumbWidth, nThumbHeight);
        if (this.GetThumbMap() != null && sKey != null && !sKey.isEmpty()) {
            if (DEBUG_TRACK_THUMBNAILS) {
                System.out.printf("CFile.SetIconThumb:  Thread:  %s | for file:  %s | ThumbKey:  %s\r\n", Thread.currentThread().getName(), this.GetPath(), sKey);
            }
            boolean bl = bRet = this.GetThumbMap().put(sKey, rThumbImage) != null;
            if (bUpdateGUI) {
                if (DEBUG_TRACK_THUMBNAILS) {
                    System.out.printf("CFile.SetIconThumb: Thread:  %s | for file:  %s (updating the GUI)\r\n", Thread.currentThread().getName(), this.GetPath());
                }
                this.SendUpdateThumb(objSource, nThumbWidth, nThumbHeight);
            }
        }
        return bRet;
    }

    private void SendUpdateThumb(Object objSource, int nThumbWidth, int nThumbHeight) {
        Object[] aItems = new Object[]{this, nThumbWidth, nThumbHeight};
        CRhinoEvent rEvent = new CRhinoEvent(objSource, 6009, aItems);
        this.SendEvent(rEvent);
    }

    public ImageIcon GetIconThumb(int nImageWidth, int nImageHeight) {
        ImageIcon icoThumb = null;
        String sKey = this.GetKeyThumbs(nImageWidth, nImageHeight);
        icoThumb = this.GetThumb(sKey);
        return icoThumb;
    }

    public String GetAbsFileName() {
        return this.GetPath();
    }

    protected void SetAbsFileName(String sAbsPath) {
        this.SetPath(sAbsPath);
    }

    public String GetPrevFileName() {
        return this.GetPrevPath();
    }

    public boolean IsDirectory() {
        return this.IsDir();
    }

    public Date GetModifiedDate() {
        return new Date(this.GetLastModified());
    }

    public void SetModifiedDate(long tModified) {
        this.SetLastModified(tModified);
    }

    public CPath[] CreatePaths(boolean bResolveLinks) {
        CPath[] aPaths = new CPath[]{this.CreatePath(bResolveLinks)};
        return aPaths;
    }

    public CPath CreatePath() {
        return this.CreatePath(false);
    }

    public CPath CreatePath(boolean bResolveLinks) {
        return new CPath(this);
    }

    public static CPath[] CreatePaths(Vector<CFile> afFiles, boolean bResolveLinks) {
        int nSize;
        CPath[] aPaths = null;
        if (afFiles != null && (nSize = afFiles.size()) > 0) {
            aPaths = new CPath[nSize];
            for (int nIdx = 0; nIdx < nSize; ++nIdx) {
                CFile fNext = afFiles.get(nIdx);
                if (fNext == null) continue;
                aPaths[nIdx] = fNext.CreatePath(bResolveLinks);
            }
        }
        return aPaths;
    }

    public static CPath[] CreatePaths(ArrayList<CFile> afFiles, boolean bResolveLinks) {
        int nSize;
        CPath[] aPaths = null;
        if (afFiles != null && (nSize = afFiles.size()) > 0) {
            aPaths = new CPath[nSize];
            for (int nIdx = 0; nIdx < nSize; ++nIdx) {
                CFile fNext = afFiles.get(nIdx);
                if (fNext == null) continue;
                aPaths[nIdx] = fNext.CreatePath(bResolveLinks);
            }
        }
        return aPaths;
    }

    public static CPath[] CreatePaths(CFile[] afFiles, boolean bResolveLinks) {
        int nSize;
        CPath[] aPaths = null;
        if (afFiles != null && (nSize = afFiles.length) > 0) {
            aPaths = new CPath[nSize];
            for (int nIdx = 0; nIdx < nSize; ++nIdx) {
                CFile fNext = afFiles[nIdx];
                if (fNext == null) continue;
                aPaths[nIdx] = fNext.CreatePath(bResolveLinks);
            }
        }
        return aPaths;
    }

    private CPath[] CreatePathsThumbs(boolean bResolveLinks) {
        Vector<CPath> aPaths = null;
        int nCount = this.GetChildFileCount();
        if (nCount > 0) {
            aPaths = new Vector<CPath>();
            Set<String> aKeys = this.GetChildMap().keySet();
            for (String sChildPath : aKeys) {
                CFile fNext;
                if (sChildPath == null || sChildPath.isEmpty() || (fNext = this.GetChildMap().get(sChildPath)) == null || !fNext.IsThumbSupported(bResolveLinks)) continue;
                CPath rThumbPath = fNext.CreatePath(bResolveLinks);
                aPaths.add(rThumbPath);
            }
        }
        CPath[] aRetPaths = null;
        if (aPaths != null) {
            aRetPaths = new CPath[aPaths.size()];
            aRetPaths = aPaths.toArray(aRetPaths);
        }
        return aRetPaths;
    }

    public boolean IsMediaSupported() {
        boolean bIsSupported = false;
        return bIsSupported;
    }

    public CFile FindFile(String sAbsPath, boolean bEnsureLastFileSep) {
        int nMaxDepth = this.GetMaxTreeDepth(sAbsPath, this.GetFileSeparator());
        int nCurDepth = 0;
        return this.FindFile(sAbsPath, nMaxDepth, nCurDepth, bEnsureLastFileSep);
    }

    public CFile FindFile(String sAbsPath, int nMaxDepth, int nCurDepth, boolean bEnsureLastFileSep) {
        CFile fFound = null;
        if (sAbsPath != null && !sAbsPath.isEmpty()) {
            if (bEnsureLastFileSep) {
                sAbsPath = CString.EnsureLastChar(Character.valueOf(this.GetFileSeparatorChar()), sAbsPath);
            }
            if (this.GetPath() != null && !this.GetPath().isEmpty() && this.GetPathsMatch(this.GetPath(), sAbsPath)) {
                fFound = this;
            } else if (this.m_afChildMap != null && (fFound = this.m_afChildMap.get(sAbsPath)) == null && nCurDepth < nMaxDepth) {
                Set<String> aKeys = this.m_afChildMap.keySet();
                Iterator<String> itr = aKeys.iterator();
                while (itr.hasNext() && fFound == null) {
                    String sKey = itr.next();
                    CFile fNext = this.m_afChildMap.get(sKey);
                    if (fNext == null) continue;
                    fFound = fNext.FindFile(sAbsPath, nMaxDepth, nCurDepth + 1, bEnsureLastFileSep);
                }
            }
        }
        return fFound;
    }

    public CFile OnRecvParentFile(CFile fRecvParent) {
        String sAbsPath;
        CFile fUpdateFile = null;
        if (fRecvParent != null && (sAbsPath = fRecvParent.GetPath()) != null && !sAbsPath.isEmpty()) {
            fUpdateFile = this.FindFile(sAbsPath, true);
            if (fUpdateFile == null) {
                CPath fValidParent = null;
                String sParentPath = sAbsPath;
                String sPrevPath = "";
                while (fValidParent == null && !sParentPath.equals(sPrevPath)) {
                    sPrevPath = sParentPath;
                    if ((sParentPath = CFile.GetParentPath(sParentPath, this.GetFileSeparator())) == null || sParentPath.isEmpty()) break;
                    CFile fNextParent = this.FindFile(sParentPath, true);
                    if (fNextParent == null) continue;
                    fValidParent = fNextParent;
                }
                if (fValidParent != null) {
                    boolean bCont = true;
                    String sNexParentPath = fValidParent.GetPath();
                    while (bCont) {
                        int nNextPathSep = sAbsPath.indexOf(this.GetFileSeparator(), sNexParentPath.length());
                        if (!(sNexParentPath = sAbsPath.substring(0, ++nNextPathSep)).equals(sAbsPath)) {
                            CFile fChild = this.CreateFile(sNexParentPath, true);
                            ((CFile)fValidParent).AddChildFile(fChild, true, true);
                            fValidParent = fChild;
                            continue;
                        }
                        bCont = false;
                    }
                }
                if (fValidParent != null) {
                    sAbsPath = CString.EnsureLastChar(Character.valueOf(this.GetFileSeparatorChar()), sAbsPath);
                    fUpdateFile = this.CreateFile(sAbsPath, fRecvParent.IsDirectory());
                    ((CFile)fValidParent).AddChildFile(fUpdateFile, true, true);
                }
            }
            if (fUpdateFile != null) {
                fUpdateFile.UpdateParentData(fRecvParent);
            }
        }
        return fUpdateFile;
    }

    public CFile OnRecvChildFile(CFile fRecvChild) {
        CFile fUpdateFile = null;
        if (fRecvChild != null && fRecvChild.GetParent() != null) {
            CFile fParent = this.FindFile(fRecvChild.GetParent().GetPath(), true);
            if (fParent != null) {
                fUpdateFile = fParent.GetChildFile(fRecvChild.GetPath());
                if (fUpdateFile == null) {
                    fUpdateFile = this.CreateFile(fRecvChild.GetPath(), fRecvChild.IsDirectory());
                }
                if (fUpdateFile != null) {
                    fParent.AddChildFile(fRecvChild, true, true);
                }
            }
        } else if (DEBUG) {
            System.out.println("OnRecvChildFile | fChild == null or fParent == null");
        }
        return fUpdateFile;
    }

    @Override
    protected boolean UpdateParentData(CPath rUpdateFrom) {
        boolean bUpdated = super.UpdateParentData(rUpdateFrom);
        if (rUpdateFrom instanceof CFile) {
            CFile fFrom = (CFile)rUpdateFrom;
            if (this.SetDisplayName(fFrom.GetDisplayName())) {
                bUpdated = true;
            }
            if (this.SetIsDrive(fFrom.IsDrive())) {
                bUpdated = true;
            }
            if (this.SetIcon16(fFrom.GetIcon16())) {
                bUpdated = true;
            }
            if (this.SetIcon32(fFrom.GetIcon32())) {
                bUpdated = true;
            }
            if (this.SyncThumbs(fFrom.GetThumbMap(), false)) {
                bUpdated = true;
            }
        }
        return bUpdated;
    }

    @Override
    protected boolean UpdateData(CPath rUpdateFrom) {
        boolean bUpdated = super.UpdateData(rUpdateFrom);
        if (rUpdateFrom instanceof CFile) {
            CFile fFrom = (CFile)rUpdateFrom;
            if (this.SetDisplayName(fFrom.GetDisplayName())) {
                bUpdated = true;
            }
            if (this.SetIsReadOnly(fFrom.IsReadOnly())) {
                bUpdated = true;
            }
            if (this.SetIsHidden(fFrom.IsHidden())) {
                bUpdated = true;
            }
            if (this.SetIsArchived(fFrom.IsArchived())) {
                bUpdated = true;
            }
            if (this.SetIsLink(fFrom.IsLink())) {
                bUpdated = true;
            }
            if (this.SetIsNormal(fFrom.IsNormal())) {
                bUpdated = true;
            }
            if (this.SetIsDrive(fFrom.IsDrive())) {
                bUpdated = true;
            }
            if (this.SetIcon16(fFrom.GetIcon16())) {
                bUpdated = true;
            }
            if (this.SetIcon32(fFrom.GetIcon32())) {
                bUpdated = true;
            }
            if (this.SyncThumbs(fFrom.GetThumbMap(), false)) {
                bUpdated = true;
            }
        }
        return bUpdated;
    }

    protected boolean InitParent(String sAbsPath) {
        boolean bCreated = false;
        if (sAbsPath == null || !sAbsPath.isEmpty()) {
            // empty if block
        }
        return bCreated;
    }

    public boolean AddChildFile(CFile fChild, boolean bFireGUIEvent, boolean bSendEvent) {
        return this.AddChildFile(fChild, bFireGUIEvent, bSendEvent, true);
    }

    public boolean AddChildFile(CFile fChild, boolean bFireGUIEvent, boolean bSendEvent, boolean bUpdateUI) {
        boolean bAdded = false;
        if (fChild != null && this.m_afChildMap != null) {
            CFile fUpdateChild = this.GetChildFile(fChild.GetPath());
            if (fUpdateChild == null) {
                fChild.SetParent(this);
                this.m_afChildMap.put(fChild.GetPath(), fChild);
                bAdded = true;
                if (this.m_afChildFiles != null) {
                    this.m_afChildFiles.add(fChild);
                }
                if (bFireGUIEvent) {
                    Object[] aItems = new Object[]{fChild, new Boolean(bUpdateUI)};
                    CRhinoEvent rEvent = new CRhinoEvent(this, 6001, aItems);
                    if (bSendEvent) {
                        this.SendEvent(rEvent);
                    } else {
                        this.PostEvent(rEvent);
                    }
                }
            } else if (fUpdateChild.UpdateData(fChild) && bFireGUIEvent) {
                Object[] aItems = new Object[]{fUpdateChild, new Boolean(bUpdateUI)};
                CRhinoEvent rEvent = new CRhinoEvent(this, 6005, aItems);
                if (bSendEvent) {
                    this.SendEvent(rEvent);
                } else {
                    this.PostEvent(rEvent);
                }
            }
        }
        return bAdded;
    }

    public CFile GetChildFile(String sAbsPath) {
        CFile fChild = null;
        if (this.m_afChildMap != null) {
            fChild = this.m_afChildMap.get(sAbsPath);
        }
        return fChild;
    }

    private boolean GetPathsMatch(String sPath1, String sPath2) {
        boolean bPathsMatch = false;
        boolean bIsWindows = false;
        if (CFileSystemUtils.GetFileSysUtils() != null) {
            bIsWindows = CFileSystemUtils.GetFileSysUtils().IsWindows();
        }
        if ((bIsWindows || !this.IsLocal()) && sPath1.equalsIgnoreCase(sPath2)) {
            bPathsMatch = true;
        } else if (sPath1.equals(sPath2)) {
            bPathsMatch = true;
        }
        return bPathsMatch;
    }

    public CFile RemoveChildFile(String sPath, boolean bFireEvent, boolean bSendEvent) {
        CFile fChild = null;
        if (this.m_afChildMap != null && sPath != null && !sPath.isEmpty() && (fChild = this.m_afChildMap.remove(sPath)) != null) {
            if (this.m_afChildFiles != null) {
                this.m_afChildFiles.remove(fChild);
            }
            if (bFireEvent) {
                CRhinoEvent rEvent = new CRhinoEvent(this, 6003, fChild);
                if (bSendEvent) {
                    this.SendEvent(rEvent);
                } else {
                    this.PostEvent(rEvent);
                }
            }
        }
        return fChild;
    }

    protected boolean RemoveAllChildFiles(boolean bFireEvent, boolean bSendEvent) {
        boolean bRemovedAll = true;
        if (this.m_afChildMap != null) {
            Set<String> aKeys = this.m_afChildMap.keySet();
            Iterator<String> itr = aKeys.iterator();
            while (itr.hasNext()) {
                CFile fChild;
                String sPath = itr.next();
                if (sPath != null && !sPath.isEmpty() && (fChild = this.m_afChildMap.get(sPath)) != null) {
                    if (this.m_afChildFiles != null) {
                        this.m_afChildFiles.remove(fChild);
                    }
                    if (bFireEvent) {
                        CRhinoEvent rEvent = new CRhinoEvent(this, 6003, fChild);
                        if (bSendEvent) {
                            this.SendEvent(rEvent);
                        } else {
                            this.PostEvent(rEvent);
                        }
                    }
                }
                itr.remove();
            }
        }
        this.SetHasListing(false);
        return bRemovedAll;
    }

    public final String GetDisplayName() {
        return this.m_sDisplayName;
    }

    public boolean SetDisplayName(String sDisplayName) {
        boolean bChanged = false;
        String sPrevName = this.m_sDisplayName;
        this.m_sDisplayName = sDisplayName;
        if (sPrevName != null) {
            if (!sPrevName.equals(this.m_sDisplayName)) {
                bChanged = true;
            }
        } else {
            bChanged = true;
        }
        return bChanged;
    }

    public boolean IsHidden() {
        return this.m_bIsHidden;
    }

    public boolean SetIsHidden(boolean bVal) {
        boolean bChanged = false;
        if (this.m_bIsHidden != bVal) {
            this.m_bIsHidden = bVal;
            bChanged = true;
        }
        return bChanged;
    }

    public boolean IsArchived() {
        return this.m_bIsArchived;
    }

    public boolean SetIsArchived(boolean bVal) {
        boolean bChanged = false;
        if (this.m_bIsArchived != bVal) {
            this.m_bIsArchived = bVal;
            bChanged = true;
        }
        return bChanged;
    }

    public boolean IsNormal() {
        return this.m_bIsNormal;
    }

    public boolean SetIsNormal(boolean bVal) {
        boolean bChanged = false;
        if (this.m_bIsNormal != bVal) {
            this.m_bIsNormal = bVal;
            bChanged = true;
        }
        return bChanged;
    }

    public boolean IsDrive() {
        return this.m_bIsDrive;
    }

    public boolean SetIsDrive(boolean bVal) {
        boolean bChanged = false;
        if (this.m_bIsDrive != bVal) {
            this.m_bIsDrive = bVal;
            bChanged = true;
        }
        return bChanged;
    }

    public boolean SetParent(CFile fParent) {
        boolean bChanged = false;
        if (this.m_fParent != fParent) {
            this.m_fParent = fParent;
            bChanged = true;
        }
        return bChanged;
    }

    public CFile GetParent() {
        return this.m_fParent;
    }

    public Icon GetIcon16() {
        if (this.m_Icon16 == null) {
            this.SetIcon16(this.GetIcon(this.IsLocal(), false));
        }
        return this.m_Icon16;
    }

    public boolean SetIcon16(Icon icon) {
        boolean bChanged = false;
        if (this.m_Icon16 != icon) {
            this.m_Icon16 = icon;
            bChanged = true;
        }
        return bChanged;
    }

    public Icon GetIcon32() {
        if (this.m_Icon32 == null) {
            this.SetIcon32(this.GetIcon(this.IsLocal(), true));
        }
        return this.m_Icon32;
    }

    public boolean SetIcon32(Icon icon) {
        boolean bChanged = false;
        if (this.m_Icon32 != icon) {
            this.m_Icon32 = icon;
            bChanged = true;
        }
        return bChanged;
    }

    protected boolean SyncThumbs(HashMap<String, ImageIcon> aThumbs, boolean bMakeCopy) {
        boolean bChanged = false;
        if (this.GetThumbMap() != null && aThumbs != null) {
            ImageIcon rImage;
            String sKey;
            Iterator<String> itr;
            Vector<String> asRemove = new Vector<String>();
            Set<String> aKeys = this.GetThumbMap().keySet();
            if (aKeys != null && (itr = aKeys.iterator()).hasNext() && (sKey = itr.next()) != null && !sKey.isEmpty() && !aThumbs.containsKey(sKey)) {
                asRemove.add(sKey);
            }
            if (asRemove.size() > 0) {
                bChanged = true;
                for (int nIdx = 0; nIdx < asRemove.size(); ++nIdx) {
                    this.GetThumbMap().remove(asRemove.get(nIdx));
                }
            }
            if ((aKeys = aThumbs.keySet()) != null && (itr = aKeys.iterator()).hasNext() && (sKey = itr.next()) != null && !sKey.isEmpty() && (rImage = aThumbs.get(sKey)) != null) {
                if (bMakeCopy) {
                    this.GetThumbMap().put(sKey, new ImageIcon(rImage.getImage()));
                    bChanged = true;
                } else if (!this.GetThumbMap().containsKey(sKey)) {
                    this.GetThumbMap().put(sKey, aThumbs.get(sKey));
                    bChanged = true;
                } else {
                    ImageIcon rInternal = this.GetThumbMap().get(sKey);
                    if (rImage != rInternal) {
                        this.GetThumbMap().put(sKey, rImage);
                        bChanged = true;
                    }
                }
            }
        }
        return bChanged;
    }

    protected CFile GetFile(Vector<CFile> aFrom, String sAbsPath) {
        CFile fRet = null;
        if (aFrom != null && sAbsPath != null && !sAbsPath.isEmpty()) {
            Iterator<CFile> itr = aFrom.iterator();
            while (itr.hasNext() && fRet == null) {
                String sPath;
                CFile fNext = itr.next();
                if (fNext == null || (sPath = fNext.GetPath()) == null || sPath.isEmpty() || !sPath.equals(sAbsPath)) continue;
                fRet = fNext;
            }
        }
        return fRet;
    }

    public int GetChildFileCount() {
        int nCount = 0;
        if (this.m_afChildMap != null) {
            nCount = this.m_afChildMap.size();
        }
        return nCount;
    }

    public CFile GetChildFile(int nIndex) {
        CFile fChild = null;
        if (this.m_afChildFiles != null && nIndex >= 0 && nIndex < this.m_afChildFiles.size()) {
            fChild = this.m_afChildFiles.get(nIndex);
        }
        return fChild;
    }

    public CFile[] GetParents() {
        Vector<CFile> aParents = new Vector<CFile>();
        CFile fParent = this.GetParent();
        if (fParent == null) {
            aParents.add(this);
        } else {
            while (fParent != null) {
                aParents.add(fParent);
                fParent = fParent.GetParent();
            }
        }
        CFile[] afParents = null;
        if (aParents != null && aParents.size() > 0) {
            afParents = new CFile[aParents.size()];
            int nIdx = aParents.size() - 1;
            int nIdx2 = 0;
            while (nIdx >= 0) {
                afParents[nIdx2] = (CFile)aParents.get(nIdx);
                --nIdx;
                ++nIdx2;
            }
        }
        return afParents;
    }

    protected void SendEvent(CRhinoEvent rEvent) {
        if (CMainFrame.GET_APP() != null) {
            CMainFrame.GET_APP().dispatchEvent(rEvent);
        }
    }

    protected void PostEvent(AWTEvent rEvent) {
        Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(rEvent);
    }

    public int GetListing(CBaseThread tThread, Object objSource, boolean bRefresh, boolean bIsSetWorkingDir, boolean bExpandTreeNode, boolean bRenameTreeNode, CHistoryItem rItem) {
        int nRc = -1;
        this.SendEvent(new CRhinoEvent(objSource, 6004, this));
        if (bRefresh && this.IsDirectory()) {
            this.RemoveAllChildFiles(true, true);
        }
        if (this.HasListing() && !bRefresh) {
            CPath rPath = this.CreatePath();
            CThreadMsgList rMsg = this.CreateListMsg(Thread.currentThread(), objSource, this.GetClientInfo(), this.GetCompressionType(), rPath, bIsSetWorkingDir, bExpandTreeNode, bRenameTreeNode, rItem, this);
            Set<String> aKeys = this.m_afChildMap.keySet();
            for (String sChildPath : aKeys) {
                CFile fChild;
                if (sChildPath == null || sChildPath.isEmpty() || (fChild = this.m_afChildMap.get(sChildPath)) == null) continue;
                Object[] aItems = new Object[]{fChild, new Boolean(true)};
                this.SendEvent(new CRhinoEvent(this, 6001, aItems));
            }
            CRhinoEvent rAddedAllEvent = new CRhinoEvent(this, 6002, this.m_afChildMap.clone());
            this.SendEvent(rAddedAllEvent);
            CRhinoEvent rEvent = new CRhinoEvent(objSource, 3021, rMsg);
            this.SendEvent(rEvent);
        } else if (this.IsDirectory()) {
            if (tThread != null) {
                CPath rPath = this.CreatePath();
                if (tThread.PostListDir(objSource, this.GetClientInfo(), this.GetCompressionType(), rPath, bIsSetWorkingDir, bExpandTreeNode, bRenameTreeNode, rItem, this)) {
                    nRc = 2;
                }
            }
        } else {
            nRc = 14;
        }
        return nRc;
    }

    public int OpenChildFiles(CBaseThread rtListThread, Object objSource, CFile[] afFromChildren) {
        int nRc = -1;
        Vector<CFile> afDirs = new Vector<CFile>();
        Vector<CFile> afFiles = new Vector<CFile>();
        if (afFromChildren != null) {
            for (int nIdx = 0; nIdx < afFromChildren.length; ++nIdx) {
                CFile fOpen = afFromChildren[nIdx];
                if (fOpen == null) continue;
                if (fOpen.IsDirectory()) {
                    afDirs.add(fOpen);
                    continue;
                }
                afFiles.add(fOpen);
            }
        }
        if (afDirs.size() > 0 && afDirs.lastElement() != null) {
            ((CFile)afDirs.lastElement()).OpenDirectory(rtListThread, objSource);
        }
        if (afFiles != null && afFiles.size() > 0) {
            CPath[] arSourceFiles = CFile.CreatePaths(afFiles, false);
            String sAbsTargetPath = null;
            File fTemp = CFileSystemUtils.GetTempFolder();
            if (fTemp != null) {
                sAbsTargetPath = fTemp.getAbsolutePath();
            }
            CBaseThread tTransferThread = null;
            if (CMainFrame.GET_APP() != null) {
                tTransferThread = this.IsLocal() ? CMainFrame.GET_APP().CreateLocalThread("LocalOpenThread") : CMainFrame.GET_APP().CreateRemoteThread("RemoteOpenThread");
            }
            nRc = this.OnTransferDownload(tTransferThread, objSource, sAbsTargetPath, arSourceFiles, false, true, false);
        }
        return nRc;
    }

    public int OpenDirectory(CBaseThread tThread, Object objSource) {
        int nRc = 14;
        if (this.IsDirectory()) {
            nRc = this.GetListing(tThread, objSource, false, true, true, false, null);
        }
        return nRc;
    }

    public int Refresh(CBaseThread tThread, Object objSource) {
        return this.GetListing(tThread, objSource, true, false, false, false, null);
    }

    protected void OnRecvListDir(CFile fListDir) {
        CFile fParent;
        if (fListDir != null && (fParent = this.FindFile(fListDir.GetPath(), fListDir.IsDir())) != null) {
            fParent.SetHasListing(true);
        }
    }

    protected void OnSetWorkingDir(CFile fWorkingDir, Object rSource, boolean bExpandTreeNode, boolean bRenameTreeNode, CHistoryItem rItem) {
        CFile fParent;
        if (fWorkingDir != null && (fParent = this.FindFile(fWorkingDir.GetPath(), fWorkingDir.IsDir())) != null) {
            Object[] anItems = new Object[]{fParent, rSource, bExpandTreeNode, bRenameTreeNode, rItem};
            this.OnUpdateGUI(this, 6008, anItems);
        }
    }

    protected void OnUpdateGUI(CFile fSource, int nEventID, Object rObject) {
        if (CMainFrame.GET_APP() != null) {
            CRhinoEvent rEvent = new CRhinoEvent(fSource, nEventID, rObject);
            CMainFrame.GET_APP().dispatchEvent(rEvent);
        }
    }

    protected void OnUpdateGUI(CFile fSource, int nEventID, Object[] arObjects) {
        if (CMainFrame.GET_APP() != null) {
            CRhinoEvent rEvent = new CRhinoEvent(fSource, nEventID, arObjects);
            CMainFrame.GET_APP().dispatchEvent(rEvent);
        }
    }

    public void CancelChildThumbs(CBaseThread rtThread) {
        if (rtThread != null) {
            rtThread.CancelAllJobs();
        }
    }

    public int GetThumb(CBaseThread tThread, Object objSource, boolean bRefresh, int nThumbWidth, int nThumbHeight, boolean bIsPreview, boolean bCancelThreadJobs, boolean bResolveLinks) {
        int nRc = -1;
        ImageIcon icoThumb = this.GetIconThumb(nThumbWidth, nThumbHeight);
        if (!this.IsThumbSupported(bResolveLinks)) {
            icoThumb = (ImageIcon)this.GetIcon32();
            bRefresh = false;
        }
        if (icoThumb != null && !bRefresh) {
            if (tThread != null && bCancelThreadJobs) {
                tThread.CancelAllJobs();
            }
            if (DEBUG_TRACK_THUMBNAILS) {
                System.out.printf("CFile.GetThumb: %s - sending back cached version\r\n", this.GetPath());
            }
            this.SendUpdateThumb(objSource, nThumbWidth, nThumbHeight);
            nRc = 0;
        } else if (tThread != null) {
            String sParentPath = CFile.GetParentPath(this.GetPath(), this.GetFileSeparator());
            String sAbsToPath = null;
            if (CFileSystemUtils.GetTempFolder() != null) {
                sAbsToPath = CFileSystemUtils.GetTempFolder().getPath();
            }
            if (tThread.PostDownloadThumbs(objSource, this.GetClientInfo(), this.GetCompressionType(), sParentPath, sAbsToPath, this.CreatePaths(bResolveLinks), nThumbWidth, nThumbHeight, bIsPreview, bCancelThreadJobs)) {
                if (DEBUG_TRACK_THUMBNAILS) {
                    System.out.printf("Request thread thumbnail: %d, %d\r\n", nThumbWidth, nThumbHeight);
                }
                nRc = 2;
            }
        }
        return nRc;
    }

    protected int GetMaxTreeDepth(String sAbsPath, String sFileSep) {
        return CPath.GetMaxDepth(sAbsPath, sFileSep);
    }

    protected CThreadMsgList CreateListMsg(Thread tThread, Object rSource, CClientInfo rClientInfo, int nCompressionType, CPath rListPath, boolean bIsSetWorkingDir, boolean bExpandTreeNode, boolean bRenameTreeNode, CHistoryItem rHistoryItem, CFile fListFile) {
        CThreadMsgList msg = this.CreateListMsg(tThread, rSource, rClientInfo, nCompressionType);
        if (msg != null) {
            msg.SetIsSetWorkingDir(bIsSetWorkingDir);
            msg.SetExpandTreeNode(bExpandTreeNode);
            msg.SetRenameTreeNode(bRenameTreeNode);
            msg.SetHistoryItem(rHistoryItem);
            msg.AddFromPath(rListPath);
            msg.SetPathIndex(0);
            msg.SetListFile(fListFile);
        }
        return msg;
    }

    public int DeleteFiles(CBaseThread rtThread, Object objSource, CFile[] afFromChildren) {
        int nRc = -1;
        if (rtThread != null) {
            CPath[] arPaths = new CPath[afFromChildren.length];
            for (int nIdx = 0; nIdx < afFromChildren.length; ++nIdx) {
                CFile fChild = afFromChildren[nIdx];
                if (fChild == null) continue;
                arPaths[nIdx] = fChild.CreatePath();
            }
            if (rtThread.PostDeleteFiles(objSource, this.GetClientInfo(), this.GetCompressionType(), arPaths)) {
                nRc = 2;
            }
        }
        return nRc;
    }

    public int CreateDirs(CBaseThread rtThread, Object objSource, CPath[] arCreatePaths, boolean bWhenDoneEnterRename) {
        int nRc = -1;
        if (rtThread != null && rtThread.PostCreateDirs(objSource, this.GetClientInfo(), this.GetCompressionType(), arCreatePaths, bWhenDoneEnterRename)) {
            nRc = 2;
        }
        return nRc;
    }

    protected String GetNewFolderName() {
        return this.GetNewFolderName(null);
    }

    protected String GetNewFolderName(String sFolderName) {
        String sNewFolderName = CString.LoadString("IDS_NEW_FOLDER_GENERATED_NAME1");
        if (sFolderName != null) {
            sNewFolderName = sFolderName;
        }
        boolean bUseNewFolder = true;
        Vector<Integer> anExcludedIndices = new Vector<Integer>();
        Set<String> aKeys = this.m_afChildMap.keySet();
        for (String sChildPath : aKeys) {
            CFile fFile;
            if (sChildPath == null || sChildPath.isEmpty() || (fFile = this.m_afChildMap.get(sChildPath)) == null) continue;
            String sFileName = fFile.GetAbsFileName();
            if (!(sFileName = CString.GetFileName(sFileName)).startsWith(sNewFolderName)) continue;
            int nLastIdx = sFileName.indexOf(sNewFolderName) + sNewFolderName.length();
            if (nLastIdx < sFileName.length()) {
                int nEnd;
                String sValue;
                int nValue;
                String sExtra = sFileName.substring(nLastIdx, sFileName.length());
                int nStart = (sExtra = sExtra.trim()).indexOf(40);
                if (nStart < 0 || !CConversionUtils.IsValidInt(nValue = CConversionUtils.ConvertToInt(sValue = sExtra.substring(nStart + 1, nEnd = sExtra.indexOf(41, nStart))))) continue;
                anExcludedIndices.add(nValue);
                continue;
            }
            if (nLastIdx != sNewFolderName.length()) continue;
            bUseNewFolder = false;
        }
        if (!bUseNewFolder) {
            int nValidIndex = -1;
            if (anExcludedIndices.size() > 0) {
                boolean bBreak = false;
                for (nValidIndex = 2; nValidIndex < Integer.MAX_VALUE; ++nValidIndex) {
                    Integer nExcluded;
                    for (int nIdx2 = 0; nIdx2 < anExcludedIndices.size() && ((nExcluded = (Integer)anExcludedIndices.get(nIdx2)) == null || nExcluded != nValidIndex); ++nIdx2) {
                        if (anExcludedIndices.size() - 1 != nIdx2) continue;
                        bBreak = true;
                    }
                    if (!bBreak) {
                        continue;
                    }
                    break;
                }
            } else {
                nValidIndex = 2;
            }
            if (nValidIndex > 0) {
                sNewFolderName = sNewFolderName + " (" + Integer.toString(nValidIndex) + ")";
            }
        }
        return sNewFolderName;
    }

    protected String FormatRenamePath(CPath rPath, String sNewName) {
        String sRenameTo = null;
        if (rPath != null && sNewName != null && !sNewName.isEmpty()) {
            sRenameTo = CFile.GetParentPath(rPath.GetPath(), this.GetFileSeparator());
            sRenameTo = CString.EnsureLastChar(Character.valueOf(this.GetFileSeparatorChar()), sRenameTo);
            sRenameTo = sRenameTo + sNewName;
            if (rPath.IsDir()) {
                sRenameTo = CString.EnsureLastChar(Character.valueOf(this.GetFileSeparatorChar()), sRenameTo);
            }
        }
        return sRenameTo;
    }

    public int Rename(CBaseThread rtThread, Object objSource, String sNewName) {
        CPath rFromPath;
        int nRc = -1;
        if (rtThread != null && (rFromPath = this.CreatePath()) != null) {
            CPath[] arFromPaths = new CPath[]{rFromPath};
            CPath rToPath = rFromPath.clone();
            String sRenameTo = this.FormatRenamePath(rToPath, sNewName);
            if (sRenameTo != null && !sRenameTo.isEmpty()) {
                rToPath.SetPath(sRenameTo);
            }
            CPath[] arToPaths = new CPath[]{rToPath};
            this.Rename(rToPath.GetPath(), true, false);
            if (rtThread.PostRenamePaths(objSource, this.GetClientInfo(), this.GetCompressionType(), arFromPaths, arToPaths)) {
                nRc = 2;
            }
        }
        return nRc;
    }

    private void OnRename(CPath rFromPath, CPath rToPath) {
        CFile fChildFile;
        String sParentPath;
        CFile fParent;
        if (rFromPath != null && rToPath != null && (fParent = this.FindFile(sParentPath = CFile.GetParentPath(rFromPath.GetPath(), this.GetFileSeparator()), true)) != null && (fChildFile = fParent.GetChildFile(rFromPath.GetPath())) != null) {
            fChildFile.Rename(rToPath.GetPath(), true, false);
        }
    }

    public void Rename(String sToPath, boolean bUpdateUI, boolean bSendError) {
        if (this.SetPath(sToPath)) {
            CFile fParent = this.GetParent();
            if (fParent == null && CMainFrame.GET_APP() != null) {
                fParent = this.IsLocal() ? CMainFrame.GET_APP().GetLocalRoot() : CMainFrame.GET_APP().GetRemoteRoot();
            }
            if (bUpdateUI) {
                if (bSendError) {
                    this.OnUpdateGUI(fParent, 6007, this);
                } else {
                    this.OnUpdateGUI(fParent, 6006, this);
                }
            }
        }
    }

    public void ReleaseChildThumbs() {
        Set<String> aKeys = this.GetChildMap().keySet();
        for (String sChildPath : aKeys) {
            CFile fChild;
            if (sChildPath == null || sChildPath.isEmpty() || (fChild = this.GetChildMap().get(sChildPath)) == null) continue;
            fChild.ReleaseThumbs();
        }
    }

    public void ReleaseThumbs() {
        if (this.GetThumbMap() != null) {
            Set<String> aKeys = this.GetThumbMap().keySet();
            if (aKeys != null) {
                for (String sKey : aKeys) {
                    ImageIcon icoImage;
                    if (sKey == null || sKey.isEmpty() || (icoImage = this.GetThumbMap().get(sKey)) == null) continue;
                    icoImage = null;
                    this.GetThumbMap().put(sKey, null);
                }
            }
            this.GetThumbMap().clear();
        }
    }

    public void processEvent(AWTEvent event) {
        if (event != null && event instanceof CRhinoEvent) {
            CRhinoEvent rEvent = (CRhinoEvent)event;
            switch (event.getID()) {
                case 3021: {
                    if (!(rEvent.GetEventObj() instanceof CThreadMsg)) break;
                    CThreadMsg rMsg = (CThreadMsg)rEvent.GetEventObj();
                    this.OnRecvThreadOpItemDone(rMsg);
                    break;
                }
                case 3020: {
                    CThreadMsg rMsg;
                    if (!(rEvent.GetEventObj() instanceof CThreadMsg) || !((rMsg = (CThreadMsg)rEvent.GetEventObj()) instanceof CThreadMsgTransfer)) break;
                    this.OnRecvTransfer((CThreadMsgTransfer)rMsg);
                    break;
                }
                case 3005: {
                    if (!(rEvent.GetEventObj() instanceof CThreadMsg)) break;
                    CThreadMsg rMsg = (CThreadMsg)rEvent.GetEventObj();
                    this.OnRecvThreadOpError(rMsg);
                    break;
                }
                case 4000: {
                    Object[] anItems = (Object[])rEvent.GetEventObj();
                    if (anItems == null || anItems.length != 4) break;
                    CFile fFile = null;
                    Object rSource = rEvent.getSource();
                    String sPath = (String)anItems[1];
                    CBaseThread rThread = (CBaseThread)anItems[2];
                    CHistoryItem rItem = (CHistoryItem)anItems[3];
                    if (sPath == null || rThread == null) break;
                    fFile = this.FindFile(sPath, true);
                    if (fFile != null) {
                        fFile.GetListing(rThread, rSource, false, true, true, false, rItem);
                        break;
                    }
                    fFile = this.CreateFile(sPath, true);
                    if (fFile == null) break;
                    fFile.GetListing(rThread, rSource, true, true, true, false, rItem);
                    break;
                }
            }
        }
    }

    protected void OnRecvThreadOpItemDone(CThreadMsg rThreadMsg) {
        if (rThreadMsg != null) {
            switch (rThreadMsg.GetMsgID()) {
                case 8: {
                    this.OnRecvDelete(rThreadMsg);
                    break;
                }
                case 5: {
                    this.OnRecvList(rThreadMsg);
                    break;
                }
                case 21: {
                    this.OnRecvDownload(rThreadMsg);
                    break;
                }
                case 24: {
                    this.OnRecvUpload(rThreadMsg);
                    break;
                }
                case 22: {
                    this.OnRecvThumb(rThreadMsg);
                    break;
                }
                case 9: {
                    this.OnRecvRename(rThreadMsg);
                    break;
                }
                case 10: {
                    this.OnRecvCreateDir(rThreadMsg);
                    break;
                }
                case 20: {
                    this.OnRecvCopy(rThreadMsg);
                    break;
                }
            }
        }
    }

    private void OnRecvThreadOpError(CThreadMsg rThreadMsg) {
        if (rThreadMsg != null) {
            switch (rThreadMsg.GetMsgID()) {
                case 9: {
                    this.OnRecvRenameError(rThreadMsg);
                    break;
                }
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: {
                    this.OnRecvTransfer(rThreadMsg);
                    break;
                }
            }
        }
    }

    private void OnRecvDownload(CThreadMsg rThreadMsg) {
        if (rThreadMsg != null && rThreadMsg instanceof CThreadMsgTransfer) {
            String sParentPath;
            CFile fParent;
            CThreadMsgTransfer rTransferMsg = (CThreadMsgTransfer)rThreadMsg;
            CPath rToPath = null;
            if (rTransferMsg.GetOpeningFiles()) {
                CPath rPath = null;
                if (rThreadMsg instanceof CThreadMsgDownloadLocal) {
                    rPath = rTransferMsg.GetFromPath(rTransferMsg.GetPathIndex());
                } else {
                    rToPath = rPath = rTransferMsg.GetToPath(rTransferMsg.GetPathIndex());
                }
                if (rPath != null && !rPath.IsDir()) {
                    this.OpenFile(rPath.GetPath());
                }
            } else {
                rToPath = rTransferMsg.GetToPath(rTransferMsg.GetPathIndex());
            }
            if (rToPath != null && (fParent = this.FindFile(sParentPath = CPath.GetParentPath(rToPath.GetPath(), File.separator), true)) != null) {
                CFile fChild = this.CreateFile(rToPath.GetPath(), rToPath.IsDir());
                fParent.AddChildFile(fChild, true, true);
            }
        }
    }

    private void OnRecvUpload(CThreadMsg rThreadMsg) {
        CFile fChildFile;
        String sParentPath;
        CFile fParent;
        CThreadMsgTransfer rMsg;
        CPath rToPath;
        if (rThreadMsg != null && rThreadMsg instanceof CThreadMsgTransfer && (rToPath = (rMsg = (CThreadMsgTransfer)rThreadMsg).GetToPath(rMsg.GetPathIndex())) != null && (fParent = this.FindFile(sParentPath = CPath.GetParentPath(rToPath.GetPath(), CRemoteFile.GetFileSeparatorStatic()), true)) != null && (fChildFile = rMsg.GetListFile()) != null) {
            fParent.AddChildFile(fChildFile, true, true);
        }
    }

    private void OnRecvCopy(CThreadMsg rThreadMsg) {
        String sParentPath;
        CFile fParent;
        CThreadMsgCopy rMsg;
        CPath rToPath;
        if (rThreadMsg != null && rThreadMsg instanceof CThreadMsgCopy && (rToPath = (rMsg = (CThreadMsgCopy)rThreadMsg).GetToPath(rMsg.GetPathIndex())) != null && (fParent = this.FindFile(sParentPath = CPath.GetParentPath(rToPath.GetPath(), this.GetFileSeparator()), true)) != null) {
            if (rToPath.IsLocal()) {
                CFile fChild = this.CreateFile(rToPath.GetPath(), rToPath.IsDir());
                fParent.AddChildFile(fChild, true, true);
            } else {
                CFile fChildFile = rMsg.GetListFile();
                if (fChildFile != null) {
                    fParent.AddChildFile(fChildFile, true, true);
                }
            }
        }
    }

    private void OnRecvThumb(CThreadMsg rThreadMsg) {
        if (rThreadMsg != null && rThreadMsg instanceof CThreadMsgTransfer) {
            CThreadMsgTransfer rMsg = (CThreadMsgTransfer)rThreadMsg;
            String sPath = null;
            boolean bIsDir = true;
            CPath rFromPath = rMsg.GetFromPath(rMsg.GetPathIndex());
            sPath = rFromPath.GetPath();
            bIsDir = rFromPath.IsDir();
            if (sPath != null && !sPath.isEmpty()) {
                CFile fFile;
                if (rFromPath.IsLink()) {
                    sPath = rFromPath.GetPrevPath();
                }
                if ((fFile = this.FindFile(sPath, bIsDir)) != null && rMsg instanceof CThreadMsgThumb) {
                    CThreadMsgThumb rThumbMsg = (CThreadMsgThumb)rMsg;
                    if (DEBUG) {
                        System.out.printf("CFile.OnRecvThumb - Thread: %s | Set thumb for:  %s\r\n", Thread.currentThread().getName(), fFile.GetPath());
                    }
                    fFile.SetIconThumb(rThumbMsg, true);
                }
            }
        }
    }

    protected void OnRecvDelete(CThreadMsg rThreadMsg) {
        String sParentPath;
        CFile fParent;
        CThreadMsgDelete rMsg;
        CPath rPath;
        if (rThreadMsg instanceof CThreadMsgDelete && (rPath = (rMsg = (CThreadMsgDelete)rThreadMsg).GetDeletePath()) != null && (fParent = this.FindFile(sParentPath = CFile.GetParentPath(rPath.GetPath(), this.GetFileSeparator()), true)) != null) {
            String sPath = rPath.GetPath();
            String sPrevPath = null;
            if (rMsg.IsRenameReplace()) {
                sPrevPath = rPath.GetPrevPath();
            }
            fParent.RemoveChildFile(sPath, true, true);
        }
    }

    private void OnRecvList(CThreadMsg rThreadMsg) {
        CThreadMsgList rMsg;
        CFile fListFile;
        if (rThreadMsg instanceof CThreadMsgList && (fListFile = (rMsg = (CThreadMsgList)rThreadMsg).GetListFile()) != null) {
            this.OnRecvListDir(fListFile);
            if (rMsg.IsSetWorkingDir()) {
                this.OnSetWorkingDir(fListFile, rMsg.GetSource(), rMsg.GetExpandTreeNode(), rMsg.GetRenameTreeNode(), rMsg.GetHistoryItem());
            }
        }
    }

    protected void OnUpdateChildPath(CFile rParent, CFile rChildFile) {
        if (rParent != null && rChildFile != null) {
            String sNewParentPath = rParent.GetPath();
            String sPrevParentPath = rChildFile.GetParentPath(true);
            String sPath = rChildFile.GetPath();
            String sNewPath = sNewParentPath;
            sNewPath = CString.EnsureLastChar(Character.valueOf(this.GetFileSeparatorChar()), sNewPath);
            String sTemp = CString.MakeForwardSlashes(sPath);
            sTemp = CString.EnsureNotLastChar(Character.valueOf('/'), sTemp);
            String sFileName = CString.GetFileName(sTemp);
            sNewPath = sNewPath + sFileName;
            if (rChildFile.IsDir()) {
                sNewPath = CString.EnsureLastChar(Character.valueOf(this.GetFileSeparatorChar()), sNewPath);
            }
            rChildFile.SetPath(sNewPath);
            rChildFile.SetParent(rParent);
            this.OnUpdateGUI(rParent, 6006, rChildFile);
            if (rChildFile.IsDir()) {
                Set<String> aKeys = rChildFile.m_afChildMap.keySet();
                for (String sChildPath : aKeys) {
                    if (sChildPath == null || sChildPath.isEmpty()) continue;
                    CFile rNextChild = rChildFile.m_afChildMap.get(sChildPath);
                    this.OnUpdateChildPath(rChildFile, rNextChild);
                }
            }
        }
    }

    protected void OnRecvRename(CThreadMsg rThreadMsg) {
        CThreadMsgRename rMsg;
        CPath rDestinationPath;
        CFile fUpdate;
        if (rThreadMsg instanceof CThreadMsgRename && (fUpdate = this.FindFile((rDestinationPath = (rMsg = (CThreadMsgRename)rThreadMsg).GetToPath(rMsg.GetPathIndex())).GetPath(), rDestinationPath.IsDir())) != null) {
            CPath rPreviousPath;
            CFile rParent = fUpdate.GetParent();
            if (rParent != null && (rPreviousPath = rMsg.GetFromPath(rMsg.GetPathIndex())) != null) {
                CFile fRemoved = rParent.m_afChildMap.remove(rPreviousPath.GetPath());
                rParent.m_afChildMap.put(rDestinationPath.GetPath(), fUpdate);
            }
            Set<String> aKeys = fUpdate.m_afChildMap.keySet();
            for (String sChildPath : aKeys) {
                if (sChildPath == null || sChildPath.isEmpty()) continue;
                CFile fChild = fUpdate.m_afChildMap.get(sChildPath);
                this.OnUpdateChildPath(fUpdate, fChild);
            }
        }
    }

    private void OnRecvRenameError(CThreadMsg rThreadMsg) {
        if (rThreadMsg instanceof CThreadMsgRename) {
            CFile fChildFile;
            CThreadMsgRename rMsg = (CThreadMsgRename)rThreadMsg;
            CPath rFromPath = rMsg.GetFromPath(rMsg.GetPathIndex());
            CPath rToPath = rMsg.GetToPath(rMsg.GetPathIndex());
            String sParentPath = CFile.GetParentPath(rFromPath.GetPath(), this.GetFileSeparator());
            CFile fParent = this.FindFile(sParentPath, true);
            if (fParent != null && (fChildFile = fParent.GetChildFile(rFromPath.GetPath())) != null) {
                fChildFile.Rename(rFromPath.GetPath(), true, true);
            }
        }
    }

    protected void OnRecvCreateDir(CThreadMsg rThreadMsg) {
        CThreadMsgCreateDir rMsg;
        CPath rCreateDirPath;
        if (rThreadMsg instanceof CThreadMsgCreateDir && (rCreateDirPath = (rMsg = (CThreadMsgCreateDir)rThreadMsg).GetFromPath(rMsg.GetPathIndex())) != null) {
            String sParentPath = CFile.GetParentPath(rCreateDirPath.GetPath(), this.GetFileSeparator());
            CFile fParent = this.FindFile(sParentPath, true);
            CFile rMsgFile = rMsg.GetListFile();
            if (rMsgFile != null) {
                rMsgFile.SetHasListing(true);
            }
            if (fParent != null) {
                if (rMsgFile != null) {
                    CFile fChildFile = fParent.GetChildFile(rMsgFile.GetPath());
                    if (fChildFile == null) {
                        fParent.AddChildFile(rMsg.GetListFile(), true, true);
                    } else {
                        fChildFile.UpdateData(rMsgFile);
                    }
                } else assert (rMsgFile != null);
            }
            Object[] anItems = new Object[]{rMsg.GetListFile(), rMsg.GetEnterRenameMode()};
            CRhinoEvent rRenameEvent = new CRhinoEvent(rMsg.GetSource(), 9111, anItems);
            this.PostEvent(rRenameEvent);
        }
    }

    public boolean HasListing() {
        return this.m_bHasListing;
    }

    protected boolean SetHasListing(boolean bHasListing) {
        boolean bChanged = false;
        if (this.m_bHasListing != bHasListing) {
            this.m_bHasListing = bHasListing;
            bChanged = true;
        }
        return bChanged;
    }

    private void OnRecvTransfer(CThreadMsg rThreadMsg) {
        String sChildPath;
        CFile fChildFile;
        String sParentPath;
        CFile fParent;
        CThreadMsgTransfer rMsg;
        CPath rToPath;
        if (rThreadMsg != null && rThreadMsg instanceof CThreadMsgTransfer && (rToPath = (rMsg = (CThreadMsgTransfer)rThreadMsg).GetToPath(rMsg.GetPathIndex())) != null && (fParent = this.FindFile(sParentPath = CPath.GetParentPath(rToPath.GetPath(), this.GetFileSeparator()), true)) != null && (fChildFile = rMsg.GetListFile()) != null && !sParentPath.equals(sChildPath = fChildFile.GetPath())) {
            fParent.AddChildFile(fChildFile, true, true);
        }
    }

    public boolean IsRenameAllowed() {
        return true;
    }

    public long GetTimestampLastAccessed() {
        return this.m_lTimestampLastAccessed;
    }

    public boolean SetTimestampLastAccessed(long lTimestampLastAccessed) {
        boolean bDirty = false;
        if (this.m_lTimestampLastAccessed != lTimestampLastAccessed) {
            this.m_lTimestampLastAccessed = lTimestampLastAccessed;
            bDirty = true;
        }
        return bDirty;
    }

    public long GetTimestampCreated() {
        return this.m_lTimestampCreated;
    }

    public boolean SetTimestampCreated(long lTimestampCreated) {
        boolean bDirty = false;
        if (this.m_lTimestampCreated != lTimestampCreated) {
            this.m_lTimestampCreated = lTimestampCreated;
            bDirty = true;
        }
        return bDirty;
    }

    public Date GetDateLastAccessed() {
        return new Date(this.GetTimestampLastAccessed());
    }

    public Date GetDateCreated() {
        return new Date(this.GetTimestampCreated());
    }

    protected HashMap<String, CFile> GetChildMap() {
        return this.m_afChildMap;
    }

    public void OnRecvChildFiles(String sAbsParentPath, Vector<CFile> afRecvChildFiles) {
        CFile fParent;
        if (sAbsParentPath != null && !sAbsParentPath.isEmpty() && (fParent = this.FindFile(sAbsParentPath, true)) != null) {
            if (afRecvChildFiles != null) {
                for (CFile fChild : afRecvChildFiles) {
                    CFile fUpdateFile = fParent.GetChildFile(fChild.GetPath());
                    if (fUpdateFile == null) {
                        fUpdateFile = this.CreateFile(fChild.GetPath(), fChild.IsDirectory());
                    }
                    fParent.AddChildFile(fChild, true, true, false);
                }
            }
            if (this.m_afChildMap != null) {
                CRhinoEvent rAddedAllEvent = new CRhinoEvent(fParent, 6002, this.m_afChildMap.clone());
                this.SendEvent(rAddedAllEvent);
            }
        }
    }

    static {
        if (DEBUG) {
            // empty if block
        }
        DEBUG_TRACK_THUMBNAILS = false;
    }
}

