/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.base.files.WindowsLink;

import java.nio.ByteBuffer;

public class CFileLocationInfo {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_OFFSETS = false;
    public static final int OFFSET_LENGTH = 0;
    public static final int OFFSET_FIRST_OFFSET = 4;
    public static final int OFFSET_FLAGS = 8;
    public static final int OFFSET_LOCAL_VOLUME_INFO = 12;
    public static final int OFFSET_BASE_PATH_NAME = 16;
    public static final int OFFSET_NETWORK_VOLUME_INFO = 20;
    public static final int OFFSET_REMAINING_PATHNAME = 24;
    public static final int OFFSET_WIDE_BASE_PATHNAME = 28;
    public static final int OFFSET_WIDE_REMAINING_PATHNAME = 32;
    public static final int BIT_FLAGS_LOCAL_VOLUME = 0;
    public static final int BIT_FLAGS_NETWORK_SHARE = 1;
    private static final int SIZE_UNUSED = 3;
    private byte[] m_aBuffer;
    private int m_dwLen;
    private int m_dwFirstOffset;
    private boolean m_bLocalVolume;
    private boolean m_bNetworkShare;
    private byte[] m_achUnused = new byte[3];
    private int m_dwLocalVolumeInfoOffset;
    private int m_dwBasePathNameOffset;
    private int m_dwNetworkVolInfoOffset;
    private int m_dwRemainingPathnameOffset;
    private int m_dwWideBasePathNameOffset;
    private int m_dwWideRemainingPathnameOffset;

    public boolean Parse(byte[] aBuf, int nOffset) {
        boolean bParsed = false;
        if (aBuf != null && nOffset + CFileLocationInfo.sizeof() < aBuf.length) {
            if (this.m_aBuffer == null) {
                this.m_aBuffer = new byte[aBuf.length - nOffset];
            }
            System.arraycopy(aBuf, nOffset, this.m_aBuffer, 0, this.m_aBuffer.length);
            ByteBuffer ByteHelper = ByteBuffer.wrap(this.m_aBuffer);
            this.m_dwLen = Integer.reverseBytes(ByteHelper.getInt());
            this.m_dwFirstOffset = Integer.reverseBytes(ByteHelper.getInt());
            int nFlags = Integer.reverseBytes(ByteHelper.getInt());
            this.m_bLocalVolume = (nFlags & 1) != 0;
            this.m_bNetworkShare = (nFlags & 2) != 0;
            this.m_dwLocalVolumeInfoOffset = Integer.reverseBytes(ByteHelper.getInt());
            this.m_dwBasePathNameOffset = Integer.reverseBytes(ByteHelper.getInt());
            this.m_dwNetworkVolInfoOffset = Integer.reverseBytes(ByteHelper.getInt());
            this.m_dwRemainingPathnameOffset = Integer.reverseBytes(ByteHelper.getInt());
            this.m_dwWideBasePathNameOffset = Integer.reverseBytes(ByteHelper.getInt());
            this.m_dwWideRemainingPathnameOffset = Integer.reverseBytes(ByteHelper.getInt());
            bParsed = true;
        }
        return bParsed;
    }

    public static int sizeof() {
        int nNumOfBytes = 4;
        nNumOfBytes += 4;
        nNumOfBytes += 4;
        nNumOfBytes += 4;
        nNumOfBytes += 4;
        nNumOfBytes += 4;
        nNumOfBytes += 4;
        nNumOfBytes += 4;
        return nNumOfBytes += 4;
    }

    public static String ParseString(byte[] aBuf, int nOffset) {
        StringBuilder sBuilder = new StringBuilder();
        if (aBuf != null && nOffset >= 0) {
            int nPos = nOffset;
            boolean bEOS = false;
            while (!bEOS && nPos < aBuf.length) {
                byte NextByte;
                if ((NextByte = aBuf[nPos++]) != 0) {
                    char NextChar = (char)(NextByte & 0xFF);
                    sBuilder.append(NextChar);
                    continue;
                }
                bEOS = true;
            }
        }
        return sBuilder.toString();
    }

    public static String ParseWideString(byte[] aBuf, int nOffset) {
        StringBuilder sBuilder = new StringBuilder();
        if (aBuf != null && nOffset >= 0) {
            byte[] aBuffer = new byte[aBuf.length - nOffset];
            System.arraycopy(aBuf, nOffset, aBuffer, 0, aBuffer.length);
            ByteBuffer ByteHelper = ByteBuffer.wrap(aBuffer);
            char chNext = Character.reverseBytes(ByteHelper.getChar());
            while (chNext != '\u0000' && ByteHelper.position() < aBuf.length) {
                sBuilder.append(chNext);
                chNext = Character.reverseBytes(ByteHelper.getChar());
            }
        }
        return sBuilder.toString();
    }

    public String GetRemainingPathName() {
        return CFileLocationInfo.ParseString(this.m_aBuffer, this.GetRemainingPathNameOffset());
    }

    public String GetBasePathName() {
        return CFileLocationInfo.ParseString(this.m_aBuffer, this.GetBasePathNameOffset());
    }

    public int GetFirstOffset() {
        return this.m_dwFirstOffset;
    }

    public boolean HasWideStrings() {
        boolean bHasWideStrings = false;
        if (this.GetFirstOffset() >= CFileLocationInfo.sizeof()) {
            bHasWideStrings = true;
        }
        return bHasWideStrings;
    }

    public String GetWideRemainingPathName() {
        return CFileLocationInfo.ParseWideString(this.m_aBuffer, this.GetWideRemainingPathNameOffset());
    }

    public String GetWideBasePathName() {
        return CFileLocationInfo.ParseWideString(this.m_aBuffer, this.GetWideBasePathNameOffset());
    }

    public int GetRemainingPathNameOffset() {
        return this.m_dwRemainingPathnameOffset;
    }

    public int GetBasePathNameOffset() {
        return this.m_dwBasePathNameOffset;
    }

    public int GetWideBasePathNameOffset() {
        return this.m_dwWideBasePathNameOffset;
    }

    public int GetWideRemainingPathNameOffset() {
        return this.m_dwWideRemainingPathnameOffset;
    }

    public boolean HasLocalVolume() {
        return this.m_bLocalVolume;
    }

    public boolean HasNetworkShare() {
        return this.m_bNetworkShare;
    }
}

