/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.base.files.WindowsLink;

import com.rhinosoft.base.files.WindowsLink.CFileHeader;
import com.rhinosoft.base.files.WindowsLink.CFileLocationInfo;
import com.rhinosoft.base.files.WindowsLink.CLocalVolume;
import com.rhinosoft.base.files.WindowsLink.CNetworkVolume;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.strings.CString;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.nio.ByteBuffer;

public class CWindowsLink {
    public static final boolean DEBUG = CMainFrame.DEBUG;
    public static final boolean DEBUG_LINK_TARGET_PATH;
    private boolean m_bValid = false;
    private String m_sLinkPath;
    private String m_sResolvedPath;
    private String m_sVolume;
    private String m_sName;
    private String m_sLinkName;
    long m_CreationTime;
    long m_ModificationTime;
    long m_LastAccessTime;
    private CFileHeader m_Header;
    private long m_dwLocalType;
    private long m_dwLocalSerialNum;
    private CFileLocationInfo m_FileLocationInfo;
    private CLocalVolume m_LocalVolume;
    private CNetworkVolume m_NetworkVolume;
    private String m_sDescription;
    private String m_sRelativePath;
    private String m_sWorkingDir;
    private String m_sParams;
    private String m_sIconFileName;
    long m_fsSize;

    public CWindowsLink(String sPath) {
        this.m_sLinkPath = sPath;
        this.m_ModificationTime = this.m_CreationTime = System.currentTimeMillis();
        this.m_LastAccessTime = this.m_CreationTime;
        this.m_dwLocalType = 0L;
        this.m_dwLocalSerialNum = 0L;
        this.m_fsSize = -1L;
        this.m_Header = new CFileHeader();
        this.m_FileLocationInfo = new CFileLocationInfo();
        this.m_LocalVolume = new CLocalVolume();
        this.m_NetworkVolume = new CNetworkVolume();
        this.Resolve();
    }

    private byte[] GetLinkData(File fFile) {
        byte[] aData;
        block9: {
            aData = null;
            if (fFile != null && fFile.exists()) {
                ByteArrayOutputStream ByteOutStream;
                FileInputStream FileInStream;
                block8: {
                    FileInStream = null;
                    ByteOutStream = null;
                    long fsLen = fFile.length();
                    fsLen = Math.max(Math.min(fsLen, 20480L), 2048L);
                    byte[] pBuf = new byte[(int)fsLen];
                    try {
                        FileInStream = new FileInputStream(fFile);
                        ByteOutStream = new ByteArrayOutputStream();
                        int nIdx = 0;
                        while (nIdx != -1 && (long)nIdx < fsLen) {
                            nIdx = FileInStream.read(pBuf);
                            if (nIdx <= 0) continue;
                            ByteOutStream.write(pBuf, 0, nIdx);
                        }
                    }
                    catch (Exception e) {
                        if (!DEBUG) break block8;
                        e.printStackTrace();
                    }
                }
                aData = ByteOutStream.toByteArray();
                try {
                    if (FileInStream != null) {
                        FileInStream.close();
                    }
                    if (ByteOutStream != null) {
                        ByteOutStream.close();
                    }
                }
                catch (Exception e) {
                    if (!DEBUG) break block9;
                    e.printStackTrace();
                }
            }
        }
        return aData;
    }

    private void Resolve() {
        byte[] aLinkData;
        File fFile = new File(this.m_sLinkPath);
        if (fFile != null && fFile.exists() && this.m_Header.Parse(aLinkData = this.GetLinkData(fFile))) {
            int nFilePos = CFileHeader.sizeof();
            if (this.m_Header.HasShellIDList()) {
                if ((long)(nFilePos + 2) <= fFile.length()) {
                    ByteBuffer Helper = ByteBuffer.wrap(aLinkData);
                    Helper.position(nFilePos);
                    nFilePos += Short.reverseBytes(Helper.getShort());
                }
                nFilePos += 2;
            }
            Object[] aItems = this.CheckStruct(aLinkData, nFilePos, this.m_Header.IsFileOrDir());
            boolean bExists = (Boolean)aItems[0];
            int nFileLocInfoStart = (Integer)aItems[1];
            int nBufPos = (Integer)aItems[2];
            if (bExists && this.m_FileLocationInfo.Parse(aLinkData, nFilePos)) {
                String sName = this.m_FileLocationInfo.GetRemainingPathName();
                String sPath = this.m_FileLocationInfo.GetBasePathName();
                if (this.m_FileLocationInfo.HasWideStrings()) {
                    sName = this.m_FileLocationInfo.GetWideRemainingPathName();
                    sPath = this.m_FileLocationInfo.GetWideBasePathName();
                }
                aItems = this.CheckStruct(aLinkData, nFilePos, this.m_FileLocationInfo.HasLocalVolume());
                bExists = (Boolean)aItems[0];
                int nLocalVolumeOffset = (Integer)aItems[1];
                nBufPos = (Integer)aItems[2];
                if (bExists && this.m_LocalVolume.Parse(aLinkData, nLocalVolumeOffset)) {
                    this.m_sVolume = this.m_LocalVolume.HasWideStrings() ? this.m_LocalVolume.GetVolumeName() : this.m_LocalVolume.GetWideVolumeName();
                    this.m_dwLocalType = this.m_LocalVolume.GetType();
                    this.m_dwLocalSerialNum = this.m_LocalVolume.GetSerialNum();
                }
                if (sPath == null || sPath.isEmpty()) {
                    aItems = this.CheckStruct(aLinkData, nFilePos, this.m_FileLocationInfo.HasNetworkShare());
                    bExists = (Boolean)aItems[0];
                    int nNetworkShareOffset = (Integer)aItems[1];
                    nBufPos = (Integer)aItems[2];
                    if (bExists && this.m_NetworkVolume.Parse(aLinkData, nNetworkShareOffset)) {
                        boolean bHasWideStrings;
                        int dwEndOfStruct = CNetworkVolume.sizeof();
                        if (this.m_NetworkVolume.IsMappedDrive()) {
                            dwEndOfStruct = Math.min(dwEndOfStruct, this.m_NetworkVolume.GetFinalNameOffset());
                        }
                        if (this.m_NetworkVolume.IsUNCPath()) {
                            dwEndOfStruct = Math.min(dwEndOfStruct, this.m_NetworkVolume.GetNetworkShareNameOffset());
                        }
                        boolean bl = bHasWideStrings = dwEndOfStruct >= CNetworkVolume.sizeof();
                        if (bHasWideStrings) {
                            if (this.m_NetworkVolume.IsMappedDrive()) {
                                sPath = this.m_NetworkVolume.GetWideFinalName();
                            } else if (this.m_NetworkVolume.IsUNCPath()) {
                                sPath = this.m_NetworkVolume.GetWideNetworkShareName();
                            }
                        } else if (this.m_NetworkVolume.IsMappedDrive()) {
                            sPath = this.m_NetworkVolume.GetFinalName();
                        } else if (this.m_NetworkVolume.IsUNCPath()) {
                            sPath = this.m_NetworkVolume.GetNetworkShareName();
                        }
                    }
                }
                this.m_sResolvedPath = sPath;
                if (sName != null && !sName.isEmpty()) {
                    this.m_sResolvedPath = CString.EnsureLastCharIsAFileSeparator(this.m_sResolvedPath);
                    this.m_sResolvedPath = this.m_sResolvedPath + sName;
                }
                if (this.m_sResolvedPath != null && !this.m_sResolvedPath.isEmpty()) {
                    if (DEBUG_LINK_TARGET_PATH) {
                        System.out.printf("Link target path: %s\r\n", this.m_sResolvedPath);
                    }
                    this.m_bValid = true;
                }
                int nStartPos = nFileLocInfoStart + CFileLocationInfo.sizeof();
            }
        }
    }

    private Object[] CheckStruct(byte[] aBuf, int nBufOffset, boolean bUseStruct) {
        boolean bRet = false;
        int nStructStart = 0;
        if (aBuf != null) {
            if (nBufOffset + 4 <= aBuf.length) {
                byte[] aTemp = new byte[aBuf.length - nBufOffset];
                System.arraycopy(aBuf, nBufOffset, aTemp, 0, aTemp.length);
                ByteBuffer ByteHelper = ByteBuffer.wrap(aTemp);
                int dwLen = Integer.reverseBytes(ByteHelper.getInt());
                if (!bUseStruct && dwLen != 0) {
                    this.m_bValid = true;
                } else if (nBufOffset + dwLen <= aBuf.length) {
                    if (dwLen > 0) {
                        nStructStart = nBufOffset;
                        nBufOffset += dwLen;
                        bRet = true;
                    } else {
                        nBufOffset += 4;
                    }
                    this.m_bValid = true;
                }
            } else {
                nBufOffset = aBuf.length;
            }
        }
        Object[] aItems = new Object[]{bRet, nStructStart, nBufOffset};
        return aItems;
    }

    public String GetResolvedPath() {
        return this.m_sResolvedPath;
    }

    static {
        if (DEBUG) {
            // empty if block
        }
        DEBUG_LINK_TARGET_PATH = false;
    }
}

