/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.base.gui;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.RangeSlider;
import com.rhinosoft.base.gui.IDualSliderListener;
import com.rhinosoft.base.gui.frames.CBaseMainFrame;
import com.rhinosoft.fvjv.gui.frames.CLookAndFeels;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CDualSlider
extends RangeSlider
implements ChangeListener,
ActionListener {
    private static boolean DEBUG_VALUES;
    private int m_nHighExtent;
    private Vector<IDualSliderListener> m_LowValueListeners;
    private Timer m_UserChangedLowValTimer;
    private int m_nPrevLowValue;

    public CDualSlider() {
        this.InitVars();
    }

    public CDualSlider(int nMin, int nMax, int nLow, int nHigh) {
        super(nMin, nMax, nLow, nHigh);
        this.InitVars();
    }

    private void InitVars() {
        this.m_nHighExtent = Short.MAX_VALUE;
        this.addChangeListener(this);
        this.m_LowValueListeners = new Vector();
        this.m_UserChangedLowValTimer = new Timer(1000, this);
    }

    public void AddLowValueListener(IDualSliderListener rListener) {
        this.m_LowValueListeners.add(rListener);
    }

    public void RemoveLowValueListener(IDualSliderListener rListener) {
        this.m_LowValueListeners.remove(rListener);
    }

    public void FireUserChangedLowValue(int nOldValue, int nNewValue, int nMin, int nMax) {
        for (IDualSliderListener rListener : this.m_LowValueListeners) {
            if (rListener == null) continue;
            rListener.OnUserChangedLowValue(this, nOldValue, nNewValue, nMin, nMax);
        }
    }

    public void SetHighExtent(int nHighExtent) {
        this.m_nHighExtent = nHighExtent;
        this.fireStateChanged();
    }

    public int GetHighExtent() {
        return this.m_nHighExtent;
    }

    @Override
    public void setLowValue(int nLowValue) {
        this.m_nPrevLowValue = this.getLowValue();
        super.setLowValue(nLowValue);
        if (this.m_nPrevLowValue != nLowValue) {
            this.StartUserChangedLowValTimer();
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.m_UserChangedLowValTimer) {
            this.StopUserChangedLowValTimer();
            this.FireUserChangedLowValue(this.m_nPrevLowValue, this.getLowValue(), this.getMinimum(), this.getMaximum());
        }
    }

    private void StartUserChangedLowValTimer() {
        if (this.m_UserChangedLowValTimer != null) {
            if (this.m_UserChangedLowValTimer.isRunning()) {
                this.m_UserChangedLowValTimer.restart();
            } else {
                this.m_UserChangedLowValTimer.start();
            }
        }
    }

    private void StopUserChangedLowValTimer() {
        if (this.m_UserChangedLowValTimer != null) {
            this.m_UserChangedLowValTimer.stop();
        }
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        if (event.getSource() instanceof RangeSlider) {
            RangeSlider slider = (RangeSlider)event.getSource();
            if (this.GetHighExtent() != Short.MAX_VALUE) {
                if (slider.getHighValue() != this.GetHighExtent()) {
                    this.setHighValue(this.GetHighExtent());
                }
                if (slider.getLowValue() >= slider.getHighValue()) {
                    this.setLowValue(this.m_nHighExtent);
                }
            }
            if (DEBUG_VALUES) {
                System.out.printf("Minimum: %d | Maximum: %d | Value: %d | LowValue: %d | HighValue: %d\r\n", slider.getMinimum(), slider.getMaximum(), slider.getValue(), slider.getLowValue(), slider.getHighValue());
            }
        }
    }

    private boolean IsWindowsOfficeLnF() {
        return CLookAndFeels.IsWindowsOffice();
    }

    private Color GetBackClr() {
        Color clr = UIDefaultsLookup.getColor("Panel.background");
        if (clr == null) {
            clr = Color.LIGHT_GRAY;
        }
        return clr;
    }

    public void FireStateChanged() {
        this.fireStateChanged();
    }

    static {
        if (CBaseMainFrame.DEBUG) {
            // empty if block
        }
        DEBUG_VALUES = false;
    }
}

