/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.base.gui;

import com.rhinosoft.fvjv.strings.CString;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

public class CLanguageComboBox
extends JComboBox {
    private String[] m_asItems;

    public CLanguageComboBox() {
        this.InitVars();
    }

    private void InitVars() {
        this.LoadStrings();
        this.setModel(new DefaultComboBoxModel<String>(this.m_asItems));
        this.setEditable(false);
        this.setSelectedIndex(this.GetIndex(LANGUAGE.ENGLISH));
    }

    private void LoadStrings() {
        LANGUAGE[] aItems = LANGUAGE.values();
        this.m_asItems = new String[aItems.length];
        for (int nIdx = 0; nIdx < this.m_asItems.length; ++nIdx) {
            this.m_asItems[nIdx] = this.GetString(aItems[nIdx]);
        }
    }

    public String GetString(LANGUAGE nLanguage) {
        String sLang = "";
        switch (nLanguage) {
            case GERMAN: {
                sLang = CString.LoadString("IDS_LANG_GERMAN");
                break;
            }
            case FRENCH: {
                sLang = CString.LoadString("IDS_LANG_FRENCH");
                break;
            }
            case ITALIAN: {
                sLang = CString.LoadString("IDS_LANG_ITALIAN");
                break;
            }
            case RUSSIAN: {
                sLang = CString.LoadString("IDS_LANG_RUSSIAN");
                break;
            }
            case CHINESE_SIMPLIFIED: {
                sLang = CString.LoadString("IDS_LANG_SIMPLIFIED_CHINESE");
                break;
            }
            case CHINESE_TRADITIONAL: {
                sLang = CString.LoadString("IDS_LANG_TRADITIONAL_CHINESE");
                break;
            }
            case JAPANESE: {
                sLang = CString.LoadString("IDS_LANG_JAPANESE");
                break;
            }
            default: {
                sLang = CString.LoadString("IDS_LANG_ENGLISH");
            }
        }
        return sLang;
    }

    public int GetIndex(LANGUAGE nLanguage) {
        int nIndex = -1;
        LANGUAGE[] aItems = LANGUAGE.values();
        for (int nIdx = 0; nIdx < aItems.length && nIndex == -1; ++nIdx) {
            if (aItems[nIdx] != nLanguage) continue;
            nIndex = nIdx;
        }
        return nIndex;
    }

    public LANGUAGE GetLanguage(int nIndex) {
        LANGUAGE nLang = LANGUAGE.ENGLISH;
        LANGUAGE[] aItems = LANGUAGE.values();
        if (nIndex >= 0 && nIndex < aItems.length) {
            nLang = aItems[nIndex];
        }
        return nLang;
    }

    public String GetLanguageCode() {
        return this.GetLanguageCode(this.GetLanguage(this.getSelectedIndex()));
    }

    public String GetLanguageCode(LANGUAGE nLanguage) {
        String sCode = "en";
        switch (nLanguage) {
            case GERMAN: {
                sCode = "de";
                break;
            }
            case FRENCH: {
                sCode = "fr";
                break;
            }
            case ITALIAN: {
                sCode = "it";
                break;
            }
            case RUSSIAN: {
                sCode = "ru";
                break;
            }
            case CHINESE_SIMPLIFIED: {
                sCode = "zh";
                break;
            }
            case CHINESE_TRADITIONAL: {
                sCode = "zh";
                break;
            }
            case JAPANESE: {
                sCode = "jp";
                break;
            }
            default: {
                sCode = "en";
            }
        }
        return sCode;
    }

    public String GetCountryCode() {
        return this.GetCountryCode(this.GetLanguage(this.getSelectedIndex()));
    }

    public String GetCountryCode(LANGUAGE nLanguage) {
        String sCode = "US";
        switch (nLanguage) {
            case GERMAN: {
                sCode = "DE";
                break;
            }
            case FRENCH: {
                sCode = "FR";
                break;
            }
            case ITALIAN: {
                sCode = "IT";
                break;
            }
            case RUSSIAN: {
                sCode = "RU";
                break;
            }
            case CHINESE_SIMPLIFIED: {
                sCode = "CN";
                break;
            }
            case CHINESE_TRADITIONAL: {
                sCode = "TW";
                break;
            }
            case JAPANESE: {
                sCode = "JP";
                break;
            }
            default: {
                sCode = "US";
            }
        }
        return sCode;
    }

    public void SetSelectedLanguage(String sLanguageCode, String sCountryCode) {
        LANGUAGE nLanguage = this.GetLanguage(sLanguageCode, sCountryCode);
        this.setSelectedIndex(this.GetIndex(nLanguage));
    }

    public LANGUAGE GetLanguage(String sLanguageCode, String sCountryCode) {
        LANGUAGE nLangCode = LANGUAGE.ENGLISH;
        LANGUAGE nCountryCode = LANGUAGE.ENGLISH;
        if (sLanguageCode != null && !sLanguageCode.isEmpty()) {
            if ((sLanguageCode = sLanguageCode.toLowerCase()).equals("de")) {
                nLangCode = LANGUAGE.GERMAN;
            } else if (sLanguageCode.equals("fr")) {
                nLangCode = LANGUAGE.FRENCH;
            } else if (sLanguageCode.equals("it")) {
                nLangCode = LANGUAGE.ITALIAN;
            } else if (sLanguageCode.equals("ru")) {
                nLangCode = LANGUAGE.RUSSIAN;
            } else if (sLanguageCode.equals("zh")) {
                nLangCode = LANGUAGE.CHINESE_SIMPLIFIED;
            } else if (sLanguageCode.equals("jp")) {
                nLangCode = LANGUAGE.JAPANESE;
            }
        }
        if (sCountryCode != null && !sCountryCode.isEmpty()) {
            if ((sCountryCode = sCountryCode.toUpperCase()).equals("DE")) {
                nCountryCode = LANGUAGE.GERMAN;
            } else if (sCountryCode.equals("FR")) {
                nCountryCode = LANGUAGE.FRENCH;
            } else if (sCountryCode.equals("IT")) {
                nCountryCode = LANGUAGE.ITALIAN;
            } else if (sCountryCode.equals("RU")) {
                nCountryCode = LANGUAGE.RUSSIAN;
            } else if (sCountryCode.equals("CN")) {
                nCountryCode = LANGUAGE.CHINESE_SIMPLIFIED;
            } else if (sCountryCode.equals("TW")) {
                nCountryCode = LANGUAGE.CHINESE_TRADITIONAL;
            } else if (sCountryCode.equals("JP")) {
                nCountryCode = LANGUAGE.JAPANESE;
            }
        }
        return nCountryCode;
    }

    public static enum LANGUAGE {
        ENGLISH,
        GERMAN,
        FRENCH,
        ITALIAN,
        RUSSIAN,
        CHINESE_SIMPLIFIED,
        CHINESE_TRADITIONAL,
        JAPANESE;

    }
}

