/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.base.gui.components.files.listing;

import com.rhinosoft.base.files.CFile;
import com.rhinosoft.base.gui.components.files.listing.CFileModel;
import java.util.EventListener;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class CFileListModel
extends CFileModel
implements ListModel {
    public CFileListModel(boolean bSortWhileAddingItems) {
        super(bSortWhileAddingItems);
    }

    @Override
    public int getSize() {
        return this.GetFileCount();
    }

    public Object getElementAt(int nIndex) {
        return this.GetFile(nIndex);
    }

    @Override
    public void addListDataListener(ListDataListener rListener) {
        this.AddListener(ListDataListener.class, rListener);
    }

    @Override
    public void removeListDataListener(ListDataListener rListener) {
        this.RemoveListener(ListDataListener.class, rListener);
    }

    public void UpdateUIContent() {
        this.fireContentsChanged(this, 0, this.getSize() - 1);
    }

    protected void fireContentsChanged(Object rSource, int nIndex0, int nIndex1) {
        this.fireListEvent(new ListDataEvent(rSource, 0, nIndex0, nIndex1));
    }

    protected void fireIntervalAdded(Object rSource, int nIndex0, int nIndex1) {
        this.fireListEvent(new ListDataEvent(rSource, 1, nIndex0, nIndex1));
    }

    protected void fireIntervalRemoved(Object rSource, int nIndex0, int nIndex1) {
        this.fireListEvent(new ListDataEvent(rSource, 2, nIndex0, nIndex1));
    }

    protected boolean fireListEvent(ListDataEvent rEvent) {
        EventListener[] aListeners;
        boolean bSentToListeners = false;
        if (rEvent != null && (aListeners = this.GetListeners(ListDataListener.class)) != null && aListeners.length > 0) {
            bSentToListeners = true;
            for (int nIdx = aListeners.length - 1; nIdx >= 0; --nIdx) {
                if (rEvent.getType() == 0) {
                    ((ListDataListener)aListeners[nIdx]).contentsChanged(rEvent);
                    continue;
                }
                if (rEvent.getType() == 1) {
                    ((ListDataListener)aListeners[nIdx]).intervalAdded(rEvent);
                    continue;
                }
                if (rEvent.getType() != 2) continue;
                ((ListDataListener)aListeners[nIdx]).intervalRemoved(rEvent);
            }
        }
        return bSentToListeners;
    }

    @Override
    public boolean AddFile(CFile fFile, boolean bFireGUIEvent) {
        boolean bAdded = super.AddFile(fFile, bFireGUIEvent);
        if (bAdded && bFireGUIEvent) {
            int nIndexAdded = this.getSize() - 1;
            this.fireIntervalAdded(this, nIndexAdded, nIndexAdded);
        }
        return bAdded;
    }

    @Override
    public CFile UpdateFile(int nIndex, boolean bFireGUIEvent) {
        CFile fUpdated = super.UpdateFile(nIndex, bFireGUIEvent);
        if (fUpdated != null && bFireGUIEvent && nIndex >= 0 && nIndex < this.GetFileCount()) {
            this.fireContentsChanged(this, nIndex, nIndex);
        }
        return fUpdated;
    }

    @Override
    protected CFile RemoveFile(int nIndex, boolean bFireGUIEvent) {
        CFile fRemoved = super.RemoveFile(nIndex, bFireGUIEvent);
        if (fRemoved != null && bFireGUIEvent) {
            this.fireIntervalRemoved(this, nIndex, nIndex);
        }
        return fRemoved;
    }

    @Override
    public boolean RemoveAll(boolean bFireGUIEvent) {
        boolean bRemoved = super.RemoveAll(bFireGUIEvent);
        if (bRemoved) {
            this.fireContentsChanged(this, 0, 0);
        }
        return bRemoved;
    }
}

