/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.base.gui.components.files.listing;

import com.rhinosoft.base.files.CFile;
import com.rhinosoft.base.gui.components.files.listing.CFileListModel;
import com.rhinosoft.fvjv.strings.CString;
import java.util.EventListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class CFileListTableModel
extends CFileListModel
implements TableModel {
    public static final int COL_NAME = 0;
    public static final int COL_SIZE = 1;
    public static final int COL_TYPE = 2;
    public static final int COL_MODIFIED = 3;
    public static final int COL_PARENT_PATH = 4;
    public static final int COL_MAX = 5;
    private String[] m_asColHeaders;

    public CFileListTableModel(boolean bSortWhileAddingItems) {
        super(bSortWhileAddingItems);
        this.InitVars();
    }

    private void InitVars() {
        this.m_asColHeaders = new String[5];
        this.m_asColHeaders[0] = CString.LoadString("IDS_TABLE_HEADER_NAME");
        this.m_asColHeaders[1] = CString.LoadString("IDS_TABLE_HEADER_SIZE");
        this.m_asColHeaders[2] = CString.LoadString("IDS_TABLE_HEADER_TYPE");
        this.m_asColHeaders[3] = CString.LoadString("IDS_TABLE_HEADER_MODIFIED");
        this.m_asColHeaders[4] = CString.LoadString("IDS_TABLE_HEADER_PARENT_PATH");
    }

    @Override
    public int getRowCount() {
        return this.getSize();
    }

    @Override
    public int getColumnCount() {
        int nSize = -1;
        if (this.m_asColHeaders != null) {
            nSize = this.m_asColHeaders.length;
        }
        return nSize;
    }

    @Override
    public String getColumnName(int nColumnIndex) {
        String sHeader = "";
        if (this.m_asColHeaders != null) {
            sHeader = this.m_asColHeaders[nColumnIndex];
        }
        return sHeader;
    }

    @Override
    public Class<?> getColumnClass(int nColumnIndex) {
        Class cRet = String.class;
        if (this.m_asColHeaders != null) {
            cRet = this.m_asColHeaders[nColumnIndex].getClass();
        }
        return cRet;
    }

    @Override
    public boolean isCellEditable(int nRowIndex, int nColumnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        return this.getElementAt(nRowIndex);
    }

    @Override
    public void setValueAt(Object aValue, int nRowIndex, int nColumnIndex) {
    }

    @Override
    public void addTableModelListener(TableModelListener rListener) {
        this.AddListener(TableModelListener.class, rListener);
    }

    @Override
    public void removeTableModelListener(TableModelListener rListener) {
        this.RemoveListener(TableModelListener.class, rListener);
    }

    public void fireTableDataChanged() {
        this.fireTableDataChanged(true);
    }

    protected void fireTableDataChanged(boolean bFireListEvent) {
        this.fireTableEvent(new TableModelEvent(this));
        if (bFireListEvent) {
            this.fireContentsChanged(this, 0, this.getSize(), false);
        }
    }

    public void fireTableStructureChanged() {
        this.fireTableStructureChanged(true);
    }

    private void fireTableStructureChanged(boolean bFireListEvent) {
        this.fireTableEvent(new TableModelEvent(this, -1));
        if (bFireListEvent) {
            this.fireContentsChanged(this, 0, this.getSize(), false);
        }
    }

    public void fireTableRowsInserted(int firstRow, int lastRow) {
        this.fireTableRowsInserted(firstRow, lastRow, true);
    }

    private void fireTableRowsInserted(int firstRow, int lastRow, boolean bFireListEvent) {
        this.fireTableEvent(new TableModelEvent(this, firstRow, lastRow, -1, 1));
        if (bFireListEvent) {
            this.fireIntervalAdded(this, firstRow, lastRow, false);
        }
    }

    public void fireTableRowsUpdated(int firstRow, int lastRow) {
        this.fireTableRowsUpdated(firstRow, lastRow, true);
    }

    private void fireTableRowsUpdated(int firstRow, int lastRow, boolean bFireListEvent) {
        this.fireTableEvent(new TableModelEvent(this, firstRow, lastRow, -1, 0));
        if (bFireListEvent) {
            this.fireContentsChanged(this, firstRow, lastRow, false);
        }
    }

    public void fireTableRowsDeleted(int firstRow, int lastRow) {
        this.fireTableRowsDeleted(firstRow, lastRow, true);
    }

    private void fireTableRowsDeleted(int firstRow, int lastRow, boolean bFireListEvent) {
        this.fireTableEvent(new TableModelEvent(this, firstRow, lastRow, -1, -1));
        if (bFireListEvent) {
            this.fireIntervalRemoved(this, firstRow, lastRow, false);
        }
    }

    public void fireTableCellUpdated(int row, int column) {
        this.fireTableCellUpdated(row, column, true);
    }

    private void fireTableCellUpdated(int row, int column, boolean bFireListEvent) {
        this.fireTableEvent(new TableModelEvent(this, row, row, column));
        if (bFireListEvent) {
            this.fireContentsChanged(this, row, row, false);
        }
    }

    protected boolean fireTableEvent(TableModelEvent rEvent) {
        EventListener[] aListeners;
        boolean bSentToListeners = false;
        if (rEvent != null && (aListeners = this.GetListeners(TableModelListener.class)) != null && aListeners.length > 0) {
            bSentToListeners = true;
            for (int nIdx = aListeners.length - 1; nIdx >= 0; --nIdx) {
                if (!(aListeners[nIdx] instanceof TableModelListener)) continue;
                ((TableModelListener)aListeners[nIdx]).tableChanged(rEvent);
            }
        }
        return bSentToListeners;
    }

    @Override
    protected void fireContentsChanged(Object source, int index0, int index1) {
        this.fireContentsChanged(source, index0, index1, true);
    }

    protected void fireContentsChanged(Object source, int index0, int index1, boolean bFireTableEvent) {
        super.fireContentsChanged(source, index0, index1);
        if (bFireTableEvent) {
            if (index0 >= 0 && index0 < this.getRowCount() && index0 == index1) {
                this.fireTableRowsUpdated(index0, index1);
            } else {
                this.fireTableStructureChanged(false);
            }
        }
    }

    @Override
    protected void fireIntervalAdded(Object source, int index0, int index1) {
        this.fireIntervalAdded(source, index0, index1, true);
    }

    private void fireIntervalAdded(Object source, int index0, int index1, boolean bFireTableEvent) {
        super.fireIntervalAdded(source, index0, index1);
        if (bFireTableEvent) {
            this.fireTableRowsInserted(index0, index1, false);
        }
    }

    @Override
    protected void fireIntervalRemoved(Object source, int index0, int index1) {
        this.fireIntervalRemoved(source, index0, index1, true);
    }

    private void fireIntervalRemoved(Object source, int index0, int index1, boolean bFireTableEvent) {
        super.fireIntervalRemoved(source, index0, index1);
        if (bFireTableEvent) {
            this.fireTableRowsDeleted(index0, index1, false);
        }
    }

    @Override
    public boolean AddFile(CFile fAddFile, boolean bFireGUIEvent) {
        boolean bAdded = super.AddFile(fAddFile, bFireGUIEvent);
        if (bAdded) {
            int nIndexAdded = this.getSize() - 1;
            this.fireTableRowsInserted(nIndexAdded, nIndexAdded, false);
        }
        return bAdded;
    }

    @Override
    public CFile RemoveFile(CFile fRemoved, boolean bFireGUIEvent) {
        int nIndex = this.GetFileIndex(fRemoved);
        CFile fRet = super.RemoveFile(fRemoved, bFireGUIEvent);
        if (fRet != null) {
            this.fireTableRowsDeleted(nIndex, nIndex, false);
        }
        return fRet;
    }
}

