/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.base.gui.components.files.preview;

import com.rhinosoft.base.files.CFile;
import com.rhinosoft.base.gui.components.files.preview.CPlayListModel;
import com.rhinosoft.base.gui.components.files.preview.CRhinoMediaPlayListPanel;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public abstract class CPlayListPanel
extends JPanel {
    private static final boolean DEBUG = true;
    private int m_nPlayListIndex;
    private CPlayListModel m_aPlayListModel;
    private CRhinoMediaPlayListPanel m_cPlayListPanel;
    private JDialog m_cPlayListDlg;

    public CPlayListPanel() {
        this.InitVars();
    }

    public abstract void Destroy();

    protected abstract void PlayFile(CFile var1);

    protected abstract void Play();

    protected abstract void Stop();

    private void InitVars() {
        this.m_nPlayListIndex = -1;
        this.m_aPlayListModel = this.CreatePlayListModel();
        this.m_cPlayListPanel = this.CreatePlayListPanel(this.GetPlayListModel());
        this.m_cPlayListDlg = this.InitPlayListDlg(this.GetPlayListPanel());
    }

    protected CPlayListModel CreatePlayListModel() {
        return new CPlayListModel();
    }

    protected CRhinoMediaPlayListPanel CreatePlayListPanel(CPlayListModel arModel) {
        return new CRhinoMediaPlayListPanel(arModel);
    }

    protected JDialog CreatePlayListDlg() {
        Frame cFrame = null;
        Container cParent = SwingUtilities.getAncestorOfClass(Frame.class, this);
        if (cParent != null && cParent instanceof Frame) {
            cFrame = (Frame)cParent;
        }
        return new JDialog(cFrame, "Playlist", false);
    }

    private CPlayListModel GetPlayListModel() {
        return this.m_aPlayListModel;
    }

    private JDialog InitPlayListDlg(CRhinoMediaPlayListPanel rPanel) {
        JDialog cDlg = null;
        if (rPanel != null) {
            cDlg = this.CreatePlayListDlg();
            cDlg.setAlwaysOnTop(true);
            cDlg.setContentPane(this.GetPlayListPanel());
            cDlg.setLocationRelativeTo(this);
            cDlg.setPreferredSize(new Dimension(300, 400));
            cDlg.pack();
        }
        return cDlg;
    }

    private JDialog GetPlayListDlg() {
        return this.m_cPlayListDlg;
    }

    private CRhinoMediaPlayListPanel GetPlayListPanel() {
        return this.m_cPlayListPanel;
    }

    public boolean AddFile(CFile fFile) {
        boolean bAdded = false;
        if (fFile != null && this.GetPlayListModel() != null) {
            bAdded = this.GetPlayListModel().AddFile(fFile, true);
            if (this.GetPlayListSize() == 1) {
                this.SetPlayListIndex(0);
            }
        }
        return bAdded;
    }

    public boolean RemoveFile(CFile fFile) {
        boolean bRemoved = false;
        if (fFile != null && this.GetPlayListModel() != null) {
            int nIndex = this.GetPlayListIndex(fFile);
            CFile fRemoved = this.GetPlayListModel().RemoveFile(fFile, true);
            if (fRemoved != null) {
                bRemoved = true;
            }
            if (nIndex == this.GetPlayListIndex()) {
                // empty if block
            }
        }
        return bRemoved;
    }

    public CFile GetFile(int nIndex) {
        CFile fFile = null;
        if (this.GetPlayListModel() != null && nIndex >= 0 && nIndex < this.GetPlayListSize()) {
            fFile = (CFile)this.GetPlayListModel().getElementAt(nIndex);
        }
        return fFile;
    }

    public int GetPlayListIndex(CFile fFile) {
        int nIndex = -1;
        if (this.GetPlayListModel() != null && fFile != null) {
            for (int nIdx = 0; nIdx < this.GetPlayListModel().getSize() && nIndex == -1; ++nIdx) {
                CFile fNext = (CFile)this.GetPlayListModel().getElementAt(nIdx);
                if (fNext == null || fNext.GetPath() == null || fNext.GetPath().isEmpty() || !fNext.GetPath().equals(fFile.GetPath())) continue;
                nIndex = nIdx;
            }
        }
        return nIndex;
    }

    public int GetPlayListIndex() {
        return this.m_nPlayListIndex;
    }

    private void SetPlayListIndex(int nIndex) {
        if (nIndex >= 0 && nIndex < this.GetPlayListSize()) {
            this.m_nPlayListIndex = nIndex;
            this.PlayFile(this.GetFile(this.GetPlayListIndex()));
        } else if (this.GetPlayListSize() > 0) {
            this.SetPlayListIndex(0);
        }
    }

    public int GetPlayListSize() {
        int nSize = 0;
        if (this.GetPlayListModel() != null) {
            nSize = this.GetPlayListModel().getSize();
        }
        return nSize;
    }

    public void PlayNext() {
        this.SetPlayListIndex(this.GetPlayListIndex() + 1);
    }

    public void PlayPrevious() {
        this.SetPlayListIndex(this.GetPlayListIndex() - 1);
    }

    public void ShowPlayList() {
        if (this.GetPlayListDlg() != null && !this.GetPlayListDlg().isVisible()) {
            this.GetPlayListDlg().setVisible(true);
        }
    }

    public void OnResize() {
    }

    public boolean IsEventSource(Object objSource) {
        boolean bIsEventSource = false;
        if (objSource == this) {
            bIsEventSource = true;
        }
        return bIsEventSource;
    }
}

