/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.base.gui.components.files.tree;

import com.rhinosoft.FilePanel.CFileTableSorter;
import com.rhinosoft.base.files.CFile;
import com.rhinosoft.base.files.CFileSystemUtils;
import com.rhinosoft.base.gui.components.files.tree.CFileTreeNode;
import com.rhinosoft.base.gui.components.files.tree.CSearchTreeNode;
import com.rhinosoft.fvjv.files.CLocalFile;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class CFileTreeModel
extends DefaultTreeModel {
    public static boolean DEBUG = CMainFrame.DEBUG;
    public static boolean DEBUG_SEARCH_EXCEPTIONS;
    private CFileTreeNode m_rRootNode;
    private CSearchTreeNode m_SearchNode;

    public CFileTreeModel() {
        super(null);
        this.InitVars();
    }

    private void InitVars() {
        this.m_rRootNode = null;
        this.m_SearchNode = new CSearchTreeNode();
    }

    public void AddChildNode(CFile fParent, CFile fChild) {
        CFileTreeNode rParentNode;
        if (fParent != null && fChild != null && (rParentNode = this.FindNode(fParent)) != null) {
            this.AddChild(rParentNode, fChild, false);
        }
    }

    public void UpdateChildNode(CFile fParent, CFile fChild) {
        CFileTreeNode rParentNode;
        if (fParent != null && fChild != null && (rParentNode = this.FindNode(fParent)) != null) {
            this.UpdateChild(rParentNode, fChild, false);
        }
    }

    public CFileTreeNode FindNode(CFile fFile, String sAbsPath) {
        CFileTreeNode rNode = null;
        if (sAbsPath != null && !sAbsPath.isEmpty() && this.GetRootNode() != null) {
            int nMaxDepth = this.GetMaxDepth(fFile);
            rNode = this.GetNode(this.GetRootNode(), sAbsPath, 0, nMaxDepth);
        }
        return rNode;
    }

    public CFileTreeNode FindNode(CFile fFile) {
        CFileTreeNode rNode = null;
        if (fFile != null && this.GetRootNode() != null) {
            int nMaxDepth = this.GetMaxDepth(fFile);
            rNode = this.GetNode(this.GetRootNode(), fFile.GetPath(), 0, nMaxDepth);
        }
        return rNode;
    }

    private CFileTreeNode AddChild(CFileTreeNode rParentNode, CFile fChild, boolean bAppend) {
        CFileTreeNode rChildNode = null;
        if (rParentNode != null && fChild != null && rParentNode.GetChildNode(fChild.GetPath()) == null && (fChild.IsDirectory() || fChild.IsDrive())) {
            rChildNode = new CFileTreeNode(fChild);
            int nInsertIndex = rParentNode.getChildCount();
            if (!bAppend) {
                nInsertIndex = this.GetInsertIndex(rParentNode, rChildNode);
            }
            this.insertNodeInto(rChildNode, rParentNode, nInsertIndex);
        }
        return rChildNode;
    }

    private CFileTreeNode UpdateChild(CFileTreeNode rParentNode, CFile fChild, boolean bAppend) {
        CFileTreeNode rChildNode = null;
        if (rParentNode != null && fChild != null && (rChildNode = rParentNode.GetChildNode(fChild.GetPath())) != null) {
            this.nodeChanged(rChildNode);
        }
        return rChildNode;
    }

    public void RemoveChildNode(CFile fParent, CFile fChild) {
        CFileTreeNode rChildNode;
        if (fParent != null && fChild != null && (rChildNode = this.FindNode(fChild)) != null) {
            this.removeNodeFromParent(rChildNode);
        }
    }

    public void RenameChildNode(CFile fParent, CFile fChild) {
        if (fParent != null && fChild != null) {
            String sChildPath = fChild.GetPath();
            if (fChild.IsLocal()) {
                sChildPath = fChild.GetPrevPath();
            }
            CFileTreeNode rParentNode = this.FindNode(fParent);
            CFileTreeNode rChildNode = this.FindNode(fChild, sChildPath);
            if (rParentNode != null && rChildNode != null) {
                this.nodeChanged(rChildNode);
            }
        }
    }

    public boolean IsSameFileSystem(CFile fFile) {
        CFile fRoot;
        boolean bIsSameFileSystem = false;
        if (this.GetRootNode() != null && fFile != null && (fRoot = this.GetRootNode().GetFile()) != null && (fRoot.IsLocal() && fFile.IsLocal() || !fRoot.IsLocal() && !fFile.IsLocal())) {
            bIsSameFileSystem = true;
        }
        return bIsSameFileSystem;
    }

    private CFileTreeNode GetRootNode() {
        return this.m_rRootNode;
    }

    public void SetRootNode(CFile fRoot) {
        this.m_rRootNode = new CFileTreeNode(fRoot);
        this.setRoot(this.m_rRootNode);
        this.AddAllChildren(this.m_rRootNode);
    }

    private void AddAllChildren(CFileTreeNode rParentNode) {
        CFile fParent;
        if (rParentNode != null && (fParent = rParentNode.GetFile()) != null) {
            for (int nIdx = 0; nIdx < fParent.GetChildFileCount(); ++nIdx) {
                CFile fChild = fParent.GetChildFile(nIdx);
                if (fChild == null) continue;
                CFileTreeNode rChildNode = this.AddChild(rParentNode, fChild, true);
                if (fChild.GetChildFileCount() <= 0) continue;
                this.AddAllChildren(rChildNode);
            }
        }
    }

    private CFileTreeNode GetNode(CFileTreeNode rParent, String sChildPath, int nCurDepth, int nMaxDepth) {
        CFileTreeNode rNode = null;
        if (sChildPath != null && rParent != null && nCurDepth < nMaxDepth) {
            if (rParent.Matches(sChildPath)) {
                rNode = rParent;
            } else {
                for (int nIdx = 0; nIdx < rParent.getChildCount() && rNode == null; ++nIdx) {
                    TreeNode rNextNode = rParent.getChildAt(nIdx);
                    if (!(rNextNode instanceof CFileTreeNode)) continue;
                    CFileTreeNode rChildNode = (CFileTreeNode)rNextNode;
                    rNode = this.GetNode(rChildNode, sChildPath, nCurDepth + 1, nMaxDepth);
                }
            }
        }
        return rNode;
    }

    public int GetMaxDepth(CFile fFile) {
        int nMaxDepth = 1;
        if (fFile != null) {
            nMaxDepth = CFile.GetMaxDepth(fFile.GetPath(), fFile.GetFileSeparator());
            if (fFile instanceof CLocalFile && CFileSystemUtils.GetFileSysUtils() != null && CFileSystemUtils.GetFileSysUtils().IsWindows()) {
                nMaxDepth += 3;
            }
        }
        return nMaxDepth;
    }

    private int GetInsertIndex(CFileTreeNode rParentNode, CFileTreeNode rChildNode) {
        int nInsertAt = -1;
        if (rParentNode != null && rChildNode != null) {
            int nChildCount = rParentNode.getChildCount();
            CFile fChild = rChildNode.GetFile();
            if (fChild != null) {
                boolean bTestPath = fChild.IsDrive();
                String sPath = fChild.GetPath();
                String sDisplayName = fChild.GetDisplayName();
                if (sPath != null && !sPath.isEmpty() && sDisplayName != null && !sDisplayName.isEmpty()) {
                    for (int nIdx = 0; nIdx < rParentNode.getChildCount() && nInsertAt == -1; ++nIdx) {
                        CFileTreeNode rNextNode;
                        CFile fNextFile;
                        TreeNode rNext = rParentNode.getChildAt(nIdx);
                        if (!(rNext instanceof CFileTreeNode) || (fNextFile = (rNextNode = (CFileTreeNode)rNext).GetFile()) == null) continue;
                        String sNextName = fNextFile.GetDisplayName();
                        if (bTestPath) {
                            sNextName = fNextFile.GetPath();
                        }
                        if (sNextName == null || sNextName.isEmpty()) continue;
                        int nCompare = 0;
                        nCompare = bTestPath ? CFileTableSorter.Compare(true, sPath, sNextName, true) : CFileTableSorter.Compare(true, sDisplayName, sNextName, true);
                        if (nCompare >= 0) continue;
                        nInsertAt = nIdx;
                    }
                }
            }
            if (nInsertAt == -1) {
                nInsertAt = nChildCount;
            }
        } else {
            nInsertAt = 0;
        }
        return nInsertAt;
    }

    public CSearchTreeNode GetSearchNode() {
        return this.m_SearchNode;
    }

    public void SetSearchNodeVisible(boolean bVisible) {
        if (bVisible) {
            this.ShowSearchNode();
        } else {
            this.HideSearchNode();
        }
    }

    private void ShowSearchNode() {
        int nIdx;
        if (this.GetRootNode() != null && ((nIdx = this.getIndexOfChild(this.GetRootNode(), this.GetSearchNode())) <= 0 || nIdx >= this.GetRootNode().getChildCount())) {
            int nInsertIndex = this.GetRootNode().getChildCount();
            this.insertNodeInto(this.GetSearchNode(), this.GetRootNode(), nInsertIndex);
        }
    }

    private void HideSearchNode() {
        block2: {
            try {
                this.removeNodeFromParent(this.GetSearchNode());
            }
            catch (Exception e) {
                if (!DEBUG_SEARCH_EXCEPTIONS) break block2;
                e.printStackTrace();
            }
        }
    }

    static {
        if (DEBUG) {
            // empty if block
        }
        DEBUG_SEARCH_EXCEPTIONS = false;
    }
}

