/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.base.gui.events;

import com.rhinosoft.fvjv.strings.CString;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class CBaseAction
extends AbstractAction {
    private Vector<Component> m_aOwners;
    private CBaseAction[] m_arActionGroup;

    public CBaseAction(int nID) {
        this.InitVars(nID);
    }

    public CBaseAction(CBaseAction rCopyFrom) {
        if (rCopyFrom != null) {
            this.InitVars(rCopyFrom.GetEventID());
            for (int nIdx = 0; nIdx < rCopyFrom.GetOwnerCount(); ++nIdx) {
                this.AddOwner(rCopyFrom.GetOwner(nIdx));
            }
            CBaseAction[] aActionGroup = rCopyFrom.GetActionGroup();
            if (aActionGroup != null) {
                this.SetActionGroup((CBaseAction[])aActionGroup.clone());
            }
            this.SetName(rCopyFrom.GetName());
            this.putValue("AcceleratorKey", rCopyFrom.getValue("AcceleratorKey"));
            this.SetLongDesc(rCopyFrom.GetLongDesc());
            this.SetShortDesc(rCopyFrom.GetShortDesc());
            this.SetSmallIcon(rCopyFrom.GetSmallIcon());
            this.SetLargeIcon(rCopyFrom.GetLargeIcon());
            this.SetSelected(rCopyFrom.IsSelected());
        }
    }

    private void InitVars(int nID) {
        this.SetEventID(nID);
        this.m_aOwners = new Vector();
    }

    public String toString() {
        StringBuilder sbRet = new StringBuilder();
        sbRet.append(String.format("Class:     %s\r\n", this.getClass().getName()));
        sbRet.append(String.format("EventID:   %s\r\n", this.GetEventID()));
        return sbRet.toString();
    }

    public void SetEventID(int nEventID) {
        this.putValue("ActionCommandKey", String.valueOf(nEventID));
    }

    public Integer GetEventID() {
        return Integer.parseInt((String)this.getValue("ActionCommandKey"));
    }

    public void SetName(String sName) {
        Character chMnemonic = CString.GetMnemonic(sName);
        sName = CString.RemoveMnemonic(sName);
        this.putValue("Name", sName);
        if (chMnemonic != null) {
            char nAsciiVal = chMnemonic.charValue();
            this.putValue("MnemonicKey", nAsciiVal);
        }
    }

    public void SetAccelerator(int nAccKey) {
        this.SetAccelerator(nAccKey, 0);
    }

    public void SetAccelerator(int nAccKey, int nAccModifier) {
        if (nAccKey >= 0) {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(nAccKey, nAccModifier));
        }
    }

    public void SetLongDesc(String sDesc) {
        this.putValue("LongDescription", sDesc);
    }

    public String GetLongDesc() {
        return (String)this.getValue("LongDescription");
    }

    public String GetName() {
        return (String)this.getValue("Name");
    }

    public void SetShortDesc(String sDesc) {
        this.putValue("ShortDescription", sDesc);
    }

    public String GetShortDesc() {
        return (String)this.getValue("ShortDescription");
    }

    public void SetSmallIcon(ImageIcon image) {
        this.putValue("SmallIcon", image);
    }

    public ImageIcon GetSmallIcon() {
        return (ImageIcon)this.getValue("SmallIcon");
    }

    public void SetLargeIcon(ImageIcon icoImage) {
        this.putValue("SwingLargeIconKey", icoImage);
    }

    public ImageIcon GetLargeIcon() {
        return (ImageIcon)this.getValue("SwingLargeIconKey");
    }

    public void SetSelected(boolean bSelected) {
        this.SetSelected(bSelected, true);
    }

    private void SetSelected(boolean bSelected, boolean bUpdateActionGroup) {
        CBaseAction[] arActionGroup;
        this.putValue("SwingSelectedKey", bSelected);
        for (int nIdx = 0; nIdx < this.GetOwnerCount(); ++nIdx) {
            Component rComp = this.GetOwner(nIdx);
            if (!(rComp instanceof JButton)) continue;
            JButton rBtn = (JButton)rComp;
            rBtn.setSelected(bSelected);
        }
        if (bSelected && bUpdateActionGroup && (arActionGroup = this.GetActionGroup()) != null) {
            for (int nIdx = 0; nIdx < arActionGroup.length; ++nIdx) {
                CBaseAction rAction = arActionGroup[nIdx];
                if (rAction == null) continue;
                Integer rThisID = this.GetEventID();
                Integer rActionID = rAction.GetEventID();
                if (rThisID != null && rActionID != null && rThisID.intValue() == rActionID.intValue()) continue;
                rAction.SetSelected(false, false);
            }
        }
    }

    public boolean IsSelected() {
        boolean bIsSelected = false;
        Boolean bVal = (Boolean)this.getValue("SwingSelectedKey");
        if (bVal != null) {
            bIsSelected = bVal;
        }
        return bIsSelected;
    }

    protected Vector<Component> GetOwners() {
        return this.m_aOwners;
    }

    public boolean AddOwner(Component rComp) {
        boolean bRet = false;
        if (this.GetOwners() != null && rComp != null) {
            bRet = this.GetOwners().add(rComp);
        }
        if (rComp instanceof JButton) {
            JButton rBtn = (JButton)rComp;
            rBtn.setSelected(this.IsSelected());
        }
        return bRet;
    }

    public Component RemoveOwner(int nIdx) {
        Component rRet = null;
        Component rTemp = this.GetOwner(nIdx);
        if (this.RemoveOwner(rTemp)) {
            rRet = rTemp;
        }
        return rRet;
    }

    public boolean RemoveOwner(Component rComp) {
        boolean bRet = false;
        if (this.GetOwners() != null && rComp != null) {
            bRet = this.GetOwners().remove(rComp);
        }
        return bRet;
    }

    public Component GetOwner(int nIdx) {
        Component rOwner = null;
        if (this.GetOwners() != null && nIdx >= 0 && nIdx < this.GetOwners().size()) {
            rOwner = this.GetOwners().get(nIdx);
        }
        return rOwner;
    }

    public int GetOwnerCount() {
        int nSize = 0;
        if (this.GetOwners() != null) {
            nSize = this.GetOwners().size();
        }
        return nSize;
    }

    protected CBaseAction[] GetActionGroup() {
        return this.m_arActionGroup;
    }

    public void SetActionGroup(CBaseAction[] arActionGroup) {
        this.m_arActionGroup = arActionGroup;
    }

    protected CBaseAction GetActionFromGroup(int nEventID) {
        CBaseAction rRet = null;
        CBaseAction[] arActionGroup = this.GetActionGroup();
        if (arActionGroup != null && arActionGroup.length > 0) {
            for (int nIdx = 0; nIdx < arActionGroup.length && rRet == null; ++nIdx) {
                Integer nNextID;
                CBaseAction rNext = arActionGroup[nIdx];
                if (rNext == null || (nNextID = rNext.GetEventID()) == null || nNextID != nEventID) continue;
                rRet = rNext;
            }
        }
        return rRet;
    }

    public CBaseAction GetSelectedGroupItem() {
        CBaseAction rRet = null;
        CBaseAction[] arActionGroup = this.GetActionGroup();
        if (arActionGroup != null && arActionGroup.length > 0) {
            for (int nIdx = 0; nIdx < arActionGroup.length && rRet == null; ++nIdx) {
                CBaseAction rNext = arActionGroup[nIdx];
                if (rNext == null || !rNext.IsSelected()) continue;
                rRet = rNext;
            }
        }
        return rRet;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Integer nEventID;
        Boolean bIsSelected = (Boolean)this.getValue("SwingSelectedKey");
        boolean bUpdateAction = true;
        if (event.getSource() instanceof JButton) {
            JButton rBtn = (JButton)event.getSource();
            if (bIsSelected != null) {
                bIsSelected = bIsSelected == false;
            }
        }
        if ((nEventID = this.GetEventID()) != null && this.GetActionFromGroup(nEventID) != null && bIsSelected != null && !bIsSelected.booleanValue()) {
            bUpdateAction = false;
        }
        if (!bUpdateAction && bIsSelected != null) {
            if (event.getSource() instanceof JButton) {
                ((JButton)event.getSource()).setSelected(bIsSelected == false);
            } else if (event.getSource() instanceof JMenuItem) {
                ((JMenuItem)event.getSource()).setSelected(bIsSelected == false);
            }
        }
        if (bUpdateAction && bIsSelected != null) {
            this.SetSelected(bIsSelected, true);
        }
    }
}

