/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.base.gui.events;

import com.rhinosoft.base.gui.events.CRhinoEvent;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.util.EmptyStackException;

public class CBaseEventQueue
extends EventQueue {
    protected static final boolean DEBUG = CMainFrame.DEBUG;
    protected static final boolean DEBUG_EVENTS;
    protected static final boolean DEBUG_DESTROY;

    public CBaseEventQueue() {
        this.Create();
    }

    public void Create() {
        Toolkit.getDefaultToolkit().getSystemEventQueue().push(this);
    }

    public void Destroy() {
        AWTEvent rEvent = null;
        do {
            block7: {
                if ((rEvent = this.peekEvent()) == null) continue;
                try {
                    rEvent = this.getNextEvent();
                }
                catch (InterruptedException ex) {
                    if (!CMainFrame.DEBUG) break block7;
                    ex.printStackTrace();
                }
            }
            if (rEvent instanceof CRhinoEvent) {
                if (!DEBUG_DESTROY) continue;
                System.out.println("CRhinoEventQueue.Destroy | CRhinoEvent | getNextEvent: " + rEvent.getID());
                continue;
            }
            if (DEBUG_DESTROY) {
                System.out.println("CRhinoEventQueue.Destroy | getNextEvent: " + rEvent.toString());
            }
            this.dispatchEvent(rEvent);
        } while (rEvent != null);
        try {
            this.pop();
        }
        catch (EmptyStackException ese) {
            System.out.println("CRhinoEventQueue.Destroy - No event queue to pop");
        }
    }

    public static void PostEvent(AWTEvent rEvent) {
        if (DEBUG_EVENTS) {
            System.out.format("CurrentThread: (%s, %d) is calling CRhinoEventQueue.PostEvent -->\r\n", Thread.currentThread().getName(), Thread.currentThread().getId());
            if (rEvent instanceof CRhinoEvent) {
                System.out.println("Event: " + rEvent.getID());
            }
        }
        Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(rEvent);
        if (DEBUG_EVENTS) {
            System.out.format("CurrentThread: (%s, %d) is calling CRhinoEventQueue.PostEvent <--\r\n", Thread.currentThread().getName(), Thread.currentThread().getId());
        }
    }

    static {
        if (DEBUG) {
            // empty if block
        }
        DEBUG_EVENTS = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_DESTROY = false;
    }
}

