/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.base.gui.frames;

import com.jidesoft.action.Chevron;
import com.jidesoft.action.CommandBarTitleBar;
import com.jidesoft.action.DefaultDockableBarDockableHolder;
import com.jidesoft.action.DockableBarManager;
import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.DockingManager;
import com.jidesoft.docking.FloatingContainer;
import com.jidesoft.docking.PopupMenuCustomizer;
import com.jidesoft.swing.Gripper;
import com.jidesoft.swing.JideSplitButton;
import com.jidesoft.swing.JideTabbedPane;
import com.rhinosoft.base.files.CFileSystemUtils;
import com.rhinosoft.base.gui.events.CBaseAction;
import com.rhinosoft.base.gui.frames.CBaseDockBarFactory;
import com.rhinosoft.base.gui.frames.CBaseDockFrameFactory;
import com.rhinosoft.base.gui.frames.CLogger;
import com.rhinosoft.fvjv.strings.CString;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.SimpleFormatter;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public abstract class CBaseMainFrame
extends DefaultDockableBarDockableHolder
implements WindowListener,
DockingManager.TabbedPaneCustomizer,
PopupMenuCustomizer,
DockingManager.FloatingContainerCustomizer {
    public static boolean DEBUG = false;
    public static boolean DEBUG_FUTURE_FEATURES = false;
    protected static CBaseMainFrame m_App;
    private static CLogger m_DebugLogger;
    private long m_lUniqueID = -1L;

    public CBaseMainFrame(String sTitle) throws HeadlessException {
        super(sTitle);
        m_App = this;
        this.InitVars();
    }

    private void InitVars() {
        this.InitTitleBarImages();
        this.addWindowListener(this);
        if (this.getDockingManager() != null) {
            this.getDockingManager().setOutlineMode(3);
            this.getDockingManager().setTabbedPaneCustomizer(this);
            this.getDockingManager().setPopupMenuCustomizer(this);
            this.getDockingManager().setFloatingContainerCustomizer(this);
            this.getDockingManager().setFloatingContainerType(1);
        }
        m_DebugLogger = this.CreateDebugLogger();
        this.InitDebugLogger(CBaseMainFrame.GetDebugLogger());
    }

    protected void InitTitleBarImages() {
    }

    public void LoadInitialLayout(File fFile) throws SAXException, ParserConfigurationException, IOException {
        if (fFile != null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(fFile);
            this.LoadInitialLayout(document);
        }
    }

    private void LoadInitialLayout(Document doc) {
        DockingManager frameManager;
        DockableBarManager barManager = this.getDockableBarManager();
        if (barManager != null) {
            barManager.beginLoadLayoutData();
            barManager.setDockableBarFactory(this.CreateDockableBarFactory());
            if (doc != null) {
                barManager.loadInitialLayout(doc);
            }
        }
        if ((frameManager = this.getDockingManager()) != null) {
            frameManager.beginLoadLayoutData();
            frameManager.setDockableFrameFactory(this.CreateDockFrameFactory());
            if (doc != null) {
                frameManager.loadInitialLayout(doc);
            }
        }
    }

    @Override
    public void windowOpened(WindowEvent event) {
    }

    @Override
    public void windowClosing(WindowEvent event) {
    }

    @Override
    public void windowClosed(WindowEvent event) {
    }

    @Override
    public void windowIconified(WindowEvent event) {
    }

    @Override
    public void windowDeiconified(WindowEvent event) {
    }

    @Override
    public void windowActivated(WindowEvent event) {
    }

    @Override
    public void windowDeactivated(WindowEvent event) {
    }

    public long GetNextUniqueID() {
        return ++this.m_lUniqueID;
    }

    public void SetNextUniqueID(long lNextID) {
        this.m_lUniqueID = Math.max(this.m_lUniqueID, lNextID);
    }

    protected abstract CBaseDockFrameFactory CreateDockFrameFactory();

    protected abstract CBaseDockBarFactory CreateDockableBarFactory();

    public void RemoveAllComponents(JComponent rFrom) {
        int nCompCount;
        if (rFrom != null && (nCompCount = rFrom.getComponentCount()) > 0) {
            for (int nIdx = nCompCount - 1; nIdx >= 0; --nIdx) {
                AbstractButton rBtn;
                Action rAction;
                Component rComp = rFrom.getComponent(nIdx);
                if (rComp == null || !(rComp instanceof JComponent) || rComp instanceof Chevron || rComp instanceof Gripper || rComp instanceof CommandBarTitleBar) continue;
                JComponent rNextComp = (JComponent)rComp;
                if (rNextComp instanceof JideSplitButton) {
                    JideSplitButton rSplitBtn = (JideSplitButton)rComp;
                    this.RemoveAllComponents(rSplitBtn);
                }
                if (rNextComp instanceof AbstractButton && (rAction = (rBtn = (AbstractButton)rNextComp).getAction()) != null && rAction instanceof CBaseAction) {
                    CBaseAction rBaseAction = (CBaseAction)rAction;
                    rBaseAction.RemoveOwner(rComp);
                }
                rFrom.remove(nIdx);
            }
        }
    }

    protected Vector<Integer> GetActions(JComponent rFrom) {
        int nCompCount;
        Vector<Integer> anActionIDs = new Vector<Integer>();
        if (rFrom != null && (nCompCount = rFrom.getComponentCount()) > 0) {
            for (int nIdx = 0; nIdx < nCompCount; ++nIdx) {
                AbstractButton rBtn;
                Action rAction;
                Component rNextComp = rFrom.getComponent(nIdx);
                if (rNextComp == null || !(rNextComp instanceof AbstractButton) || (rAction = (rBtn = (AbstractButton)rNextComp).getAction()) == null || !(rAction instanceof CBaseAction)) continue;
                CBaseAction rBaseAction = (CBaseAction)rAction;
                anActionIDs.add(rBaseAction.GetEventID());
            }
        }
        return anActionIDs;
    }

    protected boolean AddDockableFrame(DockableFrame rDockableFrame) {
        boolean bAdded;
        block3: {
            bAdded = false;
            if (rDockableFrame != null && this.getDockingManager() != null) {
                try {
                    this.getDockingManager().addFrame(rDockableFrame);
                    bAdded = true;
                }
                catch (IllegalArgumentException iae) {
                    if (!DEBUG) break block3;
                    System.out.println(String.format("Most likely a frame already exists with this key:  %s", rDockableFrame.getKey()));
                    iae.printStackTrace();
                }
            }
        }
        return bAdded;
    }

    protected boolean RemoveDockableFrame(DockableFrame rDockableFrame) {
        boolean bRemoved;
        block3: {
            bRemoved = false;
            if (rDockableFrame != null && this.getDockingManager() != null) {
                try {
                    this.getDockingManager().removeFrame(rDockableFrame.getKey());
                    bRemoved = true;
                }
                catch (IllegalArgumentException iae) {
                    if (!DEBUG) break block3;
                    System.out.println(String.format("Most likely a frame already exists with this key:  %s", rDockableFrame.getKey()));
                    iae.printStackTrace();
                }
            }
        }
        return bRemoved;
    }

    protected abstract String GetDebugLoggerFileName();

    protected abstract String GetDebugLoggerKey();

    protected abstract Level GetDebugLoggerLvl();

    private CLogger CreateDebugLogger() {
        return new CLogger(this.GetDebugLoggerAbsPath(), this.GetDebugLoggerKey());
    }

    public static CLogger GetDebugLogger() {
        return m_DebugLogger;
    }

    private String GetDebugLoggerAbsPath() {
        File fTempFolder = CFileSystemUtils.GetTempFolder();
        String sPath = fTempFolder.getAbsolutePath();
        sPath = CString.EnsureLastCharIsAFileSeparator(sPath);
        sPath = sPath + this.GetDebugLoggerFileName();
        return sPath;
    }

    private void InitDebugLogger(CLogger rLogger) {
        if (rLogger != null) {
            FileHandler rFileHandler;
            block6: {
                rLogger.SetUseParentHandlers(false);
                ConsoleHandler rConsoleHandler = new ConsoleHandler();
                rLogger.AddHandler(rConsoleHandler);
                rConsoleHandler.setLevel(Level.ALL);
                rFileHandler = null;
                if (DEBUG) {
                    try {
                        rFileHandler = new FileHandler(this.GetDebugLoggerAbsPath());
                        if (DEBUG) {
                            System.out.println("Debug log file: " + this.GetDebugLoggerAbsPath());
                        }
                    }
                    catch (IOException ioe) {
                        rFileHandler = null;
                        rLogger.Severe("EXCEPTION:  Failed to create FileHandler for logger.");
                        if (!DEBUG) break block6;
                        ioe.printStackTrace();
                    }
                }
            }
            if (rFileHandler != null) {
                rFileHandler.setFormatter(new SimpleFormatter());
                rLogger.AddHandler(rFileHandler);
            }
            rLogger.SetLevel(this.GetDebugLoggerLvl());
        }
    }

    protected abstract CBaseAction CreateDockTabCloseAction();

    @Override
    public void customize(JideTabbedPane tabbedPane) {
        tabbedPane.setHideOneTab(false);
        tabbedPane.setTabPlacement(1);
        if (CFileSystemUtils.GetFileSysUtils().IsMac()) {
            tabbedPane.setTabShape(0);
        } else {
            tabbedPane.setTabShape(4);
        }
        tabbedPane.setTabResizeMode(1);
        tabbedPane.setShowTabArea(true);
        tabbedPane.setShowTabContent(true);
        tabbedPane.setShowIconsOnTab(true);
        tabbedPane.setShowCloseButton(true);
        tabbedPane.setShowCloseButtonOnTab(true);
        CBaseAction rTabCloseAction = this.CreateDockTabCloseAction();
        tabbedPane.setCloseAction(rTabCloseAction);
        tabbedPane.setTabClosableAt(0, false);
        tabbedPane.setScrollSelectedTabOnWheel(true);
        tabbedPane.setOpaque(true);
        boolean bUseOneNote = false;
        if (bUseOneNote) {
            tabbedPane.setTabColorProvider(JideTabbedPane.ONENOTE_COLOR_PROVIDER);
        } else {
            tabbedPane.setTabColorProvider(null);
        }
    }

    @Override
    public void customizePopupMenu(JPopupMenu cPopupMenu, DockingManager cDockingManager, DockableFrame cDockableFrame, boolean bOnTab) {
        cPopupMenu.removeAll();
    }

    public static void Finest(String sText) {
        if (CBaseMainFrame.GetDebugLogger() != null) {
            CBaseMainFrame.GetDebugLogger().Finest(sText);
        }
    }

    public static void Finer(String sText) {
        if (CBaseMainFrame.GetDebugLogger() != null) {
            CBaseMainFrame.GetDebugLogger().Finer(sText);
        }
    }

    public static void Fine(String sText) {
        if (CBaseMainFrame.GetDebugLogger() != null) {
            CBaseMainFrame.GetDebugLogger().Fine(sText);
        }
    }

    public static void Config(String sText) {
        if (CBaseMainFrame.GetDebugLogger() != null) {
            CBaseMainFrame.GetDebugLogger().Config(sText);
        }
    }

    public static void Info(String sText) {
        if (CBaseMainFrame.GetDebugLogger() != null) {
            CBaseMainFrame.GetDebugLogger().Info(sText);
        }
    }

    public static void Warning(String sText) {
        if (CBaseMainFrame.GetDebugLogger() != null) {
            CBaseMainFrame.GetDebugLogger().Warning(sText);
        }
    }

    public static void Severe(String sText) {
        if (CBaseMainFrame.GetDebugLogger() != null) {
            CBaseMainFrame.GetDebugLogger().Severe(sText);
        }
    }

    public static void Entering(String sSource, String sMethod) {
        if (CBaseMainFrame.GetDebugLogger() != null) {
            CBaseMainFrame.GetDebugLogger().Entering(sSource, sMethod);
        }
    }

    public static void Entering(String sSource, String sMethod, Object rParm) {
        if (CBaseMainFrame.GetDebugLogger() != null) {
            CBaseMainFrame.GetDebugLogger().Entering(sSource, sMethod, rParm);
        }
    }

    public static void Entering(String sSource, String sMethod, Object[] arParms) {
        if (CBaseMainFrame.GetDebugLogger() != null) {
            CBaseMainFrame.GetDebugLogger().Entering(sSource, sMethod, arParms);
        }
    }

    public static void Exiting(String sSource, String sMethod) {
        if (CBaseMainFrame.GetDebugLogger() != null) {
            CBaseMainFrame.GetDebugLogger().Exiting(sSource, sMethod);
        }
    }

    public static void Exiting(String sSource, String sMethod, Object rResult) {
        if (CBaseMainFrame.GetDebugLogger() != null) {
            CBaseMainFrame.GetDebugLogger().Exiting(sSource, sMethod, rResult);
        }
    }

    public static void Log(Level rLevel, String sText) {
        if (CBaseMainFrame.GetDebugLogger() != null) {
            CBaseMainFrame.GetDebugLogger().Log(rLevel, sText);
        }
    }

    public static void Log(Level rLevel, String sText, Object rParm) {
        if (CBaseMainFrame.GetDebugLogger() != null) {
            CBaseMainFrame.GetDebugLogger().Log(rLevel, sText, rParm);
        }
    }

    public static void Log(Level rLevel, String sText, Object[] arParms) {
        if (CBaseMainFrame.GetDebugLogger() != null) {
            CBaseMainFrame.GetDebugLogger().Log(rLevel, sText, arParms);
        }
    }

    protected void OnDestroy() {
        if (CBaseMainFrame.GetDebugLogger() != null) {
            CBaseMainFrame.GetDebugLogger().OnDestroy();
            m_DebugLogger = null;
        }
    }

    @Override
    public void customize(FloatingContainer floatingContainer) {
    }
}

