/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.base.gui.frames;

import com.jidesoft.action.CommandBar;
import com.rhinosoft.base.CConversionUtils;
import com.rhinosoft.base.gui.events.CBaseAction;
import com.rhinosoft.base.gui.frames.CPopupMenu;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

public abstract class CToolbar
extends CommandBar
implements MouseListener {
    protected static final boolean DEBUG = CMainFrame.DEBUG;
    protected static final boolean DEBUG_TRACE_METHODS;
    public static final int ID_TOOLBAR = -1;
    public static final int ID_SEPARATOR = -2;
    public static final String ITEM_DELIMITER = ",";
    private HashMap<Integer, AbstractButton> m_aItemMap;
    private HashMap<Integer, String> m_asShowMap;
    private HashMap<Integer, CBaseAction> m_aActionMap;
    private CPopupMenu m_PopupMenu;

    public CToolbar(HashMap<Integer, CBaseAction> aActionMap) {
        this.m_aActionMap = aActionMap;
    }

    protected abstract void CreateItems();

    protected abstract void LayoutItems();

    protected abstract void CreateMenus();

    protected abstract void LayoutMenus();

    protected abstract void InitMenus();

    protected abstract void RefreshBtnLayout();

    public void OnCreate() {
        this.setAlignmentX(0.0f);
        this.setLayout(new BoxLayout(this, 0));
        this.add(Box.createHorizontalStrut(2));
        this.setFloatable(false);
        this.setOrientation(0);
        this.m_aItemMap = new HashMap();
        this.m_asShowMap = new HashMap();
        this.CreateItems();
        this.LayoutItems();
        this.InitItems();
        this.m_PopupMenu = new CPopupMenu();
        this.addMouseListener(this);
        this.CreateMenus();
        this.LayoutMenus();
        this.InitMenus();
    }

    protected void InitItems() {
        this.RefreshBtnLayout();
    }

    public void OnInitialUpdate() {
        this.RefreshBtnLayout();
    }

    public CBaseAction GetAction(int nID) {
        CBaseAction rAction = null;
        if (this.GetActionMap() != null) {
            rAction = this.GetActionMap().get(nID);
        }
        return rAction;
    }

    @Override
    public void mouseClicked(MouseEvent jEvent) {
    }

    @Override
    public void mousePressed(MouseEvent jEvent) {
        if (this.GetPopupMenu() != null) {
            if (SwingUtilities.isRightMouseButton(jEvent)) {
                Object jSource = jEvent.getSource();
                if (jSource instanceof Component) {
                    Component jComp = (Component)jEvent.getSource();
                    Point ptMouseLoc = SwingUtilities.convertPoint(jComp, jEvent.getPoint(), this);
                    this.GetPopupMenu().show(this, ptMouseLoc.x, ptMouseLoc.y);
                }
            } else {
                this.GetPopupMenu().setVisible(false);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent jEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent jEvent) {
    }

    @Override
    public void mouseExited(MouseEvent jEvent) {
    }

    @Override
    public Component add(Component rComp) {
        rComp.addMouseListener(this);
        return super.add(rComp);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.GetItemMap() != null) {
            Collection<AbstractButton> rItems = this.GetItemMap().values();
            for (AbstractButton rNextItem : rItems) {
                if (rNextItem == null) continue;
                rNextItem.updateUI();
            }
        }
        if (this.GetPopupMenu() != null) {
            this.GetPopupMenu().updateUI();
        } else if (CMainFrame.GetDebugLogger() != null) {
            CMainFrame.GetDebugLogger().Info("ASSERT:  Programming error, GetPopupMenu() = null");
        }
    }

    public void AddItem(int nID, AbstractButton rItem) {
        if (this.GetItemMap() != null) {
            this.GetItemMap().put(nID, rItem);
        }
    }

    public void ShowItems(int nID, int[] anItems) {
        StringBuilder sbItems = new StringBuilder();
        if (anItems != null && anItems.length > 0) {
            for (int nNextID : anItems) {
                sbItems.append(nNextID);
                sbItems.append(ITEM_DELIMITER);
            }
        }
        if (this.GetShowMap() != null) {
            this.GetShowMap().put(nID, sbItems.toString());
        }
    }

    public JMenuItem GetMenuItem(int nID) {
        JMenuItem rItem = null;
        if (this.GetPopupMenu() != null) {
            rItem = this.GetPopupMenu().GetItem(nID);
        }
        return rItem;
    }

    public AbstractButton GetItem(int nID) {
        AbstractButton rBtn = null;
        if (this.GetItemMap() != null) {
            rBtn = this.GetItemMap().get(nID);
        }
        return rBtn;
    }

    private void BuildItems() {
        this.removeAll();
        this.BuildItems(-1, this);
        this.RemoveSeparators();
    }

    private void BuildItems(int nID, JComponent rAddTo) {
        if (rAddTo != null) {
            if (this.GetShowMap() != null) {
                String sShowItems = this.GetShowMap().get(nID);
                if (sShowItems != null) {
                    String[] asItems;
                    for (String sItem : asItems = sShowItems.split(ITEM_DELIMITER)) {
                        int nNextID = CConversionUtils.ConvertToInt(sItem);
                        if (!CConversionUtils.IsValidInt(nNextID)) continue;
                        if (nNextID == -2) {
                            this.AddSeparator(rAddTo);
                            continue;
                        }
                        this.AddComp(nNextID, rAddTo);
                    }
                }
            } else if (CMainFrame.GetDebugLogger() != null) {
                CMainFrame.GetDebugLogger().Info("ASSERT:  Programming error, GetShowItems() = null");
            }
        } else if (CMainFrame.GetDebugLogger() != null) {
            CMainFrame.GetDebugLogger().Info("ASSERT:  Programming error, rAddTo = null");
        }
    }

    protected void AddComp(int nID, JComponent rAddTo) {
        AbstractButton rItem = this.GetItem(nID);
        if (rItem != null) {
            rAddTo.add(rItem);
        }
    }

    @Override
    public void setVisible(boolean bVisible) {
        if (bVisible) {
            this.BuildItems();
        }
        super.setVisible(bVisible);
    }

    private void AddSeparator(Component rAddTo) {
        if (rAddTo != null) {
            if (rAddTo instanceof JToolBar) {
                JToolBar rToolbar = (JToolBar)rAddTo;
                JSeparator rSep = new JSeparator();
                Dimension dimSize = new Dimension(2, Integer.MAX_VALUE);
                int nOrientation = 1;
                if (this.getOrientation() == 1) {
                    nOrientation = 0;
                    dimSize = new Dimension(Integer.MAX_VALUE, 2);
                }
                rSep.setOrientation(nOrientation);
                rSep.setMinimumSize(dimSize);
                rSep.setMaximumSize(dimSize);
                Component rStrut = Box.createHorizontalStrut(3);
                rStrut.setName(Integer.toString(-2));
                rStrut.setFocusable(false);
                rToolbar.add(rStrut);
                rSep.setName(Integer.toString(-2));
                rToolbar.add(rSep);
                rStrut = Box.createHorizontalStrut(2);
                rStrut.setName(Integer.toString(-2));
                rStrut.setFocusable(false);
                rToolbar.add(rStrut);
            }
        } else if (CMainFrame.GetDebugLogger() != null) {
            CMainFrame.GetDebugLogger().Info("ASSERT:  Programming error, rAddTo = null");
        }
    }

    private void RemoveSeparators() {
        int nSeparatorID;
        String sName;
        Component rComp;
        int nIdx;
        for (nIdx = 0; nIdx < this.getComponentCount(); ++nIdx) {
            rComp = this.getComponent(nIdx);
            if (rComp == null) continue;
            sName = rComp.getName();
            nSeparatorID = CConversionUtils.ConvertToInt(sName);
            if (!CConversionUtils.IsValidInt(nSeparatorID)) break;
            if (nSeparatorID != -2) continue;
            this.remove(nIdx);
            --nIdx;
        }
        for (nIdx = this.getComponentCount() - 1; nIdx >= 0; --nIdx) {
            rComp = this.getComponent(nIdx);
            if (rComp == null) continue;
            sName = rComp.getName();
            nSeparatorID = CConversionUtils.ConvertToInt(sName);
            if (!CConversionUtils.IsValidInt(nSeparatorID)) break;
            if (nSeparatorID != -2) continue;
            this.remove(nIdx);
        }
        for (nIdx = 0; nIdx < this.getComponentCount() - 2; ++nIdx) {
            String sName2;
            int nSeparatorID2;
            int nIdx2;
            Component rComp2;
            Component rComp1 = this.getComponent(nIdx);
            if (!(rComp1 instanceof JSeparator) || (rComp2 = this.getComponent(nIdx2 = nIdx + 2)) == null || !CConversionUtils.IsValidInt(nSeparatorID2 = CConversionUtils.ConvertToInt(sName2 = rComp2.getName())) || nSeparatorID2 != -2) continue;
            this.remove(nIdx2);
            this.remove(nIdx2);
            this.remove(nIdx2);
            --nIdx;
        }
    }

    protected HashMap<Integer, AbstractButton> GetItemMap() {
        return this.m_aItemMap;
    }

    protected HashMap<Integer, String> GetShowMap() {
        return this.m_asShowMap;
    }

    protected HashMap<Integer, CBaseAction> GetActionMap() {
        return this.m_aActionMap;
    }

    protected CPopupMenu GetPopupMenu() {
        return this.m_PopupMenu;
    }

    static {
        if (DEBUG) {
            // empty if block
        }
        DEBUG_TRACE_METHODS = false;
    }
}

