/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.base.gui.renderers.files;

import com.rhinosoft.base.files.CFile;
import com.rhinosoft.base.files.CFileSystemUtils;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;

public class CFileListCellRenderer
extends DefaultListCellRenderer {
    private boolean m_bShowPath = false;

    public CFileListCellRenderer(boolean bShowPath) {
        this.InitVars(bShowPath);
    }

    private void InitVars(boolean bShowPath) {
        this.m_bShowPath = bShowPath;
    }

    public boolean GetShowPath() {
        return this.m_bShowPath;
    }

    @Override
    public Component getListCellRendererComponent(JList rList, Object rValue, int nIndex, boolean bIsSelected, boolean bCellHasFocus) {
        super.getListCellRendererComponent((JList<?>)rList, rValue, nIndex, bIsSelected, bCellHasFocus);
        if (rValue instanceof CFile) {
            CFile fFile = (CFile)rValue;
            this.setIcon(fFile.GetIcon16());
            String sText = fFile.GetPath();
            boolean bShowPath = this.GetShowPath();
            if (CFileSystemUtils.GetFileSysUtils() != null && CFileSystemUtils.GetFileSysUtils().IsRoot(fFile.GetPath())) {
                bShowPath = false;
            }
            if (!bShowPath) {
                sText = fFile.GetDisplayName();
            }
            this.setText(sText);
        }
        return this;
    }
}

