/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.base.gui.tables;

import com.rhinosoft.FilePanel.CFileTableCellRenderer;
import com.rhinosoft.FilePanel.ICellRendererColumnWidths;
import com.rhinosoft.base.CUtils;
import com.rhinosoft.base.files.CFile;
import com.rhinosoft.base.gui.CColorUtils;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.gui.frames.IArchive;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class CTableUtils {
    public static final int SORT_CLR_OFFSET = 10;

    public static int[] GetColXLocs(JTable jTable, int nModelCol) {
        JTableHeader jHeader;
        int[] nXLocs = new int[]{0, 0};
        if (nModelCol >= 0 && nModelCol < jTable.getColumnCount() && (jHeader = jTable.getTableHeader()) != null) {
            TableCellRenderer jHeaderRenderer = jHeader.getDefaultRenderer();
            nXLocs = CTableUtils.GetColXLocs(jTable, jHeaderRenderer, jTable.convertColumnIndexToView(nModelCol));
        }
        return nXLocs;
    }

    private static int[] GetColXLocs(JTable jTable, TableCellRenderer jHeaderRenderer, int nViewCol) {
        int[] nXLocs = new int[]{0, 0};
        if (jTable != null) {
            TableColumnModel jColModel;
            TableModel jModel = jTable.getModel();
            JTableHeader jHeader = jTable.getTableHeader();
            if (jHeader != null && (jColModel = jHeader.getColumnModel()) != null) {
                int nTableColCount = jTable.getColumnCount();
                int[] naColWidths = new int[nTableColCount];
                for (int nColIdx = 0; nColIdx < nTableColCount; ++nColIdx) {
                    TableColumn jNextCol = jColModel.getColumn(nColIdx);
                    if (jNextCol == null) continue;
                    naColWidths[nColIdx] = jNextCol.getWidth();
                }
                for (int nIdx = 0; nIdx < nViewCol; ++nIdx) {
                    nXLocs[0] = nXLocs[0] + naColWidths[nIdx];
                }
                nXLocs[1] = nXLocs[0] + naColWidths[nViewCol];
                naColWidths = null;
            }
        }
        return nXLocs;
    }

    public static Color GetSortColor(Color rBackClr, int nOffset) {
        Color clrRet = Color.DARK_GRAY;
        boolean bMakeBrighter = CColorUtils.IsADarkColor(rBackClr);
        if (rBackClr != null) {
            int nBlue;
            int nRed = bMakeBrighter ? rBackClr.getRed() + nOffset : rBackClr.getRed() - nOffset;
            int nGreen = bMakeBrighter ? rBackClr.getGreen() + nOffset : rBackClr.getGreen() - nOffset;
            int n = nBlue = bMakeBrighter ? rBackClr.getBlue() + nOffset : rBackClr.getBlue() - nOffset;
            if (nRed < 0 || nRed > 255) {
                nRed = rBackClr.getRed();
            }
            if (nGreen < 0 || nGreen > 255) {
                nGreen = rBackClr.getGreen();
            }
            if (nBlue < 0 || nBlue > 255) {
                nBlue = rBackClr.getBlue();
            }
            if (nRed < 11 && nGreen < 11 && nBlue < 11) {
                nRed = 30;
                nGreen = 30;
                nBlue = 30;
            }
            clrRet = new Color(nRed, nGreen, nBlue);
        }
        return clrRet;
    }

    public static int GetModelColFromPoint(JTable jTable, Point pt) {
        int nModelCol = -1;
        JTableHeader jHeader = jTable.getTableHeader();
        for (int nCol = 0; nCol < jTable.getColumnCount(); ++nCol) {
            int nViewCol = jTable.convertColumnIndexToView(nCol);
            Rectangle rCell = jHeader.getHeaderRect(nViewCol);
            if (!CUtils.IsPointInRect(pt, rCell, 1)) continue;
            nModelCol = nCol;
            break;
        }
        return nModelCol;
    }

    public static int GetViewColToExpand(JTable jTable, Point pt) {
        int nRetViewCol = -1;
        JTableHeader jTableHeader = jTable.getTableHeader();
        int nCursorType = jTableHeader.getCursor().getType();
        if (nCursorType == 11 || nCursorType == 10) {
            int nModelCol = CTableUtils.GetModelColFromPoint(jTable, pt);
            int nViewCol = jTable.convertColumnIndexToView(nModelCol);
            Rectangle rCell = jTableHeader.getHeaderRect(nViewCol);
            int nMidPt = rCell.x + rCell.width / 2;
            if (pt.x >= nMidPt) {
                nRetViewCol = nViewCol;
            } else if (nViewCol - 1 > -1) {
                nRetViewCol = nViewCol - 1;
            }
        }
        return nRetViewCol;
    }

    public static int GetMaxCellWidth(JTable jTable, int nViewCol, IArchive rArchive) {
        int nMaxCellWidth = 0;
        if (jTable != null) {
            Object objHeaderVal;
            TableColumn jCol;
            TableColumnModel jColModel;
            FontRenderContext fFontContext;
            Graphics2D g2d;
            TableModel jModel = jTable.getModel();
            Font fFont = jTable.getFont();
            if (fFont != null && (g2d = (Graphics2D)jTable.getGraphics()) != null && (fFontContext = g2d.getFontRenderContext()) != null && (jColModel = jTable.getColumnModel()) != null && (jCol = jColModel.getColumn(nViewCol)) != null && (objHeaderVal = jCol.getHeaderValue()) instanceof String) {
                String sColHeaderTxt = (String)objHeaderVal;
                Rectangle2D rStringBounds = fFont.getStringBounds(sColHeaderTxt, fFontContext);
                int nHeaderTextWidth = (int)rStringBounds.getWidth();
                for (int nRow = 0; nRow < jModel.getRowCount(); ++nRow) {
                    int nTextWidth;
                    int nModelCol = jTable.convertColumnIndexToModel(nViewCol);
                    Object objVal = jModel.getValueAt(nRow, nModelCol);
                    if (!(objVal instanceof CFile)) continue;
                    CFile fFile = (CFile)objVal;
                    String sCellVal = null;
                    if (nModelCol == 0) {
                        sCellVal = fFile.GetDisplayName();
                    } else if (nModelCol == 1) {
                        if (!fFile.IsDirectory()) {
                            sCellVal = CFile.FormatFileSize(fFile.GetSize(), false);
                        }
                    } else if (nModelCol == 2) {
                        sCellVal = fFile.GetType();
                    } else if (nModelCol == 3) {
                        sCellVal = CFileTableCellRenderer.FmtDisplayDate(fFile.GetModifiedDate(), rArchive, false);
                    }
                    if (sCellVal == null || (nTextWidth = (int)(rStringBounds = fFont.getStringBounds(sCellVal, fFontContext)).getWidth()) <= nMaxCellWidth) continue;
                    nMaxCellWidth = nTextWidth;
                }
                nMaxCellWidth = CTableUtils.GetMaxCellWidth(jTable, nViewCol, nHeaderTextWidth, nMaxCellWidth);
            }
        }
        return nMaxCellWidth;
    }

    public static int GetMaxCellWidth(JTable jTable, int nViewCol, int nHeaderTextWidth, int nMaxCellWidth) {
        if (nHeaderTextWidth > nMaxCellWidth) {
            nMaxCellWidth = nHeaderTextWidth;
            TableCellRenderer jRenderer = jTable.getCellRenderer(0, 0);
            if (jRenderer instanceof DefaultTableCellRenderer) {
                CMainFrame rMainPanel;
                Insets jInset;
                DefaultTableCellRenderer jDefRenderer = (DefaultTableCellRenderer)jRenderer;
                Border jBorder = jDefRenderer.getBorder();
                if (jBorder != null && (jInset = jBorder.getBorderInsets(jDefRenderer)) != null) {
                    nMaxCellWidth += jInset.left + jInset.right;
                }
                if ((rMainPanel = (CMainFrame)SwingUtilities.getAncestorOfClass(CMainFrame.class, jTable)) != null) {
                    ImageIcon icoImage = rMainPanel.GetJarImage("SortUpArrow.png");
                    if (icoImage != null) {
                        nMaxCellWidth += icoImage.getIconWidth();
                    }
                    nMaxCellWidth += jDefRenderer.getIconTextGap();
                }
            }
        } else {
            TableCellRenderer rCellRenderer = jTable.getCellRenderer(0, nViewCol);
            if (rCellRenderer instanceof ICellRendererColumnWidths) {
                ICellRendererColumnWidths rCellRendererColumnWidths = (ICellRendererColumnWidths)((Object)rCellRenderer);
                nMaxCellWidth += rCellRendererColumnWidths.GetBorderWidthLeftRight();
                nMaxCellWidth += rCellRendererColumnWidths.GetIconWidth();
                nMaxCellWidth += rCellRendererColumnWidths.GetIconTxtGap(true);
            }
        }
        return nMaxCellWidth;
    }

    public static Border GetFocusCellBorder() {
        Border rRet = null;
        Object objTemp = UIManager.get("Table.focusCellHighlightBorder");
        if (objTemp instanceof Border) {
            rRet = (Border)objTemp;
        }
        return rRet;
    }

    public static Border GetEmptyCellBorder(JComponent jComp, Border jFocusBorder, Border jEmptyBorder) {
        Insets jFocusInsets;
        Border jRetBorder = jEmptyBorder;
        if (jComp != null && jFocusBorder != null && (jFocusInsets = jFocusBorder.getBorderInsets(jComp)) != null) {
            Insets jEmptyInsets;
            boolean bCreateEmptyBorder = true;
            if (jEmptyBorder != null && (jEmptyInsets = jEmptyBorder.getBorderInsets(jComp)) != null && jEmptyInsets.top == jFocusInsets.top && jEmptyInsets.bottom == jFocusInsets.bottom && jEmptyInsets.left == jFocusInsets.left && jEmptyInsets.right == jFocusInsets.right) {
                bCreateEmptyBorder = false;
            }
            if (bCreateEmptyBorder) {
                jRetBorder = BorderFactory.createEmptyBorder(jFocusInsets.top, jFocusInsets.left, jFocusInsets.bottom, jFocusInsets.right);
            }
        }
        return jRetBorder;
    }
}

