/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.base.net;

import com.rhinosoft.base.gui.events.CRhinoEvent;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CHTTPConnection {
    public static final boolean DEBUG = CMainFrame.DEBUG;
    public static final boolean DEBUG_PRINT_URL;
    public static final boolean DEBUG_PRINT_REQUEST_HEADER;
    public static final boolean DEBUG_UPLOAD_BOUNDARY;
    public static final boolean DEBUG_PRINT_RESPONSE_HEADER;
    public static final boolean DEBUG_PRINT_RESPONSE_BODY;
    public static final boolean DEBUG_OVERRIDE_USE_COMPRESSION;
    public static final boolean DEBUG_INFLATE_PACKETS = false;
    public static final int COMPRESSION_UNKNOWN = 0;
    public static final int COMPRESSION_GZIP = 1;
    public static final int COMPRESSION_DEFLATE = 2;
    private HttpURLConnection m_Connection;
    private int m_nCompressionType = 0;
    private InputStream m_InputStream;
    private OutputStream m_OutputStream;

    public CHTTPConnection(int nCompressionType) {
        this.m_nCompressionType = nCompressionType;
    }

    public void finalize() throws Throwable {
        this.m_InputStream = this.CloseInputStream(this.m_InputStream);
        this.m_OutputStream = this.CloseOutputStream(this.m_OutputStream);
        this.Disconnect();
        super.finalize();
    }

    protected HttpURLConnection GetConnection() {
        return this.m_Connection;
    }

    private boolean SetConnection(HttpURLConnection rConnection) {
        boolean bDirty = false;
        if (this.m_Connection != rConnection) {
            bDirty = true;
            this.m_Connection = rConnection;
        }
        return bDirty;
    }

    public void SetCompressionType(int nCompressionType) {
        this.m_nCompressionType = nCompressionType;
    }

    public int GetCompressionType() {
        return this.m_nCompressionType;
    }

    private HttpURLConnection CreateConnection(URL rURL) throws IOException {
        HttpURLConnection rConnection = null;
        rConnection = (HttpURLConnection)rURL.openConnection();
        if (rConnection == null) {
            throw new NullPointerException("HttpURLConnection failed in CURLConnection.CreateConnection");
        }
        rConnection.setDoInput(true);
        rConnection.setDoOutput(true);
        rConnection.setUseCaches(false);
        rConnection.setDefaultUseCaches(false);
        return rConnection;
    }

    private void LoadRequestHeader(String[] asHeaderInfo) throws NullPointerException {
        if (asHeaderInfo == null || this.GetConnection() == null) {
            throw new NullPointerException("Invalid parms in CURLConnection.LoadRequestHeader");
        }
        for (int nIdx = 0; nIdx < asHeaderInfo.length; nIdx += 2) {
            String sKey = asHeaderInfo[nIdx];
            String sValue = asHeaderInfo[nIdx + 1];
            if (sKey == null) {
                throw new NullPointerException("Invalid key in CURLConnection.LoadRequestHeader");
            }
            this.GetConnection().setRequestProperty(sKey, sValue);
        }
    }

    protected void PrintRequestHeader() {
        System.out.println(String.format("---------- HTTP Header | Request | %s ----------", Thread.currentThread().getName()));
        this.PrintHTTPFields(this.GetConnection().getRequestProperties());
    }

    protected void PrintResponseHeader() {
        System.out.println(String.format("---------- HTTP Header | Response | %s ----------", Thread.currentThread().getName()));
        this.PrintHTTPFields(this.GetConnection().getHeaderFields());
    }

    private void PrintHTTPFields(Map<String, List<String>> aFieldMap) {
        Set<String> asSet;
        if (aFieldMap != null && (asSet = aFieldMap.keySet()) != null) {
            for (String sHeaderField : asSet) {
                System.out.println(String.format("%30s: %s", sHeaderField, aFieldMap.get(sHeaderField)));
            }
            System.out.println(String.format("%30s: %s", "Using Proxy", this.GetConnection().usingProxy()));
        }
    }

    protected void PrintResponseBody() {
        block5: {
            try {
                String decodedString;
                StringBuilder sbResponse = new StringBuilder("---------- Response Body ----------\r\n");
                InputStream streamInput = this.GetConnection().getInputStream();
                boolean bMarkSupported = streamInput.markSupported();
                if (bMarkSupported) {
                    streamInput.mark(Integer.MAX_VALUE);
                }
                BufferedReader streamReader = new BufferedReader(new InputStreamReader(streamInput));
                while ((decodedString = streamReader.readLine()) != null) {
                    sbResponse.append("\t" + decodedString + "\r\n");
                }
                if (bMarkSupported) {
                    streamInput.reset();
                }
                System.out.println(sbResponse);
            }
            catch (IOException ioe) {
                if (CMainFrame.GetDebugLogger() == null) break block5;
                CMainFrame.GetDebugLogger().Warning(String.format("EXCEPTION:  PrintResponse failed (%s)", ioe.getMessage()));
            }
        }
    }

    private void ConnectToServer() throws IOException {
        if (DEBUG_PRINT_REQUEST_HEADER) {
            this.PrintRequestHeader();
        }
        this.m_InputStream = this.CloseInputStream(this.m_InputStream);
        this.m_OutputStream = this.CloseOutputStream(this.m_OutputStream);
        this.GetConnection().connect();
        if (DEBUG_PRINT_RESPONSE_HEADER) {
            this.PrintResponseHeader();
        }
        if (DEBUG_PRINT_RESPONSE_BODY) {
            this.PrintResponseBody();
        }
    }

    public boolean Get(URL rURL, String[] asRequestHeaderInfo) {
        boolean bRet = true;
        if (DEBUG_PRINT_URL) {
            System.out.println(String.format("---------- URL ----------\r\n\t%s", rURL.toString()));
        }
        try {
            this.SetConnection(this.CreateConnection(rURL));
        }
        catch (IOException ioe) {
            bRet = false;
        }
        try {
            this.GetConnection().setRequestMethod("GET");
        }
        catch (ProtocolException pe) {
            bRet = false;
        }
        this.LoadRequestHeader(asRequestHeaderInfo);
        try {
            this.ConnectToServer();
        }
        catch (IOException ioe) {
            bRet = false;
        }
        return bRet;
    }

    public boolean Post(URL rURL, String[] asRequestHeaderInfo, int nContentLen) {
        boolean bRet = true;
        if (DEBUG_PRINT_URL) {
            System.out.println(String.format("---------- URL ----------\r\n\t%s", rURL.toString()));
        }
        try {
            this.SetConnection(this.CreateConnection(rURL));
        }
        catch (IOException ioe) {
            bRet = false;
        }
        try {
            this.GetConnection().setRequestMethod("POST");
        }
        catch (ProtocolException pe) {
            bRet = false;
        }
        if (this.GetConnection() != null) {
            this.GetConnection().setFixedLengthStreamingMode(nContentLen);
            this.GetConnection().setRequestProperty("Content-Length", Integer.toString(nContentLen));
            this.LoadRequestHeader(asRequestHeaderInfo);
        }
        return bRet;
    }

    private void CheckCompressionMethod() {
        String sContentEncoding;
        if (this.GetConnection() != null && (sContentEncoding = this.GetConnection().getContentEncoding()) != null && !sContentEncoding.isEmpty()) {
            if ((sContentEncoding = sContentEncoding.toLowerCase()).equals("gzip")) {
                this.SetCompressionType(1);
            } else if (sContentEncoding.equals("deflate")) {
                this.SetCompressionType(2);
            }
        }
    }

    public InputStream GetInputStream() {
        if (this.GetConnection() != null) {
            try {
                this.m_InputStream = new BufferedInputStream(this.GetConnection().getInputStream());
                this.CheckCompressionMethod();
            }
            catch (Exception e) {
                if (DEBUG) {
                    e.printStackTrace();
                }
                this.m_InputStream = this.CloseInputStream(this.m_InputStream);
            }
        } else {
            this.m_InputStream = this.CloseInputStream(this.m_InputStream);
        }
        return this.m_InputStream;
    }

    public InputStream CloseInputStream(InputStream rStream) {
        if (rStream != null) {
            block3: {
                try {
                    rStream.close();
                }
                catch (IOException ioe) {
                    if (!DEBUG) break block3;
                    ioe.printStackTrace();
                }
            }
            rStream = null;
        }
        return rStream;
    }

    public OutputStream GetOutputStream() {
        if (this.GetConnection() != null) {
            if (this.m_OutputStream == null) {
                try {
                    this.m_OutputStream = new BufferedOutputStream(this.GetConnection().getOutputStream());
                }
                catch (IOException ioe) {
                    this.m_OutputStream = this.CloseOutputStream(this.m_OutputStream);
                }
            }
        } else {
            this.m_OutputStream = this.CloseOutputStream(this.m_OutputStream);
        }
        return this.m_OutputStream;
    }

    public OutputStream CloseOutputStream(OutputStream rStream) {
        if (rStream != null) {
            block3: {
                try {
                    rStream.close();
                }
                catch (IOException ioe) {
                    if (!DEBUG) break block3;
                    ioe.printStackTrace();
                }
            }
            rStream = null;
        }
        return rStream;
    }

    public void Disconnect() {
        this.m_InputStream = this.CloseInputStream(this.m_InputStream);
        this.m_OutputStream = this.CloseOutputStream(this.m_OutputStream);
        if (this.GetConnection() != null) {
            this.GetConnection().disconnect();
            this.SetConnection(null);
        }
    }

    public int GetResponseCode() {
        int nRespCode = 503;
        if (this.GetConnection() != null) {
            try {
                nRespCode = this.GetConnection().getResponseCode();
            }
            catch (IOException ioe) {
                nRespCode = 503;
            }
        }
        return nRespCode;
    }

    protected void PostEvent(int nEventID, Object rEventObj) throws NullPointerException {
        CRhinoEvent rEvent = new CRhinoEvent(this, nEventID, rEventObj);
        Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(rEvent);
    }

    public String GetHeaderValue(String sHTTPField) {
        String sValue = "";
        if (this.GetConnection() != null) {
            sValue = this.GetConnection().getHeaderField(sHTTPField);
        }
        return sValue;
    }

    protected String CreateBoundary() {
        return "--------------------" + Long.toString(System.currentTimeMillis(), 16);
    }

    protected String FmtStartBoundary(String sBoundary, String sContentDispName, String sFileName) {
        StringBuilder sStartBoundary = new StringBuilder();
        if (sBoundary != null) {
            sStartBoundary.append("--");
            sStartBoundary.append(sBoundary);
            sStartBoundary.append("\r\n");
            String sEncodedFileName = sFileName;
            try {
                sEncodedFileName = sEncodedFileName.replaceAll("&", "&#38;");
                sEncodedFileName = CHTTPConnection.HTMLEncode(sEncodedFileName);
                if (DEBUG_UPLOAD_BOUNDARY) {
                    System.out.println("---------- HTTP Upload Boundary ----------");
                    System.out.printf("    Filename:  %s\r\n", sFileName);
                    String sUTF82 = new String(sFileName.getBytes("UTF-8"));
                    System.out.printf("    getBytes using UTF-8:  %s\r\n", sUTF82);
                    String sUTF8 = URLEncoder.encode(sFileName, "UTF-8");
                    System.out.printf("    URLEncoder using UTF-8:  %s\r\n", sUTF8);
                    String sISO = URLEncoder.encode(sFileName, "ISO-8859-1");
                    System.out.printf("    URLEncoder using ISO-8859-1:  %s\r\n", sISO);
                    String sHTML = CHTTPConnection.HTMLEncode(sFileName);
                    System.out.printf("    HTMLEncoded:  %s\r\n", sHTML);
                }
            }
            catch (Exception e) {
                sEncodedFileName = sFileName;
            }
            sStartBoundary.append(String.format("Content-Disposition: form-data; name=\"%s\"; filename=\"%s\"\r\n", sContentDispName, sEncodedFileName));
            sStartBoundary.append("Content-Type; application/octet-stream\r\n");
            sStartBoundary.append("\r\n");
        }
        return sStartBoundary.toString();
    }

    public static String HTMLEncode(String sStr) {
        StringBuffer sbRet = new StringBuffer();
        for (int nIdx = 0; nIdx < sStr.length(); ++nIdx) {
            char ch = sStr.charAt(nIdx);
            if (ch > '\u007f' || ch == '\"' || ch == '<' || ch == '>') {
                sbRet.append("&#" + ch + ";");
                continue;
            }
            sbRet.append(ch);
        }
        return sbRet.toString();
    }

    protected String FmtEndBoundary(String sBoundary) {
        StringBuilder sEndBoundary = new StringBuilder();
        if (sBoundary != null) {
            sEndBoundary.append("\r\n");
            sEndBoundary.append("--");
            sEndBoundary.append(sBoundary);
            sEndBoundary.append("--");
            sEndBoundary.append("\r\n");
        }
        return sEndBoundary.toString();
    }

    protected int GetFileBoundaryLength(String sBoundary, String sContentDispName, String sFileName) {
        int nTotal = 0;
        String sStartBoundary = this.FmtStartBoundary(sBoundary, sContentDispName, sFileName);
        String sEndBoundary = this.FmtEndBoundary(sBoundary);
        if (sStartBoundary != null && sEndBoundary != null) {
            nTotal = sStartBoundary.getBytes().length + sEndBoundary.getBytes().length;
        }
        return nTotal;
    }

    public boolean UseCompression() {
        boolean bUseCompression = false;
        if (this.GetCompressionType() == 1 || this.GetCompressionType() == 2) {
            bUseCompression = true;
        }
        if (DEBUG_OVERRIDE_USE_COMPRESSION) {
            bUseCompression = false;
        }
        return bUseCompression;
    }

    static {
        if (DEBUG) {
            // empty if block
        }
        DEBUG_PRINT_URL = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_PRINT_REQUEST_HEADER = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_UPLOAD_BOUNDARY = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_PRINT_RESPONSE_HEADER = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_PRINT_RESPONSE_BODY = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_OVERRIDE_USE_COMPRESSION = false;
    }
}

