/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.base.parsers;

import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class CXMLParser
extends DefaultHandler {
    private static final boolean DEBUG = CMainFrame.DEBUG;
    private static final boolean DEBUG_TRACK_PARSER;
    public static final boolean DEBUG_TRACK_LISTENERS;
    public static final int XML_PARSING_UNKNOWN = -1;
    private SAXParserFactory m_XmlFactory = null;
    private SAXParser m_XmlSaxParser = null;
    protected DefaultHandler m_XmlParser = null;
    protected int m_nParsingTag = -1;

    public CXMLParser() {
        this.InitSAX();
    }

    private void InitSAX() {
        if (DEBUG) {
            if (this.CreateXmlFactory()) {
                this.CreateSaxParser();
            }
        } else {
            this.CreateXmlFactory();
            this.CreateSaxParser();
        }
    }

    private boolean CreateXmlFactory() {
        boolean bCreated = false;
        try {
            if (DEBUG_TRACK_PARSER) {
                System.out.println("Creating XML factory.");
            }
            this.m_XmlFactory = SAXParserFactory.newInstance();
            this.m_XmlFactory.setValidating(true);
            bCreated = true;
            if (DEBUG_TRACK_PARSER) {
                System.out.println("Created XML factory.");
            }
        }
        catch (Throwable t) {
            if (DEBUG) {
                System.out.println("Exception occurred when creating XML factory.");
            }
            t.printStackTrace();
        }
        return bCreated;
    }

    private boolean CreateSaxParser() {
        boolean bCreated = false;
        try {
            if (DEBUG_TRACK_PARSER) {
                System.out.println("Creating SAX parser.");
            }
            this.m_XmlSaxParser = this.m_XmlFactory.newSAXParser();
            bCreated = true;
            if (DEBUG_TRACK_PARSER) {
                System.out.println("Created SAX parser.");
            }
        }
        catch (Throwable t) {
            if (DEBUG) {
                System.out.println("Exception occurred when creating SAX parser.");
            }
            t.printStackTrace();
        }
        return bCreated;
    }

    public boolean Parse(InputStream jInputStream) {
        boolean bParsed;
        block14: {
            bParsed = false;
            if (jInputStream != null) {
                if (this.m_XmlSaxParser != null) {
                    try {
                        this.m_XmlSaxParser.parse(jInputStream, (DefaultHandler)this);
                        bParsed = true;
                    }
                    catch (EOFException eofe) {
                        if (DEBUG) {
                            eofe.printStackTrace();
                        }
                        break block14;
                    }
                    catch (SAXException se) {
                        if (DEBUG) {
                            se.printStackTrace();
                        }
                        break block14;
                    }
                    catch (IOException ioe) {
                        if (DEBUG) {
                            ioe.printStackTrace();
                        }
                        break block14;
                    }
                    catch (Exception e) {
                        if (DEBUG) {
                            e.printStackTrace();
                        }
                        break block14;
                    }
                }
                if (CMainFrame.GetDebugLogger() != null) {
                    CMainFrame.GetDebugLogger().Info("ASSERT:  Programming error, m_XmlSaxParser = null");
                }
            } else if (CMainFrame.GetDebugLogger() != null) {
                CMainFrame.GetDebugLogger().Info("ASSERT:  Programming error, InputStream = null");
            }
        }
        return bParsed;
    }

    protected String PrepareXmlTag(String sName, String sFQName) {
        String sXmlTag = sName;
        if (sXmlTag == null || sXmlTag.isEmpty()) {
            sXmlTag = sFQName;
        }
        return sXmlTag;
    }

    @Override
    public void startDocument() throws SAXException {
        if (DEBUG_TRACK_LISTENERS) {
            System.out.println("startDocument -->");
        }
        this.m_nParsingTag = -1;
    }

    @Override
    public void endDocument() throws SAXException {
        if (DEBUG_TRACK_LISTENERS) {
            System.out.println("endDocument <--");
        }
    }

    @Override
    public void startElement(String sNamespaceURI, String sName, String sFQName, Attributes jAttrs) throws SAXException {
        if (DEBUG_TRACK_LISTENERS) {
            System.out.println("startElement -->");
            System.out.printf("start...Name: %s | FQName: %s\r\n", sName, sFQName);
        }
        String sXMLTag = this.PrepareXmlTag(sName, sFQName);
        this.m_nParsingTag = -1;
    }

    @Override
    public void endElement(String sNamespaceURI, String sName, String sFQName) throws SAXException {
        String sXMLTag = this.PrepareXmlTag(sName, sFQName);
        this.m_nParsingTag = -1;
        if (DEBUG_TRACK_LISTENERS) {
            System.out.printf("end...Name: %s | FQName: %s\r\n", sName, sFQName);
            System.out.println("endElement <--");
        }
    }

    @Override
    public void characters(char[] szBuf, int nOffset, int nLen) throws SAXException {
        if (DEBUG_TRACK_LISTENERS) {
            System.out.println("characters -->");
            System.out.println("characters <--");
        }
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        if (CMainFrame.DEBUG) {
            System.out.println("Warning: ");
            this.printInfo(e);
        }
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        if (CMainFrame.DEBUG) {
            System.out.println("Error: ");
            this.printInfo(e);
        }
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        if (CMainFrame.DEBUG) {
            System.out.println("Fatal error: ");
            this.printInfo(e);
        }
    }

    private void printInfo(SAXParseException spe) {
        System.out.println("   Public ID: " + spe.getPublicId());
        System.out.println("   System ID: " + spe.getSystemId());
        System.out.println("   Line number: " + spe.getLineNumber());
        System.out.println("   Column number: " + spe.getColumnNumber());
        System.out.println("   Message: " + spe.getMessage());
    }

    static {
        if (DEBUG) {
            // empty if block
        }
        DEBUG_TRACK_PARSER = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_TRACK_LISTENERS = false;
    }
}

