/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.base.threads;

import com.rhinosoft.base.gui.events.CBaseEventQueue;
import com.rhinosoft.base.gui.events.CRhinoEvent;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import java.awt.Component;

public class CRhinoThread
extends Thread {
    public static final boolean DEBUG = CMainFrame.DEBUG;
    public static final boolean DEBUG_LOG_METHODS = CMainFrame.DEBUG_LOG_METHODS;
    public static final boolean DEBUG_LOG_THREAD_LIFE = CMainFrame.DEBUG_LOG_THREAD_LIFE;
    public static final boolean DEBUG_TRACE_WAITS;
    private static final String RHINO_THREAD_NAME = "CRhinoThread";
    private volatile boolean m_bCancelShouldQuit;
    private volatile boolean m_bShouldQuit;
    private Component m_rcEventSource;

    private CRhinoThread(Component rcEventSource) {
        this.InitVars(rcEventSource, RHINO_THREAD_NAME);
    }

    public CRhinoThread(Component rcEventSource, String sThreadName) {
        this.InitVars(rcEventSource, sThreadName);
    }

    private void InitVars(Component rcEventSource, String sThreadName) {
        this.setName(sThreadName);
        this.m_bShouldQuit = false;
        this.m_rcEventSource = rcEventSource;
    }

    @Override
    public void start() {
        if (DEBUG_LOG_METHODS && CMainFrame.GetDebugLogger() != null) {
            CMainFrame.GetDebugLogger().Entering(CRhinoThread.class.getName(), "start");
        }
        if (DEBUG_LOG_THREAD_LIFE && CMainFrame.GetDebugLogger() != null) {
            CMainFrame.GetDebugLogger().Fine(String.format("%40s %s-%d is ALIVE", "<<< DEBUG_LOG_THREAD_LIFE >>>", this.getName(), this.getId()));
        }
        super.start();
        if (DEBUG_LOG_METHODS && CMainFrame.GetDebugLogger() != null) {
            CMainFrame.GetDebugLogger().Exiting(CRhinoThread.class.getName(), "start");
        }
    }

    protected void CancelCurrentOperation() {
    }

    public void Cancel() {
        if (DEBUG_LOG_METHODS && CMainFrame.GetDebugLogger() != null) {
            CMainFrame.GetDebugLogger().Entering(CRhinoThread.class.getName(), "Cancel");
        }
        if (this.m_bCancelShouldQuit) {
            this.SetShouldQuit(true);
        }
        this.CancelCurrentOperation();
        if (DEBUG_LOG_METHODS && CMainFrame.GetDebugLogger() != null) {
            CMainFrame.GetDebugLogger().Entering(CRhinoThread.class.getName(), "Cancel");
        }
    }

    public boolean GetShouldQuit() {
        if (DEBUG_LOG_METHODS && CMainFrame.GetDebugLogger() != null) {
            CMainFrame.GetDebugLogger().Entering(CRhinoThread.class.getName(), "GetShouldQuit");
            CMainFrame.GetDebugLogger().Entering(CRhinoThread.class.getName(), "GetShouldQuit");
        }
        return this.m_bShouldQuit;
    }

    protected void SetShouldQuit(boolean bShouldQuit) {
        if (DEBUG_LOG_METHODS && CMainFrame.GetDebugLogger() != null) {
            CMainFrame.GetDebugLogger().Entering(CRhinoThread.class.getName(), "SetShouldQuit", bShouldQuit);
        }
        this.m_bShouldQuit = bShouldQuit;
        if (DEBUG_LOG_METHODS && CMainFrame.GetDebugLogger() != null) {
            CMainFrame.GetDebugLogger().Exiting(CRhinoThread.class.getName(), "SetShouldQuit", this.m_bShouldQuit);
        }
    }

    public void Quit(boolean bResume) {
        if (DEBUG_LOG_METHODS && CMainFrame.GetDebugLogger() != null) {
            CMainFrame.GetDebugLogger().Entering(CRhinoThread.class.getName(), "Quit", bResume);
        }
        this.SetShouldQuit(true);
        this.CancelCurrentOperation();
        if (DEBUG_LOG_METHODS && CMainFrame.GetDebugLogger() != null) {
            CMainFrame.GetDebugLogger().Exiting(CRhinoThread.class.getName(), "Quit");
        }
    }

    public boolean GetCancelShouldQuit() {
        if (DEBUG_LOG_METHODS && CMainFrame.GetDebugLogger() != null) {
            CMainFrame.GetDebugLogger().Entering(CRhinoThread.class.getName(), "GetCancelShouldQuit");
            CMainFrame.GetDebugLogger().Exiting(CRhinoThread.class.getName(), "GetCancelShouldQuit");
        }
        return this.m_bCancelShouldQuit;
    }

    public void SetCancelShouldQuit(boolean bCancelShouldQuit) {
        if (DEBUG_LOG_METHODS && CMainFrame.GetDebugLogger() != null) {
            CMainFrame.GetDebugLogger().Entering(CRhinoThread.class.getName(), "SetCancelShouldQuit", bCancelShouldQuit);
        }
        this.m_bCancelShouldQuit = bCancelShouldQuit;
        if (DEBUG_LOG_METHODS && CMainFrame.GetDebugLogger() != null) {
            CMainFrame.GetDebugLogger().Exiting(CRhinoThread.class.getName(), "SetCancelShouldQuit");
        }
    }

    protected Component GetEventSource() {
        return this.m_rcEventSource;
    }

    protected void PostEvent(int nEventID) {
        this.PostEvent(nEventID, null);
    }

    protected void PostEvent(int nEventID, Object rEventObj) {
        Component rcTarget = this.GetEventSource();
        if (rcTarget != null) {
            CRhinoEvent rEvent = new CRhinoEvent(rcTarget, nEventID, rEventObj);
            CBaseEventQueue.PostEvent(rEvent);
        } else if (CMainFrame.GetDebugLogger() != null) {
            CMainFrame.GetDebugLogger().Info("ASSERT:  Programming error, GetEventSource() = null");
        }
    }

    @Override
    public String toString() {
        return String.format("%s - %d", this.getName(), this.getId());
    }

    static {
        if (DEBUG) {
            // empty if block
        }
        DEBUG_TRACE_WAITS = false;
    }
}

