/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.base.threads;

import com.rhinosoft.base.threads.CAsynchQueue;
import com.rhinosoft.base.threads.CRhinoThread;
import com.rhinosoft.base.threads.CWorkerThreadID;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import java.awt.Component;

public class CWorkerThread
extends CRhinoThread {
    public static final boolean DEBUG_SINGLE_THREADED = false;
    protected CAsynchQueue m_AsynchQueue = new CAsynchQueue(this);
    protected CWorkerThreadID m_rCurrentMsg;
    private boolean m_bCancel = false;

    public CWorkerThread(Component rcEventSource, String sThreadName) {
        super(rcEventSource, sThreadName);
    }

    public void finalize() throws Throwable {
        this.m_AsynchQueue = null;
        super.finalize();
    }

    public void InitInstance() {
        if (CMainFrame.DEBUG_LOG_THREAD_LIFE) {
            String sTrack = String.format("%40s %s-%d is alive.", "<<< DEBUG_LOG_THREAD_LIFE >>>", this.getName(), this.getId());
            System.out.println(sTrack);
        }
    }

    @Override
    public void run() {
        if (DEBUG_LOG_METHODS && CMainFrame.GetDebugLogger() != null) {
            CMainFrame.GetDebugLogger().Entering(CRhinoThread.class.getName(), "run");
        }
        this.InitInstance();
        this.PostEvent(2900, this.getId());
        while (true) {
            this.SetCurrentMsg(null);
            if (this.GetShouldQuit()) {
                this.SetCurrentMsg(null);
                break;
            }
            this.PostEvent(2901, this.getId());
            CWorkerThreadID rMsg = null;
            try {
                rMsg = (CWorkerThreadID)this.m_AsynchQueue.GetHead();
            }
            catch (InterruptedException ie) {
                if (CMainFrame.GetDebugLogger() != null) {
                    CMainFrame.GetDebugLogger().Warning(String.format("Thread-%d has been interrupted.", this.getId()));
                }
                this.SetCurrentMsg(null);
                break;
            }
            this.SetCurrentMsg(rMsg);
            this.PostEvent(2902, this.getId());
            if (rMsg == null) continue;
            if (rMsg.GetMsgID() == 0) {
                this.SetCurrentMsg(null);
                break;
            }
            this.OnMessage(rMsg);
        }
        if (CMainFrame.DEBUG_LOG_THREAD_LIFE) {
            String sTrack = String.format("%40s %s-%d is dead.", "<<< DEBUG_LOG_THREAD_LIFE >>>", this.getName(), this.getId());
            System.out.println(sTrack);
        }
        this.PostEvent(2903, this.getId());
        if (DEBUG_LOG_METHODS && CMainFrame.GetDebugLogger() != null) {
            CMainFrame.GetDebugLogger().Exiting(CRhinoThread.class.getName(), "run");
        }
    }

    protected void OnMessage(CWorkerThreadID rMsg) {
        if (rMsg != null) {
            rMsg.ProcessEvent();
        } else if (CMainFrame.GetDebugLogger() != null) {
            CMainFrame.GetDebugLogger().Info("ASSERT:  Programming error, rCmd = null");
        }
    }

    public void PostMessage(CWorkerThreadID rMsg) {
        if (DEBUG_LOG_METHODS && CMainFrame.GetDebugLogger() != null) {
            CMainFrame.GetDebugLogger().Entering(CWorkerThread.class.getName(), "PostMessage", rMsg);
        }
        if (rMsg != null) {
            int nMsgID = rMsg.GetMsgID();
            if (nMsgID == 0) {
                this.m_AsynchQueue.AddHead(rMsg);
            } else {
                this.m_AsynchQueue.AddItem(rMsg);
            }
        } else if (CMainFrame.GetDebugLogger() != null) {
            CMainFrame.GetDebugLogger().Info("ASSERT:  Programming error, rCmd = null");
        }
        if (DEBUG_LOG_METHODS && CMainFrame.GetDebugLogger() != null) {
            CMainFrame.GetDebugLogger().Exiting(CWorkerThread.class.getName(), "PostMessage");
        }
    }

    @Override
    public void Quit(boolean bResume) {
        if (DEBUG_LOG_METHODS && CMainFrame.GetDebugLogger() != null) {
            CMainFrame.GetDebugLogger().Entering(CWorkerThread.class.getName(), "Quit", bResume);
        }
        this.PostMessage(new CWorkerThreadID(this, 0, this.GetEventSource()));
        super.Quit(bResume);
        if (DEBUG_LOG_METHODS && CMainFrame.GetDebugLogger() != null) {
            CMainFrame.GetDebugLogger().Exiting(CWorkerThread.class.getName(), "Quit");
        }
    }

    @Override
    protected void CancelCurrentOperation() {
        this.SetCancel(true);
        if (this.GetCurrentMsg() != null) {
            this.GetCurrentMsg().SetCancel(true);
        }
    }

    protected CWorkerThreadID GetCurrentMsg() {
        return this.m_rCurrentMsg;
    }

    private void SetCurrentMsg(CWorkerThreadID rCurrentMsg) {
        this.m_rCurrentMsg = rCurrentMsg;
    }

    public void CancelAllJobs() {
        this.m_AsynchQueue.Clear();
        this.CancelCurrentOperation();
    }

    public boolean IsProcessingJob() {
        return this.GetCurrentMsg() != null;
    }

    protected synchronized boolean SetCancel(boolean bCancel) {
        boolean bChanged = false;
        if (this.m_bCancel != bCancel) {
            bChanged = true;
            this.m_bCancel = bCancel;
        }
        return bChanged;
    }

    public synchronized boolean GetCancel() {
        return this.m_bCancel;
    }
}

