/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.cipher;

import com.sun.crypto.provider.SunJCE;
import java.security.Key;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;

public class CCipher {
    public static boolean DEBUG = false;
    private String m_sAlgorithm;
    private Key m_Key;
    private Cipher m_Cipher;

    public CCipher(boolean bIsDebug) {
        DEBUG = bIsDebug;
    }

    protected void SetKey(Key rKey) {
        this.m_Key = rKey;
    }

    protected Key GetKey() {
        return this.m_Key;
    }

    protected void SetAlgorithm(String sAlgorithm) {
        this.m_sAlgorithm = sAlgorithm;
        this.m_Cipher = this.CreateCipher(this.GetAlgorithm());
    }

    public String GetAlgorithm() {
        return this.m_sAlgorithm;
    }

    private Cipher CreateCipher(String sAlgorithm) {
        Cipher cipher;
        block3: {
            cipher = null;
            if (sAlgorithm != null && !sAlgorithm.isEmpty()) {
                try {
                    cipher = Cipher.getInstance(sAlgorithm);
                }
                catch (Exception e) {
                    if (!DEBUG) break block3;
                    e.printStackTrace();
                }
            }
        }
        return cipher;
    }

    private Cipher GetCipher() {
        return this.m_Cipher;
    }

    private boolean HasProvider(Class cProvider) {
        boolean bHasProvider = false;
        if (cProvider != null) {
            String sInstallProviderClassName = cProvider.getName();
            Provider[] aProviders = Security.getProviders();
            for (int nIdx = 0; nIdx < aProviders.length && !bHasProvider; ++nIdx) {
                String sProviderClassName;
                Provider rProvider = aProviders[nIdx];
                if (rProvider == null || (sProviderClassName = rProvider.getClass().getName()) == null || sProviderClassName.equals(sInstallProviderClassName)) continue;
                bHasProvider = true;
            }
        }
        return bHasProvider;
    }

    protected boolean CheckProvider(Class cProvider) {
        String sProviderClassName;
        boolean bDynamicallyInstalled = false;
        if (!this.HasProvider(cProvider) && (sProviderClassName = cProvider.getName()) != null && !sProviderClassName.isEmpty() && sProviderClassName.equals(SunJCE.class.getName())) {
            Security.addProvider(new SunJCE());
            bDynamicallyInstalled = true;
        }
        return bDynamicallyInstalled;
    }

    public byte[] Encrypt(byte[] aData) {
        byte[] aRet;
        block3: {
            aRet = null;
            if (aData != null && aData.length > 0 && this.GetCipher() != null && this.GetKey() != null) {
                aData = this.AddPadding(aData);
                try {
                    this.GetCipher().init(1, this.GetKey());
                    aRet = this.GetCipher().doFinal(aData);
                }
                catch (Exception e) {
                    if (!DEBUG) break block3;
                    e.printStackTrace();
                }
            }
        }
        return aRet;
    }

    public byte[] Decrypt(byte[] aData) {
        byte[] aRet = null;
        if (aData != null && aData.length > 0 && this.GetCipher() != null && this.GetKey() != null) {
            block3: {
                try {
                    this.GetCipher().init(2, this.GetKey());
                    aRet = this.GetCipher().doFinal(aData);
                }
                catch (Exception e) {
                    if (!DEBUG) break block3;
                    e.printStackTrace();
                }
            }
            aRet = this.RemovePadding(aRet);
        }
        return aRet;
    }

    protected byte[] AddPadding(byte[] aData) {
        return aData;
    }

    protected byte[] RemovePadding(byte[] aData) {
        return aData;
    }
}

