/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.docking.fvjv.fileTree;

import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.DockingManager;
import com.rhinosoft.FilePanel.CFileCellEditor;
import com.rhinosoft.FilePanel.CFilePanel;
import com.rhinosoft.FilePanel.CTypeAhead;
import com.rhinosoft.base.files.CFile;
import com.rhinosoft.base.files.CFileSystemUtils;
import com.rhinosoft.base.files.CPath;
import com.rhinosoft.base.gui.components.files.tree.CFileTreeModel;
import com.rhinosoft.base.gui.components.files.tree.CFileTreeNode;
import com.rhinosoft.base.gui.components.files.tree.CFileTreeNodeRenderer;
import com.rhinosoft.base.gui.components.files.tree.CSearchTreeNode;
import com.rhinosoft.base.gui.events.CBaseAction;
import com.rhinosoft.base.gui.events.CRhinoEvent;
import com.rhinosoft.docking.fvjv.fileTree.CFileTreeEvent;
import com.rhinosoft.docking.fvjv.fileTree.IFileTreeListener;
import com.rhinosoft.fvjv.gui.crumbbar.CCrumbButton;
import com.rhinosoft.fvjv.gui.dialogs.CRenameDlg;
import com.rhinosoft.fvjv.gui.events.CFVJVAction;
import com.rhinosoft.fvjv.gui.events.CTransferMenuItem;
import com.rhinosoft.fvjv.gui.events.dragdrop.CDragDropHandler;
import com.rhinosoft.fvjv.gui.events.dragdrop.ICompleteDragDrop;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.gui.frames.IArchive;
import com.rhinosoft.fvjv.gui.frames.browser.CSearchStateEvent;
import com.rhinosoft.fvjv.gui.frames.browser.ISearchStateListener;
import com.rhinosoft.fvjv.strings.CString;
import com.rhinosoft.fvjv.threads.CBaseThread;
import com.rhinosoft.fvjv.threads.CThreadMsg;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class CFileTree
extends JScrollPane
implements MouseListener,
ActionListener,
KeyListener,
TreeWillExpandListener,
TreeSelectionListener,
ChangeListener,
MouseMotionListener,
FocusListener,
ICompleteDragDrop {
    protected static boolean DEBUG = CMainFrame.DEBUG;
    protected static boolean DEBUG_TRACK_DND_DRAG_EVENTS;
    protected static boolean DEBUG_TRACK_DND_DROP_EVENTS;
    protected static boolean DEBUG_CHANGE_TIMER;
    protected static boolean DEBUG_KEY_EVENTS;
    protected static boolean DEBUG_TREE_SEL_EVENT;
    protected static boolean DEBUG_TREE_VALUE_TO_TEXT;
    protected static boolean DEBUG_TREE_TYPE_AHEAD;
    protected static boolean DEBUG_RENAME_EDITOR;
    private static final int CHANGE_TIMER_ARROWS = 500;
    public static final int CHANGE_TIMER_TYPE_AHEAD = 2000;
    public static final int ON_RENAME_CLICK_TIMER = 500;
    private boolean m_bPreventSelectionListing = false;
    private JTree m_cTree;
    private CFileTreeModel m_cModel;
    private CFileTreeNodeRenderer m_cCellRenderer;
    private CFileCellEditor m_cEditor;
    private CBaseThread m_tGeneralThread;
    private long m_nDateLastSearch;
    private String m_sSearchStr;
    private TreeNode m_rResumeListingsNode;
    private JPopupMenu m_cPopupMenu;
    private JMenuItem m_cDownloadPopupMenuItem;
    private JMenu m_cDownloadToPopupMenu;
    private JMenuItem m_cUploadPopupMenuItem;
    private JMenu m_cUploadToPopupMenu;
    private DockingManager m_rDockingManager;
    private String m_sFrameKey;
    private CDragDropHandler m_DragDropHandler;
    private MouseEvent m_FirstMouseEvent;
    private boolean m_bSkipInitialScroll;
    private TreePath m_cDragExpandTreePath;
    private Timer m_DragExpandTimer;
    private Timer m_ChangeTimer;
    private boolean m_bCanRenameOnClick = true;
    private Timer m_RenameTimer;
    private boolean m_bIsDragOver = false;
    private CTypeAhead m_TypeAhead;
    private boolean m_bIsTypeAhead = false;
    private boolean m_bExpandOnTypeAhead = true;
    private Vector<ISearchStateListener> m_aSearchStateListeners;
    private CFile m_rWorkingDirBeroreSearch;
    private boolean m_bIsSearch = false;
    private Vector<IFileTreeListener> m_aFileTreeListeners;

    public CFileTree() {
        this.InitVars(null);
    }

    private void InitVars(CFileTreeModel cModel) {
        this.m_aFileTreeListeners = new Vector();
        this.m_aSearchStateListeners = new Vector();
        this.m_nDateLastSearch = 0L;
        this.m_DragDropHandler = new CDragDropHandler();
        this.m_cTree = new JTree(){

            @Override
            public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                CFileTreeNode rNode;
                String sText = super.convertValueToText(value, selected, expanded, leaf, row, hasFocus);
                if (value instanceof CFileTreeNode && (rNode = (CFileTreeNode)value).GetFile() != null) {
                    sText = rNode.GetFile().GetDisplayName();
                }
                if (DEBUG_TREE_VALUE_TO_TEXT) {
                    System.out.println("JTree.convertValueToText | " + sText);
                }
                return sText;
            }
        };
        this.m_cModel = cModel != null ? cModel : new CFileTreeModel();
        if (this.GetTree() != null) {
            this.setViewportView(this.GetTree());
            this.getViewport().addChangeListener(this);
            this.GetTree().setModel(this.GetModel());
            this.m_cCellRenderer = new CFileTreeNodeRenderer();
            this.GetTree().setCellRenderer(this.GetCellRenderer());
            this.GetTree().addTreeWillExpandListener(this);
            this.GetTree().addTreeSelectionListener(this);
            this.GetTree().setShowsRootHandles(true);
            this.GetTree().setLargeModel(true);
            this.GetTree().addMouseListener(this);
            this.GetTree().addKeyListener(this);
            this.GetTree().addFocusListener(this);
            this.GetTree().setEditable(false);
            if (this.m_DragDropHandler != null) {
                this.GetTree().addMouseMotionListener(this);
                this.GetTree().setDragEnabled(true);
                this.GetTree().setDropMode(DropMode.USE_SELECTION);
            }
        }
        this.m_rResumeListingsNode = null;
        this.InitPopupMenu();
        this.m_DragExpandTimer = new Timer(1200, this);
        this.m_ChangeTimer = new Timer(1000, this);
        this.addFocusListener(this);
        this.m_RenameTimer = new Timer(500, this);
        this.m_TypeAhead = new CTypeAhead(this);
        this.m_bIsSearch = false;
    }

    public JTree GetTree() {
        return this.m_cTree;
    }

    protected CFileTreeModel GetModel() {
        return this.m_cModel;
    }

    protected TreeSelectionModel GetSelModel() {
        TreeSelectionModel rSelModel = null;
        if (this.GetTree() != null) {
            rSelModel = this.GetTree().getSelectionModel();
        }
        return rSelModel;
    }

    protected CFileTreeNodeRenderer GetCellRenderer() {
        return this.m_cCellRenderer;
    }

    public void SetRoot(CFile fRoot) {
        if (this.GetModel() != null) {
            this.GetModel().SetRootNode(fRoot);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void processEvent(AWTEvent event) {
        if (event instanceof CRhinoEvent) {
            CRhinoEvent rEvent = (CRhinoEvent)event;
            switch (event.getID()) {
                case 6000: {
                    if (!(event instanceof CRhinoEvent)) return;
                    CRhinoEvent rGUIEvent = (CRhinoEvent)event;
                    if (!(rGUIEvent.GetEventObj() instanceof CFile)) return;
                    CFile fFile = (CFile)rGUIEvent.GetEventObj();
                    this.SetRootNode(fFile);
                    return;
                }
                case 6001: {
                    Object[] aItems = (Object[])rEvent.GetEventObj();
                    if (aItems == null) return;
                    CFile fChild = (CFile)aItems[0];
                    boolean bUpdateUI = true;
                    Boolean bVal = (Boolean)aItems[1];
                    if (bVal != null) {
                        bUpdateUI = bVal;
                    }
                    CFile fParent = (CFile)rEvent.getSource();
                    if (fChild == null) return;
                    if (this.GetModel() == null) return;
                    if (!this.GetModel().IsSameFileSystem(fChild)) return;
                    this.GetModel().AddChildNode(fParent, fChild);
                    return;
                }
                case 6005: {
                    Object[] aItems = (Object[])rEvent.GetEventObj();
                    if (aItems == null) return;
                    CFile fChild = (CFile)aItems[0];
                    boolean bUpdateUI = true;
                    Boolean bVal = (Boolean)aItems[1];
                    if (bVal != null) {
                        bUpdateUI = bVal;
                    }
                    CFile fParent = (CFile)rEvent.getSource();
                    if (fChild == null) return;
                    if (this.GetModel() == null) return;
                    if (!this.GetModel().IsSameFileSystem(fChild)) return;
                    this.GetModel().UpdateChildNode(fParent, fChild);
                    return;
                }
                case 6003: {
                    CFile fSelFile;
                    CFile fParent = (CFile)rEvent.getSource();
                    CFile fChild = (CFile)rEvent.GetEventObj();
                    if (fChild == null) return;
                    if (this.GetModel() == null) return;
                    if (!this.GetModel().IsSameFileSystem(fChild)) return;
                    if (this.GetTree() != null && (fSelFile = this.GetSelectedFile()) != null) {
                        CFileTreeNode rParent;
                        CFileTreeNode rNode;
                        String sSelPath = fSelFile.GetPath();
                        String sDelPath = fChild.GetPath();
                        if (sSelPath != null && !sSelPath.isEmpty() && sDelPath != null && !sDelPath.isEmpty() && sSelPath.equals(sDelPath) && (rNode = this.GetModel().FindNode(fSelFile)) != null && (rParent = rNode.GetParent()) != null) {
                            this.GetTree().setSelectionPath(rParent.GetTreePath());
                        }
                    }
                    this.GetModel().RemoveChildNode(fParent, fChild);
                    return;
                }
                case 6006: {
                    CFile fParent = (CFile)rEvent.getSource();
                    CFile fChild = (CFile)rEvent.GetEventObj();
                    if (fChild == null) return;
                    if (this.GetModel() == null) return;
                    if (!this.GetModel().IsSameFileSystem(fChild)) return;
                    this.GetModel().RenameChildNode(fParent, fChild);
                    return;
                }
                case 6007: {
                    CFile fParent = (CFile)rEvent.getSource();
                    CFile fChild = (CFile)rEvent.GetEventObj();
                    if (fChild == null) return;
                    if (this.GetModel() == null) return;
                    if (!this.GetModel().IsSameFileSystem(fChild)) return;
                    return;
                }
                case 6008: {
                    Component rFocusOwner;
                    Object[] arObjs = (Object[])rEvent.GetEventObj();
                    if (!this.IsEventSource(arObjs[1])) return;
                    if (arObjs[0] instanceof CFile) {
                        CFile fWorkingDir = (CFile)arObjs[0];
                        boolean bExpandTreeNode = false;
                        Boolean bFlag = (Boolean)arObjs[2];
                        if (bFlag != null) {
                            bExpandTreeNode = bFlag;
                        }
                        this.SelectNode(fWorkingDir, bExpandTreeNode);
                    }
                    if ((rFocusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner()) == null) return;
                    if (!this.IsEventSource(rFocusOwner)) return;
                    this.UpdateBtnStates();
                    this.UpdateBtnSelections();
                    return;
                }
                case 9021: {
                    this.UpdateBtnStates();
                    return;
                }
                case 9023: {
                    this.UpdateBtnSelections();
                    return;
                }
                case 2005: {
                    this.OnDelete();
                    return;
                }
                case 2004: {
                    this.OnOpen();
                    return;
                }
                case 2008: 
                case 2009: {
                    Object obj = rEvent.GetEventObj();
                    if (!(obj instanceof CPath)) return;
                    CPath rTransferTo = (CPath)obj;
                    this.OnTransferFilesTo(rTransferTo);
                    return;
                }
                case 2006: {
                    this.OnRename(this.GetSelectedFile());
                    return;
                }
                case 2115: {
                    this.OnRefresh();
                    return;
                }
                case 2003: {
                    this.OnNewFolder();
                    return;
                }
                case 2007: {
                    this.OnProperties();
                    return;
                }
                case 9111: {
                    if (event.getSource() != this) return;
                    Object[] anItems = (Object[])rEvent.GetEventObj();
                    CFile fCreatedDir = (CFile)anItems[0];
                    if (fCreatedDir == null) return;
                    if (this.GetModel() == null) return;
                    if (this.GetTree() == null) return;
                    fCreatedDir.GetListing(this.GetThread(), this, true, false, true, true, null);
                    return;
                }
                case 9146: {
                    if (this.m_DragDropHandler != null) {
                        this.m_DragDropHandler.InitVars();
                    }
                    this.SetIsDragOver(false);
                    this.putClientProperty("DndRightClick", null);
                    if (this.GetTree() == null) return;
                    this.GetTree().putClientProperty("DndRightClick", null);
                    return;
                }
                case 3005: 
                case 3020: 
                case 3021: {
                    if (!(event.getSource() instanceof CCrumbButton)) return;
                    if (!(rEvent.GetEventObj() instanceof CThreadMsg)) return;
                    CThreadMsg rThreadMsg = (CThreadMsg)rEvent.GetEventObj();
                    switch (rThreadMsg.GetMsgID()) {
                        case 5: {
                            CFile fWorkingDir = this.GetCurWorkingDir();
                            Container rSource = this.getParent();
                            if (fWorkingDir == null) return;
                            if (rSource == null) return;
                            if (CMainFrame.GET_APP() == null) return;
                            this.SelectNode(fWorkingDir, true);
                            return;
                        }
                    }
                    return;
                }
                default: {
                    super.processEvent(event);
                    return;
                }
            }
        }
        super.processEvent(event);
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
        Object rExpandedNode;
        TreePath rTreePath = event.getPath();
        if (rTreePath != null && (rExpandedNode = rTreePath.getLastPathComponent()) != null && rExpandedNode instanceof CFileTreeNode) {
            CFile fExpanded;
            CFileTreeNode rFileNode = (CFileTreeNode)rExpandedNode;
            if (this.GetResumeListingsNode() == rExpandedNode) {
                this.SetResumeListingsNode(null);
            }
            if ((fExpanded = rFileNode.GetFile()) != null && this.GetResumeListingsNode() == null) {
                fExpanded.GetListing(this.GetThread(), this, false, false, true, false, null);
            }
        }
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
    }

    private CBaseThread GetThread() {
        return this.m_tGeneralThread;
    }

    public void SetThread(CBaseThread tThread) {
        this.m_tGeneralThread = tThread;
        this.m_cEditor = new CFileCellEditor(this, this.GetThread());
    }

    protected TreeNode GetResumeListingsNode() {
        return this.m_rResumeListingsNode;
    }

    protected void SetResumeListingsNode(TreeNode rNode) {
        this.m_rResumeListingsNode = rNode;
    }

    @Override
    public void valueChanged(TreeSelectionEvent event) {
        if (DEBUG_TREE_SEL_EVENT) {
            TreePath[] aTreePaths = new TreePath[]{event.getOldLeadSelectionPath(), event.getNewLeadSelectionPath()};
            for (int nIdx = 0; nIdx < aTreePaths.length; ++nIdx) {
                CFile fFile;
                CFileTreeNode rNode;
                TreePath rTreePath = aTreePaths[nIdx];
                if (rTreePath == null || (rNode = (CFileTreeNode)rTreePath.getLastPathComponent()) == null || (fFile = rNode.GetFile()) == null) continue;
                System.out.printf("%s Path: %s | isAddedPath: %s\r\n", nIdx == 0 ? "Old" : "New", fFile.GetDisplayName(), Boolean.toString(event.isAddedPath(rTreePath)));
            }
        }
        if (!this.IsTypeAhead()) {
            if (this.m_bIsDragOver) {
                TreePath rTreePath = event.getNewLeadSelectionPath();
                this.StartDragExpandTimer(rTreePath);
            } else {
                Object rPrevSelNode;
                TreePath rPrevSelTreePath = event.getOldLeadSelectionPath();
                if (rPrevSelTreePath != null && (rPrevSelNode = rPrevSelTreePath.getLastPathComponent()) != null && rPrevSelNode instanceof CSearchTreeNode) {
                    CSearchTreeNode rSearchNode = (CSearchTreeNode)rPrevSelNode;
                    this.SetSearchState(CSearchStateEvent.SEARCH_STATE.OFF);
                }
                this.m_bCanRenameOnClick = false;
                if (!this.IsChangeTimerRunning()) {
                    CFileTreeNode rFileNode;
                    CFile fSelected;
                    Object rSelNode;
                    TreePath rTreePath;
                    this.SetRenameMarker(System.currentTimeMillis());
                    if (!this.m_bPreventSelectionListing && (rTreePath = event.getNewLeadSelectionPath()) != null && (rSelNode = rTreePath.getLastPathComponent()) != null && rSelNode instanceof CFileTreeNode && (fSelected = (rFileNode = (CFileTreeNode)rSelNode).GetFile()) != null) {
                        if (this.GetResumeListingsNode() == rFileNode) {
                            this.SetResumeListingsNode(null);
                        }
                        fSelected.GetListing(this.GetThread(), this, false, true, !fSelected.HasListing(), false, null);
                        this.FireOnFileSelected(fSelected);
                    }
                }
            }
        } else {
            if (DEBUG_TREE_TYPE_AHEAD) {
                System.out.println("Start Change Timer");
            }
            this.SetExpandOnTypeAhead(false);
            this.StartChangeTimer(2000);
        }
    }

    public boolean IsEventSource(Object objSource) {
        boolean bIsEventSource = false;
        if (objSource == this || objSource == this.GetTree()) {
            bIsEventSource = true;
        }
        return bIsEventSource;
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    protected void OnLeftDoubleClick(MouseEvent event) {
    }

    protected void OnLeftSingleClick(MouseEvent event) {
        Rectangle rCellBounds;
        TreePath rMouseTreePath;
        Point ptLoc;
        if (!event.isControlDown() && !event.isShiftDown() && CMainFrame.GET_APP() != null && this.GetEditor() != null && this.GetEditor().GetMarker() + 1000L < System.currentTimeMillis() && (ptLoc = event.getPoint()) != null && (rMouseTreePath = this.GetTree().getClosestPathForLocation(ptLoc.x, ptLoc.y)) != null && rMouseTreePath.equals(this.GetTree().getSelectionPath()) && (rCellBounds = this.GetTree().getPathBounds(rMouseTreePath)).contains(ptLoc)) {
            this.StartRenameTimer();
        }
    }

    protected void OnRightSingleClick(MouseEvent event) {
        if (event != null) {
            Point pt = event.getPoint();
            if (this.GetTree() != null) {
                TreePath rMouseOverTreePath = this.GetTree().getPathForLocation(pt.x, pt.y);
                if (rMouseOverTreePath != null) {
                    this.GetTree().setSelectionPath(rMouseOverTreePath);
                }
                pt = SwingUtilities.convertPoint(this.GetTree(), pt, this);
                if (this.GetPopupMenu() != null) {
                    this.GetPopupMenu().show(this, pt.x, pt.y);
                }
                Container cParent = this.getParent();
                if (this.GetDockingManager() != null) {
                    this.GetDockingManager().activateFrame(this.GetFrameKey());
                }
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
    }

    @Override
    public void mouseReleased(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    private JMenuItem CreateJMenuItem(int nEventID) {
        JMenuItem rMenuItem = null;
        if (CMainFrame.GET_APP() != null) {
            CFVJVAction rAction = CMainFrame.GET_APP().GetAction(nEventID);
            CFVJVAction rNewAction = new CFVJVAction(rAction);
            rNewAction.SetDispatchOnAction(false);
            rMenuItem = new JMenuItem(rNewAction);
            rMenuItem.addActionListener(this);
        }
        return rMenuItem;
    }

    private void InitPopupMenu() {
        this.m_cPopupMenu = new JPopupMenu();
        JMenuItem cBtn = this.CreateJMenuItem(2004);
        if (cBtn != null) {
            this.m_cPopupMenu.add((Component)cBtn);
        }
        this.m_cPopupMenu.addSeparator();
        this.m_cDownloadPopupMenuItem = this.CreateJMenuItem(2009);
        if (this.m_cDownloadPopupMenuItem != null) {
            this.m_cPopupMenu.add(this.m_cDownloadPopupMenuItem);
        }
        this.m_cDownloadToPopupMenu = new JMenu(CString.LoadString("IDS_DOWNLOAD_TO_MENU"));
        if (this.m_cDownloadToPopupMenu != null) {
            this.m_cPopupMenu.add(this.m_cDownloadToPopupMenu);
        }
        this.m_cUploadPopupMenuItem = this.CreateJMenuItem(2008);
        if (this.m_cUploadPopupMenuItem != null) {
            this.m_cPopupMenu.add(this.m_cUploadPopupMenuItem);
        }
        this.m_cUploadToPopupMenu = new JMenu(CString.LoadString("IDS_UPLOAD_TO_MENU"));
        if (this.m_cUploadToPopupMenu != null) {
            this.m_cPopupMenu.add(this.m_cUploadToPopupMenu);
        }
        this.m_cPopupMenu.addSeparator();
        cBtn = this.CreateJMenuItem(2005);
        if (cBtn != null) {
            this.m_cPopupMenu.add((Component)cBtn);
        }
        if ((cBtn = this.CreateJMenuItem(2003)) != null) {
            this.m_cPopupMenu.add((Component)cBtn);
        }
        if ((cBtn = this.CreateJMenuItem(2006)) != null) {
            this.m_cPopupMenu.add((Component)cBtn);
        }
        this.m_cPopupMenu.addSeparator();
        cBtn = this.CreateJMenuItem(2115);
        if (cBtn != null) {
            this.m_cPopupMenu.add((Component)cBtn);
        }
        if ((cBtn = this.CreateJMenuItem(2007)) != null) {
            this.m_cPopupMenu.add((Component)cBtn);
        }
    }

    private JPopupMenu GetPopupMenu() {
        this.LoadDownloadToMenuItems(this.GetDownloadToPopupMenu());
        this.LoadUploadToMenuItems(this.GetUploadToPopupMenu());
        if (this.GetSelectedFile() != null) {
            boolean bShowDownloadBtns = this.GetSelectedFile().IsLocal();
            if (this.GetDownloadPopupMenuItem() != null) {
                this.GetDownloadPopupMenuItem().setVisible(!bShowDownloadBtns);
            }
            if (this.GetDownloadToPopupMenu() != null) {
                this.GetDownloadToPopupMenu().setVisible(!bShowDownloadBtns);
            }
            if (this.GetUploadPopupMenuItem() != null) {
                this.GetUploadPopupMenuItem().setVisible(bShowDownloadBtns);
            }
            if (this.GetUploadToPopupMenu() != null) {
                this.GetUploadToPopupMenu().setVisible(bShowDownloadBtns);
            }
        }
        return this.m_cPopupMenu;
    }

    private JMenuItem GetDownloadPopupMenuItem() {
        return this.m_cDownloadPopupMenuItem;
    }

    private JMenu GetDownloadToPopupMenu() {
        return this.m_cDownloadToPopupMenu;
    }

    private JMenuItem GetUploadPopupMenuItem() {
        return this.m_cUploadPopupMenuItem;
    }

    private JMenu GetUploadToPopupMenu() {
        return this.m_cUploadToPopupMenu;
    }

    private void LoadDownloadToMenuItems(JMenu rMenu) {
        if (CMainFrame.GET_APP() != null) {
            this.LoadTransferToMenuItems(rMenu, CMainFrame.GET_APP().GetLocalWorkingDirs(), CTransferMenuItem.TYPE.TRANSFER_TO);
        }
    }

    private void LoadUploadToMenuItems(JMenu rMenu) {
        if (CMainFrame.GET_APP() != null) {
            this.LoadTransferToMenuItems(rMenu, CMainFrame.GET_APP().GetRemoteWorkingDirs(), CTransferMenuItem.TYPE.TRANSFER_TO);
        }
    }

    private void LoadTransferToMenuItems(JMenu rMenu, Vector<CFile> afWorkingDirs, CTransferMenuItem.TYPE nType) {
        if (rMenu != null) {
            rMenu.removeAll();
            if (afWorkingDirs != null) {
                for (CFile fNext : afWorkingDirs) {
                    if (fNext == null || rMenu == null) continue;
                    CTransferMenuItem cMenuItem = new CTransferMenuItem(fNext, nType);
                    rMenu.add(cMenuItem);
                    cMenuItem.addActionListener(this);
                }
            }
        }
    }

    private AbstractButton GetPopupMenuBtn(int nEventID) {
        AbstractButton rBtn = null;
        JPopupMenu rPopMenu = this.GetPopupMenu();
        if (rPopMenu != null) {
            for (int nIdx = 0; nIdx < rPopMenu.getComponentCount() && rBtn == null; ++nIdx) {
                CBaseAction rBaseAction;
                AbstractButton cBtn;
                Action rAction;
                Component cComp = rPopMenu.getComponent(nIdx);
                if (cComp instanceof JMenu) {
                    rBtn = this.GetMenuBtn((JMenu)cComp, nEventID);
                    continue;
                }
                if (!(cComp instanceof AbstractButton) || !((rAction = (cBtn = (AbstractButton)cComp).getAction()) instanceof CBaseAction) || (rBaseAction = (CBaseAction)rAction).GetEventID() != nEventID) continue;
                rBtn = cBtn;
            }
        }
        return rBtn;
    }

    private AbstractButton GetMenuBtn(JMenu rMenu, int nEventID) {
        AbstractButton rBtn = null;
        if (rMenu != null) {
            for (int nIdx = 0; nIdx < rMenu.getComponentCount() && rBtn == null; ++nIdx) {
                CBaseAction rBaseAction;
                AbstractButton cBtn;
                Action rAction;
                Component cComp = rMenu.getComponent(nIdx);
                if (cComp instanceof JMenu) {
                    rBtn = this.GetMenuBtn((JMenu)cComp, nEventID);
                    continue;
                }
                if (!(cComp instanceof AbstractButton) || !((rAction = (cBtn = (AbstractButton)cComp).getAction()) instanceof CBaseAction) || (rBaseAction = (CBaseAction)rAction).GetEventID() != nEventID) continue;
                rBtn = cBtn;
            }
        }
        return rBtn;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() instanceof CTransferMenuItem) {
            CTransferMenuItem rMenuItem = (CTransferMenuItem)event.getSource();
            CFile fTransferTo = rMenuItem.GetFile();
            this.OnTransferFilesTo(fTransferTo);
            return;
        } else if (event.getSource() instanceof JMenuItem) {
            JMenuItem rBtn = (JMenuItem)event.getSource();
            if (!(rBtn.getAction() instanceof CFVJVAction)) return;
            CFVJVAction rAction = (CFVJVAction)rBtn.getAction();
            CRhinoEvent rEvent = new CRhinoEvent(this, rAction.GetEventID());
            switch (rAction.GetEventID()) {
                case 2008: 
                case 2009: {
                    if (CMainFrame.GET_APP() == null) return;
                    CMainFrame.GET_APP().dispatchEvent(rEvent);
                    return;
                }
                default: {
                    this.processEvent(rEvent);
                }
            }
            return;
        } else if (event.getSource() == this.m_DragExpandTimer) {
            TreePath rCurTreePath;
            this.StopDragExpandTimer();
            if (this.GetTree() == null || (rCurTreePath = this.GetTree().getSelectionPath()) == null) return;
            if (!this.GetTree().isExpanded(rCurTreePath)) {
                this.GetTree().expandPath(rCurTreePath);
                return;
            } else {
                CFileTreeNode rFileNode;
                CFile fSelected;
                Object rSelNode = rCurTreePath.getLastPathComponent();
                if (rSelNode == null || !(rSelNode instanceof CFileTreeNode) || (fSelected = (rFileNode = (CFileTreeNode)rSelNode).GetFile()) == null) return;
                fSelected.GetListing(this.GetThread(), this, false, false, true, false, null);
            }
            return;
        } else if (event.getSource() == this.m_ChangeTimer) {
            TreePath rCurTreePath;
            if (DEBUG_CHANGE_TIMER) {
                System.out.println("Change Timer hit!");
            }
            this.StopChangeTimer();
            if (this.GetTree() != null && (rCurTreePath = this.GetTree().getSelectionPath()) != null) {
                CFileTreeNode rFileNode;
                CFile fSelected;
                Object rSelNode;
                if (this.GetExpandOnTypeAhead() && !this.GetTree().isExpanded(rCurTreePath)) {
                    this.GetTree().expandPath(rCurTreePath);
                }
                if ((rSelNode = rCurTreePath.getLastPathComponent()) != null && rSelNode instanceof CFileTreeNode && (fSelected = (rFileNode = (CFileTreeNode)rSelNode).GetFile()) != null) {
                    fSelected.GetListing(this.GetThread(), this, false, true, false, false, null);
                }
            }
            this.SetExpandOnTypeAhead(true);
            return;
        } else {
            if (event.getSource() != this.m_RenameTimer) return;
            this.StopRenameTimer();
            this.OnRename(this.GetSelectedFile());
        }
    }

    private void OnTransferFilesTo(CPath rTransferTo) {
        CPath[] arFrom = this.GetSelectedFile().CreatePaths(false);
        this.TransferFiles(this.GetSelectedFile().GetParent(), rTransferTo, arFrom, false, this.IsSearch());
    }

    private void TransferFiles(CFile fTransferFrom, CPath rTransferTo, CPath[] arFromChildren, boolean bMovingFiles, boolean bIsSearch) {
        CFilePanel.TransferFilesEx(this, fTransferFrom, rTransferTo, arFromChildren, bMovingFiles, bIsSearch);
    }

    public CFile GetSelectedFile() {
        CFile fRet = null;
        if (this.GetTree() != null) {
            fRet = this.GetFileFromTreePath(this.GetTree().getSelectionPath());
        }
        return fRet;
    }

    private CFile GetFileFromTreePath(TreePath rTreePath) {
        Object rNode;
        CFile fRet = null;
        if (rTreePath != null && (rNode = rTreePath.getLastPathComponent()) != null && rNode instanceof CFileTreeNode) {
            CFileTreeNode rFileNode = (CFileTreeNode)rNode;
            fRet = rFileNode.GetFile();
        }
        return fRet;
    }

    protected IArchive GetArchive() {
        IArchive rArchive = null;
        if (CMainFrame.GET_APP() != null) {
            rArchive = CMainFrame.GET_APP().GetArchive();
        }
        return rArchive;
    }

    private void OnDelete() {
        boolean bCanDelete;
        CFile[] afSelFiles;
        Boolean bVal;
        boolean bConfirmFolderDelete = true;
        if (this.GetArchive() != null && (bVal = this.GetArchive().GetValueBool("ConfirmFolderDel", true)) != null) {
            bConfirmFolderDelete = bVal;
        }
        if (this.GetSelectedFile() != null && (afSelFiles = new CFile[]{this.GetSelectedFile()}) != null && afSelFiles.length > 0 && (bCanDelete = this.ShowConfirmDeleteDlg(true, bConfirmFolderDelete, true, afSelFiles)) && this.GetSelectedFile().GetParent() != null) {
            this.GetSelectedFile().GetParent().DeleteFiles(this.GetThread(), this, afSelFiles);
        }
    }

    public boolean ShowConfirmDeleteDlg(boolean bPermanentDel, boolean bConfirmFolderDelete, boolean bConfirmFileDelete, CFile[] afSelFiles) {
        boolean bRet = false;
        if (CMainFrame.GET_APP() != null) {
            bRet = CMainFrame.GET_APP().ShowConfirmDeleteDlg(bPermanentDel, bConfirmFolderDelete, bConfirmFileDelete, afSelFiles);
        }
        return bRet;
    }

    protected DockingManager GetDockingManager() {
        return this.m_rDockingManager;
    }

    public void SetDockingManager(DockingManager rDockingManager) {
        this.m_rDockingManager = rDockingManager;
    }

    protected String GetFrameKey() {
        return this.m_sFrameKey;
    }

    public void SetFrameKey(String sKey) {
        this.m_sFrameKey = sKey;
    }

    private void UpdateBtnStates() {
        CFile fSelectedFile = this.GetSelectedFile();
        if (fSelectedFile != null) {
            boolean bIsLocal = fSelectedFile.IsLocal();
            boolean bIsARoot = fSelectedFile.IsARoot();
            boolean bIsDrive = fSelectedFile.IsDrive();
            boolean bEnableOpen = true;
            boolean bEnableRename = false;
            boolean bEnableNewDir = true;
            boolean bEnableDelete = false;
            boolean bEnableUpload = false;
            boolean bEnableDownload = false;
            boolean bEnableProperties = true;
            if (!bIsARoot && !bIsDrive) {
                if (fSelectedFile.IsLocal()) {
                    bEnableUpload = true;
                } else {
                    bEnableDownload = true;
                }
                bEnableRename = true;
                bEnableDelete = true;
            } else if (bIsARoot) {
                bEnableNewDir = false;
            }
            this.SetBtnEnabled(2004, bEnableOpen);
            this.SetBtnEnabled(2003, bEnableNewDir);
            this.SetBtnEnabled(2006, bEnableRename);
            this.SetBtnEnabled(2008, bEnableUpload);
            this.SetBtnEnabled(2009, bEnableDownload);
            this.SetBtnEnabled(2005, bEnableDelete);
            this.SetBtnEnabled(2007, bEnableProperties);
        }
    }

    private void UpdateBtnSelections() {
    }

    private void SetBtnEnabled(int nEventID, boolean bEnabled) {
        Object[] anItems = new Object[]{nEventID, bEnabled};
        CRhinoEvent rEvent = new CRhinoEvent(this, 9020, anItems);
        if (CMainFrame.GET_APP() != null) {
            CMainFrame.GET_APP().dispatchEvent(rEvent);
        }
        this.OnUpdateBtnState(nEventID, bEnabled);
    }

    private void SetBtnSelected(int nEventID, boolean bSelected) {
        Object[] anItems = new Object[]{nEventID, bSelected};
        CRhinoEvent rEvent = new CRhinoEvent(this, 9022, anItems);
        if (CMainFrame.GET_APP() != null) {
            CMainFrame.GET_APP().dispatchEvent(rEvent);
        }
        this.OnUpdateBtnSelection(nEventID, bSelected);
    }

    private void OnUpdateBtnState(int nEventID, boolean bEnabled) {
        AbstractButton rBtn = this.GetPopupMenuBtn(nEventID);
        if (rBtn != null) {
            rBtn.setEnabled(bEnabled);
        }
        if (nEventID == 2008 && this.GetUploadToPopupMenu() != null) {
            this.GetUploadToPopupMenu().setEnabled(bEnabled);
        } else if (nEventID == 2009 && this.GetDownloadToPopupMenu() != null) {
            this.GetDownloadToPopupMenu().setEnabled(bEnabled);
        }
    }

    private void OnUpdateBtnSelection(int nEventID, boolean bSelected) {
        AbstractButton rBtn = this.GetPopupMenuBtn(nEventID);
        if (rBtn != null) {
            rBtn.setSelected(bSelected);
        }
    }

    private void OnOpen() {
        if (this.GetTree() != null) {
            this.GetTree().expandPath(this.GetTree().getSelectionPath());
        }
    }

    private void OnRename(CFile fRenameFile) {
        if (fRenameFile != null && this.GetTree() != null && this.GetModel() != null) {
            Boolean bPromptReadOnly;
            Rectangle rScreenCoords = null;
            Object rCellRenderer = null;
            IArchive rArchive = this.GetArchive();
            if (rArchive != null && (bPromptReadOnly = rArchive.GetValueBool("ConfirmFileReadOnly", true)) != null && this.GetEditor() != null) {
                this.GetEditor().SetWarnOnReadOnly(bPromptReadOnly);
            }
            if (this.GetCellRenderer() != null) {
                int nRow = -1;
                CFileTreeNode rNode = this.GetModel().FindNode(fRenameFile);
                nRow = this.GetTree().getRowForPath(rNode.GetTreePath());
                rScreenCoords = this.GetCellRenderer().GetEditorRect(this.GetTree(), nRow);
            }
            if (rScreenCoords != null && rScreenCoords.width > 0 && rScreenCoords.height > 0) {
                if (DEBUG_RENAME_EDITOR) {
                    System.out.println(String.format("Show CellEditor at (%s)", rScreenCoords.toString()));
                }
                this.ShowEditor(rScreenCoords, fRenameFile);
            }
        }
    }

    private void OnNewFolder() {
        if (this.GetSelectedFile() != null) {
            this.GetSelectedFile().CreateNewFolder(this.GetThread(), this, true);
        }
    }

    private void OnProperties() {
        if (CMainFrame.GET_APP() != null) {
            CFile[] afFiles = new CFile[]{this.GetSelectedFile()};
            CMainFrame.GET_APP().ShowPropertiesDlg(afFiles);
        }
    }

    @Override
    public void keyTyped(KeyEvent event) {
        if (DEBUG_KEY_EVENTS) {
            System.out.println("keyTyped");
        }
    }

    @Override
    public void keyPressed(KeyEvent event) {
        if (DEBUG_KEY_EVENTS) {
            System.out.println("keyPressed");
        }
        Object objSource = event.getSource();
        int nKeyCode = event.getKeyCode();
        block0 : switch (nKeyCode) {
            case 113: {
                if (event.getModifiers() != 0) break;
                this.OnRename(this.GetSelectedFile());
                event.consume();
                break;
            }
            case 27: {
                this.HideEditor(false);
                event.consume();
                break;
            }
            case 10: {
                if (event.isAltDown()) {
                    this.OnProperties();
                    event.consume();
                    break;
                }
                this.OnOpen();
                event.consume();
                break;
            }
            case 8: {
                break;
            }
            case 38: 
            case 40: {
                TreePath rCurTreePath = this.GetTree().getSelectionPath();
                if (rCurTreePath != null) {
                    int nRow = this.GetTree().getRowForPath(rCurTreePath);
                    nRow = nKeyCode == 38 ? --nRow : ++nRow;
                    TreePath rNextTreePath = this.GetTree().getPathForRow(nRow);
                    if (rNextTreePath != null) {
                        this.StartChangeTimer(500);
                        this.GetTree().scrollPathToVisible(rNextTreePath);
                        this.GetTree().requestFocusInWindow();
                        this.GetTree().setSelectionPath(rNextTreePath);
                    }
                }
                event.consume();
                break;
            }
            case 115: {
                if (event.getModifiers() != 0) break;
                CRhinoEvent CrumbEditEvent = new CRhinoEvent(this, 9201);
                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(CrumbEditEvent);
                break;
            }
            default: {
                if (event.isControlDown()) {
                    switch (nKeyCode) {
                        case 65: {
                            CRhinoEvent Event2 = new CRhinoEvent(this, 2021);
                            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(Event2);
                            event.consume();
                            break block0;
                        }
                        case 73: {
                            CRhinoEvent Event3 = new CRhinoEvent(this, 2022);
                            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(Event3);
                            event.consume();
                            break block0;
                        }
                    }
                    break;
                }
                this.SetIsTypeAhead(true);
                if (!DEBUG_TREE_TYPE_AHEAD) break;
                System.out.printf("keyPressed | SetTypeAhead: %s\r\n", Boolean.toString(this.IsTypeAhead()));
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent event) {
        if (DEBUG_KEY_EVENTS) {
            System.out.println("keyReleased");
        }
        this.SetIsTypeAhead(false);
        if (DEBUG_TREE_TYPE_AHEAD) {
            System.out.printf("keyPressed | SetTypeAhead: %s\r\n", Boolean.toString(this.IsTypeAhead()));
        }
        this.m_bCanRenameOnClick = true;
    }

    @Override
    public void stateChanged(ChangeEvent rChangeEvent) {
    }

    private void OnRefresh() {
        CFile fRefresh = null;
        if (this.GetTree() != null) {
            boolean bExpandNode = false;
            TreePath cTreePath = this.GetTree().getSelectionPath();
            bExpandNode = this.GetTree().isExpanded(cTreePath);
            fRefresh = this.GetFileFromTreePath(cTreePath);
            if (fRefresh != null) {
                fRefresh.GetListing(this.GetThread(), this, true, true, bExpandNode, false, null);
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent rMouseEvent) {
        if (DEBUG_TRACK_DND_DRAG_EVENTS) {
            System.out.println("mouseDragged");
        }
        if (SwingUtilities.isRightMouseButton(rMouseEvent)) {
            rMouseEvent.consume();
            Object rSourceObj = rMouseEvent.getSource();
            if (rSourceObj instanceof JComponent) {
                JComponent rSource = (JComponent)rSourceObj;
                if (this.m_FirstMouseEvent != null) {
                    int nAction = 1;
                    int dXExtent = Math.abs(rMouseEvent.getX() - this.m_FirstMouseEvent.getX());
                    int dYExtent = Math.abs(rMouseEvent.getY() - this.m_FirstMouseEvent.getY());
                    if (dXExtent > 5 || dYExtent > 5) {
                        rSource.putClientProperty("DndRightClick", true);
                        TransferHandler rHandler = rSource.getTransferHandler();
                        if (rHandler != null && CFileSystemUtils.GetFileSysUtils() != null && !CFileSystemUtils.GetFileSysUtils().IsNIX()) {
                            rHandler.exportAsDrag(rSource, this.m_FirstMouseEvent, nAction);
                        }
                        this.m_FirstMouseEvent = null;
                    }
                }
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent event) {
    }

    private void StartDragExpandTimer(TreePath rExpandTreePath) {
        this.m_cDragExpandTreePath = rExpandTreePath;
        if (this.m_DragExpandTimer != null && !this.m_DragExpandTimer.isRunning()) {
            this.m_DragExpandTimer.start();
        } else {
            this.m_DragExpandTimer.restart();
        }
    }

    private void StopDragExpandTimer() {
        if (this.m_DragExpandTimer != null && this.m_DragExpandTimer.isRunning()) {
            this.m_DragExpandTimer.stop();
        }
    }

    public void StartChangeTimer(int nDelay) {
        if (this.m_ChangeTimer != null && !this.m_ChangeTimer.isRunning()) {
            this.m_ChangeTimer.setInitialDelay(nDelay);
            this.m_ChangeTimer.setDelay(nDelay);
            this.m_ChangeTimer.start();
        } else {
            this.m_ChangeTimer.restart();
        }
    }

    private void StopChangeTimer() {
        if (this.m_ChangeTimer != null && this.m_ChangeTimer.isRunning()) {
            this.m_ChangeTimer.stop();
        }
    }

    private boolean IsChangeTimerRunning() {
        boolean bIsRunning = false;
        if (this.m_ChangeTimer != null && this.m_ChangeTimer.isRunning()) {
            bIsRunning = true;
        }
        return bIsRunning;
    }

    @Override
    public void focusGained(FocusEvent event) {
    }

    @Override
    public void focusLost(FocusEvent event) {
    }

    public void SetHasFocusClrs(boolean bHasFocusClrs) {
        CFileTreeNodeRenderer rCellRenderer = this.GetCellRenderer();
        if (rCellRenderer != null) {
            rCellRenderer.SetHasFocusClrs(bHasFocusClrs);
        }
    }

    private void StartRenameTimer() {
        if (!this.GetShowRenameDlg()) {
            if (this.m_RenameTimer != null && !this.m_RenameTimer.isRunning()) {
                this.m_RenameTimer.start();
            } else {
                this.m_RenameTimer.restart();
            }
        }
    }

    private void StopRenameTimer() {
        if (this.m_RenameTimer != null && this.m_RenameTimer.isRunning()) {
            this.m_RenameTimer.stop();
        }
    }

    private DockableFrame GetTreeFrame() {
        DockableFrame rFrame = null;
        if (this.GetDockingManager() != null) {
            rFrame = this.GetDockingManager().getFrame(this.GetFrameKey());
        }
        return rFrame;
    }

    private CFileCellEditor GetEditor() {
        return this.m_cEditor;
    }

    private void ShowEditor(Rectangle rBounds, CFile fRename) {
        boolean bShowDlg = false;
        if (this.GetShowRenameDlg()) {
            CRenameDlg dlg = new CRenameDlg((Frame)CMainFrame.GET_APP(), (Component)this, this.GetThread());
            dlg.SetRenameFile(fRename);
            dlg.setVisible(true);
        } else if (this.GetEditor() != null) {
            this.GetEditor().ShowEditor(rBounds.x, rBounds.y, rBounds.width, rBounds.height, fRename);
        }
    }

    private void HideEditor(boolean bCommit) {
        if (this.GetEditor() != null) {
            this.GetEditor().HideEditor(bCommit);
        }
    }

    public void SetRenameMarker(long lTime) {
        if (this.GetEditor() != null) {
            this.GetEditor().SetMarker(lTime);
        }
    }

    public void SetIsDragOver(boolean bIsDragOver) {
        this.m_bIsDragOver = bIsDragOver;
    }

    public boolean IsDragOver() {
        return this.m_bIsDragOver;
    }

    @Override
    public boolean CompleteDragDrop(CPath rDragSourceDir, CPath rDropTargetDir, CPath[] arDragSourceFiles, boolean bIsMove, boolean bIsSearch, boolean bShowDropMenu, Point ptDropLoc) {
        return CFilePanel.CompleteDragDrop(this, rDragSourceDir, rDropTargetDir, arDragSourceFiles, bIsMove, bIsSearch, bShowDropMenu, ptDropLoc, this.GetCompressionType());
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.GetTree() != null) {
            SwingUtilities.updateComponentTreeUI(this.GetTree());
        }
        if (this.m_cPopupMenu != null) {
            SwingUtilities.updateComponentTreeUI(this.m_cPopupMenu);
        }
    }

    private boolean GetShowRenameDlg() {
        String sLnFClassName;
        boolean bShowDlg = false;
        if (CFileSystemUtils.GetFileSysUtils().IsMac() && (sLnFClassName = UIManager.getLookAndFeel().getClass().getName()).equals("apple.laf.AquaLookAndFeel")) {
            bShowDlg = true;
        }
        return bShowDlg;
    }

    private CTypeAhead GetTypeAhead() {
        return this.m_TypeAhead;
    }

    public void SetIsTypeAhead(boolean bVal) {
        this.m_bIsTypeAhead = bVal;
    }

    public boolean IsTypeAhead() {
        return this.m_bIsTypeAhead;
    }

    public void SetExpandOnTypeAhead(boolean bVal) {
        this.m_bExpandOnTypeAhead = bVal;
    }

    public boolean GetExpandOnTypeAhead() {
        return this.m_bExpandOnTypeAhead;
    }

    public boolean MoveTo(CFile fFile) {
        CFileTreeNode rNode;
        boolean bMoved = false;
        if (fFile != null && this.GetTree() != null && this.GetModel() != null && (rNode = this.GetModel().FindNode(fFile)) != null) {
            this.m_bPreventSelectionListing = true;
            this.GetTree().setSelectionPath(rNode.GetTreePath());
            this.m_bPreventSelectionListing = false;
            bMoved = true;
        }
        return bMoved;
    }

    private CFile GetCurWorkingDir() {
        CFile fWorkingDir = null;
        return fWorkingDir;
    }

    public void SelectNode(CFile fFile, boolean bExpandTreeNode) {
        CFileTreeNode rNode;
        if (fFile != null && this.GetModel() != null && (rNode = this.GetModel().FindNode(fFile)) != null) {
            if (bExpandTreeNode) {
                this.SetResumeListingsNode(rNode);
                if (this.GetTree() != null) {
                    this.GetTree().expandPath(rNode.GetTreePath());
                }
            }
            if (this.GetTree() != null) {
                this.GetTree().scrollPathToVisible(rNode.GetTreePath());
                this.m_bPreventSelectionListing = true;
                this.GetTree().setSelectionPath(rNode.GetTreePath());
                this.m_bPreventSelectionListing = false;
            }
        }
    }

    public void SetSearchState(CSearchStateEvent.SEARCH_STATE nSearchState) {
        if (nSearchState == CSearchStateEvent.SEARCH_STATE.ON) {
            this.m_bIsSearch = true;
            this.ShowSearchNode(true);
        } else {
            this.m_bIsSearch = false;
            this.HideSearchNode();
        }
    }

    private void ShowSearchNode(boolean bSelectIt) {
        if (this.GetModel() != null) {
            this.m_rWorkingDirBeroreSearch = this.GetSelectedFile();
            if (this.GetModel().GetSearchNode() != null) {
                this.GetModel().GetSearchNode().UpdateText(this.GetSelectedFile());
            }
            this.GetModel().SetSearchNodeVisible(true);
            this.FireOnChangedSearchState(CSearchStateEvent.SEARCH_STATE.ON);
        }
        if (bSelectIt && this.GetTree() != null && this.GetModel().GetSearchNode() != null) {
            TreePath rTreePath = this.GetModel().GetSearchNode().GetTreePath();
            this.GetTree().setSelectionPath(rTreePath);
            this.GetTree().scrollPathToVisible(rTreePath);
        }
    }

    private void HideSearchNode() {
        if (this.GetModel() != null) {
            this.SelectNode(this.m_rWorkingDirBeroreSearch, false);
            this.GetModel().SetSearchNodeVisible(false);
            this.FireOnChangedSearchState(CSearchStateEvent.SEARCH_STATE.OFF);
        }
    }

    private Vector<ISearchStateListener> GetSearchStateListeners() {
        return this.m_aSearchStateListeners;
    }

    public void AddSearchStateListener(ISearchStateListener rListener) {
        if (this.GetSearchStateListeners() != null) {
            this.GetSearchStateListeners().add(rListener);
        }
    }

    public void RemoveSearchStateListener(ISearchStateListener rListener) {
        if (this.GetSearchStateListeners() != null) {
            this.GetSearchStateListeners().remove(rListener);
        }
    }

    private void FireOnChangedSearchState(CSearchStateEvent.SEARCH_STATE nSearchState) {
        CSearchStateEvent rSearchEvent = new CSearchStateEvent(this, nSearchState);
        if (this.GetSearchStateListeners() != null) {
            for (ISearchStateListener rListener : this.GetSearchStateListeners()) {
                if (rListener == null) continue;
                rListener.OnChangedSearchState(rSearchEvent);
            }
        }
    }

    public boolean IsSearch() {
        return this.m_bIsSearch;
    }

    public void SetRootNode(CFile fFile) {
        if (this.GetModel() != null) {
            this.GetModel().SetRootNode(fFile);
        }
    }

    public void TurnOnFocusClrs() {
        this.SetHasFocusClrs(true);
    }

    public void TurnOffFocusClrs() {
        this.SetHasFocusClrs(false);
    }

    private Vector<IFileTreeListener> GetFileTreeListeners() {
        return this.m_aFileTreeListeners;
    }

    public void AddFileTreeListener(IFileTreeListener rListener) {
        if (this.GetFileTreeListeners() != null) {
            this.GetFileTreeListeners().add(rListener);
        }
    }

    public void RemoveFileTreeListener(IFileTreeListener rListener) {
        if (this.GetFileTreeListeners() != null) {
            this.GetFileTreeListeners().remove(rListener);
        }
    }

    protected void FireOnFileSelected(CFile fSelected) {
        CFileTreeEvent rFileTreeEvent = new CFileTreeEvent(this);
        if (rFileTreeEvent != null) {
            rFileTreeEvent.SetSelectedFile(fSelected);
            if (this.GetFileTreeListeners() != null) {
                for (IFileTreeListener rListener : this.GetFileTreeListeners()) {
                    if (rListener == null) continue;
                    rListener.OnFileSelected(rFileTreeEvent);
                }
            }
        }
    }

    public int GetCompressionType() {
        int nCompressionType = 0;
        if (CMainFrame.GET_APP() != null) {
            nCompressionType = CMainFrame.GET_APP().GetCompressionType();
        }
        return nCompressionType;
    }

    static {
        if (DEBUG) {
            // empty if block
        }
        DEBUG_TRACK_DND_DRAG_EVENTS = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_TRACK_DND_DROP_EVENTS = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_CHANGE_TIMER = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_KEY_EVENTS = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_TREE_SEL_EVENT = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_TREE_VALUE_TO_TEXT = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_TREE_TYPE_AHEAD = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_RENAME_EDITOR = false;
    }
}

