/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.docking.fvjv.search;

import com.jidesoft.action.DefaultDockableBarDockableHolder;
import com.jidesoft.docking.DockableFrame;
import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.office2003.Office2003Painter;
import com.rhinosoft.base.files.CFileSystemUtils;
import com.rhinosoft.docking.CDockableBar;
import com.rhinosoft.docking.CDockableFrame;
import com.rhinosoft.docking.CDockablePanel;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.Border;

public class CCustomComboBox
extends JComponent
implements ActionListener,
KeyListener {
    private static boolean DEBUG = true;
    private boolean m_bInitSize;
    private JTextField m_TextField;
    private CDropButton m_DropBtn;
    private boolean m_bCanDeactivatePopup;
    private JDialog m_Popup;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LookAndFeelFactory.installDefaultLookAndFeelAndExtension();
                try {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                }
                catch (ClassNotFoundException cnfe) {
                    cnfe.printStackTrace();
                }
                catch (InstantiationException ie) {
                    ie.printStackTrace();
                }
                catch (IllegalAccessException iae) {
                    iae.printStackTrace();
                }
                catch (UnsupportedLookAndFeelException ulafe) {
                    ulafe.printStackTrace();
                }
                LookAndFeelFactory.installJideExtension(3);
                ((Office2003Painter)Office2003Painter.getInstance()).setColorName("NormalColor");
                DefaultDockableBarDockableHolder mainFrame = new DefaultDockableBarDockableHolder("Dock Test");
                mainFrame.setDefaultCloseOperation(3);
                mainFrame.setSize(800, 600);
                mainFrame.getDockableBarManager().loadLayoutData();
                mainFrame.getDockingManager().loadLayoutData();
                CDockableBar dockBar = new CDockableBar("NorthBar", mainFrame);
                dockBar.add(new JTextField());
                mainFrame.getDockableBarManager().addDockableBar(dockBar);
                dockBar = new CDockableBar("SouthBar", mainFrame);
                mainFrame.getDockableBarManager().addDockableBar(dockBar);
                DockableFrame dockFrame = new CDockableFrame("NorthFrame", mainFrame, 4, 1);
                mainFrame.getDockingManager().addFrame(dockFrame);
                dockFrame = new CDockableFrame("SouthFrame", mainFrame, 4, 2);
                mainFrame.getDockingManager().addFrame(dockFrame);
                dockFrame = mainFrame.getDockingManager().getFrame("NorthFrame");
                RootPaneContainer rpc = (RootPaneContainer)((Object)SwingUtilities.getAncestorOfClass(RootPaneContainer.class, dockFrame));
                CDockablePanel dockPanel = new CDockablePanel(rpc, dockFrame);
                dockFrame.add(dockPanel);
                dockBar = new CDockableBar("NorthBarSub", dockPanel);
                CCustomComboBox dtPicker2 = new CCustomComboBox(true);
                dtPicker2.setPreferredSize(new Dimension(100, 20));
                dockBar.add(dtPicker2);
                dockPanel.AddDockableBar(dockBar);
                dockFrame = new CDockableFrame("NorthFrameSub", dockPanel, 4, 8);
                dockPanel.AddDockableFrame(dockFrame);
                mainFrame.setVisible(true);
            }
        });
    }

    public CCustomComboBox(boolean bInitVars) {
        if (bInitVars) {
            this.InitVars();
        }
    }

    protected void InitVars() {
        this.m_bInitSize = true;
        this.m_bCanDeactivatePopup = true;
        this.m_TextField = new JTextField();
        this.GetTextField().setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
        this.m_DropBtn = new CDropButton((Icon)CMainFrame.GetJARImage("Calendar.png"));
        this.GetDropBtn().setMargin(new Insets(0, 2, 0, 1));
        this.GetDropBtn().setIconTextGap(0);
        this.GetDropBtn().addActionListener(this);
        this.GetDropBtn().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent event) {
                CCustomComboBox.this.SetCanDeactivatePopup(false);
            }

            @Override
            public void mouseExited(MouseEvent event) {
                CCustomComboBox.this.SetCanDeactivatePopup(true);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent event) {
                CCustomComboBox.this.AdjustBtnSize();
            }
        });
        JComboBox combo = new JComboBox();
        this.setBorder(combo.getBorder());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(false);
        layout.setAutoCreateContainerGaps(false);
        layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(this.GetTextField(), -1, -2, Short.MAX_VALUE).addComponent(this.GetDropBtn(), -1, -2, -2));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(this.GetTextField(), -1, -2, Short.MAX_VALUE).addComponent(this.GetDropBtn(), -1, -2, Short.MAX_VALUE)));
        this.InitPopup();
    }

    private void InitPopup() {
        this.m_Popup = new JDialog();
        this.GetPopup().addKeyListener(this);
        this.GetPopup().setModal(false);
        this.GetPopup().setUndecorated(true);
        this.GetPopup().addWindowListener(new WindowAdapter(){

            @Override
            public void windowDeactivated(WindowEvent event) {
                if (DEBUG) {
                    System.out.println("Popup.windowDeactivated");
                }
                if (CCustomComboBox.this.CanDeactivatePopup()) {
                    CCustomComboBox.this.HidePopup(true);
                }
            }
        });
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createRaisedBevelBorder());
        this.GetPopup().setContentPane(panel);
        this.InitPopupPanel(panel);
    }

    protected void InitPopupPanel(JPanel rPanel) {
        rPanel.add(new JLabel("<Override so you can put your own controls on the drop-down>"));
    }

    protected boolean CanDeactivatePopup() {
        return this.m_bCanDeactivatePopup;
    }

    protected void SetCanDeactivatePopup(boolean bVal) {
        this.m_bCanDeactivatePopup = bVal;
    }

    @Override
    public void setVisible(boolean bVisible) {
        if (this.m_bInitSize && bVisible) {
            this.m_bInitSize = false;
            this.AdjustBtnSize();
        }
        super.setVisible(bVisible);
    }

    private void AdjustBtnSize() throws NullPointerException {
        if (this.GetTextField() != null && this.GetDropBtn() != null) {
            Dimension dimSize = this.GetTextField().getSize();
            if (dimSize != null) {
                int nHeight = dimSize.height;
                this.GetDropBtn().setMinimumSize(new Dimension(nHeight, nHeight));
                this.GetDropBtn().setPreferredSize(new Dimension(nHeight, nHeight));
                this.GetDropBtn().setMaximumSize(new Dimension(nHeight, nHeight));
                this.GetDropBtn().setSize(new Dimension(nHeight, nHeight));
                this.revalidate();
            }
        } else {
            throw new NullPointerException();
        }
    }

    protected JTextField GetTextField() {
        return this.m_TextField;
    }

    protected JButton GetDropBtn() {
        return this.m_DropBtn;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.GetDropBtn() && this.GetPopup() != null) {
            if (this.GetPopup().isVisible()) {
                this.HidePopup(true);
            } else {
                this.ShowPopup(true);
            }
        }
    }

    protected JDialog GetPopup() {
        return this.m_Popup;
    }

    private void HidePopup(boolean bFireListener) {
        if (this.GetPopup() != null) {
            this.GetPopup().setVisible(false);
        }
    }

    private void ShowPopup(boolean bFireListener) {
        if (this.GetPopup() != null) {
            Rectangle bounds = this.getBounds();
            Point ptLoc = this.getLocationOnScreen();
            if (bounds != null && ptLoc != null) {
                int nXLoc = ptLoc.x;
                int nYLoc = ptLoc.y + bounds.height;
                this.GetPopup().pack();
                Dimension dimScreenSize = Toolkit.getDefaultToolkit().getScreenSize();
                if (dimScreenSize != null) {
                    if (nXLoc + this.GetPopup().getWidth() > dimScreenSize.width) {
                        nXLoc = dimScreenSize.width - this.GetPopup().getWidth();
                    }
                    if (nYLoc + this.GetPopup().getHeight() > dimScreenSize.height) {
                        nYLoc = dimScreenSize.height - this.GetPopup().getHeight();
                    }
                }
                this.GetPopup().setLocation(nXLoc, nYLoc);
                this.GetPopup().setVisible(true);
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent(this.GetPopup());
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }

    @Override
    public void keyPressed(KeyEvent event) {
    }

    @Override
    public void keyReleased(KeyEvent event) {
        switch (event.getKeyCode()) {
            case 27: {
                this.HidePopup(true);
                break;
            }
        }
    }

    @Override
    public void setEnabled(boolean bEnable) {
        if (this.GetTextField() != null) {
            this.GetTextField().setEnabled(bEnable);
        }
        if (this.GetDropBtn() != null) {
            this.GetDropBtn().setEnabled(bEnable);
        }
        super.setEnabled(bEnable);
    }

    public boolean IsEventSource(Object objSource) {
        boolean bIsEventSource = false;
        if (objSource == this) {
            bIsEventSource = true;
        }
        if (!bIsEventSource) {
            for (int nIdx = 0; nIdx < this.getComponentCount(); ++nIdx) {
                Component rComp = this.getComponent(nIdx);
                if (rComp == null || rComp != objSource) continue;
                bIsEventSource = true;
                break;
            }
        }
        return bIsEventSource;
    }

    private class CDropButton
    extends JButton {
        private boolean m_bHasIcon;
        private Border m_BtnBorderUp;
        private Border m_BtnBorderDown;

        public CDropButton() {
            this.InitVars(false);
        }

        public CDropButton(Icon icon) {
            this.InitVars(true);
            this.setIcon(icon);
        }

        private void InitVars(boolean bHasIcon) {
            this.m_bHasIcon = bHasIcon;
            this.setFocusable(false);
            if (CFileSystemUtils.GetFileSysUtils().IsWindows()) {
                this.m_BtnBorderUp = this.getBorder();
                this.m_BtnBorderDown = BorderFactory.createLineBorder(this.getBackground().darker());
                this.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent e) {
                        if (DEBUG) {
                            System.out.println("DropBtn.mousePressed");
                        }
                        if (CDropButton.this.isEnabled()) {
                            CDropButton.this.setBorder(CDropButton.this.m_BtnBorderDown);
                        }
                    }

                    @Override
                    public void mouseReleased(MouseEvent e) {
                        CDropButton.this.setBorder(CDropButton.this.m_BtnBorderUp);
                    }
                });
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            Rectangle rClip;
            super.paintComponent(g);
            if (!this.m_bHasIcon && (rClip = g.getClipBounds()) != null) {
                int nOriginX = rClip.width / 2;
                int nOriginY = Math.min(rClip.width / 2, rClip.height / 2);
                float fLenSideA = (float)(rClip.height / 2) * 0.5f;
                Polygon triangle = new Polygon();
                triangle.addPoint(nOriginX - (int)fLenSideA, nOriginY -= (int)(fLenSideA / 2.0f));
                triangle.addPoint(nOriginX + (int)fLenSideA, nOriginY);
                triangle.addPoint(nOriginX, nOriginY + (int)fLenSideA);
                Color oldClr = g.getColor();
                g.setColor(Color.BLACK);
                if (!this.isEnabled()) {
                    g.setColor(Color.GRAY);
                }
                g.fillPolygon(triangle);
                g.setColor(oldClr);
            }
        }
    }
}

