/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.docking.fvjv.search;

import com.jidesoft.action.DefaultDockableBarDockableHolder;
import com.jidesoft.docking.DockableFrame;
import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.office2003.Office2003Painter;
import com.rhinosoft.docking.CDockableBar;
import com.rhinosoft.docking.CDockableFrame;
import com.rhinosoft.docking.CDockablePanel;
import com.rhinosoft.docking.fvjv.search.CCustomComboBox;
import com.rhinosoft.docking.fvjv.search.CSearchBar;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.strings.CString;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Vector;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import javax.swing.LayoutStyle;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class CDatePicker
extends CCustomComboBox {
    private static boolean DEBUG = CMainFrame.DEBUG;
    private static int m_nIndex = 0;
    private Calendar m_Calendar;
    private SimpleDateFormat m_dtFormat;
    private JComboBox m_cMonthCombo;
    private JComboBox m_cDayCombo;
    private JComboBox m_cYearCombo;
    private boolean m_bIsAMPM;
    private JComboBox m_cHourCombo;
    private JComboBox m_cMinCombo;
    private JComboBox m_cSecCombo;
    private JComboBox m_cMilliSecCombo;
    private JComboBox m_cAMPMCombo;
    private Timer m_Timer;
    private JToolTip m_ToolTip;
    private Popup m_PopupTip;
    private Timer m_ToolTipExpiredTimer;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CDatePicker.IsValidMonth(0, true);
                CDatePicker.IsValidMonth(1, true);
                CDatePicker.IsValidMonth(11, true);
                CDatePicker.IsValidMonth(12, true);
                CDatePicker.IsValidMonth(13, true);
                CDatePicker.IsValidYear(0, true);
                CDatePicker.IsValidYear(1, true);
                CDatePicker.IsValidYear(1200, true);
                CDatePicker.IsValidYear(1969, true);
                CDatePicker.IsValidYear(1970, true);
                CDatePicker.IsValidYear(1971, true);
                CDatePicker.IsValidYear(1999, true);
                CDatePicker.IsValidYear(2000, true);
                CDatePicker.IsValidYear(2010, true);
                CDatePicker.IsValidYear(9999, true);
                CDatePicker.IsValidYear(10000, true);
                CDatePicker.IsValidDay(1, 1, 0, true);
                CDatePicker.IsValidDay(1, 1, 30, true);
                CDatePicker.IsValidDay(1, 1, 31, true);
                CDatePicker.IsValidDay(2004, 2, 28, true);
                CDatePicker.IsValidDay(2004, 2, 29, true);
                CDatePicker.IsValidDay(2004, 2, 30, true);
                CDatePicker.IsValidDay(2005, 2, 28, true);
                CDatePicker.IsValidDay(2005, 2, 29, true);
                CDatePicker.IsValidDay(2006, 2, 29, true);
                CDatePicker.IsValidDay(2007, 2, 29, true);
                CDatePicker.IsValidDay(2008, 2, 29, true);
                CDatePicker.IsValidDay(2009, 2, 29, true);
                CDatePicker.IsValidDay(2006, 6, 0, true);
                CDatePicker.IsValidDay(2006, 6, 1, true);
                CDatePicker.IsValidDay(2006, 6, 30, true);
                CDatePicker.IsValidDay(2006, 6, 31, true);
                CDatePicker.IsValidDay(2006, 6, 32, true);
                CDatePicker.IsValidDay(2006, 12, 0, true);
                CDatePicker.IsValidDay(2006, 12, 1, true);
                CDatePicker.IsValidDay(2006, 12, 30, true);
                CDatePicker.IsValidDay(2006, 12, 31, true);
                CDatePicker.IsValidDay(2006, 12, 32, true);
                LookAndFeelFactory.installDefaultLookAndFeelAndExtension();
                try {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                }
                catch (ClassNotFoundException cnfe) {
                    cnfe.printStackTrace();
                }
                catch (InstantiationException ie) {
                    ie.printStackTrace();
                }
                catch (IllegalAccessException iae) {
                    iae.printStackTrace();
                }
                catch (UnsupportedLookAndFeelException ulafe) {
                    ulafe.printStackTrace();
                }
                LookAndFeelFactory.installJideExtension(3);
                ((Office2003Painter)Office2003Painter.getInstance()).setColorName("NormalColor");
                DefaultDockableBarDockableHolder mainFrame = new DefaultDockableBarDockableHolder("Dock Test");
                mainFrame.setDefaultCloseOperation(3);
                mainFrame.setSize(800, 600);
                mainFrame.getDockableBarManager().loadLayoutData();
                mainFrame.getDockingManager().loadLayoutData();
                CDockableBar dockBar = new CDockableBar("NorthBar", mainFrame);
                DateFormat dtFormat = DateFormat.getDateInstance(3, Locale.GERMANY);
                CDatePicker dtPicker = new CDatePicker(dtFormat);
                dtPicker.setPreferredSize(new Dimension(100, 20));
                dockBar.add(dtPicker);
                mainFrame.getDockableBarManager().addDockableBar(dockBar);
                dockBar = new CDockableBar("SouthBar", mainFrame);
                mainFrame.getDockableBarManager().addDockableBar(dockBar);
                DockableFrame dockFrame = new CDockableFrame("NorthFrame", mainFrame, 4, 1);
                mainFrame.getDockingManager().addFrame(dockFrame);
                dockFrame = new CDockableFrame("SouthFrame", mainFrame, 4, 2);
                mainFrame.getDockingManager().addFrame(dockFrame);
                dockFrame = mainFrame.getDockingManager().getFrame("NorthFrame");
                RootPaneContainer rpc = (RootPaneContainer)((Object)SwingUtilities.getAncestorOfClass(RootPaneContainer.class, dockFrame));
                CDockablePanel dockPanel = new CDockablePanel(rpc, dockFrame);
                dockFrame.add(dockPanel);
                dockBar = new CSearchBar("SearchBar", dockPanel, true);
                dockBar.setPreferredSize(new Dimension(100, 40));
                dockPanel.AddDockableBar(dockBar);
                dockBar = new CDockableBar("NorthBarSub", dockPanel);
                dockPanel.AddDockableBar(dockBar);
                dockFrame = new CDockableFrame("NorthFrameSub", dockPanel, 4, 8);
                dockPanel.AddDockableFrame(dockFrame);
                mainFrame.setVisible(true);
            }
        });
    }

    public CDatePicker(DateFormat dtFormat) {
        super(false);
        this.InitVars(dtFormat);
    }

    public static boolean IsValidMonth(int nMonth, boolean bShowException) {
        boolean bIsValid;
        block2: {
            bIsValid = false;
            try {
                Calendar cal = Calendar.getInstance();
                cal.setLenient(false);
                cal.set(5, 1);
                cal.set(1, 1970);
                cal.set(2, nMonth);
                Date dt = cal.getTime();
                bIsValid = true;
            }
            catch (Exception e) {
                bIsValid = false;
                if (!bShowException) break block2;
                e.printStackTrace();
            }
        }
        return bIsValid;
    }

    public static boolean IsValidYear(int nYear, boolean bShowException) {
        boolean bIsValid;
        block2: {
            bIsValid = false;
            try {
                Calendar cal = Calendar.getInstance();
                cal.setLenient(false);
                cal.set(2, 0);
                cal.set(5, 1);
                cal.set(1, nYear);
                Date dt = cal.getTime();
                bIsValid = true;
            }
            catch (Exception e) {
                bIsValid = false;
                if (!bShowException) break block2;
                e.printStackTrace();
            }
        }
        return bIsValid;
    }

    public static boolean IsValidDay(int nYear, int nMonth, int nDay, boolean bShowException) {
        boolean bIsValid;
        block2: {
            bIsValid = false;
            try {
                Calendar cal = Calendar.getInstance();
                cal.setLenient(false);
                cal.set(1, nYear);
                cal.set(2, nMonth);
                cal.set(5, nDay);
                Date dt = cal.getTime();
                bIsValid = true;
            }
            catch (Exception e) {
                bIsValid = false;
                if (!bShowException) break block2;
                e.printStackTrace();
            }
        }
        return bIsValid;
    }

    protected void InitVars(DateFormat dtFormat) {
        this.m_Calendar = Calendar.getInstance();
        if (dtFormat != null && dtFormat instanceof SimpleDateFormat) {
            this.m_dtFormat = (SimpleDateFormat)dtFormat;
        }
        this.m_ToolTip = new JToolTip();
        String sToolTipMsg = String.format(CString.LoadString("IDS_DATE_PICKER_TOOLTIP"), this.GetDateFormatterPattern());
        this.m_ToolTip.setTipText(sToolTipMsg);
        this.m_ToolTipExpiredTimer = new Timer(5000, this);
        this.m_bIsAMPM = true;
        this.m_Timer = new Timer(1000, this);
        super.InitVars();
        this.GetTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                CDatePicker.this.StopTooltipExpiredTimer();
                CDatePicker.this.HidePopupTip();
                CDatePicker.this.SetEditorTextColor(Color.BLACK);
                CDatePicker.this.StartTimer();
            }
        });
    }

    private SimpleDateFormat GetDateFormatter() {
        return this.m_dtFormat;
    }

    private String GetDateFormatterPattern() {
        String sPattern = "";
        if (this.GetDateFormatter() != null) {
            sPattern = this.GetDateFormatter().toPattern();
        }
        return sPattern;
    }

    private Popup GetPopupTip() {
        return this.m_PopupTip;
    }

    private void ShowPopupTip() {
        Rectangle bounds = this.getBounds();
        Point ptLoc = this.getLocationOnScreen();
        if (bounds != null && ptLoc != null) {
            int nXLoc = ptLoc.x;
            int nYLoc = ptLoc.y + bounds.height;
            this.m_PopupTip = PopupFactory.getSharedInstance().getPopup(this, this.m_ToolTip, nXLoc, nYLoc);
            this.GetPopupTip().show();
            this.StartTooltipExpired();
        }
    }

    private void HidePopupTip() {
        if (this.GetPopupTip() != null) {
            this.GetPopupTip().hide();
        }
    }

    private void StartTooltipExpired() {
        if (this.m_ToolTipExpiredTimer.isRunning()) {
            this.m_ToolTipExpiredTimer.restart();
        } else {
            this.m_ToolTipExpiredTimer.start();
        }
    }

    private void StopTooltipExpiredTimer() {
        if (this.m_ToolTipExpiredTimer.isRunning()) {
            this.m_ToolTipExpiredTimer.stop();
        }
    }

    private void StartTimer() {
        if (this.m_Timer.isRunning()) {
            this.m_Timer.restart();
        } else {
            this.m_Timer.start();
        }
    }

    private void StopTimer() {
        if (this.m_Timer.isRunning()) {
            this.m_Timer.stop();
        }
    }

    private Calendar GetCalendar() {
        return this.m_Calendar;
    }

    @Override
    protected void InitPopupPanel(JPanel rPanel) {
        this.InitDateControls();
        this.InitTimeControls();
        GroupLayout layout = new GroupLayout(rPanel);
        rPanel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        Dimension dimSize = this.GetMonthCombo().getPreferredSize();
        JComponent[] arComps = new JComponent[]{this.GetMonthCombo(), this.GetDayCombo(), this.GetYearCombo()};
        for (int nIdx = 0; nIdx < arComps.length; ++nIdx) {
            JComponent rSizeComp = arComps[nIdx];
            if (rSizeComp == null) continue;
            Dimension dimAdjSize = new Dimension(rSizeComp.getPreferredSize().width, dimSize.height);
            rSizeComp.setPreferredSize(dimAdjSize);
        }
        JComponent[] arComps2 = new JComponent[]{this.GetMonthCombo(), this.GetDayCombo(), this.GetYearCombo()};
        for (int nIdx = 0; nIdx < arComps2.length; ++nIdx) {
            JComponent rSizeComp = arComps2[nIdx];
            if (rSizeComp == null) continue;
            Dimension dimAdjSize = new Dimension(60, dimSize.height);
            rSizeComp.setMinimumSize(dimAdjSize);
        }
        layout.setHorizontalGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 5, 5).addGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(this.GetFirstComponent(), -1, -2, Short.MAX_VALUE).addComponent(this.GetSecondComponent(), -1, -2, Short.MAX_VALUE).addComponent(this.GetThirdComponent(), -1, -2, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 5, 5));
        layout.setVerticalGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 5, 5).addGroup(layout.createParallelGroup().addComponent(this.GetFirstComponent(), -1, -2, -2).addComponent(this.GetSecondComponent(), -1, -2, -2).addComponent(this.GetThirdComponent(), -1, -2, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 5, 5));
    }

    private Component GetFirstComponent() {
        JComboBox cComp = this.GetMonthCombo();
        String sPattern = this.GetDateFormatterPattern();
        if (sPattern != null && !sPattern.isEmpty()) {
            int nMonthIdx = sPattern.indexOf("M");
            int nDayIdx = sPattern.indexOf("d");
            int nYearIdx = sPattern.indexOf("y");
            int nMin = Math.min(nMonthIdx, nDayIdx);
            if ((nMin = Math.min(nMin, nYearIdx)) == nDayIdx) {
                cComp = this.GetDayCombo();
            } else if (nMin == nYearIdx) {
                cComp = this.GetYearCombo();
            }
        }
        return cComp;
    }

    private Component GetSecondComponent() {
        JComboBox cComp = this.GetDayCombo();
        String sPattern = this.GetDateFormatterPattern();
        if (sPattern != null && !sPattern.isEmpty()) {
            int nMonthIdx = sPattern.indexOf("M");
            int nDayIdx = sPattern.indexOf("d");
            int nYearIdx = sPattern.indexOf("y");
            int nMin = Math.min(nMonthIdx, nDayIdx);
            nMin = Math.min(nMin, nYearIdx);
            if (nMonthIdx > nDayIdx && nMonthIdx < nYearIdx || nMonthIdx > nYearIdx && nMonthIdx < nDayIdx) {
                cComp = this.GetMonthCombo();
            } else if (nYearIdx > nMonthIdx && nYearIdx < nDayIdx || nYearIdx > nDayIdx && nYearIdx < nMonthIdx) {
                cComp = this.GetYearCombo();
            }
        }
        return cComp;
    }

    private Component GetThirdComponent() {
        JComboBox cComp = this.GetYearCombo();
        String sPattern = this.GetDateFormatterPattern();
        if (sPattern != null && !sPattern.isEmpty()) {
            int nMonthIdx = sPattern.indexOf("M");
            int nDayIdx = sPattern.indexOf("d");
            int nYearIdx = sPattern.indexOf("y");
            int nMax = Math.max(nMonthIdx, nDayIdx);
            if ((nMax = Math.max(nMax, nYearIdx)) == nMonthIdx) {
                cComp = this.GetMonthCombo();
            } else if (nMax == nDayIdx) {
                cComp = this.GetDayCombo();
            }
        }
        return cComp;
    }

    private void InitDateControls() {
        Vector<String> asMonths = new Vector<String>();
        Vector<String> asYears = new Vector<String>();
        if (this.GetCalendar() != null) {
            int nMonthMin = this.GetCalendar().getMinimum(2);
            int nMonthMax = this.GetCalendar().getMaximum(2);
            for (int nMonth = nMonthMin; nMonth <= nMonthMax; ++nMonth) {
                String sItem = Integer.toString(nMonth + 1);
                if (sItem == null || sItem.isEmpty()) continue;
                asMonths.add(sItem);
            }
            int nYearMin = this.GetCalendar().getMinimum(1);
            int nYearMax = this.GetCalendar().getMaximum(1);
            nYearMin = 1970;
            nYearMax = this.GetCalendar().get(1);
            for (int nYear = nYearMin; nYear <= nYearMax; ++nYear) {
                String sItem = Integer.toString(nYear);
                if (sItem == null || sItem.isEmpty()) continue;
                asYears.add(sItem);
            }
        }
        this.m_cMonthCombo = new JComboBox(asMonths);
        int nCurMonth = this.GetCalendar().get(2);
        this.m_cMonthCombo.setSelectedIndex(nCurMonth);
        this.m_cMonthCombo.addActionListener(this);
        this.m_cMonthCombo.addKeyListener(this);
        this.m_cYearCombo = new JComboBox(asYears);
        int nCurYear = this.GetCalendar().get(1);
        this.m_cYearCombo.setSelectedIndex(asYears.size() - 1);
        this.m_cYearCombo.addActionListener(this);
        this.m_cYearCombo.addKeyListener(this);
        this.m_cDayCombo = new JComboBox();
        this.m_cDayCombo.addActionListener(this);
        this.m_cDayCombo.addKeyListener(this);
        this.InitDays(nCurYear, nCurMonth);
    }

    private void InitDays(int nYear, int nMonth) {
        this.GetDayCombo().removeActionListener(this);
        this.GetDayCombo().removeAllItems();
        Calendar cal = Calendar.getInstance();
        cal.setLenient(false);
        cal.clear(1);
        if (CDatePicker.IsValidYear(nYear, DEBUG)) {
            cal.set(1, nYear);
        }
        cal.clear(2);
        if (CDatePicker.IsValidMonth(nMonth, DEBUG)) {
            cal.set(2, nMonth);
        }
        cal.set(5, 1);
        boolean bUpdated = false;
        try {
            Date dt = cal.getTime();
            bUpdated = true;
        }
        catch (Exception e) {
            bUpdated = false;
        }
        if (bUpdated) {
            int nActualDayMin = cal.getActualMinimum(5);
            int nActualDayMax = cal.getActualMaximum(5);
            if (DEBUG) {
                System.out.printf("Actual: %d, %d\r\n", nActualDayMin, nActualDayMax);
            }
            for (int nDay = nActualDayMin; nDay <= nActualDayMax; ++nDay) {
                String sItem = Integer.toString(nDay);
                if (sItem == null || sItem.isEmpty()) continue;
                this.GetDayCombo().addItem(sItem);
            }
        }
        this.GetDayCombo().addActionListener(this);
    }

    private void InitTimeControls() {
        Vector<String> asHours = new Vector<String>();
        Vector<String> asMins = new Vector<String>();
        Vector<String> asSecs = new Vector<String>();
        Vector<String> asMilliSecs = new Vector<String>();
        if (this.GetCalendar() != null) {
            int nHourMin = this.GetCalendar().getMinimum(10);
            int nHourMax = this.GetCalendar().getMaximum(10);
            if (this.Is24Hours()) {
                nHourMin = this.GetCalendar().getMinimum(11);
                nHourMax = this.GetCalendar().getMaximum(11);
            }
            for (int nHour = nHourMin; nHour <= nHourMax; ++nHour) {
                String sItem = Integer.toString(nHour + 1);
                if (this.Is24Hours()) {
                    sItem = String.format("%02d", nHour + 1);
                }
                if (sItem == null || sItem.isEmpty()) continue;
                asHours.add(sItem);
            }
            int nMinutesMin = this.GetCalendar().getMinimum(12);
            int nMinutesMax = this.GetCalendar().getMaximum(12);
            for (int nMinute = nMinutesMin; nMinute <= nMinutesMax; ++nMinute) {
                String sItem = String.format("%02d", nMinute);
                if (sItem == null || sItem.isEmpty()) continue;
                asMins.add(sItem);
            }
            int nSecondsMin = this.GetCalendar().getMinimum(13);
            int nSecondsMax = this.GetCalendar().getMaximum(13);
            for (int nSecond = nSecondsMin; nSecond <= nSecondsMax; ++nSecond) {
                String sItem = String.format("%02d", nSecond);
                if (sItem == null || sItem.isEmpty()) continue;
                asSecs.add(sItem);
            }
            int nMillisMin = this.GetCalendar().getMinimum(14);
            int nMillisMax = this.GetCalendar().getMaximum(14);
            for (int nMillsec = nMillisMin; nMillsec <= nMillisMax; ++nMillsec) {
                String sItem = String.format("%04d", nMillsec);
                if (sItem == null || sItem.isEmpty()) continue;
                asMilliSecs.add(sItem);
            }
        }
        this.m_cHourCombo = new JComboBox(asHours);
        int nCurHour = this.GetCalendar().get(10) - 1;
        if (this.Is24Hours()) {
            nCurHour = this.GetCalendar().get(11) - 1;
        }
        this.m_cHourCombo.setSelectedIndex(nCurHour);
        this.m_cMinCombo = new JComboBox(asMins);
        int nCurMin = this.GetCalendar().get(12);
        this.m_cMinCombo.setSelectedIndex(nCurMin);
        this.m_cSecCombo = new JComboBox(asSecs);
        int nCurSec = this.GetCalendar().get(13);
        this.m_cSecCombo.setSelectedIndex(nCurSec);
        this.m_cMilliSecCombo = new JComboBox(asMilliSecs);
        int nCurMilliSec = this.GetCalendar().get(14);
        this.m_cMilliSecCombo.setSelectedIndex(nCurMilliSec);
        String[] asItems = new String[]{CString.LoadString("IDS_DATE_PICKER_TIME_AM"), CString.LoadString("IDS_DATE_PICKER_TIME_PM"), CString.LoadString("IDS_DATE_PICKER_TIME_24")};
        this.m_cAMPMCombo = new JComboBox<String>(asItems);
        if (this.Is24Hours()) {
            this.m_cAMPMCombo.setSelectedIndex(2);
        } else if (this.GetCalendar().get(9) == 1) {
            this.m_cAMPMCombo.setSelectedIndex(1);
        }
    }

    private JComboBox GetMonthCombo() {
        return this.m_cMonthCombo;
    }

    private JComboBox GetDayCombo() {
        return this.m_cDayCombo;
    }

    private JComboBox GetYearCombo() {
        return this.m_cYearCombo;
    }

    private JComboBox GetHourCombo() {
        return this.m_cHourCombo;
    }

    private JComboBox GetMinCombo() {
        return this.m_cMinCombo;
    }

    private JComboBox GetSecCombo() {
        return this.m_cSecCombo;
    }

    private JComboBox GetMilliSecCombo() {
        return this.m_cMilliSecCombo;
    }

    private JComboBox GetAMPMCombo() {
        return this.m_cAMPMCombo;
    }

    public boolean CanDeactivate() {
        boolean bCanDeactivate = false;
        if (this.GetPopup() != null) {
            bCanDeactivate = !this.GetPopup().isVisible();
        }
        return bCanDeactivate;
    }

    public boolean IsAMPM() {
        return this.m_bIsAMPM;
    }

    public boolean Is24Hours() {
        return !this.m_bIsAMPM;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.m_Timer) {
            String sText;
            this.StopTimer();
            if (this.GetTextField() != null && (sText = this.GetTextField().getText()) != null && this.GetDateFormatter() != null) {
                Date dtDate;
                block17: {
                    dtDate = null;
                    try {
                        dtDate = this.GetDateFormatter().parse(sText);
                    }
                    catch (Exception e) {
                        if (!DEBUG) break block17;
                        e.printStackTrace();
                    }
                }
                if (dtDate != null) {
                    this.SetEditorTextColor(Color.GREEN.darker().darker());
                    int nYear = this.GetDateFormatter().getCalendar().get(1);
                    int nMonth = this.GetDateFormatter().getCalendar().get(2);
                    int nDay = this.GetDateFormatter().getCalendar().get(5);
                    this.UpdateDateCtrls(nYear, nMonth, nDay);
                } else {
                    this.SetEditorTextColor(Color.RED.darker());
                    this.ShowPopupTip();
                }
            }
        } else if (event.getSource() == this.m_ToolTipExpiredTimer) {
            this.StopTooltipExpiredTimer();
            this.HidePopupTip();
        } else if (event.getSource() == this.GetYearCombo() || event.getSource() == this.GetMonthCombo()) {
            int nYear = Integer.parseInt((String)this.GetYearCombo().getSelectedItem());
            int nMonth = this.GetMonthCombo().getSelectedIndex();
            int nDay = Integer.parseInt((String)this.GetDayCombo().getSelectedItem());
            this.InitDays(nYear, nMonth - 1);
            if (CDatePicker.IsValidDay(nYear, nMonth, nDay, DEBUG)) {
                this.GetDayCombo().setSelectedItem(Integer.toString(nDay));
            } else {
                nDay = 1;
            }
            this.UpdateEditCtrl(nYear, nMonth, nDay);
        } else if (event.getSource() == this.GetDayCombo()) {
            int nDay;
            int nMonth;
            int nYear = Integer.parseInt((String)this.GetYearCombo().getSelectedItem());
            if (CDatePicker.IsValidDay(nYear, nMonth = this.GetMonthCombo().getSelectedIndex(), nDay = Integer.parseInt((String)this.GetDayCombo().getSelectedItem()), DEBUG)) {
                this.GetDayCombo().setSelectedItem(Integer.toString(nDay));
            } else {
                nDay = 1;
            }
            this.UpdateEditCtrl(nYear, nMonth, nDay);
        } else {
            super.actionPerformed(event);
        }
    }

    private void SetEditorTextColor(Color clr) {
        if (this.GetTextField() != null) {
            this.GetTextField().setForeground(clr);
        }
    }

    private void SetEditorText(String sText) {
        if (this.GetTextField() != null) {
            this.GetTextField().setText(sText);
        }
    }

    private void UpdateDateCtrls(int nYear, int nMonth, int nDay) {
        if (!CDatePicker.IsValidDay(nYear, nMonth, nDay, DEBUG)) {
            Calendar cal = Calendar.getInstance();
            nYear = cal.get(1);
            nMonth = cal.get(2) + 1;
            nDay = cal.get(5);
        }
        if (this.GetYearCombo() != null) {
            this.GetYearCombo().removeActionListener(this);
            this.GetYearCombo().setSelectedItem(Integer.toString(nYear));
            this.GetYearCombo().addActionListener(this);
        }
        if (this.GetMonthCombo() != null) {
            this.GetMonthCombo().removeActionListener(this);
            this.GetMonthCombo().setSelectedItem(Integer.toString(nMonth + 1));
            this.GetMonthCombo().addActionListener(this);
        }
        this.InitDays(nYear, nMonth);
        if (this.GetDayCombo() != null) {
            this.GetDayCombo().setSelectedItem(Integer.toString(nDay));
        }
    }

    private void UpdateEditCtrl(int nYear, int nMonth, int nDay) {
        String sFormatted = String.format("%02d/%02d/%04d", nMonth, nDay, nYear);
        GregorianCalendar cal = new GregorianCalendar(nYear, nMonth, nDay);
        Date dtDate = cal.getTime();
        StringBuffer sBuf = new StringBuffer();
        FieldPosition rFieldPos = new FieldPosition(0);
        StringBuffer sResult = this.GetDateFormatter().format(dtDate, sBuf, rFieldPos);
        if (sResult != null) {
            sFormatted = sResult.toString();
        }
        this.SetEditorText(sFormatted);
    }

    private int ParseInt(String sVal) {
        int nVal;
        block4: {
            nVal = -1;
            if (sVal != null && !sVal.isEmpty()) {
                try {
                    Integer nValue = Integer.parseInt(sVal);
                    if (nValue != null) {
                        nVal = nValue;
                    }
                }
                catch (Exception e) {
                    if (!DEBUG) break block4;
                    e.printStackTrace();
                }
            }
        }
        return nVal;
    }

    public void ShowDefaultDate() {
        int nYear = -1;
        int nMonth = -1;
        int nDay = -1;
        if (this.GetCalendar() != null) {
            nYear = this.GetCalendar().get(1);
            nMonth = this.GetCalendar().get(2);
            nDay = this.GetCalendar().get(5);
        }
        if (this.GetYearCombo() != null) {
            nYear = this.ParseInt((String)this.GetYearCombo().getSelectedItem());
        }
        if (this.GetMonthCombo() != null) {
            nMonth = this.ParseInt((String)this.GetMonthCombo().getSelectedItem()) - 1;
        }
        if (this.GetDayCombo() != null) {
            nDay = this.ParseInt((String)this.GetDayCombo().getSelectedItem());
        }
        if (nYear != -1 && nMonth > -1 && nDay != -1) {
            this.UpdateEditCtrl(nYear, nMonth, nDay);
        }
    }

    public void ClearText() {
        this.SetEditorText(null);
    }

    public long GetDate() {
        long lDate = -1L;
        int nYear = -1;
        int nMonth = -1;
        int nDay = -1;
        if (this.GetCalendar() != null) {
            nYear = this.GetCalendar().get(1);
            nMonth = this.GetCalendar().get(2);
            nDay = this.GetCalendar().get(5);
        }
        if (this.GetYearCombo() != null) {
            nYear = this.ParseInt((String)this.GetYearCombo().getSelectedItem());
        }
        if (this.GetMonthCombo() != null) {
            nMonth = this.ParseInt((String)this.GetMonthCombo().getSelectedItem()) - 1;
        }
        if (this.GetDayCombo() != null) {
            nDay = this.ParseInt((String)this.GetDayCombo().getSelectedItem());
        }
        if (nYear != -1 && nMonth > -1 && nDay != -1) {
            GregorianCalendar cal = new GregorianCalendar(nYear, nMonth, nDay);
            Date dtDate = cal.getTime();
            lDate = dtDate.getTime();
        }
        return lDate;
    }
}

