/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.docking.fvjv.search;

import com.jidesoft.action.DefaultDockableBarDockableHolder;
import com.jidesoft.action.DockableBarHolder;
import com.jidesoft.docking.DockableFrame;
import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.office2003.Office2003Painter;
import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.JideMenu;
import com.jidesoft.swing.JideSplitButton;
import com.jidesoft.swing.JideToggleButton;
import com.rhinosoft.docking.CDockableBar;
import com.rhinosoft.docking.CDockableFrame;
import com.rhinosoft.docking.CDockablePanel;
import com.rhinosoft.docking.fvjv.search.CSearchEvent;
import com.rhinosoft.docking.fvjv.search.CSearchPopup;
import com.rhinosoft.docking.fvjv.search.ISearchListener;
import com.rhinosoft.fvjv.gui.events.CActionFactory;
import com.rhinosoft.fvjv.gui.events.CFVJVAction;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class CSearchBar
extends CDockableBar
implements KeyListener,
FocusListener {
    public static boolean DEBUG = CMainFrame.DEBUG;
    private JTextField m_cSearchField;
    private JideSplitButton m_cSearchBtn;
    private CSearchPopup m_Popup;
    private JideButton m_cCancelBtn;
    private JideButton m_cPauseBtn;
    private JProgressBar m_ProgressBar;
    private boolean m_bCanDeactivatePopup;
    private Vector<ISearchListener> m_aSearchListeners;
    private int m_nPrevValue;
    private Component m_rPrevFocusOwner;
    private boolean m_bSkipShowingPopup;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LookAndFeelFactory.installDefaultLookAndFeelAndExtension();
                try {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                }
                catch (ClassNotFoundException cnfe) {
                    cnfe.printStackTrace();
                }
                catch (InstantiationException ie) {
                    ie.printStackTrace();
                }
                catch (IllegalAccessException iae) {
                    iae.printStackTrace();
                }
                catch (UnsupportedLookAndFeelException ulafe) {
                    ulafe.printStackTrace();
                }
                LookAndFeelFactory.installJideExtension(3);
                ((Office2003Painter)Office2003Painter.getInstance()).setColorName("NormalColor");
                DefaultDockableBarDockableHolder mainFrame = new DefaultDockableBarDockableHolder("Dock Test");
                mainFrame.setDefaultCloseOperation(3);
                mainFrame.setSize(800, 600);
                mainFrame.getDockableBarManager().loadLayoutData();
                mainFrame.getDockingManager().loadLayoutData();
                CDockableBar dockBar = new CDockableBar("NorthBar", mainFrame);
                mainFrame.getDockableBarManager().addDockableBar(dockBar);
                dockBar = new CDockableBar("SouthBar", mainFrame);
                mainFrame.getDockableBarManager().addDockableBar(dockBar);
                DockableFrame dockFrame = new CDockableFrame("NorthFrame", mainFrame, 4, 1);
                mainFrame.getDockingManager().addFrame(dockFrame);
                dockFrame = new CDockableFrame("SouthFrame", mainFrame, 4, 2);
                mainFrame.getDockingManager().addFrame(dockFrame);
                dockFrame = mainFrame.getDockingManager().getFrame("NorthFrame");
                RootPaneContainer rpc = (RootPaneContainer)((Object)SwingUtilities.getAncestorOfClass(RootPaneContainer.class, dockFrame));
                CDockablePanel dockPanel = new CDockablePanel(rpc, dockFrame);
                dockFrame.add(dockPanel);
                dockBar = new CSearchBar("NorthBarSub", dockPanel, true);
                dockPanel.AddDockableBar(dockBar);
                dockFrame = new CDockableFrame("NorthFrameSub", dockPanel, 4, 8);
                dockPanel.AddDockableFrame(dockFrame);
                mainFrame.setVisible(true);
            }
        });
    }

    public CSearchBar(String sKey, DockableBarHolder rDockableBarHolderParent, boolean bShowOtherFileTimes) {
        super(sKey, rDockableBarHolderParent);
        this.InitVars(bShowOtherFileTimes);
    }

    private void InitVars(boolean bShowOtherFileTimes) {
        this.m_aSearchListeners = new Vector();
        this.m_bCanDeactivatePopup = true;
        this.InitSearchField();
        this.InitSearchBtn(bShowOtherFileTimes);
        this.InitCancelBtn();
        this.InitPauseBtn();
        this.InitProgressBar();
        if (this.GetSearchField() != null) {
            this.add(this.GetSearchField());
        }
        if (this.GetSearchBtn() != null) {
            this.add(this.GetSearchBtn());
        }
        if (this.GetCancelBtn() != null) {
            this.add(this.GetCancelBtn());
        }
        if (this.GetPauseBtn() != null) {
            this.add(this.GetPauseBtn());
        }
        if (this.GetProgressBar() != null) {
            this.add(this.GetProgressBar());
        }
        this.m_nPrevValue = 0;
        this.m_bSkipShowingPopup = true;
    }

    protected JideButton GetCancelBtn() {
        return this.m_cCancelBtn;
    }

    protected JideButton GetPauseBtn() {
        return this.m_cPauseBtn;
    }

    protected JTextField GetSearchField() {
        return this.m_cSearchField;
    }

    private void InitCancelBtn() {
        CFVJVAction action = CActionFactory.CreateSearchCancel();
        if (action != null) {
            this.m_cCancelBtn = new JideButton(action);
            action.AddOwner(this.GetCancelBtn());
            action.SetDispatchOnAction(false);
            this.GetCancelBtn().setText("");
        } else {
            this.m_cCancelBtn = new JideButton(CMainFrame.GetJARImage("SearchStop.png"));
        }
        this.HideCancelBtn(false);
        this.GetCancelBtn().addActionListener(this);
    }

    private void InitPauseBtn() {
        CFVJVAction action = CActionFactory.CreateSearchPause();
        if (action != null) {
            this.m_cPauseBtn = new JideToggleButton(action);
            action.AddOwner(this.GetPauseBtn());
            action.SetDispatchOnAction(false);
            this.GetPauseBtn().setText("");
        } else {
            this.m_cPauseBtn = new JideToggleButton(CMainFrame.GetJARImage("SearchPause.png"));
        }
        this.HidePauseBtn();
        this.GetPauseBtn().addActionListener(this);
    }

    private void InitSearchField() {
        this.m_cSearchField = new JTextField();
        Dimension dimSize = this.getPreferredSize();
        this.GetSearchField().setMinimumSize(new Dimension(100, dimSize.height));
        this.GetSearchField().setPreferredSize(new Dimension(200, dimSize.height));
        this.GetSearchField().setMaximumSize(new Dimension(200, dimSize.height));
        this.GetSearchField().addKeyListener(this);
        this.GetSearchField().addFocusListener(this);
    }

    protected JideSplitButton GetSearchBtn() {
        return this.m_cSearchBtn;
    }

    private void InitSearchBtn(boolean bShowOtherFileTimes) {
        CFVJVAction action = CActionFactory.CreateSearchSearch();
        if (action != null) {
            this.m_cSearchBtn = new JideSplitButton(action);
            action.AddOwner(this.GetSearchBtn());
            action.SetDispatchOnAction(false);
        } else {
            this.m_cSearchBtn = new JideSplitButton(CMainFrame.GetJARImage("MagnifingGlass16.png"));
        }
        this.GetSearchBtn().addActionListener(this);
        this.InitPopup(bShowOtherFileTimes);
    }

    private CSearchPopup GetSearchPopup() {
        return this.m_Popup;
    }

    private void SetCanDeactivatePopup(boolean bVal) {
        this.m_bCanDeactivatePopup = bVal;
    }

    private boolean CanDeactivatePopup() {
        return this.m_bCanDeactivatePopup;
    }

    private void InitPopup(boolean bShowOtherFileTimes) {
        this.m_Popup = new CSearchPopup(bShowOtherFileTimes, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                CSearchBar.this.FireOnSearch();
            }
        });
        this.GetSearchPopup().addWindowListener(new WindowAdapter(){

            @Override
            public void windowDeactivated(WindowEvent event) {
                if (DEBUG) {
                    System.out.println("Popup.winodwDeactivated");
                }
                if (CSearchBar.this.CanDeactivatePopup()) {
                    CSearchBar.this.HidePopup();
                }
            }
        });
        this.GetSearchBtn().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent event) {
                CSearchBar.this.SetCanDeactivatePopup(false);
            }

            @Override
            public void mouseExited(MouseEvent event) {
                CSearchBar.this.SetCanDeactivatePopup(true);
            }
        });
        this.GetSearchBtn().setPopupMenuCustomizer(new JideMenu.PopupMenuCustomizer(){

            @Override
            public void customize(JPopupMenu rPopMenu) {
                if (DEBUG) {
                    System.out.println("SearchBtn.JPopup.customize");
                }
                if (CSearchBar.this.m_bSkipShowingPopup) {
                    CSearchBar.this.m_bSkipShowingPopup = false;
                } else {
                    CSearchBar.this.m_bSkipShowingPopup = true;
                    rPopMenu.removeAll();
                    CSearchBar.this.ShowPopup();
                }
            }
        });
    }

    private void ShowPopup() {
        if (this.GetSearchBtn() != null) {
            Rectangle bounds = this.GetSearchBtn().getBounds();
            Point ptLoc = this.GetSearchBtn().getLocationOnScreen();
            if (bounds != null && ptLoc != null) {
                int nXLoc = ptLoc.x;
                int nYLoc = ptLoc.y + bounds.height;
                if (this.GetSearchPopup() != null) {
                    this.GetSearchPopup().pack();
                    Dimension dimScreenSize = Toolkit.getDefaultToolkit().getScreenSize();
                    if (dimScreenSize != null) {
                        if (nXLoc + this.GetSearchPopup().getWidth() > dimScreenSize.width) {
                            nXLoc = dimScreenSize.width - this.GetSearchPopup().getWidth();
                        }
                        if (nYLoc + this.GetSearchPopup().getHeight() > dimScreenSize.height) {
                            nYLoc = dimScreenSize.height - this.GetSearchPopup().getHeight();
                        }
                    }
                    this.GetSearchPopup().setLocation(nXLoc, nYLoc);
                    this.GetSearchPopup().setVisible(true);
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent(this.GetSearchPopup());
                }
            }
        }
    }

    private void HidePopup() {
        if (this.GetSearchPopup() != null && this.GetSearchPopup().CanDeactivate()) {
            this.GetSearchPopup().setVisible(false);
        }
    }

    private Vector<ISearchListener> GetSearchListeners() {
        return this.m_aSearchListeners;
    }

    public void AddSearchListener(ISearchListener rListener) {
        if (this.GetSearchListeners() != null) {
            this.GetSearchListeners().add(rListener);
        }
    }

    public void RemoveSearchListener(ISearchListener rListener) {
        if (this.GetSearchListeners() != null) {
            this.GetSearchListeners().remove(rListener);
        }
    }

    private void FireOnSearch() {
        if (this.IsSearchBtnEnabled() && this.GetSearchPopup() != null) {
            this.HidePopup();
            this.ShowCancelBtn();
            this.ShowPauseBtn();
            this.CheckEmptySearch();
            this.FireSearchEvent();
            if (this.m_rPrevFocusOwner != null) {
                this.m_rPrevFocusOwner.requestFocusInWindow();
            }
        }
    }

    public void FireSearchEvent() {
        CSearchEvent rSearchEvent = this.GetSearchPopup().CreateSearchEvent(this);
        if (rSearchEvent != null) {
            if (this.GetSearchField() != null) {
                rSearchEvent.SetSearchParms(this.GetSearchField().getText());
            }
            if (this.GetSearchListeners() != null) {
                for (ISearchListener rListener : this.GetSearchListeners()) {
                    if (rListener == null) continue;
                    rListener.OnSearch(rSearchEvent);
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent rEvent) {
        if (rEvent.getSource() == this.GetSearchBtn()) {
            this.FireOnSearch();
        } else if (rEvent.getSource() == this.GetCancelBtn()) {
            this.HideCancelBtn(false);
            if (this.GetPauseBtn() != null) {
                this.GetPauseBtn().setSelected(false);
            }
            this.HidePauseBtn();
            CSearchEvent rSearchEvent = new CSearchEvent(this);
            if (rSearchEvent != null) {
                if (this.GetSearchField() != null) {
                    rSearchEvent.SetSearchParms(this.GetSearchField().getText());
                }
                if (this.GetSearchListeners() != null) {
                    for (ISearchListener rListener : this.GetSearchListeners()) {
                        if (rListener == null) continue;
                        rListener.OnCancelSearch(rSearchEvent);
                    }
                }
            }
        } else if (rEvent.getSource() == this.GetPauseBtn()) {
            CSearchEvent rSearchEvent = new CSearchEvent(this);
            if (rSearchEvent != null) {
                rSearchEvent.SetPauseSearch(this.IsPauseBtnDown());
                if (this.GetSearchListeners() != null) {
                    for (ISearchListener rListener : this.GetSearchListeners()) {
                        if (rListener == null) continue;
                        rListener.OnPauseSearch(rSearchEvent);
                    }
                }
            }
        } else {
            super.actionPerformed(rEvent);
        }
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }

    @Override
    public void keyPressed(KeyEvent event) {
        if (event.getKeyCode() == 10) {
            this.FireOnSearch();
        }
    }

    private void CheckEmptySearch() {
        String sText;
        if (this.GetSearchField() != null && ((sText = this.GetSearchField().getText()) == null || sText.isEmpty())) {
            this.GetSearchField().setText("*");
        }
    }

    @Override
    public void keyReleased(KeyEvent event) {
    }

    private void Layout() {
        this.removeAll();
        if (this.GetSearchField() != null) {
            this.add(this.GetSearchField());
        }
        if (this.GetSearchBtn() != null) {
            this.add(this.GetSearchBtn());
        }
        if (this.GetCancelBtn() != null && this.GetCancelBtn().isVisible()) {
            this.add(this.GetCancelBtn());
        }
        if (this.GetPauseBtn() != null && this.GetPauseBtn().isVisible()) {
            this.add(this.GetPauseBtn());
        }
        if (this.GetProgressBar() != null && this.GetProgressBar().isVisible()) {
            this.add(this.GetProgressBar());
        }
        this.validate();
    }

    public void ShowCancelBtn() {
        if (this.GetCancelBtn() != null) {
            this.GetCancelBtn().setVisible(true);
            this.Layout();
        }
        this.ShowProgressBar();
    }

    public void HideCancelBtn(boolean bSearchComplete) {
        if (this.GetCancelBtn() != null) {
            this.GetCancelBtn().setVisible(false);
            this.remove(this.GetCancelBtn());
            this.validate();
        }
        this.HideProgressBar();
    }

    public void ShowPauseBtn() {
        if (this.GetPauseBtn() != null) {
            this.GetPauseBtn().setVisible(true);
            this.Layout();
        }
    }

    public void HidePauseBtn() {
        if (this.GetPauseBtn() != null) {
            this.GetPauseBtn().setVisible(false);
            this.remove(this.GetPauseBtn());
            this.validate();
        }
    }

    private JProgressBar GetProgressBar() {
        return this.m_ProgressBar;
    }

    private void InitProgressBar() {
        this.m_ProgressBar = new JProgressBar(0, 100);
        if (this.GetProgressBar() != null) {
            this.GetProgressBar().setValue(0);
            this.GetProgressBar().setIndeterminate(true);
            this.GetProgressBar().setStringPainted(false);
            Dimension dimSize = this.getPreferredSize();
            this.GetProgressBar().setMinimumSize(new Dimension(80, dimSize.height));
            this.GetProgressBar().setPreferredSize(new Dimension(80, dimSize.height));
            this.GetProgressBar().setMaximumSize(new Dimension(80, dimSize.height));
        }
        this.HideProgressBar();
    }

    public void SetProgressIndex(int nIndex) {
        if (this.GetProgressBar() != null && !this.IsValidPrevValue()) {
            this.GetProgressBar().setValue(nIndex);
        }
    }

    public void SetProgressRange(int nMin, int nMax) {
        if (this.GetProgressBar() != null) {
            if (this.GetProgressBar().getMinimum() != nMin) {
                this.GetProgressBar().setMinimum(nMin);
            }
            if (this.GetProgressBar().getMaximum() != nMax) {
                this.GetProgressBar().setMaximum(nMax);
            }
        }
    }

    public void ShowProgressBar() {
        if (this.GetProgressBar() != null) {
            this.GetProgressBar().setVisible(true);
            this.Layout();
        }
    }

    public void HideProgressBar() {
        if (this.GetProgressBar() != null) {
            this.GetProgressBar().setValue(0);
            this.GetProgressBar().setVisible(false);
            this.remove(this.GetProgressBar());
            this.validate();
        }
    }

    private void EnableSearchBtn() {
        if (this.GetSearchBtn() != null) {
            this.GetSearchBtn().setButtonEnabled(true);
        }
        if (this.GetSearchPopup() != null) {
            this.GetSearchPopup().EnableSearchBtn();
        }
    }

    private void DisableSearchBtn() {
        if (this.GetSearchBtn() != null) {
            this.GetSearchBtn().setButtonEnabled(false);
        }
        if (this.GetSearchPopup() != null) {
            this.GetSearchPopup().DisableSearchBtn();
        }
    }

    private boolean IsSearchBtnEnabled() {
        boolean bIsEnabled = false;
        if (this.GetSearchBtn() != null) {
            bIsEnabled = this.GetSearchBtn().isButtonEnabled();
        }
        return bIsEnabled;
    }

    public boolean IsValidSearchString() {
        return true;
    }

    private boolean IsPauseBtnDown() {
        boolean bIsPauseBtnDown = true;
        if (this.GetPauseBtn() != null) {
            bIsPauseBtnDown = this.GetPauseBtn().isSelected();
        }
        return bIsPauseBtnDown;
    }

    private boolean IsValidPrevValue() {
        return this.m_nPrevValue >= this.GetProgressBar().getMinimum() && this.m_nPrevValue < this.GetProgressBar().getMaximum();
    }

    public void StartProgressBar() {
        if (this.GetProgressBar() != null) {
            if (this.IsValidPrevValue()) {
                this.GetProgressBar().setValue(this.m_nPrevValue);
            }
            this.GetProgressBar().setIndeterminate(true);
        }
    }

    public void StopProgressBar() {
        if (this.GetProgressBar() != null) {
            this.GetProgressBar().setIndeterminate(false);
            this.m_nPrevValue = this.GetProgressBar().getValue();
            this.GetProgressBar().setValue(0);
        }
    }

    @Override
    public void focusGained(FocusEvent event) {
        if (event.getSource() == this.GetSearchField() && !this.IsEventSource(event.getOppositeComponent())) {
            this.m_rPrevFocusOwner = event.getOppositeComponent();
            this.GetSearchField().selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent event) {
    }

    @Override
    public boolean IsEventSource(Object objSource) {
        boolean bIsEventSource = super.IsEventSource(objSource);
        if (!bIsEventSource) {
            bIsEventSource = this.GetSearchPopup().IsEventSource(objSource);
        }
        return bIsEventSource;
    }

    public void RequestFocus() {
        if (this.GetSearchField() != null) {
            this.GetSearchField().requestFocusInWindow();
        }
    }
}

