/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.docking.fvjv.syncFolders;

import com.jidesoft.docking.DockableHolder;
import com.jidesoft.docking.event.DockableFrameEvent;
import com.rhinosoft.docking.CDockableFrame;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.strings.CString;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class COptionsFrame
extends CDockableFrame
implements ActionListener {
    public static final boolean ENABLE_NUM_OF_THREADS = false;
    private JPanel m_cMainPanel;
    private JCheckBox m_cCompareSize;
    private JCheckBox m_cCompareTime;
    private JCheckBox m_cIncludeSubfolders;
    private JCheckBox m_cDelete;
    private JCheckBox m_cPromptOverwriteConfirmations;
    private JCheckBox m_cPromptDeleteConfirmations;
    private JLabel m_cNumOfThreadsLabel;
    private JTextField m_cNumOfThreadsField;
    private JButton m_cCompareBtn;
    private boolean m_bCompareSize = true;
    private boolean m_bCompareDateModified = true;
    private boolean m_bIncludeSubFolders = true;
    private boolean m_bDelete = true;
    private boolean m_bPromptOverwrite = true;
    private boolean m_bPromptDelete = true;
    private int m_nNumOfThreads = 4;
    private ActionListener m_rChangeListener;

    public COptionsFrame(String sKey, DockableHolder rDockableHolderParent, int nInitMode, int nInitSide) {
        super(sKey, rDockableHolderParent, nInitMode, nInitSide);
        this.InitVars();
    }

    private void InitVars() {
        this.setFrameIcon(CMainFrame.GetJARImage("CheckList.png"));
        this.m_cCompareSize = new JCheckBox(CString.LoadString("IDS_COMPARE_SIZE"));
        this.m_cCompareTime = new JCheckBox(CString.LoadString("IDS_COMPARE_TIME"));
        this.m_cIncludeSubfolders = new JCheckBox(CString.LoadString("IDS_INCLUDE_SUBFOLDERS"));
        this.m_cDelete = new JCheckBox(CString.LoadString("IDS_DELETE"));
        this.m_cPromptOverwriteConfirmations = new JCheckBox(CString.LoadString("IDS_PROMPT_OVERWRITE_CONFIRMATIONS"));
        this.m_cPromptDeleteConfirmations = new JCheckBox(CString.LoadString("IDS_PROMPT_DELETE_CONFIRMATIONS"));
        AbstractButton[] aBtns = new AbstractButton[]{this.GetCompareSize(), this.GetCompareTime(), this.GetIncludeSubfolders(), this.GetDelete(), this.GetPromptOverwriteConfirmations(), this.GetPromptDeleteConfirmations()};
        for (int nIdx = 0; nIdx < aBtns.length; ++nIdx) {
            AbstractButton rBtn = aBtns[nIdx];
            if (rBtn == null) continue;
            rBtn.addActionListener(this);
        }
        this.m_cCompareBtn = new JButton(CString.LoadString("IDS_SYNC_COMPARE"));
        if (this.GetCompareBtn() != null) {
            this.GetCompareBtn().setIcon(CMainFrame.GetJARImage("Copy16.png"));
        }
        this.m_cNumOfThreadsLabel = new JLabel(CString.LoadString("IDS_NUM_OF_THREADS"));
        this.m_cNumOfThreadsField = new JTextField();
        if (this.GetNumOfThreadsField() != null) {
            this.GetNumOfThreadsField().addActionListener(this);
        }
        this.m_cMainPanel = new JPanel();
        this.add(new JScrollPane(this.m_cMainPanel));
        this.AdjustLayout(false);
        this.LoadOptions();
        this.ShowNumOfThreadComponents(false);
    }

    private void ShowNumOfThreadComponents(boolean bShow) {
        if (this.GetNumOfThreadsLabel() != null) {
            this.GetNumOfThreadsLabel().setVisible(bShow);
        }
        if (this.GetNumOfThreadsField() != null) {
            this.GetNumOfThreadsField().setVisible(bShow);
        }
    }

    private JCheckBox GetCompareSize() {
        return this.m_cCompareSize;
    }

    private JCheckBox GetCompareTime() {
        return this.m_cCompareTime;
    }

    private JCheckBox GetIncludeSubfolders() {
        return this.m_cIncludeSubfolders;
    }

    private JCheckBox GetDelete() {
        return this.m_cDelete;
    }

    private JCheckBox GetPromptOverwriteConfirmations() {
        return this.m_cPromptOverwriteConfirmations;
    }

    private JCheckBox GetPromptDeleteConfirmations() {
        return this.m_cPromptDeleteConfirmations;
    }

    private JLabel GetNumOfThreadsLabel() {
        return this.m_cNumOfThreadsLabel;
    }

    private JTextField GetNumOfThreadsField() {
        return this.m_cNumOfThreadsField;
    }

    @Override
    public void dockableFrameDocked(DockableFrameEvent event) {
        boolean bIsVertical = false;
        int nCurDockSide = this.getContext().getCurrentDockSide();
        if (nCurDockSide == 8 || nCurDockSide == 4) {
            bIsVertical = true;
        } else if (nCurDockSide == 16) {
            // empty if block
        }
        this.AdjustLayout(bIsVertical);
    }

    private void AdjustLayout(boolean bIsVertical) {
        GroupLayout layout = new GroupLayout(this.m_cMainPanel);
        this.m_cMainPanel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        if (this.GetNumOfThreadsLabel() != null && this.GetNumOfThreadsField() != null) {
            Dimension dimSize = this.GetNumOfThreadsLabel().getSize();
            dimSize.width = 60;
            this.GetNumOfThreadsField().setMinimumSize(dimSize);
            if (this.GetNumOfThreadsLabel().getPreferredSize() != null && this.GetNumOfThreadsField().getPreferredSize() != null) {
                dimSize = new Dimension(this.GetNumOfThreadsLabel().getPreferredSize().width, this.GetNumOfThreadsField().getPreferredSize().height);
                this.GetNumOfThreadsLabel().setMinimumSize(dimSize);
            }
        }
        if (bIsVertical) {
            layout.setHorizontalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(this.GetCompareSize(), -1, -2, -2).addComponent(this.GetCompareTime(), -1, -2, -2).addComponent(this.GetIncludeSubfolders(), -1, -2, -2).addComponent(this.GetDelete(), -1, -2, -2).addComponent(this.GetPromptOverwriteConfirmations(), -1, -2, -2).addComponent(this.GetPromptDeleteConfirmations(), -1, -2, -2).addGroup(layout.createSequentialGroup().addComponent(this.GetNumOfThreadsLabel(), -1, -2, -2).addComponent(this.GetNumOfThreadsField(), -1, -2, -2)).addComponent(this.GetCompareBtn(), -1, -2, -2)));
            layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.GetCompareSize(), -1, -2, -2).addComponent(this.GetCompareTime(), -1, -2, -2).addComponent(this.GetIncludeSubfolders(), -1, -2, -2).addComponent(this.GetDelete(), -1, -2, -2).addComponent(this.GetPromptOverwriteConfirmations(), -1, -2, -2).addComponent(this.GetPromptDeleteConfirmations(), -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, 20).addGroup(layout.createParallelGroup().addComponent(this.GetNumOfThreadsLabel(), -1, -2, -2).addComponent(this.GetNumOfThreadsField(), -1, -2, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.GetCompareBtn(), -1, -2, -2));
        } else {
            layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(this.GetCompareSize(), -1, -2, -2).addComponent(this.GetCompareTime(), -1, -2, -2).addComponent(this.GetIncludeSubfolders(), -1, -2, -2)).addGroup(layout.createParallelGroup().addComponent(this.GetDelete(), -1, -2, -2).addComponent(this.GetPromptOverwriteConfirmations(), -1, -2, -2).addComponent(this.GetPromptDeleteConfirmations(), -1, -2, -2))).addGroup(layout.createSequentialGroup().addComponent(this.GetNumOfThreadsLabel(), -1, -2, -2).addComponent(this.GetNumOfThreadsField(), -1, -2, -2)).addComponent(this.GetCompareBtn(), -1, -2, -2));
            layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(this.GetCompareSize(), -1, -2, -2).addComponent(this.GetCompareTime(), -1, -2, -2).addComponent(this.GetIncludeSubfolders(), -1, -2, -2)).addGroup(layout.createSequentialGroup().addComponent(this.GetDelete(), -1, -2, -2).addComponent(this.GetPromptOverwriteConfirmations(), -1, -2, -2).addComponent(this.GetPromptDeleteConfirmations(), -1, -2, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 20, Short.MAX_VALUE).addGroup(layout.createParallelGroup().addComponent(this.GetNumOfThreadsLabel(), -1, -2, -2).addComponent(this.GetNumOfThreadsField(), -1, -2, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 20, Short.MAX_VALUE).addComponent(this.GetCompareBtn(), -1, -2, -2));
        }
    }

    private void LoadOptions() {
        if (CMainFrame.GET_APP() != null && CMainFrame.GET_APP().GetArchive() != null) {
            this.m_bCompareSize = CMainFrame.GET_APP().GetArchive().GetValueBool("SyncFolders_CompareSize", true);
            this.m_bCompareDateModified = CMainFrame.GET_APP().GetArchive().GetValueBool("SyncFolders_CompareDateModified", true);
            this.m_bIncludeSubFolders = CMainFrame.GET_APP().GetArchive().GetValueBool("SyncFolders_IncludeSubFolders", true);
            this.m_bDelete = CMainFrame.GET_APP().GetArchive().GetValueBool("SyncFolders_Delete", true);
            this.m_bPromptOverwrite = CMainFrame.GET_APP().GetArchive().GetValueBool("SyncFolders_Delete", true);
            this.m_bPromptDelete = CMainFrame.GET_APP().GetArchive().GetValueBool("SyncFolders_Delete", true);
            this.m_nNumOfThreads = CMainFrame.GET_APP().GetArchive().GetValueInt("SyncFolders_NumOfThreads", 4);
        }
        if (this.GetCompareSize() != null) {
            this.GetCompareSize().setSelected(this.IsCompareSize());
        }
        if (this.GetCompareTime() != null) {
            this.GetCompareTime().setSelected(this.IsCompareDateModified());
        }
        if (this.GetIncludeSubfolders() != null) {
            this.GetIncludeSubfolders().setSelected(this.IsIncludeSubfolders());
        }
        if (this.GetDelete() != null) {
            this.GetDelete().setSelected(this.IsDelete());
        }
        if (this.GetPromptOverwriteConfirmations() != null) {
            this.GetPromptOverwriteConfirmations().setSelected(this.IsPromptOverwrite());
        }
        if (this.GetPromptDeleteConfirmations() != null) {
            this.GetPromptDeleteConfirmations().setSelected(this.IsPromptDelete());
        }
        if (this.GetNumOfThreadsField() != null) {
            this.GetNumOfThreadsField().setText(Integer.toString(this.GetNumOfThreads()));
        }
    }

    public boolean IsCompareSize() {
        return this.m_bCompareSize;
    }

    public boolean IsCompareDateModified() {
        return this.m_bCompareDateModified;
    }

    public boolean IsIncludeSubfolders() {
        return this.m_bIncludeSubFolders;
    }

    public boolean IsDelete() {
        return this.m_bDelete;
    }

    public boolean IsPromptOverwrite() {
        return this.m_bPromptOverwrite;
    }

    public boolean IsPromptDelete() {
        return this.m_bPromptDelete;
    }

    public int GetNumOfThreads() {
        return this.m_nNumOfThreads;
    }

    public void SetChangeListener(ActionListener rListener) {
        this.m_rChangeListener = rListener;
    }

    protected ActionListener GetChangeListener() {
        return this.m_rChangeListener;
    }

    protected void FireChangeListener() {
        if (this.GetChangeListener() != null) {
            this.GetChangeListener().actionPerformed(new ActionEvent(this, 0, "OnChangeOptions"));
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        boolean bFireChangeListener = true;
        if (event.getSource() == this.GetCompareSize()) {
            this.m_bCompareSize = this.GetCompareSize().isSelected();
        } else if (event.getSource() == this.GetCompareTime()) {
            this.m_bCompareDateModified = this.GetCompareTime().isSelected();
        } else if (event.getSource() == this.GetIncludeSubfolders()) {
            this.m_bIncludeSubFolders = this.GetIncludeSubfolders().isSelected();
        } else if (event.getSource() == this.GetDelete()) {
            this.m_bDelete = this.GetDelete().isSelected();
        } else if (event.getSource() == this.GetPromptOverwriteConfirmations()) {
            this.m_bPromptOverwrite = this.GetPromptOverwriteConfirmations().isSelected();
            bFireChangeListener = false;
        } else if (event.getSource() == this.GetPromptDeleteConfirmations()) {
            this.m_bPromptDelete = this.GetPromptDeleteConfirmations().isSelected();
            bFireChangeListener = false;
        }
        if (bFireChangeListener) {
            this.FireChangeListener();
        }
    }

    public JButton GetCompareBtn() {
        return this.m_cCompareBtn;
    }

    public void AddCompareListener(ActionListener rListener) {
        if (this.GetCompareBtn() != null) {
            this.GetCompareBtn().addActionListener(rListener);
        }
    }

    public void RemoveCompareListener(ActionListener rListener) {
        if (this.GetCompareBtn() != null) {
            this.GetCompareBtn().removeActionListener(rListener);
        }
    }

    @Override
    public void addKeyListener(KeyListener rListener) {
        super.addKeyListener(rListener);
        if (this.m_cMainPanel != null) {
            this.m_cMainPanel.addKeyListener(rListener);
            for (int nIdx = 0; nIdx < this.m_cMainPanel.getComponentCount(); ++nIdx) {
                Component rComp = this.m_cMainPanel.getComponent(nIdx);
                if (rComp == null) continue;
                rComp.addKeyListener(rListener);
            }
        }
    }

    @Override
    public boolean IsEventSource(Object objSource) {
        boolean bIsEventSource = super.IsEventSource(objSource);
        if (!bIsEventSource && this.m_cMainPanel != null) {
            if (this.m_cMainPanel == objSource) {
                bIsEventSource = true;
            } else {
                for (int nIdx = 0; nIdx < this.m_cMainPanel.getComponentCount() && !bIsEventSource; ++nIdx) {
                    Component rComp = this.m_cMainPanel.getComponent(nIdx);
                    if (rComp == null || rComp != objSource) continue;
                    bIsEventSource = true;
                }
            }
        }
        return bIsEventSource;
    }

    public void SetCompareBtnText(String sCompareBtnText) {
        if (this.GetCompareBtn() != null) {
            this.GetCompareBtn().setText(sCompareBtnText);
        }
    }
}

