/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.docking.fvjv.syncFolders;

import com.jidesoft.docking.DockingManager;
import com.jidesoft.docking.event.DockableFrameEvent;
import com.jidesoft.docking.event.DockableFrameListener;
import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.office2003.Office2003Painter;
import com.jidesoft.swing.JideTabbedPane;
import com.rhinosoft.base.files.CFileSystemUtils;
import com.rhinosoft.base.files.CPath;
import com.rhinosoft.docking.CDockablePanel;
import com.rhinosoft.docking.fvjv.syncFolders.CSyncFolderFrame;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.gui.frames.IArchive;
import com.rhinosoft.fvjv.strings.CString;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class CSyncFoldersDlg
extends JFrame
implements DockingManager.TabbedPaneCustomizer,
DockableFrameListener,
WindowListener {
    private static final boolean DEBUG_FRAME_LISTENERS;
    private long m_lDockKeyID = 0L;
    private JPanel m_cPanel;
    private CDockablePanel m_cDockPanel;
    private CSyncFolderFrame m_cSyncFrame;
    private String m_sArchiveWndKeyX;
    private String m_sArchiveWndKeyY;
    private String m_sArchiveWndKeyWidth;
    private String m_sArchiveWndKeyHeight;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LookAndFeelFactory.installDefaultLookAndFeelAndExtension();
                try {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                }
                catch (ClassNotFoundException cnfe) {
                    cnfe.printStackTrace();
                }
                catch (InstantiationException ie) {
                    ie.printStackTrace();
                }
                catch (IllegalAccessException iae) {
                    iae.printStackTrace();
                }
                catch (UnsupportedLookAndFeelException ulafe) {
                    ulafe.printStackTrace();
                }
                LookAndFeelFactory.installJideExtension(3);
                ((Office2003Painter)Office2003Painter.getInstance()).setColorName("NormalColor");
                CSyncFoldersDlg dlg = new CSyncFoldersDlg();
                String sKey = String.format("SyncFolders_%d", dlg.GetNextID());
                dlg.CreateNewDockFrame(sKey);
                dlg.setVisible(true);
                dlg.setLocation(60, 60);
                dlg.setSize(800, 800);
            }
        });
    }

    public CSyncFoldersDlg() {
        this.InitVars();
    }

    private void InitVars() {
        ImageIcon ico32;
        this.setDefaultCloseOperation(2);
        String sTitle = CString.LoadString("IDS_SYNC_FOLDERS_TIP");
        this.setTitle(sTitle);
        this.m_cPanel = new JPanel();
        this.m_cPanel.setOpaque(false);
        this.setContentPane(this.m_cPanel);
        RootPaneContainer rpc = (RootPaneContainer)((Object)SwingUtilities.getAncestorOfClass(RootPaneContainer.class, this));
        this.m_cDockPanel = new CDockablePanel(rpc, this.m_cPanel);
        this.m_cPanel.setLayout(new BorderLayout());
        this.m_cPanel.add((Component)this.m_cDockPanel, "Center");
        if (this.getDockingManager() != null) {
            this.getDockingManager().setShowWorkspace(false);
            this.getDockingManager().setAutohidable(false);
            this.getDockingManager().setFloatable(false);
            this.getDockingManager().setAllowedDockSides(2);
            this.getDockingManager().setDragAllTabs(false);
            this.getDockingManager().setFloatAllTabs(false);
            this.getDockingManager().setAutohideAllTabs(false);
            this.getDockingManager().setHideAllTabs(false);
            this.getDockingManager().setSideDockAllowed(false);
            this.getDockingManager().setShowTitleBar(false);
            this.getDockingManager().setTabbedPaneCustomizer(this);
            this.getDockingManager().setCrossDraggingAllowed(true);
            this.getDockingManager().setOutlineMode(3);
            this.getDockingManager().setUseDecoratedFloatingContainer(true);
        }
        this.addWindowListener(this);
        ArrayList<Image> aImages = new ArrayList<Image>();
        ImageIcon ico16 = CMainFrame.GetJARImage("FolderSync16.png");
        if (ico16 != null) {
            aImages.add(ico16.getImage());
        }
        if ((ico32 = CMainFrame.GetJARImage("FolderSync32.png")) != null) {
            aImages.add(ico32.getImage());
        }
        if (aImages != null && aImages.size() > 0) {
            this.setIconImages(aImages);
        } else {
            this.setIconImage(ico16.getImage());
        }
    }

    @Override
    public void customize(JideTabbedPane tabbedPane) {
        tabbedPane.setHideOneTab(false);
        tabbedPane.setTabPlacement(1);
        if (CFileSystemUtils.GetFileSysUtils().IsMac()) {
            tabbedPane.setTabShape(0);
        } else {
            tabbedPane.setTabShape(4);
        }
        tabbedPane.setTabResizeMode(1);
        tabbedPane.setShowTabArea(true);
        tabbedPane.setShowTabContent(true);
        tabbedPane.setShowIconsOnTab(true);
        tabbedPane.setShowCloseButton(true);
        tabbedPane.setShowCloseButtonOnTab(true);
        tabbedPane.setScrollSelectedTabOnWheel(true);
        boolean bUseOneNote = false;
        if (bUseOneNote) {
            tabbedPane.setTabColorProvider(JideTabbedPane.ONENOTE_COLOR_PROVIDER);
        } else {
            tabbedPane.setTabColorProvider(null);
        }
    }

    private long GetNextID() {
        return ++this.m_lDockKeyID;
    }

    public void CreateNewDockFrame(String sKey) {
        this.m_cSyncFrame = new CSyncFolderFrame(sKey, this.m_cDockPanel, 4, 2);
        this.m_cSyncFrame.addDockableFrameListener(this);
        if (this.getDockingManager() != null) {
            this.getDockingManager().addFrame(this.m_cSyncFrame);
        }
    }

    private CDockablePanel GetDockPanel() {
        return this.m_cDockPanel;
    }

    protected DockingManager getDockingManager() {
        DockingManager docMgr = null;
        if (this.GetDockPanel() != null) {
            docMgr = this.GetDockPanel().getDockingManager();
        }
        return docMgr;
    }

    @Override
    public void dockableFrameAdded(DockableFrameEvent event) {
        if (DEBUG_FRAME_LISTENERS) {
            System.out.println("dockableFrameAdded");
        }
        event.getDockableFrame().setShowTitleBar(false);
    }

    @Override
    public void dockableFrameRemoved(DockableFrameEvent event) {
        if (DEBUG_FRAME_LISTENERS) {
            System.out.println("dockableFrameRemoved");
        }
        this.CheckLastFrame(event.getDockableFrame().getDockingManager());
    }

    @Override
    public void dockableFrameShown(DockableFrameEvent arg0) {
        if (DEBUG_FRAME_LISTENERS) {
            System.out.println("dockableFrameShown");
        }
    }

    @Override
    public void dockableFrameHidden(DockableFrameEvent arg0) {
        if (DEBUG_FRAME_LISTENERS) {
            System.out.println("dockableFrameHidden");
        }
    }

    @Override
    public void dockableFrameDocked(DockableFrameEvent arg0) {
        if (DEBUG_FRAME_LISTENERS) {
            System.out.println("dockableFrameDocked");
        }
    }

    @Override
    public void dockableFrameFloating(DockableFrameEvent arg0) {
        if (DEBUG_FRAME_LISTENERS) {
            System.out.println("dockableFrameFloating");
        }
    }

    @Override
    public void dockableFrameAutohidden(DockableFrameEvent arg0) {
        if (DEBUG_FRAME_LISTENERS) {
            System.out.println("dockableFrameAutohidden");
        }
    }

    @Override
    public void dockableFrameAutohideShowing(DockableFrameEvent arg0) {
        if (DEBUG_FRAME_LISTENERS) {
            System.out.println("dockableFrameAutohideShowing");
        }
    }

    @Override
    public void dockableFrameActivated(DockableFrameEvent arg0) {
        if (DEBUG_FRAME_LISTENERS) {
            System.out.println("dockableFrameActivated");
        }
    }

    @Override
    public void dockableFrameDeactivated(DockableFrameEvent arg0) {
        if (DEBUG_FRAME_LISTENERS) {
            System.out.println("dockableFrameDeactivated");
        }
    }

    @Override
    public void dockableFrameTabShown(DockableFrameEvent arg0) {
        if (DEBUG_FRAME_LISTENERS) {
            System.out.println("dockableFrameTabShown");
        }
    }

    @Override
    public void dockableFrameTabHidden(DockableFrameEvent arg0) {
        if (DEBUG_FRAME_LISTENERS) {
            System.out.println("dockableFrameTabHidden");
        }
    }

    @Override
    public void dockableFrameMaximized(DockableFrameEvent arg0) {
        if (DEBUG_FRAME_LISTENERS) {
            System.out.println("dockableFrameMaximized");
        }
    }

    @Override
    public void dockableFrameRestored(DockableFrameEvent arg0) {
        if (DEBUG_FRAME_LISTENERS) {
            System.out.println("dockableFrameRestored");
        }
    }

    public void CheckFirstFrame() {
        List<String> asDockKeys;
        if (this.getDockingManager() != null && (asDockKeys = this.getDockingManager().getAllFrameNames()) != null && asDockKeys.size() < 1) {
            String sKey = String.format("SyncFolders_%d", this.GetNextID());
            this.CreateNewDockFrame(sKey);
        }
    }

    private void CheckLastFrame(DockingManager docMgr) {
        List<String> asDockKeys;
        if (this.getDockingManager() != null && docMgr != null && this.getDockingManager() == docMgr && (asDockKeys = this.getDockingManager().getAllFrameNames()) != null && asDockKeys.size() < 1) {
            this.setVisible(false);
        }
    }

    private CSyncFolderFrame GetSyncFrame() {
        return this.m_cSyncFrame;
    }

    public boolean SetLocalPath(CPath rLocalPath) {
        boolean bChanged = false;
        if (this.GetSyncFrame() != null) {
            this.GetSyncFrame().SetLocalPath(rLocalPath);
        }
        return bChanged;
    }

    public boolean SetRemotePath(CPath rRemotePath) {
        boolean bChanged = false;
        if (this.GetSyncFrame() != null) {
            this.GetSyncFrame().SetRemotePath(rRemotePath);
        }
        return bChanged;
    }

    public void OnCompare() {
        if (this.GetSyncFrame() != null) {
            this.GetSyncFrame().OnCompare();
        }
    }

    @Override
    public void windowOpened(WindowEvent event) {
        if (CMainFrame.GET_APP() != null) {
            CMainFrame.GET_APP().AddSyncFolderDlg(this);
        }
    }

    @Override
    public void windowClosing(WindowEvent event) {
        Point ptLoc = this.getLocation();
        Dimension dimSize = this.getSize();
        if (ptLoc != null && dimSize != null) {
            IArchive rArchive;
            System.out.printf("%d,%d   %d,%d", ptLoc.x, ptLoc.y, dimSize.width, dimSize.height);
            if (CMainFrame.GET_APP() != null && CMainFrame.GET_APP().GetArchive() != null && (rArchive = CMainFrame.GET_APP().GetArchive()) != null) {
                int nDefX = CMainFrame.GET_APP().GetDefSyncFoldersX();
                int nDefY = CMainFrame.GET_APP().GetDefSyncFoldersY();
                int nDefWidth = CMainFrame.GET_APP().GetDefSyncFoldersWidth();
                int nDefHeight = CMainFrame.GET_APP().GetDefSyncFoldersHeight();
                rArchive.SetValue(this.GetArchiveKeyWndX(), ptLoc.x, nDefX);
                rArchive.SetValue(this.GetArchiveKeyWndY(), ptLoc.y, nDefY);
                rArchive.SetValue(this.GetArchiveKeyWndWidth(), dimSize.width, nDefWidth);
                rArchive.SetValue(this.GetArchiveKeyWndHeight(), dimSize.height, nDefHeight);
            }
        }
    }

    @Override
    public void windowClosed(WindowEvent event) {
        if (CMainFrame.GET_APP() != null) {
            CMainFrame.GET_APP().RemoveSyncFolderDlg(this);
        }
    }

    @Override
    public void windowIconified(WindowEvent event) {
    }

    @Override
    public void windowDeiconified(WindowEvent event) {
    }

    @Override
    public void windowActivated(WindowEvent event) {
    }

    @Override
    public void windowDeactivated(WindowEvent event) {
    }

    @Override
    public void processEvent(AWTEvent event) {
        super.processEvent(event);
        if (this.GetDockPanel() != null) {
            this.GetDockPanel().dispatchEvent(event);
        }
        switch (event.getID()) {
            case 6053: {
                break;
            }
        }
    }

    public boolean IsEventSource(Object objSource) {
        boolean bIsEventSource = false;
        if (objSource == this) {
            bIsEventSource = true;
        }
        if (!bIsEventSource && this.GetDockPanel() != null) {
            bIsEventSource = this.GetDockPanel().IsEventSource(objSource);
        }
        return bIsEventSource;
    }

    public void SetArchiveKeyWndX(String sArchiveWndKeyX) {
        this.m_sArchiveWndKeyX = sArchiveWndKeyX;
    }

    public void SetArchiveKeyWndY(String sArchiveWndKeyY) {
        this.m_sArchiveWndKeyY = sArchiveWndKeyY;
    }

    public void SetArchiveKeyWndWidth(String sArchiveWndKeyWidth) {
        this.m_sArchiveWndKeyWidth = sArchiveWndKeyWidth;
    }

    public void SetArchiveKeyWndHeight(String sArchiveWndKeyHeight) {
        this.m_sArchiveWndKeyHeight = sArchiveWndKeyHeight;
    }

    public String GetArchiveKeyWndX() {
        return this.m_sArchiveWndKeyX;
    }

    public String GetArchiveKeyWndY() {
        return this.m_sArchiveWndKeyY;
    }

    public String GetArchiveKeyWndWidth() {
        return this.m_sArchiveWndKeyWidth;
    }

    public String GetArchiveKeyWndHeight() {
        return this.m_sArchiveWndKeyHeight;
    }

    static {
        if (CMainFrame.DEBUG) {
            // empty if block
        }
        DEBUG_FRAME_LISTENERS = false;
    }
}

