/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.docking.fvjv.syncFolders;

import com.rhinosoft.FilePanel.CFileTableHeaderRenderer;
import com.rhinosoft.base.CUtils;
import com.rhinosoft.base.gui.tables.CTableUtils;
import com.rhinosoft.base.gui.tables.CTableViewport;
import com.rhinosoft.docking.fvjv.syncFolders.CSyncTableHeaderRenderer;
import com.rhinosoft.docking.fvjv.syncFolders.CSyncTableModel;
import com.rhinosoft.docking.fvjv.syncFolders.CSyncTableRenderer;
import com.rhinosoft.docking.fvjv.syncFolders.CSyncTableRow;
import com.rhinosoft.docking.fvjv.syncFolders.CSyncTableSorter;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.gui.frames.IArchive;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JOptionPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class CSyncTable
extends JScrollPane
implements MouseListener,
KeyListener {
    protected static boolean DEBUG = CMainFrame.DEBUG;
    private boolean m_bIsLocal;
    private CSyncTableModel m_cModel;
    private JTable m_cTable;
    private CSyncTableHeaderRenderer m_cHeaderRenderer;
    private CTableViewport m_cTableViewport;
    private CSyncTableSorter m_cTableSorter;

    public CSyncTable(boolean bIsLocal) {
        this.InitVars(bIsLocal);
    }

    private void InitVars(boolean bIsLocal) {
        TableColumnModel rColModel;
        this.m_bIsLocal = bIsLocal;
        this.m_cModel = new CSyncTableModel();
        this.m_cTable = new JTable(this.m_cModel);
        this.m_cTableViewport = new CTableViewport(this.GetTable());
        if (this.GetTable() != null) {
            this.GetTable().addKeyListener(this);
        }
        if (this.GetTableViewport() != null) {
            ((CTableViewport)this.GetTableViewport()).SetModelCol(0);
            this.GetTableViewport().addMouseListener(this);
            this.m_cTableSorter = new CSyncTableSorter(((CTableViewport)this.GetTableViewport()).GetModelCol(), this.IsLocal());
        }
        if ((rColModel = this.GetTable().getColumnModel()) != null) {
            if (rColModel.getColumnCount() != this.GetModel().getColumnCount()) {
                JOptionPane.showConfirmDialog(null, "These have to match in order for us to set the appropriate column identifiers");
            }
            for (int nIdx = 0; nIdx < rColModel.getColumnCount(); ++nIdx) {
                TableColumn rColumn = rColModel.getColumn(nIdx);
                if (rColumn == null) continue;
                rColumn.setCellRenderer(new CSyncTableRenderer(this.GetTable(), this.GetTableViewport(), this.IsLocal()));
                rColumn.setIdentifier(nIdx);
            }
        }
        this.setViewport(this.GetTableViewport());
        JTableHeader rHeader = this.GetTable().getTableHeader();
        if (rHeader != null) {
            this.m_cHeaderRenderer = new CSyncTableHeaderRenderer(this.GetTableSorter());
            this.m_cHeaderRenderer.UpdateUIRenderer();
            rHeader.setDefaultRenderer(this.m_cHeaderRenderer);
            rHeader.addMouseListener(this);
        }
        if (this.GetTableSorter() != null) {
            this.GetTableSorter().SetSortModelCol(0);
            if (this.GetTableViewport() != null) {
                ((CTableViewport)this.GetTableViewport()).SetModelCol(0);
            }
            this.GetTableSorter().SetSortDirection(1);
        }
    }

    protected CSyncTableSorter GetTableSorter() {
        return this.m_cTableSorter;
    }

    protected JTable GetTable() {
        return this.m_cTable;
    }

    protected CSyncTableModel GetModel() {
        return this.m_cModel;
    }

    private JViewport GetTableViewport() {
        return this.m_cTableViewport;
    }

    public void TurnOnFocusClrs() {
        TableColumnModel rColModel;
        if (this.GetTable() != null && (rColModel = this.GetTable().getColumnModel()) != null) {
            for (int nIdx = 0; nIdx < rColModel.getColumnCount(); ++nIdx) {
                TableColumn rColumn = rColModel.getColumn(nIdx);
                if (rColumn == null || !(rColumn.getCellRenderer() instanceof CSyncTableRenderer)) continue;
                CSyncTableRenderer rCellRenderer = (CSyncTableRenderer)rColumn.getCellRenderer();
                rCellRenderer.TurnOnFocusClrs();
            }
        }
    }

    public void TurnOffFocusClrs() {
        TableColumnModel rColModel;
        if (this.GetTable() != null && (rColModel = this.GetTable().getColumnModel()) != null) {
            for (int nIdx = 0; nIdx < rColModel.getColumnCount(); ++nIdx) {
                TableColumn rColumn = rColModel.getColumn(nIdx);
                if (rColumn == null || !(rColumn.getCellRenderer() instanceof CSyncTableRenderer)) continue;
                CSyncTableRenderer rCellRenderer = (CSyncTableRenderer)rColumn.getCellRenderer();
                rCellRenderer.TurnOffFocusClrs();
            }
        }
    }

    public void ClearTable() {
        if (this.GetModel() != null) {
            this.GetModel().RemoveAllRows();
        }
    }

    @Override
    public void mouseClicked(MouseEvent rEvent) {
        if (SwingUtilities.isLeftMouseButton(rEvent)) {
            int nClickCount = rEvent.getClickCount();
            if (nClickCount == 2) {
                this.OnLeftDoubleClick(rEvent);
            } else {
                this.OnLeftSingleClick(rEvent);
            }
        }
    }

    private void OnLeftDoubleClick(MouseEvent event) {
        JTableHeader jTableHeader;
        Object objSource = event.getSource();
        if (objSource.equals(jTableHeader = this.GetTable().getTableHeader())) {
            int nViewColToExpand = CTableUtils.GetViewColToExpand(this.GetTable(), event.getPoint());
            this.ExpandViewCol(nViewColToExpand);
        }
    }

    private void OnLeftSingleClick(MouseEvent rEvent) {
        JTableHeader jTableHeader;
        int nCursorType;
        if (this.GetTable() != null && (nCursorType = (jTableHeader = this.GetTable().getTableHeader()).getCursor().getType()) == 0 && rEvent.getSource() == jTableHeader) {
            Point ptMouse = rEvent.getPoint();
            int nModelColClicked = CTableUtils.GetModelColFromPoint(this.GetTable(), ptMouse);
            if (nModelColClicked > -1 && nModelColClicked < this.GetTable().getColumnCount()) {
                this.OnSortCol(nModelColClicked);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent rEvent) {
        if (this.GetTable() != null) {
            this.GetTable().requestFocus();
        }
    }

    @Override
    public void mouseReleased(MouseEvent rEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent rEvent) {
    }

    @Override
    public void mouseExited(MouseEvent rEvent) {
    }

    private void OnSortCol(int nSortModelCol) {
        if (this.GetTableSorter() != null && nSortModelCol > -1 && nSortModelCol < this.GetTable().getColumnCount()) {
            int nCurSortCol = this.GetTableSorter().GetSortModelCol();
            if (nCurSortCol == nSortModelCol) {
                int nCurSortDir = this.GetTableSorter().GetSortDirection();
                nCurSortDir = nCurSortDir == 1 ? 2 : 1;
                this.GetTableSorter().SetSortDirection(nCurSortDir);
            } else {
                this.GetTableSorter().SetSortDirection(1);
                ((CTableViewport)this.GetTableViewport()).SetModelCol(nSortModelCol);
                this.GetTableSorter().SetSortModelCol(nSortModelCol);
            }
        }
        this.SortModelRetainSelection();
    }

    private void SortModelRetainSelection() {
        int nSelLeadRow = this.GetSelModel().getLeadSelectionIndex();
        this.SortModel();
    }

    private void SortModelRetainSelection(int nLeadSelIdx, String sLeadSelAbsPath, String[] asSelAbsPaths) {
    }

    protected void SortModel() {
        if (this.GetSelModel() != null) {
            this.GetSelModel().clearSelection();
            this.GetSelModel().setAnchorSelectionIndex(-1);
            this.GetSelModel().setLeadSelectionIndex(-1);
        }
        if (this.GetModel() != null) {
            this.GetModel().Sort(this.GetTableSorter());
        }
    }

    private DefaultListSelectionModel GetSelModel() {
        DefaultListSelectionModel rSelModel = null;
        if (this.GetTable() != null && this.GetTable().getSelectionModel() instanceof DefaultListSelectionModel) {
            rSelModel = (DefaultListSelectionModel)this.GetTable().getSelectionModel();
        }
        return rSelModel;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.GetTable() != null) {
            this.GetTable().updateUI();
            if (this.GetHeaderRenderer() != null) {
                this.GetHeaderRenderer().UpdateUIRenderer();
            }
        }
    }

    private CFileTableHeaderRenderer GetHeaderRenderer() {
        return this.m_cHeaderRenderer;
    }

    private boolean IsLocal() {
        return this.m_bIsLocal;
    }

    public void RemoveSelectedRows() {
        int[] anSelRows;
        if (this.GetTable() != null && this.GetModel() != null && (anSelRows = this.GetTable().getSelectedRows()) != null) {
            for (int nIdx = anSelRows.length - 1; nIdx >= 0; --nIdx) {
                int nSelRowIdx = anSelRows[nIdx];
                this.GetModel().RemoveRow(nSelRowIdx);
            }
        }
    }

    private IArchive GetArchive() {
        IArchive rArchive = null;
        if (CMainFrame.GET_APP() != null) {
            rArchive = CMainFrame.GET_APP().GetArchive();
        }
        return rArchive;
    }

    private void ExpandViewCol(int nViewCol) {
        TableColumn jCol;
        TableColumnModel jColModel;
        if (nViewCol > -1 && nViewCol < this.GetTable().getColumnCount() && (jColModel = this.GetTable().getColumnModel()) != null && (jCol = jColModel.getColumn(nViewCol)) != null) {
            int nMaxCellWidth = this.GetMaxCellWidth(this.GetTable(), nViewCol, this.GetArchive());
            jCol.setPreferredWidth(nMaxCellWidth);
        }
    }

    private int GetMaxCellWidth(JTable jTable, int nViewCol, IArchive rArchive) {
        int nMaxCellWidth = 0;
        if (jTable != null) {
            Object objHeaderVal;
            TableColumn jCol;
            TableColumnModel jColModel;
            FontRenderContext fFontContext;
            Graphics2D g2d;
            TableModel jModel = jTable.getModel();
            Font fFont = jTable.getFont();
            if (fFont != null && (g2d = (Graphics2D)jTable.getGraphics()) != null && (fFontContext = g2d.getFontRenderContext()) != null && (jColModel = jTable.getColumnModel()) != null && (jCol = jColModel.getColumn(nViewCol)) != null && (objHeaderVal = jCol.getHeaderValue()) instanceof String) {
                String sColHeaderTxt = (String)objHeaderVal;
                Rectangle2D rStringBounds = fFont.getStringBounds(sColHeaderTxt, fFontContext);
                int nHeaderTextWidth = (int)rStringBounds.getWidth();
                for (int nRow = 0; nRow < jModel.getRowCount(); ++nRow) {
                    int nTextWidth;
                    int nModelCol = jTable.convertColumnIndexToModel(nViewCol);
                    Object objVal = jModel.getValueAt(nRow, nModelCol);
                    if (!(objVal instanceof CSyncTableRow)) continue;
                    CSyncTableRow rSyncRow = (CSyncTableRow)objVal;
                    String sCellVal = null;
                    switch (nModelCol) {
                        case 0: {
                            sCellVal = rSyncRow.GetFileName();
                            break;
                        }
                        case 1: {
                            sCellVal = rSyncRow.GetResultAsString();
                            break;
                        }
                        case 2: {
                            sCellVal = rSyncRow.GetActionAsString();
                            break;
                        }
                        case 3: {
                            sCellVal = rSyncRow.GetRemoteFileSizeAsString();
                            break;
                        }
                        case 4: {
                            sCellVal = rSyncRow.GetLocalFileSizeAsString();
                            break;
                        }
                        case 5: {
                            sCellVal = rSyncRow.GetRemoteDateModifiedAsString();
                            break;
                        }
                        case 6: {
                            sCellVal = rSyncRow.GetLocalDateModifiedAsString();
                            break;
                        }
                    }
                    if (sCellVal == null || (nTextWidth = (int)(rStringBounds = fFont.getStringBounds(sCellVal, fFontContext)).getWidth()) <= nMaxCellWidth) continue;
                    nMaxCellWidth = nTextWidth;
                }
                nMaxCellWidth = CTableUtils.GetMaxCellWidth(jTable, nViewCol, nHeaderTextWidth, nMaxCellWidth);
            }
        }
        return nMaxCellWidth;
    }

    private JScrollBar GetVerticalScrollBar() {
        JScrollBar rScrollBar = null;
        int nCompCount = this.getComponentCount();
        for (int nIdx = 0; nIdx < nCompCount && rScrollBar == null; ++nIdx) {
            JScrollBar rTempScrollBar;
            Component rNextComp = this.getComponent(nIdx);
            if (rNextComp == null || !(rNextComp instanceof JScrollBar) || (rTempScrollBar = (JScrollBar)rNextComp).getOrientation() != 1) continue;
            rScrollBar = rTempScrollBar;
        }
        return rScrollBar;
    }

    private int GetVerticalScrollBarWidth(boolean bGetUIDefaultValue) {
        int nWidth = 0;
        if (bGetUIDefaultValue) {
            try {
                Object objWidth = UIManager.getDefaults().get("ScrollBar.width");
                Integer nScrollBarWidth = (Integer)objWidth;
                nWidth = nScrollBarWidth;
            }
            catch (Exception exception) {}
        } else if (this.GetVerticalScrollBar() != null) {
            nWidth = this.GetVerticalScrollBar().getWidth();
        }
        return nWidth;
    }

    private boolean IsVerticalScrollBarVisible() {
        boolean bIsVisible = false;
        if (this.GetVerticalScrollBar() != null) {
            bIsVisible = this.GetVerticalScrollBar().isVisible();
        }
        return bIsVisible;
    }

    private int GetTableViewportWidth() {
        Insets aInsets;
        int nWidth = 0;
        if (this.GetTableViewport() != null) {
            nWidth = this.GetTableViewport().getWidth();
        }
        if (this.getBorder() != null && (aInsets = this.getBorder().getBorderInsets(this)) != null) {
            nWidth -= aInsets.left + aInsets.right;
        }
        if (this.GetTableViewport().getBorder() != null && (aInsets = this.GetTableViewport().getBorder().getBorderInsets(this)) != null) {
            nWidth -= aInsets.left + aInsets.right;
        }
        return nWidth -= this.GetVerticalScrollBarWidth(true);
    }

    private int GetDefColWidth() {
        int nViewportWidth;
        int nColWidth = 90;
        int nDivideBy = 7;
        TableColumnModel rColModel = this.GetTable().getColumnModel();
        if (rColModel != null) {
            nDivideBy = rColModel.getColumnCount();
        }
        if ((nColWidth = (nViewportWidth = this.GetTableViewportWidth()) / nDivideBy) < 1) {
            nColWidth = 90;
        }
        return nColWidth;
    }

    private TableColumn GetColumn(int nColID) {
        TableColumn rColumn;
        block3: {
            TableColumnModel rColModel;
            rColumn = null;
            if (this.GetTable() != null && (rColModel = this.GetTable().getColumnModel()) != null) {
                try {
                    int nColIdx = rColModel.getColumnIndex(nColID);
                    rColumn = rColModel.getColumn(nColIdx);
                }
                catch (Exception e) {
                    if (!DEBUG) break block3;
                    e.printStackTrace();
                }
            }
        }
        return rColumn;
    }

    private void LoadColWidths() {
        if (DEBUG && this.GetTableViewport() != null && !this.GetTableViewport().isVisible()) {
            CUtils.ASSERT(this.getClass().getName(), CUtils.GetLineNumber(), "Viewport of the JTable has to be visible before you can calculate valid column widths", true);
        }
        for (int nModelCol = 0; nModelCol < this.GetModel().getColumnCount(); ++nModelCol) {
            TableColumn rColumn;
            int nColWidth = this.GetDefColWidth();
            if (nModelCol == 1 || nModelCol == 2 || nModelCol == 3 || nModelCol == 4) {
                nColWidth = 90;
            }
            if ((rColumn = this.GetColumn(nModelCol)) == null) continue;
            rColumn.setPreferredWidth(nColWidth);
        }
    }

    protected void OnInitialUpdate() {
        this.LoadColWidths();
    }

    public void GetData(Vector<CSyncTableRow> aRows) {
        if (this.GetModel() != null) {
            this.GetModel().GetData(aRows);
        }
    }

    @Override
    public void addKeyListener(KeyListener rListener) {
        super.addKeyListener(rListener);
        if (this.GetTable() != null) {
            this.GetTable().addKeyListener(rListener);
        }
    }

    public boolean IsEventSource(Object objSource) {
        boolean bIsEventSource = false;
        if (objSource == this) {
            bIsEventSource = true;
        }
        if (!bIsEventSource && this.GetTable() != null && this.GetTable() == objSource) {
            bIsEventSource = true;
        }
        return bIsEventSource;
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }

    @Override
    public void keyPressed(KeyEvent event) {
        Object objSource = event.getSource();
        int nKeyCode = event.getKeyCode();
        switch (nKeyCode) {
            case 35: 
            case 36: {
                if (event.getSource() != this.GetTable()) break;
                if (this.GetModel() != null && this.GetSelModel() != null) {
                    if (event.isShiftDown()) {
                        if (nKeyCode == 36) {
                            this.GetSelModel().setSelectionInterval(this.GetSelModel().getAnchorSelectionIndex(), 0);
                        } else {
                            this.GetSelModel().setSelectionInterval(this.GetSelModel().getAnchorSelectionIndex(), this.GetModel().getSize() - 1);
                        }
                    } else if (event.isControlDown()) {
                        if (nKeyCode == 36) {
                            this.GetSelModel().moveLeadSelectionIndex(0);
                        } else {
                            this.GetSelModel().moveLeadSelectionIndex(this.GetModel().getSize() - 1);
                        }
                    } else if (nKeyCode == 36) {
                        this.GetSelModel().setSelectionInterval(0, 0);
                    } else {
                        this.GetSelModel().setSelectionInterval(this.GetModel().getSize() - 1, this.GetModel().getSize() - 1);
                    }
                    Rectangle rRect = this.GetTable().getCellRect(this.GetSelModel().getLeadSelectionIndex(), 0, true);
                    this.GetTable().scrollRectToVisible(rRect);
                }
                event.consume();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent event) {
    }
}

