/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.docking.fvjv.syncFolders;

import com.rhinosoft.FilePanel.CDashedBorder;
import com.rhinosoft.FilePanel.ICellRendererColumnWidths;
import com.rhinosoft.base.gui.CColorUtils;
import com.rhinosoft.base.gui.tables.CTableViewport;
import com.rhinosoft.docking.fvjv.syncFolders.CSyncTableRow;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;

public class CSyncTableRenderer
extends DefaultTableCellRenderer
implements ICellRendererColumnWidths {
    private JTable m_rTable;
    private JViewport m_rViewport;
    private boolean m_bHasFocusClrs;
    private boolean m_bIsLocal;

    public CSyncTableRenderer(JTable rTable, JViewport rViewport, boolean bIsLocal) {
        this.m_bIsLocal = bIsLocal;
        this.m_rTable = rTable;
        this.m_rViewport = rViewport;
        if (rTable != null) {
            rTable.setShowGrid(false);
            rTable.setIntercellSpacing(new Dimension(0, 0));
            rTable.setRowHeight(17);
            rTable.setAutoResizeMode(0);
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable rTable, Object rVal, boolean bIsSelected, boolean bHasFocus, int nRow, int nCol) {
        super.getTableCellRendererComponent(rTable, rVal, bIsSelected, bHasFocus, nRow, nCol);
        this.UpdateHasFocusColor(bIsSelected, nCol, rTable, this);
        nCol = rTable.convertColumnIndexToModel(nCol);
        Font font = (Font)UIManager.get("List.font");
        if (font == null) {
            font = rTable.getFont();
        }
        rTable.setFont(font);
        Border rCellBorder = this.GetCellBorder(rTable, bIsSelected, nRow, nCol);
        this.setBorder(rCellBorder);
        int nAlignHorz = 2;
        if (rVal instanceof CSyncTableRow) {
            CSyncTableRow rRow = (CSyncTableRow)rVal;
            switch (nCol) {
                case 0: {
                    this.setIcon(rRow.GetFileIcon(this.IsLocal()));
                    this.setText(rRow.GetFileName());
                    break;
                }
                case 1: {
                    this.setText(rRow.GetResultAsString());
                    break;
                }
                case 2: {
                    this.setIcon(rRow.GetActionIcon());
                    this.setText(rRow.GetActionAsString());
                    break;
                }
                case 3: {
                    this.setText(rRow.GetRemoteFileSizeAsString());
                    nAlignHorz = 4;
                    break;
                }
                case 4: {
                    this.setText(rRow.GetLocalFileSizeAsString());
                    nAlignHorz = 4;
                    break;
                }
                case 5: {
                    this.setText(rRow.GetRemoteDateModifiedAsString());
                    break;
                }
                case 6: {
                    this.setText(rRow.GetLocalDateModifiedAsString());
                    break;
                }
            }
        }
        this.setHorizontalAlignment(nAlignHorz);
        return this;
    }

    protected Border GetCellBorder(JTable jTable, boolean bIsSelected, int nRow, int nCol) {
        Border jCellBorder = null;
        int nLeadRow = -1;
        ListSelectionModel jSelModel = jTable.getSelectionModel();
        if (jSelModel != null) {
            nLeadRow = jSelModel.getLeadSelectionIndex();
        }
        int nTop = 1;
        int nBtm = 1;
        int nLeft = 0;
        int nRight = 0;
        if (nCol == 0) {
            nLeft = 1;
        } else if (nCol == jTable.getColumnCount() - 1) {
            nRight = 1;
        }
        jCellBorder = nRow == nLeadRow ? new CDashedBorder(nTop, nLeft, nBtm, nRight, Color.DARK_GRAY) : BorderFactory.createEmptyBorder(nTop, nLeft, nBtm, nRight);
        jCellBorder = BorderFactory.createCompoundBorder(jCellBorder, BorderFactory.createEmptyBorder(0, 2, 0, 2));
        return jCellBorder;
    }

    private void UpdateHasFocusColor(boolean bIsSelected, int nCol, JTable rTable, Component ... arComps) {
        Color clrTableFore = UIManager.getColor("Table.foreground");
        Color clrTableBack = UIManager.getColor("Table.background");
        Color clrTableForeSel = UIManager.getColor("Table.selectionForeground");
        Color clrTableBackSel = UIManager.getColor("Table.selectionBackground");
        Color clrFore = clrTableFore;
        Color clrBack = clrTableBack;
        if (bIsSelected) {
            clrFore = clrTableForeSel;
            clrBack = clrTableBackSel;
            if (!this.GetHasFocusClrs()) {
                clrBack = Color.LIGHT_GRAY;
                if (!CColorUtils.IsADarkColor(clrFore) && !CColorUtils.IsADarkColor(clrBack)) {
                    clrFore = clrTableFore.getRGB() < clrTableForeSel.getRGB() ? clrTableFore : clrTableForeSel;
                } else if (CColorUtils.IsADarkColor(clrFore) && CColorUtils.IsADarkColor(clrBack)) {
                    clrFore = clrTableFore.getRGB() > clrTableForeSel.getRGB() ? clrTableFore : clrTableForeSel;
                }
            }
        } else if (this.GetViewport() instanceof CTableViewport) {
            CTableViewport rViewport = (CTableViewport)this.GetViewport();
            int nSortCol = rTable.convertColumnIndexToModel(nCol);
            if (rViewport.GetModelCol() == nSortCol) {
                clrBack = rViewport.GetSortColor();
            }
        }
        if (arComps != null) {
            for (int nIdx = 0; nIdx < arComps.length; ++nIdx) {
                Component rNextComp = arComps[nIdx];
                if (rNextComp == null) continue;
                rNextComp.setForeground(clrFore);
                rNextComp.setBackground(clrBack);
            }
        }
        this.setForeground(clrFore);
        this.setBackground(clrBack);
    }

    private JViewport GetViewport() {
        return this.m_rViewport;
    }

    public void SetHasFocusClrs(boolean bHasFocusClrs) {
        this.m_bHasFocusClrs = bHasFocusClrs;
    }

    public boolean GetHasFocusClrs() {
        return this.m_bHasFocusClrs;
    }

    public void TurnOnFocusClrs() {
        this.SetHasFocusClrs(true);
    }

    public void TurnOffFocusClrs() {
        this.SetHasFocusClrs(false);
    }

    private boolean IsLocal() {
        return this.m_bIsLocal;
    }

    @Override
    public int GetBorderWidthLeftRight() {
        Insets jInset;
        int nBorderWidth = 0;
        Border jBorder = this.getBorder();
        if (jBorder != null && (jInset = jBorder.getBorderInsets(this)) != null) {
            nBorderWidth += jInset.left + jInset.right;
        }
        return nBorderWidth;
    }

    @Override
    public int GetIconWidth() {
        int nIconWidth = 0;
        Icon icoImage = this.getIcon();
        if (icoImage != null) {
            nIconWidth = icoImage.getIconWidth();
        }
        return nIconWidth;
    }

    @Override
    public int GetIconTxtGap(boolean bTestForIcon) {
        int nGap = 0;
        if (bTestForIcon) {
            Icon icoImage = this.getIcon();
            if (icoImage != null) {
                nGap = this.getIconTextGap();
            }
        } else {
            nGap = this.getIconTextGap();
        }
        return nGap;
    }
}

