/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.docking.fvjv.syncFolders;

import com.rhinosoft.FilePanel.CFileTableCellRenderer;
import com.rhinosoft.base.files.CFile;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.gui.frames.IArchive;
import com.rhinosoft.fvjv.strings.CString;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class CSyncTableRow {
    public static final int COL_ROW_NAME = 0;
    public static final int COL_ROW_RESULTS = 1;
    public static final int COL_ROW_ACTION = 2;
    public static final int COL_ROW_REMOTE_SIZE = 3;
    public static final int COL_ROW_LOCAL_SIZE = 4;
    public static final int COL_ROW_REMOTE_DATE_MODIFIED = 5;
    public static final int COL_ROW_LOCAL_DATE_MODIFIED = 6;
    public static final int COL_MAX = 7;
    private CFile m_fLocalFile;
    private CFile m_fRemoteFile;
    private String m_sAbsLocalRootPath;
    private String m_sAbsRemoteRootPath;
    private String m_sFileName;
    private ROW_ACTION m_nAction;
    private ROW_RESULT m_nResult;

    public CSyncTableRow() {
        this.InitVars();
    }

    public CSyncTableRow(CSyncTableRow rCopyFrom) {
        this.Copy(rCopyFrom);
    }

    private void InitVars() {
        this.m_nAction = ROW_ACTION.EXCLUDE;
    }

    private boolean Copy(CSyncTableRow rCopyFrom) {
        boolean bChanged = false;
        if (rCopyFrom != null) {
            if (rCopyFrom.GetLocalFile() != null && this.SetLocalFile(rCopyFrom.GetLocalFile().clone())) {
                bChanged = true;
            }
            if (rCopyFrom.GetRemoteFile() != null && this.SetRemoteFile(rCopyFrom.GetRemoteFile().clone())) {
                bChanged = true;
            }
            if (this.SetFileName(rCopyFrom.GetFileName())) {
                bChanged = true;
            }
            if (this.SetAction(rCopyFrom.GetAction())) {
                bChanged = true;
            }
            if (this.SetResult(rCopyFrom.GetResult())) {
                bChanged = true;
            }
        }
        return bChanged;
    }

    public Object clone() {
        return new CSyncTableRow(this);
    }

    public boolean SetFileName(String sFileName) {
        boolean bChanged = false;
        if (this.m_sFileName == null || !this.m_sFileName.equals(sFileName)) {
            this.m_sFileName = sFileName;
            bChanged = true;
        }
        return bChanged;
    }

    public String GetFileName() {
        return this.m_sFileName;
    }

    public boolean SetAction(ROW_ACTION nAction) {
        boolean bChanged = false;
        if (this.m_nAction != nAction) {
            this.m_nAction = nAction;
            bChanged = true;
        }
        return bChanged;
    }

    public ROW_ACTION GetAction() {
        return this.m_nAction;
    }

    public Icon GetActionIcon() {
        ImageIcon icon = null;
        switch (this.GetAction()) {
            case UPLOAD: {
                icon = CMainFrame.GetJARImage("Upload.png");
                break;
            }
            case DOWNLOAD: {
                icon = CMainFrame.GetJARImage("Download.png");
                break;
            }
            case DELETE: {
                icon = CMainFrame.GetJARImage("Delete.png");
                break;
            }
        }
        return icon;
    }

    public String GetActionAsString() {
        String sRowAction = "";
        switch (this.GetAction()) {
            case UPLOAD: {
                sRowAction = CString.LoadString("IDS_SYNC_ACTION_UPLOAD");
                break;
            }
            case DOWNLOAD: {
                sRowAction = CString.LoadString("IDS_SYNC_ACTION_DOWNLOAD");
                break;
            }
            case DELETE: {
                sRowAction = CString.LoadString("IDS_SYNC_ACTION_DELETE");
                break;
            }
            case SYNCHRONIZED: {
                sRowAction = CString.LoadString("IDS_SYNC_ACTION_SYNCHRONIZED");
                break;
            }
            case ERROR: {
                sRowAction = CString.LoadString("IDS_SYNC_ACTION_ERROR");
                break;
            }
            default: {
                sRowAction = CString.LoadString("IDS_SYNC_ACTION_EXCLUDE");
            }
        }
        return sRowAction;
    }

    public boolean SetAction(String sAction) {
        boolean bChanged = false;
        if (sAction != null && !sAction.isEmpty()) {
            if (sAction.equals(CString.LoadString("IDS_SYNC_ACTION_EXCLUDE"))) {
                bChanged = this.SetAction(ROW_ACTION.EXCLUDE);
            } else if (sAction.equals(CString.LoadString("IDS_SYNC_ACTION_UPLOAD"))) {
                bChanged = this.SetAction(ROW_ACTION.UPLOAD);
            } else if (sAction.equals(CString.LoadString("IDS_SYNC_ACTION_DOWNLOAD"))) {
                bChanged = this.SetAction(ROW_ACTION.DOWNLOAD);
            } else if (sAction.equals(CString.LoadString("IDS_SYNC_ACTION_DELETE"))) {
                bChanged = this.SetAction(ROW_ACTION.DELETE);
            } else if (sAction.equals(CString.LoadString("IDS_SYNC_ACTION_SYNCHRONIZED"))) {
                bChanged = this.SetAction(ROW_ACTION.SYNCHRONIZED);
            }
        }
        return bChanged;
    }

    public boolean SetResult(ROW_RESULT nResult) {
        boolean bChanged = false;
        if (this.m_nResult != nResult) {
            this.m_nResult = nResult;
            bChanged = true;
        }
        return bChanged;
    }

    public ROW_RESULT GetResult() {
        return this.m_nResult;
    }

    public String GetResultAsString() {
        String sRowResult = "";
        switch (this.GetResult()) {
            case NOT_ON_LOCAL: {
                sRowResult = CString.LoadString("IDS_SYNC_RESULT_NOT_ON_LOCAL");
                break;
            }
            case NOT_ON_REMOTE: {
                sRowResult = CString.LoadString("IDS_SYNC_RESULT_NOT_ON_REMOTE");
                break;
            }
            case OLDER: {
                sRowResult = CString.LoadString("IDS_SYNC_RESULT_OLDER");
                break;
            }
            case NEWER: {
                sRowResult = CString.LoadString("IDS_SYNC_RESULT_NEWER");
                break;
            }
            case SMALLER: {
                sRowResult = CString.LoadString("IDS_SYNC_RESULT_SMALLER");
                break;
            }
            case LARGER: {
                sRowResult = CString.LoadString("IDS_SYNC_RESULT_LARGER");
                break;
            }
            case SYNCHRONIZED: {
                sRowResult = CString.LoadString("IDS_SYNC_RESULT_SYNCHRONIZED");
                break;
            }
            case ERROR: {
                sRowResult = CString.LoadString("IDS_SYNC_RESULT_ERROR");
                break;
            }
            default: {
                sRowResult = CString.LoadString("IDS_SYNC_RESULT_EXCLUDE");
            }
        }
        return sRowResult;
    }

    public String GetRemoteFileSizeAsString() {
        String sRet = CString.LoadString("IDS_NOT_AVAILABLE");
        if (this.GetRemoteFile() != null && !this.GetRemoteFile().IsDir() && this.GetRemoteFile().GetSize() > -1L) {
            sRet = CFile.FormatFileSize(this.GetRemoteFile().GetSize(), false);
        }
        return sRet;
    }

    public String GetLocalFileSizeAsString() {
        String sRet = CString.LoadString("IDS_NOT_AVAILABLE");
        if (this.GetLocalFile() != null && !this.GetLocalFile().IsDir() && this.GetLocalFile().GetSize() > -1L) {
            sRet = CFile.FormatFileSize(this.GetLocalFile().GetSize(), false);
        }
        return sRet;
    }

    private IArchive GetArchive() {
        IArchive archive = null;
        if (CMainFrame.GET_APP() != null) {
            archive = CMainFrame.GET_APP().GetArchive();
        }
        return archive;
    }

    public String GetRemoteDateModifiedAsString() {
        String sRet = CString.LoadString("IDS_NOT_AVAILABLE");
        if (this.GetRemoteFile() != null && this.GetRemoteFile().GetModifiedDate() != null && this.GetRemoteFile().GetModifiedDate().getTime() > 0L) {
            sRet = CFileTableCellRenderer.FmtDisplayDate(this.GetRemoteFile().GetModifiedDate(), this.GetArchive(), false);
        }
        return sRet;
    }

    public String GetLocalDateModifiedAsString() {
        String sRet = CString.LoadString("IDS_NOT_AVAILABLE");
        if (this.GetLocalFile() != null && this.GetLocalFile().GetModifiedDate() != null && this.GetLocalFile().GetModifiedDate().getTime() > 0L) {
            sRet = CFileTableCellRenderer.FmtDisplayDate(this.GetLocalFile().GetModifiedDate(), this.GetArchive(), false);
        }
        return sRet;
    }

    public CFile GetLocalFile() {
        return this.m_fLocalFile;
    }

    public boolean SetLocalFile(CFile fFile) {
        boolean bChanged = false;
        if (this.m_fLocalFile != fFile) {
            bChanged = true;
            this.m_fLocalFile = fFile;
        }
        return bChanged;
    }

    public CFile GetRemoteFile() {
        return this.m_fRemoteFile;
    }

    public boolean SetRemoteFile(CFile fFile) {
        boolean bChanged = false;
        if (this.m_fRemoteFile != fFile) {
            bChanged = true;
            this.m_fRemoteFile = fFile;
        }
        return bChanged;
    }

    public Icon GetFileIcon(boolean bIsLocal) {
        Icon icon = null;
        CFile fFirst = null;
        CFile fNext = null;
        if (bIsLocal) {
            fFirst = this.GetLocalFile();
            fNext = this.GetRemoteFile();
        } else {
            fFirst = this.GetRemoteFile();
            fNext = this.GetLocalFile();
        }
        if (fFirst != null) {
            icon = fFirst.GetIcon16();
        }
        if (icon == null && fNext != null) {
            icon = fNext.GetIcon16();
        }
        if (this.GetResult() == ROW_RESULT.SYNCHRONIZED) {
            icon = CMainFrame.GetJARImage("RunningDone.png");
        } else if (this.GetResult() == ROW_RESULT.ERROR) {
            icon = CMainFrame.GetJARImage("RunningError.png");
        }
        return icon;
    }

    public boolean SetLocalRootPath(String sPath) {
        boolean bChanged = false;
        if (this.m_sAbsLocalRootPath == null || !this.m_sAbsLocalRootPath.equals(sPath)) {
            this.m_sAbsLocalRootPath = sPath;
            bChanged = true;
        }
        return bChanged;
    }

    public String GetLocalRootPath() {
        return this.m_sAbsLocalRootPath;
    }

    public boolean SetRemoteRootPath(String sPath) {
        boolean bChanged = false;
        if (this.m_sAbsRemoteRootPath == null || !this.m_sAbsRemoteRootPath.equals(sPath)) {
            this.m_sAbsRemoteRootPath = sPath;
            bChanged = true;
        }
        return bChanged;
    }

    public String GetRemoteRootPath() {
        return this.m_sAbsRemoteRootPath;
    }

    public static enum ROW_RESULT {
        EXCLUDE,
        SYNCHRONIZED,
        ERROR,
        NOT_ON_LOCAL,
        NOT_ON_REMOTE,
        OLDER,
        NEWER,
        SMALLER,
        LARGER;

    }

    public static enum ROW_ACTION {
        EXCLUDE,
        SYNCHRONIZED,
        ERROR,
        UPLOAD,
        DOWNLOAD,
        DELETE;

    }
}

