/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.cache;

import com.rhinosoft.base.files.CFileSystemUtils;
import com.rhinosoft.fvjv.cache.CCache;
import com.rhinosoft.fvjv.cache.CFileCachedItem;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import java.io.File;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileSystemView;

public class CFileCache
extends CCache {
    public static final String KEY_EXT_DIR = "DirExt";
    public static final String KEY_EXT_NONE = "NoExt";
    public static final String NAME_FOLDER = "Folder";
    private HashMap<String, CFileCachedItem> m_aMappedItems;
    private String[] m_asExcludeFromLocalCache = new String[]{"exe", "lnk", "ico"};

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CFileCache rCache = new CFileCache("C:\\Users\\dbladorn\\Documents\\FTP Voyager JV\\Cache\\Images\\Files");
            }
        });
    }

    public CFileCache(String sAbsCacheDir) {
        super(sAbsCacheDir);
        this.InitMap();
    }

    protected String GetExt(String sAbsPath) {
        String sExt = null;
        if (sAbsPath != null && !sAbsPath.isEmpty()) {
            String sFileName = sAbsPath;
            int nLoc = (sFileName = sFileName.replace('\\', '/')).lastIndexOf(47);
            if (nLoc >= 0 && nLoc + 1 < sFileName.length()) {
                sFileName = sFileName.substring(nLoc + 1);
            }
            if ((nLoc = sFileName.lastIndexOf(46)) >= 0 && nLoc + 1 < sFileName.length()) {
                sExt = sFileName.substring(nLoc + 1);
            }
        }
        return sExt;
    }

    protected String GetKey(boolean bIsLocal, boolean bIsDrive, boolean bIsDir, String sAbsPath) {
        String sExt;
        String sKey = KEY_EXT_NONE;
        if (bIsDrive) {
            sKey = sAbsPath;
        } else if (bIsDir) {
            sKey = KEY_EXT_DIR;
            if (CFileSystemUtils.GetFileSysUtils().IsRoot(sAbsPath)) {
                sKey = sAbsPath;
            } else if (sAbsPath != null && sAbsPath.endsWith("LocalRoot")) {
                sKey = "LocalRoot";
            }
            if (!this.CanStoreOnDisk(bIsLocal, bIsDrive, bIsDir, sAbsPath)) {
                sKey = sAbsPath;
            }
        } else if (sAbsPath != null && !sAbsPath.isEmpty() && (sExt = this.GetExt(sAbsPath)) != null && !sExt.isEmpty()) {
            sKey = sExt.toLowerCase();
            if (!this.CanStoreOnDisk(bIsLocal, bIsDrive, bIsDir, sAbsPath)) {
                sKey = sAbsPath;
            }
        }
        return sKey;
    }

    protected HashMap<String, CFileCachedItem> GetMappedItems() {
        return this.m_aMappedItems;
    }

    private void InitMap() {
        this.m_aMappedItems = new HashMap();
        if (this.GetMappedItems() != null) {
            File fCacheDir = this.GetCacheDir();
            File[] afFiles = fCacheDir.listFiles();
            for (int nIdx = 0; nIdx < afFiles.length; ++nIdx) {
                File fNext = afFiles[nIdx];
                if (fNext == null || !fNext.exists()) continue;
                boolean bIsDrive = FileSystemView.getFileSystemView().isDrive(fNext);
                String sKey = this.GetKey(true, bIsDrive, fNext.isDirectory(), fNext.getPath());
                CFileCachedItem rItem = this.CreateMapItem(fNext);
                this.AddMappedItem(sKey, rItem);
            }
        }
    }

    protected CFileCachedItem CreateMapItem(File fFile) {
        CFileCachedItem rItem = null;
        if (fFile != null) {
            rItem = new CFileCachedItem(CFileSystemUtils.GetImage16(fFile), CFileSystemUtils.GetImage32(fFile), CFileSystemUtils.GetType(fFile));
        }
        return rItem;
    }

    protected CFileCachedItem CreateMapItem(boolean bIsDrive, boolean bIsDir, String sPath) {
        CFileCachedItem rItem = null;
        if (sPath != null && !sPath.isEmpty()) {
            if (sPath.endsWith("LocalRoot")) {
                rItem = new CFileCachedItem(CMainFrame.GetJARImage("Computer.png"), CMainFrame.GetJARImage("Computer.png"), "");
            } else {
                File fFile = CFileSystemUtils.GetFileSysUtils().GetJavaFile(sPath);
                rItem = new CFileCachedItem(CFileSystemUtils.GetImage16(fFile), CFileSystemUtils.GetImage32(fFile), CFileSystemUtils.GetType(fFile));
            }
        }
        return rItem;
    }

    protected boolean AddMappedItem(String sKey, CFileCachedItem rAddItem) {
        boolean bAdded = false;
        if (this.GetMappedItems() != null && rAddItem != null && this.GetMappedItems().put(sKey, rAddItem) != null) {
            bAdded = true;
        }
        return bAdded;
    }

    protected CFileCachedItem GetMappedItem(String sKey) {
        CFileCachedItem rMappedItem = null;
        if (this.GetMappedItems() != null && sKey != null && !sKey.isEmpty()) {
            rMappedItem = this.GetMappedItems().get(sKey);
        }
        return rMappedItem;
    }

    protected boolean CanStoreOnDisk(boolean bIsLocal, boolean bIsDrive, boolean bIsDir, String sPath) {
        boolean bCanStoreOnDisk = true;
        if (bIsLocal) {
            if (CFileSystemUtils.GetFileSysUtils().IsWindows()) {
                if (!bIsDrive) {
                    if (!bIsDir) {
                        String sExt = this.GetExt(sPath);
                        bCanStoreOnDisk = !this.IsExcludedExt(sExt);
                    } else {
                        String sExt = this.GetExt(sPath);
                        if (CFileSystemUtils.GetFileSysUtils().IsRoot(sPath) || sPath.endsWith("LocalRoot") || this.IsExcludedExt(sExt)) {
                            bCanStoreOnDisk = false;
                        }
                    }
                } else {
                    bCanStoreOnDisk = false;
                }
            }
        } else {
            String sExt = this.GetExt(sPath);
            boolean bCanStoreOnDisk2 = !this.IsExcludedExt(sExt);
            boolean i = false;
        }
        return bCanStoreOnDisk;
    }

    private boolean IsExcludedExt(String sExt) {
        boolean bFound = false;
        if (sExt != null && !sExt.isEmpty()) {
            sExt = sExt.toLowerCase();
            for (int nIdx = 0; nIdx < this.m_asExcludeFromLocalCache.length; ++nIdx) {
                String sNext = this.m_asExcludeFromLocalCache[nIdx];
                if (sNext == null || sNext.isEmpty() || !sNext.equals(sExt)) continue;
                bFound = true;
                break;
            }
        }
        return bFound;
    }

    protected CFileCachedItem GetMappedItem(boolean bIsLocal, boolean bIsDrive, boolean bIsDir, String sPath) {
        String sKey = this.GetKey(bIsLocal, bIsDrive, bIsDir, sPath);
        CFileCachedItem rItem = this.GetMappedItem(sKey);
        if (rItem == null) {
            File fFile;
            rItem = !this.CanStoreOnDisk(bIsLocal, bIsDrive, bIsDir, sPath) ? this.CreateMapItem(bIsDrive, bIsDir, sPath) : ((fFile = this.GetFileOnDisk(bIsDir, sKey)) != null ? this.CreateMapItem(fFile) : this.CreateMapItem(bIsDrive, bIsDir, sPath));
            this.AddMappedItem(sKey, rItem);
        }
        return rItem;
    }

    private File GetFileOnDisk(boolean bIsDir, String sKey) {
        File fRetFile = null;
        if (this.GetCacheDir() != null) {
            if (!bIsDir) {
                if (sKey != null && !sKey.isEmpty()) {
                    File[] afSubFiles = this.GetCacheDir().listFiles();
                    for (int nIdx = 0; nIdx < afSubFiles.length; ++nIdx) {
                        File fNext = afSubFiles[nIdx];
                        if (fNext == null || !fNext.exists()) continue;
                        String sName = fNext.getName();
                        if (sKey.equals(KEY_EXT_NONE) && sName.startsWith(KEY_EXT_NONE)) {
                            fRetFile = fNext;
                            break;
                        }
                        String sExt = this.GetExt(fNext.getAbsolutePath());
                        if (sExt == null || sExt.isEmpty() || !sExt.equals(sKey)) continue;
                        fRetFile = fNext;
                        break;
                    }
                    if (fRetFile == null || !fRetFile.exists()) {
                        String sKeyLower;
                        String sFileName = sKeyLower = sKey.toLowerCase();
                        if (!sKeyLower.equals(KEY_EXT_NONE.toLowerCase())) {
                            if (!sFileName.endsWith(".")) {
                                sFileName = sFileName + ".";
                            }
                            sFileName = sFileName + sKeyLower;
                        } else {
                            sFileName = KEY_EXT_NONE;
                        }
                        fRetFile = this.CreateFileOnDisk(sFileName);
                    }
                }
            } else if (CFileSystemUtils.GetFileSysUtils().IsRoot(sKey)) {
                fRetFile = CFileSystemUtils.GetFileSysUtils().GetRoot(sKey);
            } else if (sKey != null && sKey.endsWith("LocalRoot")) {
                fRetFile = CFileSystemUtils.GetFileSysUtils().GetJavaFile(sKey);
            } else {
                String sFolder = this.GetCacheDir().getAbsolutePath();
                if (!sFolder.endsWith(File.separator)) {
                    sFolder = sFolder + File.separator;
                }
                sFolder = sFolder + NAME_FOLDER;
                CFileSystemUtils fsu = CFileSystemUtils.GetFileSysUtils();
                if (fsu != null) {
                    fRetFile = fsu.CreateAllDirs(sFolder);
                }
            }
        }
        return fRetFile;
    }

    public Icon GetImage16(boolean bIsLocal, boolean bIsDrive, boolean bIsDir, String sPath) {
        Icon rRet = null;
        CFileCachedItem rCachedItem = this.GetMappedItem(bIsLocal, bIsDrive, bIsDir, sPath);
        if (rCachedItem != null) {
            rRet = rCachedItem.GetImage16();
        }
        return rRet;
    }

    public Icon GetImage32(boolean bIsLocal, boolean bIsDrive, boolean bIsDir, String sPath) {
        Icon rRet = null;
        CFileCachedItem rCachedItem = this.GetMappedItem(bIsLocal, bIsDrive, bIsDir, sPath);
        if (rCachedItem != null) {
            rRet = rCachedItem.GetImage32();
        }
        return rRet;
    }

    public String GetType(boolean bIsLocal, boolean bIsDrive, boolean bIsDir, String sPath) {
        String sType = "";
        CFileCachedItem rCachedItem = this.GetMappedItem(bIsLocal, bIsDrive, bIsDir, sPath);
        if (rCachedItem != null) {
            sType = rCachedItem.GetType();
        }
        return sType;
    }
}

