/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.gui.crumbbar;

import com.jidesoft.action.CommandBar;
import com.jidesoft.swing.JideButton;
import com.rhinosoft.base.files.CFile;
import com.rhinosoft.base.gui.events.CRhinoEvent;
import com.rhinosoft.base.gui.frames.CBaseMainFrame;
import com.rhinosoft.base.gui.renderers.files.CFileListCellRenderer;
import com.rhinosoft.fvjv.gui.crumbbar.CCrumbButton;
import com.rhinosoft.fvjv.gui.crumbbar.CFileComboEditor;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.gui.frames.browser.CSearchStateEvent;
import com.rhinosoft.fvjv.strings.CString;
import com.rhinosoft.fvjv.threads.CBaseThread;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.Timer;

public abstract class CBreadBar
extends CommandBar
implements KeyListener,
ItemListener,
ActionListener,
MouseListener {
    public static boolean DEBUG = CMainFrame.DEBUG;
    public static final boolean DEBUG_FILE_ACTIONS;
    public static final int IDX_ROOT_CRUMB = 0;
    private Vector<CCrumbButton> m_aCrumbBtns;
    private JideButton m_cPrevPathsBtn;
    private JideButton m_cRefreshBtn;
    private boolean m_bItemWasDeselected;
    private JComboBox m_cComboBox;
    private Timer m_Timer;
    private CommandBar.Expansion m_cExpansion;
    private CFileComboEditor m_cComboEditor;
    private CBaseThread m_rtThread;
    private CFile m_rfWorkingDir;
    private CCrumbButton m_SearchCrumb;
    private Component m_cPermFocusOwner;

    public CBreadBar(String sKey, JComboBox rComboBox) {
        super(sKey);
        this.InitVars(rComboBox);
    }

    private void InitVars(JComboBox rComboBox) {
        this.m_SearchCrumb = new CCrumbButton();
        this.GetSearchCrumb().setIcon(CMainFrame.GetJARImage("MagnifingGlass16.png"));
        this.m_cComboBox = rComboBox;
        this.InitCombo(this.GetComboBox());
        this.m_cPrevPathsBtn = new JideButton(CMainFrame.GetJARImage("DownArrow.png"));
        if (this.GetPrevPathsBtn() != null) {
            this.GetPrevPathsBtn().setToolTipText(CString.LoadString("IDS_PREV_LOCATIONS"));
            this.GetPrevPathsBtn().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    CBreadBar.this.ShowComboPopup();
                }
            });
        }
        this.InitCrumbs();
        this.m_cRefreshBtn = new JideButton(CMainFrame.GetJARImage("Refresh.png"));
        if (this.GetRefreshBtn() != null) {
            this.GetRefreshBtn().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    if (CMainFrame.GET_APP() != null) {
                        CMainFrame.GET_APP().dispatchEvent(new CRhinoEvent(this, 2115));
                    }
                }
            });
        }
        this.addExpansion();
        this.m_cExpansion = (CommandBar.Expansion)this.getComponent(this.getComponentCount() - 1);
        if (this.GetExpansion() != null) {
            this.remove(this.GetExpansion());
            this.GetExpansion().addMouseListener(this);
        }
        this.addMouseListener(this);
        this.ShowCombo(false);
    }

    private void InitCrumbs() {
        this.m_aCrumbBtns = new Vector();
    }

    protected JComboBox GetComboBox() {
        return this.m_cComboBox;
    }

    private void InitCombo(JComboBox rCombo) {
        if (rCombo != null) {
            this.m_bItemWasDeselected = false;
            rCombo.setRenderer(new CFileListCellRenderer(true));
            this.m_cComboEditor = new CFileComboEditor(rCombo, this);
            rCombo.setEditor(this.m_cComboEditor);
            rCombo.removeAllItems();
            rCombo.setEditable(true);
            if (rCombo.getEditor() != null && rCombo.getEditor().getEditorComponent() != null) {
                rCombo.getEditor().getEditorComponent().addKeyListener(this);
            }
            this.m_Timer = new Timer(250, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    if (CBreadBar.this.GetComboBox() != null) {
                        CBreadBar.this.GetComboBox().showPopup();
                    }
                    CBreadBar.this.m_Timer.stop();
                }
            });
            this.m_Timer.setRepeats(false);
            this.m_Timer.setInitialDelay(250);
            rCombo.addItemListener(this);
            rCombo.addKeyListener(this);
        }
    }

    protected void RemoveAllComponents() {
        for (int nIdx = this.GetCrumbCount() - 1; nIdx >= 0; --nIdx) {
            CCrumbButton cBtn = this.GetCrumb(nIdx);
            if (cBtn == null) continue;
            this.remove(this.GetCrumb(nIdx));
        }
        if (this.GetExpansion() != null) {
            this.remove(this.GetExpansion());
        }
        if (this.GetPrevPathsBtn() != null) {
            this.remove(this.GetPrevPathsBtn());
        }
        if (this.GetComboBox() != null) {
            this.remove(this.GetComboBox());
        }
        if (this.GetRefreshBtn() != null) {
            this.remove(this.GetRefreshBtn());
        }
        this.updateUI();
    }

    protected CFileComboEditor GetComboEditor() {
        return this.m_cComboEditor;
    }

    protected void UpdateCombo(CFile fFile) {
        if (this.GetComboBox() != null) {
            int nSelIdx = this.GetComboItemIndex(fFile.GetPath());
            if (nSelIdx == -1) {
                this.GetComboBox().addItem(fFile);
                nSelIdx = this.GetComboItemIndex(fFile.GetPath());
            }
            if (nSelIdx > -1 && nSelIdx < this.GetComboBox().getItemCount()) {
                int nIdx;
                ItemListener[] aListeners = this.GetComboBox().getItemListeners();
                for (nIdx = aListeners.length - 1; nIdx >= 0; --nIdx) {
                    this.GetComboBox().removeItemListener(aListeners[nIdx]);
                }
                this.GetComboBox().setSelectedIndex(nSelIdx);
                for (nIdx = 0; nIdx < aListeners.length; ++nIdx) {
                    this.GetComboBox().addItemListener(aListeners[nIdx]);
                }
            }
            if (this.GetComboEditor() != null) {
                this.GetComboEditor().SetIcon(fFile.GetIcon16());
            }
        }
    }

    private int GetComboItemIndex(String sPath) {
        int nFoundIdx = -1;
        if (this.GetComboBox() != null && sPath != null) {
            for (int nIdx = 0; nIdx < this.GetComboBox().getItemCount() && nFoundIdx == -1; ++nIdx) {
                CFile fNextFile = (CFile)this.GetComboBox().getItemAt(nIdx);
                if (fNextFile == null || fNextFile.GetPath() == null || !sPath.equals(fNextFile.GetPath())) continue;
                nFoundIdx = nIdx;
            }
        }
        return nFoundIdx;
    }

    protected CCrumbButton CreateCrumb(CFile fFile) {
        CCrumbButton btn = null;
        btn = new CCrumbButton(fFile);
        btn.SetThread(this.GetThread());
        btn.addActionListener(this);
        return btn;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        CCrumbButton rBtn;
        CFile fFile;
        Object rSource = event.getSource();
        if (rSource instanceof CCrumbButton && (fFile = (rBtn = (CCrumbButton)rSource).GetFile()) != null) {
            fFile.GetListing(this.GetThread(), this, false, true, true, false, null);
        }
    }

    protected Vector<CCrumbButton> GetCrumbs() {
        return this.m_aCrumbBtns;
    }

    protected CCrumbButton AddCrumb(CCrumbButton rBtn) {
        if (rBtn != null && this.GetCrumbs() != null) {
            this.GetCrumbs().add(rBtn);
        }
        return rBtn;
    }

    protected int GetCrumbCount() {
        int nSize = 0;
        if (this.GetCrumbs() != null) {
            nSize = this.GetCrumbs().size();
        }
        return nSize;
    }

    protected CCrumbButton GetCrumb(int nIndex) {
        CCrumbButton rRet = null;
        if (this.GetCrumbs() != null && nIndex > -1 && nIndex < this.GetCrumbCount()) {
            rRet = this.GetCrumbs().get(nIndex);
        }
        return rRet;
    }

    protected CCrumbButton GetCrumb(String sPath) {
        CCrumbButton rRet = null;
        if (this.GetCrumbs() != null) {
            Iterator<CCrumbButton> itr = this.GetCrumbs().iterator();
            while (itr.hasNext() && rRet == null) {
                CFile fFile;
                CCrumbButton rCrumbBtn = itr.next();
                if (rCrumbBtn == null || (fFile = rCrumbBtn.GetFile()) == null || fFile.GetPath() == null || !fFile.GetPath().equals(sPath)) continue;
                rRet = rCrumbBtn;
            }
        }
        return rRet;
    }

    protected CCrumbButton GetCrumb(CFile fFile) {
        CCrumbButton rRet = null;
        if (this.GetCrumbs() != null) {
            Iterator<CCrumbButton> itr = this.GetCrumbs().iterator();
            while (itr.hasNext() && rRet == null) {
                CFile fCrumbFile;
                CCrumbButton rCrumbBtn = itr.next();
                if (rCrumbBtn == null || (fCrumbFile = rCrumbBtn.GetFile()) != fFile) continue;
                rRet = rCrumbBtn;
            }
        }
        return rRet;
    }

    public void AddRefreshListener(ActionListener rListener) {
        if (this.GetRefreshBtn() != null) {
            this.GetRefreshBtn().addActionListener(rListener);
        }
    }

    public void ShowBreadBox() {
        this.ShowCombo(false);
    }

    private void ShowComboEdit() {
        if (this.GetComboBox() != null) {
            this.ShowCombo(true);
            this.GetComboBox().getEditor().selectAll();
        }
    }

    public void ShowComboPopup() {
        if (this.GetComboBox() != null) {
            this.ShowCombo(true);
            this.m_Timer.start();
        }
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }

    @Override
    public void keyPressed(KeyEvent event) {
        if (event.getKeyCode() == 27) {
            if (this.GetComboBox() != null && this.GetComboBox().isPopupVisible()) {
                this.GetComboBox().setPopupVisible(false);
            } else {
                this.ShowBreadBox();
            }
        } else if (event.getKeyCode() == 10) {
            ComboBoxEditor cEditor;
            if (this.GetComboBox() != null && (cEditor = this.GetComboBox().getEditor()) != null && cEditor instanceof CFileComboEditor) {
                CFileComboEditor cFileEditor = (CFileComboEditor)cEditor;
                if (event.getSource() == cFileEditor.GetTextField()) {
                    String sWorkingDir = cFileEditor.GetTextField().getText();
                    Object objEdited = cFileEditor.getItem();
                    if (objEdited != null && objEdited instanceof CFile) {
                        CFile fEdited = (CFile)objEdited;
                        Object[] anItems = new Object[]{fEdited.IsLocal(), sWorkingDir, this.GetThread(), null};
                        CRhinoEvent rListEvent = new CRhinoEvent(this, 4000, anItems);
                        if (CMainFrame.GET_APP() != null) {
                            CMainFrame.GET_APP().dispatchEvent(rListEvent);
                        }
                    }
                }
            }
            this.ShowBreadBox();
        }
    }

    @Override
    public void keyReleased(KeyEvent event) {
    }

    protected CommandBar.Expansion GetExpansion() {
        return this.m_cExpansion;
    }

    protected JideButton GetPrevPathsBtn() {
        return this.m_cPrevPathsBtn;
    }

    protected JideButton GetRefreshBtn() {
        return this.m_cRefreshBtn;
    }

    protected CBaseThread GetThread() {
        return this.m_rtThread;
    }

    public void SetThread(CBaseThread rtThread) {
        this.m_rtThread = rtThread;
    }

    @Override
    protected void processEvent(AWTEvent event) {
        block17: {
            block16: {
                if (!(event instanceof CRhinoEvent)) break block16;
                CRhinoEvent rEvent = (CRhinoEvent)event;
                switch (event.getID()) {
                    case 6000: {
                        CRhinoEvent rGUIEvent;
                        if (event instanceof CRhinoEvent && (rGUIEvent = (CRhinoEvent)event).GetEventObj() instanceof CFile) {
                            CFile fFile = (CFile)rGUIEvent.GetEventObj();
                            this.UpdateRootCrumb(fFile);
                            break;
                        }
                        break block17;
                    }
                    case 6001: 
                    case 6003: 
                    case 6005: {
                        CFile fParent = (CFile)rEvent.getSource();
                        CCrumbButton rParentCrumb = this.GetCrumb(fParent.GetPath());
                        if (rParentCrumb != null) {
                            rParentCrumb.processEvent(event);
                            break;
                        }
                        if (DEBUG_FILE_ACTIONS) {
                            System.out.printf("Missed processEvent(ADDED, UPDATED, or REMOVED) for %s\r\n", fParent.GetPath());
                            break;
                        }
                        break block17;
                    }
                    case 6006: {
                        CFile fChildFile = (CFile)rEvent.GetEventObj();
                        CCrumbButton rParentCrumb = this.GetCrumb(fChildFile.GetParentPath(true));
                        if (rParentCrumb != null) {
                            rParentCrumb.processEvent(event);
                            break;
                        }
                        break block17;
                    }
                    case 6007: {
                        CFile fChildFile = (CFile)rEvent.GetEventObj();
                        CCrumbButton rParentCrumb = this.GetCrumb(fChildFile.GetParentPath(true));
                        if (rParentCrumb != null) {
                            rParentCrumb.processEvent(event);
                            break;
                        }
                        break block17;
                    }
                    case 6008: {
                        Object[] arObjs = (Object[])rEvent.GetEventObj();
                        CFile fFile = null;
                        if (arObjs[0] != null && arObjs[0] instanceof CFile) {
                            fFile = (CFile)arObjs[0];
                        }
                        this.InitWorkingDir(fFile);
                        break;
                    }
                    case 9113: {
                        this.ShowCombo(false);
                        break;
                    }
                    case 3005: 
                    case 3020: 
                    case 3021: {
                        for (int nIdx = 0; nIdx < this.GetCrumbCount(); ++nIdx) {
                            CCrumbButton rCrumb = this.GetCrumb(nIdx);
                            if (rCrumb == null) continue;
                            rCrumb.dispatchEvent(event);
                        }
                        break block17;
                    }
                    default: {
                        super.processEvent(event);
                    }
                }
                break block17;
            }
            super.processEvent(event);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        if (event.getSource() == this.GetComboBox()) {
            if (event.getStateChange() == 2) {
                this.m_bItemWasDeselected = true;
                Object objSelected = event.getItem();
                if (objSelected instanceof CFile) {
                    CFile fFile = (CFile)objSelected;
                    if (CBaseMainFrame.DEBUG) {
                        System.out.println(String.format("%s.itemStateChanged - Deselected: %s", this.getClass().getName(), fFile.GetPath()));
                    }
                }
            } else if (event.getStateChange() == 1) {
                Object objSelected;
                if (this.m_bItemWasDeselected && (objSelected = event.getItem()) instanceof CFile) {
                    CFile fFile = (CFile)objSelected;
                    if (CBaseMainFrame.DEBUG) {
                        System.out.println(String.format("%s.itemStateChanged - Selected: %s", this.getClass().getName(), fFile.GetPath()));
                    }
                    fFile.GetListing(this.GetThread(), this, false, true, true, false, null);
                }
                this.m_bItemWasDeselected = false;
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    @Override
    public void mousePressed(MouseEvent event) {
        if (event.getSource() == this || event.getSource() == this.GetExpansion()) {
            this.ShowComboEdit();
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    protected CCrumbButton GetRootCrumb() {
        return this.GetCrumb(0);
    }

    protected void UpdateRootCrumb(CFile fRoot) {
        if (this.GetRootCrumb() != null) {
            this.GetRootCrumb().SetFile(fRoot);
            this.GetRootCrumb().SetThread(this.GetThread());
        }
    }

    protected CFile GetWorkingDir() {
        return this.m_rfWorkingDir;
    }

    private void SetWorkingDir(CFile fFile) {
        this.m_rfWorkingDir = fFile;
    }

    private void InitWorkingDir(CFile fFile) {
        if (this.GetRefreshBtn() != null) {
            this.GetRefreshBtn().setToolTipText(String.format("%s \"%s\"", CString.LoadString("IDS_REFRESH_MENU"), fFile.GetPath()));
        }
        this.UpdateCombo(fFile);
        this.InitCrumbs(fFile);
        this.ShowCombo(false);
    }

    private CCrumbButton RemoveCrumb(int nIdx) {
        CCrumbButton rRemoved = null;
        if (this.GetCrumbs() != null && nIdx >= 0 && nIdx < this.GetCrumbs().size()) {
            rRemoved = this.GetCrumbs().remove(nIdx);
        }
        return rRemoved;
    }

    private void RemoveAllCrumbs() {
        for (int nIdx = this.GetCrumbCount() - 1; nIdx >= 0; --nIdx) {
            CCrumbButton rCrumb = this.RemoveCrumb(nIdx);
            this.remove(rCrumb);
            Object var2_2 = null;
        }
    }

    protected void InitCrumbs(CFile fFile) {
        this.RemoveAllCrumbs();
        if (fFile != null) {
            CFile[] afParents2 = fFile.GetParents();
            CFile[] afParents = new CFile[afParents2.length + 1];
            System.arraycopy(afParents2, 0, afParents, 0, afParents2.length);
            afParents[afParents.length - 1] = fFile;
            for (int nCrumbIndex = 0; nCrumbIndex < afParents.length; ++nCrumbIndex) {
                CCrumbButton cCrumbParent;
                CFile fParent = afParents[nCrumbIndex];
                if (fParent == null || (cCrumbParent = this.GetCrumb(fParent)) != null) continue;
                this.AddCrumb(this.CreateCrumb(fParent));
            }
            if (this.GetRootCrumb() != null) {
                this.GetRootCrumb().setIcon(fFile.GetIcon16());
            }
            this.SetWorkingDir(fFile);
        }
    }

    public boolean IsEventSource(Object objSource) {
        boolean bIsEventSource = false;
        if (objSource == this) {
            bIsEventSource = true;
        }
        for (int nIdx = 0; nIdx < this.GetCrumbCount() && !bIsEventSource; ++nIdx) {
            CCrumbButton rNextBtn = this.GetCrumb(nIdx);
            if (rNextBtn == null) continue;
            bIsEventSource = rNextBtn.IsEventSource(objSource);
        }
        return bIsEventSource;
    }

    private void ShowCombo(boolean bShow) {
        if (bShow) {
            this.m_cPermFocusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
        } else if (this.m_cPermFocusOwner != null) {
            this.m_cPermFocusOwner.requestFocusInWindow();
        }
        this.RemoveAllComponents();
        if (this.GetComboBox() != null && this.GetExpansion() != null && this.GetPrevPathsBtn() != null && this.GetRefreshBtn() != null && this.GetCrumbs() != null) {
            if (!bShow) {
                for (int nIdx = 0; nIdx < this.GetCrumbs().size(); ++nIdx) {
                    JComponent rComp = this.GetCrumbs().get(nIdx);
                    if (rComp == null) continue;
                    this.add(rComp);
                }
                this.add(this.GetExpansion());
                this.add(this.GetPrevPathsBtn());
            } else {
                this.add(this.GetComboBox());
                this.GetComboBox().requestFocus();
            }
            this.add(this.GetRefreshBtn());
        }
    }

    private CCrumbButton GetSearchCrumb() {
        return this.m_SearchCrumb;
    }

    public void SetSearchState(CSearchStateEvent.SEARCH_STATE nSearchState) {
        if (nSearchState == CSearchStateEvent.SEARCH_STATE.ON) {
            CFile fWorkingDir = this.GetWorkingDir();
            if (this.GetSearchCrumb() != null) {
                String sText = CString.LoadString("IDS_SEARCH_RESULTS_DEF");
                if (this.GetWorkingDir() != null) {
                    sText = String.format(CString.LoadString("IDS_SEARCH_RESULTS_FMT"), this.GetWorkingDir().GetDisplayName());
                }
                this.GetSearchCrumb().setText(sText);
                this.RemoveAllCrumbs();
                this.AddCrumb(this.GetSearchCrumb());
                this.ShowCombo(false);
            }
        } else {
            if (this.GetRootCrumb() != null) {
                this.GetRootCrumb().setText(this.GetRootCrumb().GetFile().GetDisplayName());
            }
            this.InitWorkingDir(this.GetWorkingDir());
        }
    }

    static {
        if (DEBUG) {
            // empty if block
        }
        DEBUG_FILE_ACTIONS = false;
    }
}

