/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.gui.crumbbar;

import com.jidesoft.swing.JideMenu;
import com.jidesoft.swing.JideSplitButton;
import com.rhinosoft.base.files.CFile;
import com.rhinosoft.base.gui.components.files.listing.CFileListModel;
import com.rhinosoft.base.gui.events.CRhinoEvent;
import com.rhinosoft.fvjv.gui.crumbbar.CBreadBar;
import com.rhinosoft.fvjv.gui.crumbbar.CFileCrumbListRenderer;
import com.rhinosoft.fvjv.gui.events.CFVJVAction;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.strings.CString;
import com.rhinosoft.fvjv.threads.CBaseThread;
import com.rhinosoft.fvjv.threads.CThreadMsg;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class CCrumbButton
extends JideSplitButton
implements JideMenu.PopupMenuCustomizer,
MouseListener,
MouseMotionListener,
ActionListener {
    public static final boolean DEBUG = CMainFrame.DEBUG;
    private static final int MAX_VISIBLE_ROWS = 18;
    private CBaseThread m_rtThread;
    private CFile m_rfFile;
    private JPanel m_cPopupPanel;
    private JScrollPane m_cScrollPane;
    private JList m_cList;
    private JButton m_cRefreshBtn;
    private CFileListModel m_ListModel;
    private CFileCrumbListRenderer m_ListRenderer;
    private JPopupMenu m_cPopupMenu;
    private Dimension m_PopupSize;

    public CCrumbButton(CFile rfFile) {
        this.InitVars(rfFile);
    }

    public CCrumbButton() {
        this.InitVars(null);
    }

    private void InitVars(CFile rfFile) {
        this.SetFile(rfFile);
        this.setPopupMenuCustomizer(this);
        this.m_cList = new JList();
        if (this.GetList() != null) {
            this.m_ListModel = new CFileListModel(true);
            this.GetList().setModel(this.GetListModel());
            this.m_cScrollPane = new JScrollPane(this.GetList());
            this.m_cScrollPane.setBorder(BorderFactory.createEmptyBorder());
            this.m_ListRenderer = new CFileCrumbListRenderer();
            this.GetList().setCellRenderer(this.GetListRenderer());
            this.GetList().setBorder(BorderFactory.createEmptyBorder());
            this.GetList().setVisibleRowCount(5);
            this.GetList().addMouseListener(this);
            this.GetList().addMouseMotionListener(this);
        }
        this.m_cRefreshBtn = this.CreateRefreshBtn();
        this.m_cRefreshBtn.addActionListener(this);
        this.m_cPopupPanel = new JPanel();
        GroupLayout layout = new GroupLayout(this.m_cPopupPanel);
        this.m_cPopupPanel.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(this.m_cScrollPane, -1, -2, Short.MAX_VALUE).addComponent(this.m_cRefreshBtn, -1, -2, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.m_cScrollPane, -1, -2, Short.MAX_VALUE).addComponent(this.m_cRefreshBtn, -1, -2, -2));
    }

    protected CFileListModel GetListModel() {
        return this.m_ListModel;
    }

    protected CFileCrumbListRenderer GetListRenderer() {
        return this.m_ListRenderer;
    }

    protected CBaseThread GetThread() {
        return this.m_rtThread;
    }

    public void SetThread(CBaseThread rtThread) {
        this.m_rtThread = rtThread;
    }

    @Override
    public void customize(JPopupMenu cPopupMenu) {
        this.SetPopupMenu(cPopupMenu);
        if (this.GetPopupMenu() != null) {
            this.SetPopupSize(this.GetDefaultPopupSize(), true);
            this.GetPopupMenu().add(this.m_cPopupPanel);
            if (this.GetListModel() != null) {
                this.GetListModel().RemoveAll(true);
            }
            if (this.GetFile() != null) {
                this.GetFile().GetListing(this.GetThread(), this, false, false, false, false, null);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void processEvent(AWTEvent event) {
        if (event instanceof CRhinoEvent) {
            CRhinoEvent rEvent = (CRhinoEvent)event;
            switch (event.getID()) {
                case 6001: 
                case 6005: {
                    Object[] aItems;
                    if (this.GetPopupMenu() == null || (aItems = (Object[])rEvent.GetEventObj()) == null) return;
                    CFile fChild = (CFile)aItems[0];
                    boolean bUpdateUI = true;
                    Boolean bVal = (Boolean)aItems[1];
                    if (bVal != null) {
                        bUpdateUI = bVal;
                    }
                    if (fChild == null || !fChild.IsDirectory() && !fChild.IsDrive()) return;
                    if (this.GetListModel() != null) {
                        int nIdx = this.GetListModel().GetFileIndex(fChild);
                        if (nIdx >= 0 && nIdx < this.GetListModel().getSize()) {
                            this.GetListModel().UpdateFile(fChild, true);
                        } else {
                            this.GetListModel().AddFile(fChild, true);
                        }
                    }
                    this.InitPopupSize(fChild, event.getID());
                    return;
                }
                case 6003: {
                    CFile fChild;
                    if (this.GetPopupMenu() == null || (fChild = (CFile)rEvent.GetEventObj()) == null || !fChild.IsDirectory() && !fChild.IsDrive()) return;
                    if (this.GetListModel() != null) {
                        this.GetListModel().RemoveFile(fChild, true);
                    }
                    this.InitPopupSize(fChild, event.getID());
                    return;
                }
                case 6006: {
                    CFile fChildFile = (CFile)rEvent.GetEventObj();
                    if (this.GetListModel() == null || fChildFile == null) return;
                    String sPath = fChildFile.GetPath();
                    int nIndex = this.GetListModel().GetFileIndex(sPath);
                    this.GetListModel().UpdateFile(nIndex, true);
                    return;
                }
                case 6007: {
                    CFile fChildFile = (CFile)rEvent.GetEventObj();
                    if (this.GetListModel() == null || fChildFile == null) return;
                    String sPath = fChildFile.GetPath();
                    return;
                }
                case 3005: 
                case 3020: 
                case 3021: {
                    if (!this.IsEventSource(event.getSource()) || !(rEvent.GetEventObj() instanceof CThreadMsg)) return;
                    CThreadMsg rThreadMsg = (CThreadMsg)rEvent.GetEventObj();
                    switch (rThreadMsg.GetMsgID()) {
                        case 5: {
                            CFile fWorkingDir = this.GetCurWorkingDir();
                            Container rSource = this.getParent();
                            if (fWorkingDir == null || rSource == null || CMainFrame.GET_APP() == null) return;
                            CFile fRoot = null;
                            fRoot = fWorkingDir.IsLocal() ? CMainFrame.GET_APP().GetLocalRoot() : CMainFrame.GET_APP().GetRemoteRoot();
                            if (fRoot == null) return;
                            fRoot.OnRecvParentFile(fWorkingDir);
                            return;
                        }
                        default: {
                            return;
                        }
                    }
                }
                default: {
                    super.processEvent(event);
                }
            }
            return;
        }
        super.processEvent(event);
    }

    public CFile GetFile() {
        return this.m_rfFile;
    }

    public void SetFile(CFile rfFile) {
        this.m_rfFile = rfFile;
        String sText = "";
        if (this.GetFile() != null) {
            sText = this.GetFile().GetDisplayName();
        }
        this.setText(sText);
    }

    protected JList GetList() {
        return this.m_cList;
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        if (this.GetList() != null && event.getSource() == this.GetList()) {
            if (SwingUtilities.isLeftMouseButton(event)) {
                CFile fFile;
                int nIndex = this.GetList().locationToIndex(event.getPoint());
                this.hideMenu();
                if (this.GetListModel() != null && nIndex >= 0 && nIndex < this.GetListModel().getSize() && (fFile = (CFile)this.GetListModel().getElementAt(nIndex)) != null) {
                    fFile.GetListing(this.GetThread(), this, true, true, true, false, null);
                }
            } else if (SwingUtilities.isRightMouseButton(event)) {
                // empty if block
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
    }

    @Override
    public void mouseReleased(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
        int nSelIdx;
        if (this.GetList() != null && (nSelIdx = this.GetList().getSelectedIndex()) > -1 && nSelIdx < this.GetList().getModel().getSize()) {
            this.GetList().removeSelectionInterval(nSelIdx, nSelIdx);
        }
    }

    @Override
    public void mouseDragged(MouseEvent event) {
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        if (this.GetList() != null && event.getSource() == this.GetList()) {
            Rectangle rect;
            Point pt = event.getPoint();
            int nSelIdx = this.GetList().getSelectedIndex();
            if (nSelIdx > -1 && nSelIdx < this.GetList().getModel().getSize() && (rect = this.GetList().getCellBounds(nSelIdx, nSelIdx)) != null && !rect.contains(pt)) {
                this.GetList().removeSelectionInterval(nSelIdx, nSelIdx);
            }
            int nIndex = this.GetList().locationToIndex(event.getPoint());
            if (this.GetList().getModel() != null && nIndex > -1 && nIndex < this.GetList().getModel().getSize()) {
                this.GetList().setSelectedIndex(nIndex);
            }
        }
    }

    private void SetPopupMenu(JPopupMenu cPopupMenu) {
        this.m_cPopupMenu = cPopupMenu;
    }

    private JPopupMenu GetPopupMenu() {
        return this.m_cPopupMenu;
    }

    private void SetPopupSize(Dimension dimSize, boolean bUpdatePopup) {
        CFileCrumbListRenderer cRenderer;
        int nExtraWidth = 0;
        int nExtraHeight = 0;
        if (this.m_cScrollPane != null) {
            if (this.m_cScrollPane.getVerticalScrollBar() != null) {
                nExtraWidth += this.m_cScrollPane.getVerticalScrollBar().getPreferredSize().width;
            }
            if (this.m_cScrollPane.getVerticalScrollBar() != null) {
                nExtraHeight += this.m_cScrollPane.getHorizontalScrollBar().getPreferredSize().height;
            }
        }
        if ((cRenderer = (CFileCrumbListRenderer)this.GetList().getCellRenderer()) != null) {
            nExtraWidth += cRenderer.getIconTextGap();
        }
        dimSize.width += nExtraWidth;
        dimSize.height += nExtraHeight;
        boolean bSet = true;
        if (this.m_PopupSize != null) {
            Dimension dimScreenSize;
            if (dimSize.width == this.m_PopupSize.width + nExtraWidth && dimSize.height == this.m_PopupSize.height + nExtraHeight) {
                bSet = false;
            }
            if ((dimScreenSize = Toolkit.getDefaultToolkit().getScreenSize()) != null && dimSize.height > dimScreenSize.height) {
                if (DEBUG) {
                    System.out.printf("Exceeded screen res: (%d, %d)\r\n", dimSize.width, dimSize.height);
                }
                bSet = false;
            }
        }
        if (bSet) {
            if (DEBUG) {
                if (this.GetPopupSize() != null) {
                    System.out.printf("PopupSize: (%d, %d)\r\n", this.GetPopupSize().width, this.GetPopupSize().height);
                }
                System.out.printf("NewSize: (%d, %d)\r\n", dimSize.width, dimSize.height);
            }
            this.m_PopupSize = dimSize;
            if (bUpdatePopup && this.GetPopupMenu() != null) {
                this.GetPopupMenu().setPopupSize(dimSize);
            }
        }
    }

    private Dimension GetPopupSize() {
        return this.m_PopupSize;
    }

    private void InitPopupSize(CFile fFile, int nEventID) {
        Dimension dimPopSize;
        if (this.GetPopupMenu() != null && this.GetPopupSize() != null && (dimPopSize = new Dimension(this.GetPopupSize())) != null) {
            Dimension dimTextSize;
            Component cComp = this.GetListRenderer().getListCellRendererComponent(this.GetList(), (Object)fFile, this.GetListModel().GetFileIndex(fFile), false, false);
            if (cComp != null && (dimTextSize = CString.GetTextSize(fFile.GetDisplayName(), cComp.getFont(), this.getGraphics())) != null) {
                dimPopSize.width = Math.max(dimPopSize.width, dimTextSize.width);
                int nMultiplier = 18;
                Rectangle rect = this.GetList().getCellBounds(0, 0);
                if (rect != null && this.GetListModel() != null) {
                    nMultiplier = Math.min(nMultiplier, this.GetListModel().getSize());
                }
            }
            this.SetPopupSize(dimPopSize, true);
        }
    }

    private Dimension GetDefaultPopupSize() {
        String sDefault;
        Dimension dimTextSize;
        Dimension dimDef = new Dimension(70, 100);
        Component rInvoker = this.GetPopupMenu().getInvoker();
        if (rInvoker != null) {
            dimDef.width = rInvoker.getWidth();
        }
        if ((dimTextSize = CString.GetTextSize(sDefault = "123456789012345678901234567890", this.getFont(), this.getGraphics())) != null) {
            dimDef.width = Math.max(dimDef.width, dimTextSize.width);
            dimDef.height = Math.max(dimDef.height, dimTextSize.height * 18);
        }
        return dimDef;
    }

    private JButton CreateRefreshBtn() {
        CFVJVAction rAction = new CFVJVAction(2115);
        rAction.SetName(CString.LoadString("IDS_REFRESH_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_REFRESH_TIP"));
        rAction.SetLongDesc(CString.LoadString("IDS_REFRESH_STATUS"));
        rAction.SetAccelerator(116);
        rAction.SetSmallIcon(CMainFrame.GetJARImage("Refresh.png"));
        rAction.SetDispatchOnAction(false);
        return new JButton(rAction);
    }

    private CFile GetCurWorkingDir() {
        CFile fWorkingDir = null;
        CBreadBar rBar = (CBreadBar)SwingUtilities.getAncestorOfClass(CBreadBar.class, this);
        if (rBar != null) {
            fWorkingDir = rBar.GetWorkingDir();
        }
        return fWorkingDir;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.m_cRefreshBtn && this.GetFile() != null) {
            this.GetFile().GetListing(this.GetThread(), this, true, false, true, false, null);
        }
    }

    public boolean IsEventSource(Object objSource) {
        boolean bIsEventSource = false;
        if (objSource == this) {
            bIsEventSource = true;
        }
        return bIsEventSource;
    }
}

