/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.gui.crumbbar;

import com.rhinosoft.base.files.CFile;
import com.rhinosoft.base.files.CFileSystemUtils;
import com.rhinosoft.base.gui.events.CRhinoEvent;
import com.rhinosoft.fvjv.gui.crumbbar.CBreadBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class CFileComboEditor
extends JPanel
implements ComboBoxEditor,
FocusListener,
PopupMenuListener {
    private JLabel m_cImageLabel;
    private JTextField m_cTextField;
    private Vector<ActionListener> m_ActionListeners;
    private Object m_rItem;
    private JComboBox m_rComboBox;
    private CBreadBar m_rBreadBar;

    public CFileComboEditor(JComboBox rComboBox, CBreadBar rBreadBar) {
        this.SetComboBox(rComboBox);
        this.SetBreadBar(rBreadBar);
        this.m_ActionListeners = new Vector();
        this.m_cImageLabel = new JLabel();
        this.m_cTextField = new JTextField();
        this.setOpaque(false);
        if (this.GetIconLabel() != null) {
            this.GetIconLabel().setOpaque(true);
            if (this.GetTextField() != null) {
                this.GetIconLabel().setBackground(this.GetTextField().getBackground());
            }
        }
        if (this.GetTextField() != null) {
            this.GetTextField().setBorder(BorderFactory.createEmptyBorder());
            this.GetTextField().addFocusListener(this);
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_cImageLabel, "West");
        this.add((Component)this.m_cTextField, "Center");
        this.addFocusListener(this);
    }

    protected Vector<ActionListener> GetActionListeners() {
        return this.m_ActionListeners;
    }

    @Override
    public Component getEditorComponent() {
        return this;
    }

    @Override
    public void setItem(Object rItem) {
        this.m_rItem = rItem;
        if (this.getItem() instanceof CFile) {
            CFile fFile = (CFile)this.getItem();
            this.SetIcon(fFile.GetIcon16());
            String sPath = fFile.GetPath();
            if (CFileSystemUtils.GetFileSysUtils() != null && CFileSystemUtils.GetFileSysUtils().IsRoot(sPath)) {
                sPath = fFile.GetDisplayName();
            }
            this.SetText(sPath);
        }
    }

    @Override
    public Object getItem() {
        return this.m_rItem;
    }

    @Override
    public void addActionListener(ActionListener rListener) {
        if (this.GetActionListeners() != null) {
            this.GetActionListeners().add(rListener);
        }
    }

    @Override
    public void removeActionListener(ActionListener rListener) {
        if (this.GetActionListeners() != null) {
            this.GetActionListeners().remove(rListener);
        }
    }

    @Override
    public void selectAll() {
        if (this.GetTextField() != null) {
            this.GetTextField().selectAll();
        }
    }

    protected JLabel GetIconLabel() {
        return this.m_cImageLabel;
    }

    protected JTextField GetTextField() {
        return this.m_cTextField;
    }

    public void SetIcon(Icon icon) {
        if (this.GetIconLabel() != null) {
            boolean bShow = true;
            if (icon != null) {
                this.GetIconLabel().setIcon(icon);
            } else {
                bShow = false;
            }
            this.GetIconLabel().setVisible(bShow);
        }
    }

    public void SetText(String sText) {
        if (this.GetTextField() != null) {
            this.GetTextField().setText(sText);
        }
    }

    @Override
    public void focusGained(FocusEvent rEvent) {
        if (this.GetTextField() != null) {
            this.GetTextField().requestFocus();
        }
    }

    @Override
    public void focusLost(FocusEvent rEvent) {
        if (rEvent.getSource() == this.GetTextField() && this.GetComboBox() != null && this.GetBreadBar() != null && !this.GetComboBox().isPopupVisible()) {
            this.ShowCrumbBtns();
        }
    }

    @Override
    public synchronized void addKeyListener(KeyListener rListener) {
        super.addKeyListener(rListener);
        if (this.GetTextField() != null) {
            this.GetTextField().addKeyListener(rListener);
        }
    }

    @Override
    public synchronized void removeKeyListener(KeyListener rListener) {
        super.addKeyListener(rListener);
        if (this.GetTextField() != null) {
            this.GetTextField().removeKeyListener(rListener);
        }
    }

    private JComboBox GetComboBox() {
        return this.m_rComboBox;
    }

    private CBreadBar GetBreadBar() {
        return this.m_rBreadBar;
    }

    private void SetComboBox(JComboBox rComboBox) {
        this.m_rComboBox = rComboBox;
        this.m_rComboBox.addPopupMenuListener(this);
    }

    private void SetBreadBar(CBreadBar rBreadBar) {
        this.m_rBreadBar = rBreadBar;
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent event) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent event) {
        this.ShowCrumbBtns();
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent event) {
    }

    private void ShowCrumbBtns() {
        CRhinoEvent rShowCrumbsEvent = new CRhinoEvent(this, 9113);
        if (this.GetBreadBar() != null) {
            this.GetBreadBar().dispatchEvent(rShowCrumbsEvent);
        }
    }
}

