/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.gui.dialogs;

import com.rhinosoft.base.files.CFileSystemUtils;
import com.rhinosoft.base.gui.events.CRhinoEvent;
import com.rhinosoft.fvjv.gui.dialogs.CFVJVPrefsTreePanel;
import com.rhinosoft.fvjv.gui.dialogs.CLinkLabel;
import com.rhinosoft.fvjv.gui.dialogs.CMsgBox;
import com.rhinosoft.fvjv.gui.dialogs.CSeparator;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.strings.CString;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;

public class CAboutComputerInfoPanel
extends CFVJVPrefsTreePanel
implements ClipboardOwner,
ActionListener {
    public static final boolean HIDE_EXTRA_INFO = true;
    private CLinkLabel m_cSmallLogo;
    private CSeparator m_cOSSep;
    private JLabel m_cOS;
    private JLabel m_cOSVersion;
    private JLabel m_cOSArch;
    private JLabel m_cCPUEndian;
    private JLabel m_cUnicodeEncoding;
    private JLabel m_cUserLanguage;
    private JLabel m_cUserCountry;
    private CSeparator m_cRuntimeSep;
    private JLabel m_cRuntimeName;
    private JLabel m_cRuntimeVersion;
    private JLabel m_cRuntimeVendor;
    private JLabel m_cRuntimeVMVendor;
    private JLabel m_cRuntimeVMVersion;
    private JButton m_cCopyClipBtn;

    public CAboutComputerInfoPanel(String sTitle, CMainFrame rMainFrame) {
        super(sTitle, rMainFrame);
    }

    @Override
    public void OnCreate() {
        super.OnCreate();
        this.m_cSmallLogo = new CLinkLabel(this.GetMainFrame(), "http://fvjv.serv-u.com/");
        if (this.GetSmallLogoCtrl() != null) {
            this.GetSmallLogoCtrl().setIcon(this.GetMainFrame().GetJarImage("FTPVoyagerJV_36x36.png"));
            this.GetSmallLogoCtrl().setBorder(BorderFactory.createLoweredBevelBorder());
            this.GetSmallLogoCtrl().setOpaque(true);
            this.GetSmallLogoCtrl().setBackground(new Color(255, 255, 255));
        }
        this.m_cOSSep = new CSeparator();
        if (this.GetOSSep() != null) {
            this.GetOSSep().setText(CString.LoadString("IDS_OS_INFO"));
        }
        JLabel cOSLabel = new JLabel(CString.LoadString("IDS_OS"));
        this.m_cOS = new JLabel();
        if (this.GetOSCtrl() != null) {
            this.ApplyBoldFont(this.GetOSCtrl());
            String sTemp = System.getProperty("os.name");
            this.GetOSCtrl().setText(sTemp);
        }
        JLabel cOSVersionLabel = new JLabel(CString.LoadString("IDS_OS_VERSION"));
        this.m_cOSVersion = new JLabel();
        if (this.GetOSVersionCtrl() != null) {
            this.ApplyBoldFont(this.GetOSVersionCtrl());
            String sTemp = System.getProperty("os.version");
            this.GetOSVersionCtrl().setText(sTemp);
        }
        JLabel cOSArchLabel = new JLabel(CString.LoadString("IDS_CPU_ARCH"));
        this.m_cOSArch = new JLabel();
        if (this.GetOSArchCtrl() != null) {
            this.ApplyBoldFont(this.GetOSArchCtrl());
            String sTemp = System.getProperty("os.arch");
            this.GetOSArchCtrl().setText(sTemp);
        }
        JLabel cCPUEndianLabel = new JLabel(CString.LoadString("IDS_CPU_ENDIAN"));
        this.m_cCPUEndian = new JLabel();
        if (this.GetCPUEndianCtrl() != null) {
            this.ApplyBoldFont(this.GetCPUEndianCtrl());
            String sTemp = System.getProperty("sun.cpu.endian");
            this.GetCPUEndianCtrl().setText(sTemp);
        }
        JLabel cUnicodeEncodingLabel = new JLabel(CString.LoadString("IDS_UNICODE_ENCODING"));
        this.m_cUnicodeEncoding = new JLabel();
        if (this.GetUnicodeEncodingCtrl() != null) {
            this.ApplyBoldFont(this.GetUnicodeEncodingCtrl());
            String sTemp = System.getProperty("sun.io.unicode.encoding");
            this.GetUnicodeEncodingCtrl().setText(sTemp);
        }
        JLabel cUserLangLabel = new JLabel(CString.LoadString("IDS_USER_LANGUAGE"));
        this.m_cUserLanguage = new JLabel();
        if (this.GetUserLanguageCtrl() != null) {
            this.ApplyBoldFont(this.GetUserLanguageCtrl());
            String sTemp = System.getProperty("user.language");
            this.GetUserLanguageCtrl().setText(sTemp);
        }
        JLabel cUserCountryLabel = new JLabel(CString.LoadString("IDS_USER_COUNTRY"));
        this.m_cUserCountry = new JLabel();
        if (this.GetUserCountryCtrl() != null) {
            this.ApplyBoldFont(this.GetUserCountryCtrl());
            String sTemp = System.getProperty("user.country");
            this.GetUserCountryCtrl().setText(sTemp);
        }
        this.m_cRuntimeSep = new CSeparator();
        if (this.GetRuntimeSep() != null) {
            this.GetRuntimeSep().setText(CString.LoadString("IDS_RUNTIME_INFO"));
        }
        JLabel cRuntimeNameLabel = new JLabel(CString.LoadString("IDS_RUNTIME_NAME"));
        this.m_cRuntimeName = new JLabel();
        if (this.GetRuntimeNameCtrl() != null) {
            this.ApplyBoldFont(this.GetRuntimeNameCtrl());
            String sTemp = System.getProperty("java.runtime.name");
            this.GetRuntimeNameCtrl().setText(sTemp);
        }
        JLabel cRuntimeVersionLabel = new JLabel(CString.LoadString("IDS_RUNTIME_VERSION"));
        this.m_cRuntimeVersion = new JLabel();
        if (this.GetRuntimeVersionCtrl() != null) {
            this.ApplyBoldFont(this.GetRuntimeVersionCtrl());
            String sTemp = System.getProperty("java.version");
            this.GetRuntimeVersionCtrl().setText(sTemp);
        }
        JLabel cRuntimeVendorLabel = new JLabel(CString.LoadString("IDS_RUNTIME_VENDOR"));
        this.m_cRuntimeVendor = new JLabel();
        if (this.GetRuntimeVendorCtrl() != null) {
            this.ApplyBoldFont(this.GetRuntimeVendorCtrl());
            String sTemp = System.getProperty("java.vendor");
            this.GetRuntimeVendorCtrl().setText(sTemp);
        }
        JLabel cRuntimeVMVendorLabel = new JLabel(CString.LoadString("IDS_RUNTIME_VM_VENDOR"));
        this.m_cRuntimeVMVendor = new JLabel();
        if (this.GetRuntimeVMVendorCtrl() != null) {
            this.ApplyBoldFont(this.GetRuntimeVMVendorCtrl());
            String sTemp = System.getProperty("java.vm.vendor");
            this.GetRuntimeVMVendorCtrl().setText(sTemp);
        }
        JLabel cRuntimeVMVersionLabel = new JLabel(CString.LoadString("IDS_RUNTIME_VM_VERSION"));
        this.m_cRuntimeVMVersion = new JLabel();
        if (this.GetRuntimeVMVersionCtrl() != null) {
            this.ApplyBoldFont(this.GetRuntimeVMVersionCtrl());
            String sTemp = System.getProperty("java.vm.version");
            this.GetRuntimeVMVersionCtrl().setText(sTemp);
        }
        this.m_cCopyClipBtn = new JButton(CString.LoadString("IDS_COPY_TO_CLIPBOARD"));
        if (this.GetCopyClipBtn() != null) {
            this.GetCopyClipBtn().addActionListener(this);
        }
        JPanel cSpacer = new JPanel();
        if (this.GetSmallLogoCtrl() != null) {
            Dimension dimSize = this.GetSmallLogoCtrl().getMinimumSize();
            dimSize.height = dimSize.height / 4 * 3;
            cSpacer.setMinimumSize(dimSize);
            dimSize = this.GetSmallLogoCtrl().getPreferredSize();
            dimSize.height = dimSize.height / 4 * 3;
            cSpacer.setPreferredSize(dimSize);
            dimSize = this.GetSmallLogoCtrl().getMaximumSize();
            dimSize.height = dimSize.height / 4 * 3;
            cSpacer.setMaximumSize(dimSize);
        }
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        int nLabelWidth = 150;
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(this.GetTitleCtrl(), -1, -2, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.GetSmallLogoCtrl(), -1, -2, -2).addGap(5).addComponent(this.GetHeaderMsgCtrl(), -1, -2, Short.MAX_VALUE)).addComponent(this.GetOSSep(), -1, -2, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(cOSLabel, nLabelWidth, nLabelWidth, nLabelWidth).addGap(5).addComponent(this.GetOSCtrl(), -1, -2, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(cOSVersionLabel, nLabelWidth, nLabelWidth, nLabelWidth).addGap(5).addComponent(this.GetOSVersionCtrl(), -1, -2, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(cOSArchLabel, nLabelWidth, nLabelWidth, nLabelWidth).addGap(5).addComponent(this.GetOSArchCtrl(), -1, -2, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(cCPUEndianLabel, nLabelWidth, nLabelWidth, nLabelWidth).addGap(5).addComponent(this.GetCPUEndianCtrl(), -1, -2, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(cUnicodeEncodingLabel, nLabelWidth, nLabelWidth, nLabelWidth).addGap(5).addComponent(this.GetUnicodeEncodingCtrl(), -1, -2, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(cUserLangLabel, nLabelWidth, nLabelWidth, nLabelWidth).addGap(5).addComponent(this.GetUserLanguageCtrl(), -1, -2, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(cUserCountryLabel, nLabelWidth, nLabelWidth, nLabelWidth).addGap(5).addComponent(this.GetUserCountryCtrl(), -1, -2, Short.MAX_VALUE)).addComponent(this.GetRuntimeSep(), -1, -2, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(cRuntimeNameLabel, nLabelWidth, nLabelWidth, nLabelWidth).addGap(5).addComponent(this.GetRuntimeNameCtrl(), -1, -2, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(cRuntimeVersionLabel, nLabelWidth, nLabelWidth, nLabelWidth).addGap(5).addComponent(this.GetRuntimeVersionCtrl(), -1, -2, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(cRuntimeVendorLabel, nLabelWidth, nLabelWidth, nLabelWidth).addGap(5).addComponent(this.GetRuntimeVendorCtrl(), -1, -2, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(cRuntimeVMVendorLabel, nLabelWidth, nLabelWidth, nLabelWidth).addGap(5).addComponent(this.GetRuntimeVMVendorCtrl(), -1, -2, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(cRuntimeVMVersionLabel, nLabelWidth, nLabelWidth, nLabelWidth).addGap(5).addComponent(this.GetRuntimeVMVersionCtrl(), -1, -2, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, Short.MAX_VALUE).addComponent(this.GetCopyClipBtn(), -1, -2, -2)));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.GetTitleCtrl(), -1, -2, -2).addGap(10).addGroup(layout.createParallelGroup().addComponent(this.GetSmallLogoCtrl(), -1, -2, -2).addComponent(this.GetHeaderMsgCtrl(), -1, -2, -2)).addGap(10).addComponent(this.GetOSSep(), -1, -2, -2).addGap(5).addGroup(layout.createParallelGroup().addComponent(cOSLabel, -1, -2, -2).addComponent(this.GetOSCtrl(), -1, -2, -2)).addGap(5).addGroup(layout.createParallelGroup().addComponent(cOSVersionLabel, -1, -2, -2).addComponent(this.GetOSVersionCtrl(), -1, -2, -2)).addGap(5).addGroup(layout.createParallelGroup().addComponent(cOSArchLabel, -1, -2, -2).addComponent(this.GetOSArchCtrl(), -1, -2, -2)).addGap(5).addGroup(layout.createParallelGroup().addComponent(cCPUEndianLabel, -1, -2, -2).addComponent(this.GetCPUEndianCtrl(), -1, -2, -2)).addGap(5).addGroup(layout.createParallelGroup().addComponent(cUnicodeEncodingLabel, -1, -2, -2).addComponent(this.GetUnicodeEncodingCtrl(), -1, -2, -2)).addGap(5).addGroup(layout.createParallelGroup().addComponent(cUserLangLabel, -1, -2, -2).addComponent(this.GetUserLanguageCtrl(), -1, -2, -2)).addGap(5).addGroup(layout.createParallelGroup().addComponent(cUserCountryLabel, -1, -2, -2).addComponent(this.GetUserCountryCtrl(), -1, -2, -2)).addGap(10).addComponent(this.GetRuntimeSep(), -1, -2, -2).addGap(5).addGroup(layout.createParallelGroup().addComponent(cRuntimeNameLabel, -1, -2, -2).addComponent(this.GetRuntimeNameCtrl(), -1, -2, -2)).addGap(5).addGroup(layout.createParallelGroup().addComponent(cRuntimeVersionLabel, -1, -2, -2).addComponent(this.GetRuntimeVersionCtrl(), -1, -2, -2)).addGap(5).addGroup(layout.createParallelGroup().addComponent(cRuntimeVendorLabel, -1, -2, -2).addComponent(this.GetRuntimeVendorCtrl(), -1, -2, -2)).addGap(5).addGroup(layout.createParallelGroup().addComponent(cRuntimeVMVendorLabel, -1, -2, -2).addComponent(this.GetRuntimeVMVendorCtrl(), -1, -2, -2)).addGap(5).addGroup(layout.createParallelGroup().addComponent(cRuntimeVMVersionLabel, -1, -2, -2).addComponent(this.GetRuntimeVMVersionCtrl(), -1, -2, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, Short.MAX_VALUE).addComponent(this.GetCopyClipBtn(), -1, -2, -2));
        if (this.GetHeaderIconCtrl() != null) {
            this.GetHeaderIconCtrl().setVisible(false);
        }
        Component[] aHideComps = new Component[]{cCPUEndianLabel, this.GetCPUEndianCtrl(), cUnicodeEncodingLabel, this.GetUnicodeEncodingCtrl(), cUserLangLabel, this.GetUserLanguageCtrl(), cUserCountryLabel, this.GetUserCountryCtrl(), cRuntimeVMVendorLabel, this.GetRuntimeVMVendorCtrl(), cRuntimeVMVersionLabel, this.GetRuntimeVMVersionCtrl(), null};
        for (int nIdx = 0; nIdx < aHideComps.length; ++nIdx) {
            Component rNext = aHideComps[nIdx];
            if (rNext == null) continue;
            rNext.setVisible(false);
        }
        if (this.GetHeaderMsgCtrl() != null) {
            this.GetHeaderMsgCtrl().setText(CString.LoadString("IDS_COMPUTER_HEADER_MSG"));
        }
    }

    protected JLabel GetSmallLogoCtrl() {
        return this.m_cSmallLogo;
    }

    protected CSeparator GetOSSep() {
        return this.m_cOSSep;
    }

    protected JLabel GetOSCtrl() {
        return this.m_cOS;
    }

    protected JLabel GetOSVersionCtrl() {
        return this.m_cOSVersion;
    }

    protected JLabel GetOSArchCtrl() {
        return this.m_cOSArch;
    }

    protected JLabel GetCPUEndianCtrl() {
        return this.m_cCPUEndian;
    }

    protected JLabel GetUnicodeEncodingCtrl() {
        return this.m_cUnicodeEncoding;
    }

    protected JLabel GetUserLanguageCtrl() {
        return this.m_cUserLanguage;
    }

    protected JLabel GetUserCountryCtrl() {
        return this.m_cUserCountry;
    }

    protected CSeparator GetRuntimeSep() {
        return this.m_cRuntimeSep;
    }

    protected JLabel GetRuntimeNameCtrl() {
        return this.m_cRuntimeName;
    }

    protected JLabel GetRuntimeVersionCtrl() {
        return this.m_cRuntimeVersion;
    }

    protected JLabel GetRuntimeVendorCtrl() {
        return this.m_cRuntimeVendor;
    }

    protected JLabel GetRuntimeVMVendorCtrl() {
        return this.m_cRuntimeVMVendor;
    }

    protected JLabel GetRuntimeVMVersionCtrl() {
        return this.m_cRuntimeVMVersion;
    }

    protected JButton GetCopyClipBtn() {
        return this.m_cCopyClipBtn;
    }

    @Override
    public void OnHelp() {
        if (this.GetMainFrame() != null) {
            String[] asInfo = new String[]{"Help-Dlg-About-ComputerInfo.htm", "none"};
            CRhinoEvent rEvent = new CRhinoEvent(this.GetMainFrame(), 7000, asInfo);
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(rEvent);
        }
    }

    private void OnCopyToClipboard() {
        Clipboard clipboard;
        String sInfo = this.CompileEnvironmentInfo();
        if (sInfo != null && (clipboard = Toolkit.getDefaultToolkit().getSystemClipboard()) != null) {
            StringSelection objTransferable = new StringSelection(sInfo);
            clipboard.setContents(objTransferable, this);
            JDialog rMainDlg = (JDialog)SwingUtilities.getAncestorOfClass(JDialog.class, this);
            CMsgBox dlg = new CMsgBox(rMainDlg, true, -1L, -1, 1);
            dlg.setTitle(CString.LoadString("IDS_COPY_TO_CLIP_CONFIRM_TITLE"));
            dlg.SetMainMsg(CString.LoadString("IDS_COPY_TO_CLIP_CONFIRM_MSG"));
            Dimension dimSize = new Dimension(300, 180);
            if (CFileSystemUtils.GetFileSysUtils().IsMac()) {
                dimSize.width += 100;
                dimSize.height += 50;
            }
            dlg.setPreferredSize(dimSize);
            dlg.setVisible(true);
        }
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
        if (DEBUG) {
            System.out.println("CAboutComputerInfoPanel.lostOwnership of clipboard.");
        }
    }

    private String CompileEnvironmentInfo() {
        StringBuffer sRet = new StringBuffer();
        sRet.append("----------  System.getenv()  ------------\r\n\r\n");
        for (String sKey : System.getenv().keySet()) {
            sRet.append(String.format("%30s = %s\r\n", sKey, System.getenv().get(sKey)));
        }
        ArrayList<Object> SortedProps = new ArrayList<Object>();
        SortedProps.addAll(System.getProperties().keySet());
        Collections.sort(SortedProps);
        sRet.append("----------  System.getProperties()  ------------\r\n\r\n");
        Object objKey = null;
        for (int nIdx = 0; nIdx < SortedProps.size(); ++nIdx) {
            Object[] objectArray = new Object[2];
            Object e = SortedProps.get(nIdx);
            objKey = e;
            objectArray[0] = e;
            objectArray[1] = System.getProperties().get(objKey);
            sRet.append(String.format("%30s = %s\r\n", objectArray));
        }
        return sRet.toString();
    }

    @Override
    public void actionPerformed(ActionEvent rActionEvent) {
        if (rActionEvent != null && rActionEvent.getSource() == this.GetCopyClipBtn()) {
            this.OnCopyToClipboard();
        }
    }

    private void ApplyBoldFont(JComponent rComp) {
        if (rComp != null) {
            rComp.setFont(new Font("Arial Bold", 1, 12));
        }
    }
}

