/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.gui.dialogs;

import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.DockingManager;
import com.rhinosoft.fvjv.gui.dialogs.CAllFramesDlgListModel;
import com.rhinosoft.fvjv.gui.dialogs.CAllFramesDlgListRenderer;
import com.rhinosoft.fvjv.strings.CString;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;

public class CAllFramesDlgPanel
extends JPanel
implements ActionListener {
    private JLabel m_cListLabel;
    private CAllFramesDlgListModel m_cListModel;
    private CAllFramesDlgListRenderer m_cListRenderer;
    private JList m_cList;
    private JButton m_cOK;
    private JButton m_cCancel;
    private int m_nDlgRetCode;
    private DockingManager m_cDockingManager;

    public CAllFramesDlgPanel() {
        this.InitVars();
    }

    private void InitVars() {
        this.m_nDlgRetCode = 2;
        this.m_cListLabel = new JLabel(CString.LoadString("IDS_ACTIVATE_FRAME_DLG_LIST_LABEL"));
        this.m_cListModel = new CAllFramesDlgListModel();
        this.m_cListRenderer = new CAllFramesDlgListRenderer();
        this.m_cList = this.InitList(this.m_cListModel, this.m_cListRenderer);
        JScrollPane cScrollPane = new JScrollPane(this.m_cList);
        this.m_cOK = this.InitOKBtn();
        this.m_cCancel = this.InitCancelBtn();
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(this.GetListLabel(), -1, -2, Short.MAX_VALUE).addComponent(cScrollPane, -1, -2, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, Short.MAX_VALUE).addComponent(this.GetOKBtn(), -1, -2, -2).addComponent(this.GetCancelBtn(), -1, -2, -2)));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.GetListLabel(), -1, -2, -2).addComponent(cScrollPane, -1, -2, Short.MAX_VALUE).addGroup(layout.createParallelGroup().addComponent(this.GetOKBtn(), -1, -2, -2).addComponent(this.GetCancelBtn(), -1, -2, -2)));
    }

    private JList InitList(ListModel rModel, ListCellRenderer rRenderer) {
        JList rList = new JList(rModel);
        if (rList != null) {
            rList.setSelectionMode(0);
            rList.setCellRenderer(rRenderer);
        }
        return rList;
    }

    private JLabel GetListLabel() {
        return this.m_cListLabel;
    }

    private JList GetList() {
        return this.m_cList;
    }

    private JButton GetOKBtn() {
        return this.m_cOK;
    }

    private JButton GetCancelBtn() {
        return this.m_cCancel;
    }

    private JButton CreateButton(String sText, boolean bAddActionListener) {
        JButton rBtn = new JButton(sText);
        if (rBtn != null && bAddActionListener) {
            rBtn.addActionListener(this);
        }
        return rBtn;
    }

    private JButton InitOKBtn() {
        return this.CreateButton(CString.LoadString("IDS_OK"), true);
    }

    private JButton InitCancelBtn() {
        return this.CreateButton(CString.LoadString("IDS_CANCEL"), true);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        boolean bClose = false;
        if (event.getSource() == this.GetOKBtn()) {
            this.m_nDlgRetCode = 0;
            bClose = true;
        } else if (event.getSource() == this.GetCancelBtn()) {
            bClose = true;
        }
        if (bClose) {
            JDialog rDlg = (JDialog)SwingUtilities.getAncestorOfClass(JDialog.class, this);
            rDlg.setVisible(false);
            rDlg.dispose();
        }
    }

    public int GetDlgRetCode() {
        return this.m_nDlgRetCode;
    }

    private CAllFramesDlgListModel GetListModel() {
        return this.m_cListModel;
    }

    public void SetDockingManager(DockingManager dockManager) {
        this.m_cDockingManager = dockManager;
        if (this.GetListModel() != null) {
            this.GetListModel().SetDockingManager(dockManager);
        }
    }

    private DockingManager GetDockingManager() {
        return this.m_cDockingManager;
    }

    public void UpdateActiveFrames() {
        if (this.GetListModel() != null) {
            this.GetListModel().InitFrames();
        }
        if (this.GetListModel() != null && this.GetList() != null && this.GetDockingManager() != null) {
            DockableFrame rActiveFrame = this.GetDockingManager().getActiveFrame();
            int nSelIdx = this.GetListModel().indexOf(rActiveFrame);
            this.GetList().setSelectedIndex(nSelIdx);
        }
    }

    public DockableFrame GetSelectedFrame() {
        DockableFrame rFrame = null;
        if (this.GetList() != null && this.GetListModel() != null) {
            int nIndex = this.GetList().getSelectedIndex();
            Object obj = this.GetListModel().get(nIndex);
            if (obj instanceof DockableFrame) {
                rFrame = (DockableFrame)obj;
            }
        }
        return rFrame;
    }
}

