/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.gui.dialogs;

import com.rhinosoft.base.gui.CLanguageComboBox;
import com.rhinosoft.fvjv.gui.CClientInfo;
import com.rhinosoft.fvjv.gui.dialogs.CDialog;
import com.rhinosoft.fvjv.gui.dialogs.CDialogMainPanel;
import com.rhinosoft.fvjv.gui.dialogs.CMsgBoxMainPanel;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.strings.CString;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;

public class CBaseLoginPanel
extends CDialogMainPanel
implements ActionListener {
    public static boolean DEBUG_TRACK_DLG_SIZE;
    public static boolean DEBUG_FOCUS;
    private JLabel m_cMainMsgImage;
    private JScrollPane m_cMainMsgScroll;
    private JTextPane m_cMainMsgCtrl;
    private JLabel m_cHostLabel;
    private JTextField m_cHostField;
    private JLabel m_cPublicPortLabel;
    private JTextField m_cPublicPortField;
    private JLabel m_cUserLabel;
    private JTextField m_cUserField;
    private JLabel m_cPasswordLabel;
    private JPasswordField m_cPasswordField;
    private JLabel m_cLanguageLabel;
    private CLanguageComboBox m_cLanguageComboBox;
    private JLabel m_cIsSecureLabel;
    private JCheckBox m_cIsSecureCheckBox;
    private JButton m_cOKBtn;
    private JButton m_cCancelBtn;
    private String m_sHost;
    private long m_lPublicPort;
    private String m_sUser;
    private String m_sPassword;
    private boolean m_bIsSecure;
    private String m_sLanguageCode;
    private String m_sCountryCode;

    public CBaseLoginPanel() {
        this.InitVars();
    }

    private void InitVars() {
        this.m_sHost = null;
        this.m_lPublicPort = -1L;
        this.m_sUser = null;
        this.m_sPassword = null;
        this.m_bIsSecure = false;
        this.m_sLanguageCode = null;
        this.m_sCountryCode = null;
    }

    public void SetConnectionInfo(boolean bIsSecure, String sHost, long lPublicPort, String sUserID, String sLanguageCode, String sCountryCode) {
        this.SetIsSecure(bIsSecure);
        this.SetHost(sHost);
        this.SetPublicPort(lPublicPort);
        this.SetUser(sUserID);
        this.SetLanguage(sLanguageCode, sCountryCode);
    }

    protected JButton GetOKBtn() {
        return this.m_cOKBtn;
    }

    protected JButton GetCancelBtn() {
        return this.m_cCancelBtn;
    }

    protected JTextPane GetMainMsgCtrl() {
        return this.m_cMainMsgCtrl;
    }

    protected JLabel GetMainMsgImage() {
        return this.m_cMainMsgImage;
    }

    protected JScrollPane GetMainMsgScrollCtrl() {
        return this.m_cMainMsgScroll;
    }

    protected JLabel GetHostLabel() {
        return this.m_cHostLabel;
    }

    protected JTextField GetHostField() {
        return this.m_cHostField;
    }

    protected JLabel GetPublicPortLabel() {
        return this.m_cPublicPortLabel;
    }

    protected JTextField GetPublicPortField() {
        return this.m_cPublicPortField;
    }

    protected JLabel GetUserLabel() {
        return this.m_cUserLabel;
    }

    protected JTextField GetUserField() {
        return this.m_cUserField;
    }

    protected JLabel GetPasswordLabel() {
        return this.m_cPasswordLabel;
    }

    protected JPasswordField GetPasswordField() {
        return this.m_cPasswordField;
    }

    protected JLabel GetLanguageLabel() {
        return this.m_cLanguageLabel;
    }

    protected CLanguageComboBox GetLanguageComboBox() {
        return this.m_cLanguageComboBox;
    }

    protected JLabel GetIsSecureLabel() {
        return this.m_cIsSecureLabel;
    }

    protected JCheckBox GetIsSecureCheckBox() {
        return this.m_cIsSecureCheckBox;
    }

    public String GetHost() {
        return this.GetHost(true);
    }

    protected String GetHost(boolean bFromGUI) {
        String sHost = this.m_sHost;
        if (bFromGUI && this.GetHostField() != null) {
            sHost = this.GetHostField().getText();
        }
        return sHost;
    }

    public void SetHost(String sVal) {
        this.m_sHost = sVal;
        this.UpdateField(this.GetHostField(), this.GetHost());
    }

    public long GetPublicPort() {
        return this.GetPublicPort(true);
    }

    protected long GetPublicPort(boolean bFromGUI) {
        long lPublicPort = this.m_lPublicPort;
        if (bFromGUI && this.GetPublicPortField() != null) {
            lPublicPort = this.GetValueLong(this.GetPublicPortField().getText());
        }
        return lPublicPort;
    }

    public void SetPublicPort(long lPublicPort) {
        this.m_lPublicPort = lPublicPort;
        this.UpdateFieldLong(this.GetPublicPortField(), this.GetPublicPort());
    }

    public String GetUser() {
        return this.GetUser(true);
    }

    protected String GetUser(boolean bFromGUI) {
        String sUser = this.m_sUser;
        if (bFromGUI && this.GetUserField() != null) {
            sUser = this.GetUserField().getText();
        }
        return sUser;
    }

    public void SetUser(String sVal) {
        this.m_sUser = sVal;
        this.UpdateField(this.GetUserField(), this.GetUser());
    }

    public String GetPassword() {
        return this.GetPassword(true);
    }

    protected String GetPassword(boolean bFromGUI) {
        String sPassword = this.m_sPassword;
        if (bFromGUI && this.GetPasswordField() != null) {
            sPassword = new String(this.GetPasswordField().getPassword());
        }
        return sPassword;
    }

    public void SetPassword(String sPassword) {
        this.m_sPassword = sPassword;
        this.UpdateField(this.GetPasswordField(), this.GetPassword());
    }

    public String GetLanguageCode() {
        String sCode = "";
        if (this.GetLanguageComboBox() != null) {
            sCode = this.GetLanguageComboBox().GetLanguageCode();
        }
        return sCode;
    }

    public String GetCountryCode() {
        String sCode = "";
        if (this.GetLanguageComboBox() != null) {
            sCode = this.GetLanguageComboBox().GetCountryCode();
        }
        return sCode;
    }

    public void SetLanguage(String sLangCode, String sCountryCode) {
        if (this.GetLanguageComboBox() != null) {
            this.GetLanguageComboBox().SetSelectedLanguage(sLangCode, sCountryCode);
        }
    }

    public boolean GetIsSecure() {
        return this.GetIsSecure(true);
    }

    protected boolean GetIsSecure(boolean bFromGUI) {
        boolean bIsSecure = this.m_bIsSecure;
        if (bFromGUI && this.GetIsSecureCheckBox() != null) {
            bIsSecure = this.GetIsSecureCheckBox().isSelected();
        }
        return bIsSecure;
    }

    protected void SetIsSecure(boolean bIsSecure) {
        this.m_bIsSecure = bIsSecure;
        if (this.GetIsSecureCheckBox() != null) {
            this.GetIsSecureCheckBox().setSelected(bIsSecure);
        }
    }

    protected int GetValueInt(String sText) {
        int nValue;
        block3: {
            nValue = -1;
            if (this.IsValid(sText)) {
                try {
                    nValue = Integer.parseInt(sText);
                }
                catch (Exception e) {
                    if (!CMainFrame.DEBUG) break block3;
                    e.printStackTrace();
                }
            }
        }
        return nValue;
    }

    protected long GetValueLong(String sText) {
        long lValue;
        block3: {
            lValue = -1L;
            if (this.IsValid(sText)) {
                try {
                    lValue = Long.parseLong(sText);
                }
                catch (Exception e) {
                    if (!CMainFrame.DEBUG) break block3;
                    e.printStackTrace();
                }
            }
        }
        return lValue;
    }

    protected boolean IsValid(String sArg) {
        boolean bIsValid = false;
        if (sArg != null && !sArg.isEmpty()) {
            bIsValid = true;
        }
        return bIsValid;
    }

    protected void UpdateField(JTextField rComp, String sText) {
        if (rComp != null) {
            rComp.setText(sText);
        }
    }

    protected void UpdateFieldInt(JTextField rComp, int nVal) {
        if (rComp != null) {
            rComp.setText(Integer.toString(nVal));
        }
    }

    protected void UpdateFieldLong(JTextField rComp, long lVal) {
        if (rComp != null) {
            rComp.setText(Long.toString(lVal));
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.TrackDlgSize();
        if (event.getSource() == this.GetOKBtn()) {
            this.UpdateData(false);
            this.OnOK();
        } else if (event.getSource() == this.GetCancelBtn()) {
            this.OnCancel();
            CDialog rDlg = (CDialog)SwingUtilities.getAncestorOfClass(CDialog.class, this);
            if (rDlg != null) {
                rDlg.OnClose(2);
            }
        } else if (event.getSource() == this.GetIsSecureCheckBox()) {
            this.OnIsSecure();
        }
    }

    protected void OnOK() {
        CDialog rDlg;
        boolean bCanClose = true;
        if (bCanClose && (rDlg = (CDialog)SwingUtilities.getAncestorOfClass(CDialog.class, this)) != null) {
            rDlg.OnClose(0);
        }
    }

    protected void OnCancel() {
        if (this.GetPasswordField() != null) {
            this.GetPasswordField().setText(null);
        }
    }

    protected void UpdateData(boolean bUpdateGUI) {
        if (bUpdateGUI) {
            this.GetHostField().setText(this.GetHost(false));
            this.GetPublicPortField().setText(Long.toString(this.GetPublicPort(false)));
            this.GetUserField().setText(this.GetUser(false));
            this.GetPasswordField().setText(this.GetPassword(false));
            this.GetIsSecureCheckBox().setSelected(this.GetIsSecure(false));
        } else {
            this.SetHost(this.GetHostField().getText());
            this.SetPublicPort(this.GetValueLong(this.GetPublicPortField().getText()));
            this.SetUser(this.GetUserField().getText());
            this.SetPassword(new String(this.GetPasswordField().getPassword()));
            this.SetIsSecure(this.GetIsSecureCheckBox().isSelected());
        }
    }

    @Override
    public void OnCreate() {
        CClientInfo rClientInfo;
        super.OnCreate();
        String sMsg = String.format(CString.LoadString("IDS_LOGIN_DLG_MSG"), "FTP Voyager JV");
        this.m_cMainMsgCtrl = new JTextPane();
        if (this.GetMainMsgCtrl() != null) {
            this.GetMainMsgCtrl().setCaretPosition(0);
            this.GetMainMsgCtrl().setMargin(new Insets(5, 5, 5, 5));
            this.GetMainMsgCtrl().setBorder(null);
            this.GetMainMsgCtrl().setOpaque(false);
            this.GetMainMsgCtrl().setEditable(false);
            this.GetMainMsgCtrl().setText(sMsg);
            this.GetMainMsgCtrl().addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent rKeyEvent) {
                    CMsgBoxMainPanel rMainPanel = (CMsgBoxMainPanel)SwingUtilities.getAncestorOfClass(CMsgBoxMainPanel.class, (JComponent)rKeyEvent.getSource());
                    if (rMainPanel != null) {
                        KeyEvent rEvt = new KeyEvent(rMainPanel, 401, System.currentTimeMillis(), rKeyEvent.getModifiers(), rKeyEvent.getKeyCode(), rKeyEvent.getKeyChar());
                        rMainPanel.dispatchEvent(rEvt);
                    }
                }
            });
        }
        this.m_cMainMsgImage = new JLabel();
        if (this.GetMainMsgImage() != null) {
            this.GetMainMsgImage().setIcon(CMainFrame.GetJARImage("FTPVoyagerJV_32x32.png"));
        }
        this.m_cMainMsgScroll = new JScrollPane(this.GetMainMsgCtrl());
        if (this.GetMainMsgScrollCtrl() != null) {
            this.GetMainMsgScrollCtrl().setBorder(null);
        }
        this.m_cHostLabel = new JLabel(CString.LoadString("IDS_SAVE_LOGIN_DLG_HOST"));
        this.m_cHostField = new JTextField();
        this.UpdateField(this.GetHostField(), this.GetHost(false));
        this.m_cPublicPortLabel = new JLabel(CString.LoadString("IDS_SAVE_LOGIN_DLG_PORT"));
        this.m_cPublicPortField = new JTextField();
        this.UpdateFieldLong(this.GetPublicPortField(), this.GetPublicPort(false));
        this.m_cUserLabel = new JLabel(CString.LoadString("IDS_SAVE_LOGIN_DLG_USER_ID"));
        this.m_cUserField = new JTextField();
        this.UpdateField(this.GetUserField(), this.GetUser(false));
        String sPwordLbl = CString.LoadString("IDS_SAVE_LOGIN_DLG_ENTER_PASSWORD");
        this.m_cPasswordLabel = new JLabel(sPwordLbl);
        this.m_cPasswordField = new JPasswordField();
        this.UpdateField(this.GetPasswordField(), this.GetPassword(false));
        this.AddEscapeKeyListener(this.GetPasswordField());
        this.m_cLanguageLabel = new JLabel(CString.LoadString("IDS_SAVE_LOGIN_DLG_LANGUAGE"));
        this.m_cLanguageComboBox = new CLanguageComboBox();
        if (this.GetLanguageComboBox() != null && CMainFrame.GET_APP() != null && (rClientInfo = CMainFrame.GET_APP().GetClientInfo()) != null) {
            this.GetLanguageComboBox().SetSelectedLanguage(rClientInfo.GetLanguageCode(), rClientInfo.GetCountryCode());
        }
        this.m_cIsSecureCheckBox = new JCheckBox(CString.LoadString("IDS_SAVE_LOGIN_DLG_IS_SECURE"));
        if (this.GetIsSecureCheckBox() != null) {
            this.GetIsSecureCheckBox().setSelected(this.GetIsSecure(false));
            this.GetIsSecureCheckBox().addActionListener(this);
        }
        String sOKBtnTxt = CString.LoadString("IDS_LOGIN_DLG_BTN_OK");
        this.m_cOKBtn = new JButton(sOKBtnTxt);
        sOKBtnTxt = CString.LoadString("IDS_LOGIN_DLG_BTN_OK", false);
        this.SetBtnTxt(this.GetOKBtn(), sOKBtnTxt);
        if (this.GetOKBtn() != null) {
            this.GetOKBtn().addActionListener(this);
            this.GetOKBtn().addKeyListener(this);
            CDialog rDlg = (CDialog)SwingUtilities.getAncestorOfClass(CDialog.class, this);
            if (rDlg != null && rDlg.getRootPane() != null) {
                rDlg.getRootPane().setDefaultButton(this.GetOKBtn());
            }
            this.GetOKBtn().requestFocus();
        }
        String sCancelBtnTxt = CString.LoadString("IDS_CANCEL");
        this.m_cCancelBtn = new JButton(sCancelBtnTxt);
        sCancelBtnTxt = CString.LoadString("IDS_CANCEL", false);
        this.SetBtnTxt(this.GetCancelBtn(), sCancelBtnTxt);
        if (this.GetCancelBtn() != null) {
            this.GetCancelBtn().addActionListener(this);
            this.GetCancelBtn().addKeyListener(this);
        }
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        if (this.GetHostField() != null) {
            Dimension dimPrefSize = this.GetHostField().getPreferredSize();
            dimPrefSize.width = 300;
            JComponent[] aSizeComps = new JComponent[]{this.GetHostLabel(), this.GetHostField(), this.GetPublicPortLabel(), this.GetPublicPortField(), this.GetUserLabel(), this.GetUserField(), this.GetPasswordLabel(), this.GetPasswordField(), this.GetLanguageLabel(), this.GetLanguageComboBox(), this.GetIsSecureCheckBox()};
            for (int nIdx = 0; nIdx < aSizeComps.length; ++nIdx) {
                JComponent rComp = aSizeComps[nIdx];
                if (rComp == null) continue;
                rComp.setPreferredSize(dimPrefSize);
            }
        }
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(this.GetMainMsgImage(), -1, -2, -2).addComponent(this.GetMainMsgScrollCtrl(), -1, -2, Short.MAX_VALUE)).addComponent(this.GetHostLabel(), -1, -2, Short.MAX_VALUE).addComponent(this.GetHostField(), -1, -2, Short.MAX_VALUE).addComponent(this.GetPublicPortLabel(), -1, -2, Short.MAX_VALUE).addComponent(this.GetPublicPortField(), -1, -2, Short.MAX_VALUE).addComponent(this.GetUserLabel(), -1, -2, Short.MAX_VALUE).addComponent(this.GetUserField(), -1, -2, Short.MAX_VALUE).addComponent(this.GetPasswordLabel(), -1, -2, Short.MAX_VALUE).addComponent(this.GetPasswordField(), -1, -2, Short.MAX_VALUE).addComponent(this.GetLanguageLabel(), -1, -2, Short.MAX_VALUE).addComponent(this.GetLanguageComboBox(), -1, -2, Short.MAX_VALUE).addComponent(this.GetIsSecureCheckBox(), -1, -2, -2).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.GetOKBtn(), -1, -2, -2).addComponent(this.GetCancelBtn(), -1, -2, -2)));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(this.GetMainMsgImage(), -1, -2, -2).addComponent(this.GetMainMsgScrollCtrl(), -2, -2, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 20, 20).addComponent(this.GetHostLabel(), -1, -2, -2).addComponent(this.GetHostField(), -1, -2, -2).addComponent(this.GetPublicPortLabel(), -1, -2, -2).addComponent(this.GetPublicPortField(), -1, -2, -2).addComponent(this.GetUserLabel(), -1, -2, -2).addComponent(this.GetUserField(), -1, -2, -2).addComponent(this.GetPasswordLabel(), -1, -2, -2).addComponent(this.GetPasswordField(), -1, -2, -2).addComponent(this.GetLanguageLabel(), -1, -2, -2).addComponent(this.GetLanguageComboBox(), -1, -2, -2).addComponent(this.GetIsSecureCheckBox(), -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 20, 20).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, Short.MAX_VALUE).addGroup(layout.createParallelGroup().addComponent(this.GetOKBtn(), -1, -2, -2).addComponent(this.GetCancelBtn(), -1, -2, -2)));
        this.TrackDlgSize();
        this.RecalcLayout();
        this.TrackDlgSize();
    }

    protected void RecalcLayout() {
        CDialog rDlg = (CDialog)SwingUtilities.getAncestorOfClass(CDialog.class, this);
        if (rDlg != null) {
            rDlg.RecalcLayout();
        }
    }

    protected void TrackDlgSize() {
        JDialog dlg;
        if (DEBUG_TRACK_DLG_SIZE && (dlg = (JDialog)SwingUtilities.getAncestorOfClass(JDialog.class, this)) != null) {
            System.out.printf("Size: %d,%d | PrefSize: %d,%d\r\n", dlg.getSize().width, dlg.getSize().height, dlg.getPreferredSize().width, dlg.getPreferredSize().height);
        }
    }

    protected void PrintFocusOwner() {
        if (DEBUG_FOCUS) {
            Component cPermFocusOwner;
            Component cFocusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (cFocusOwner != null) {
                System.out.printf("FocusOwner: %s\r\n", cFocusOwner.getClass().getName());
                if (cFocusOwner instanceof JTextPane) {
                    System.out.printf("JTextPane: %s\r\n", ((JTextPane)cFocusOwner).getText());
                } else if (cFocusOwner instanceof JButton) {
                    System.out.printf("JButton: %s\r\n", ((JButton)cFocusOwner).getText());
                } else if (cFocusOwner instanceof JPasswordField) {
                    System.out.printf("JPasswordField: %s\r\n", ((JPasswordField)cFocusOwner).getText());
                }
            }
            if ((cPermFocusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner()) != null) {
                System.out.printf("PermFocusOwner: %s\r\n", cPermFocusOwner.getClass().getName());
                if (cPermFocusOwner instanceof JTextPane) {
                    System.out.printf("JTextPane: %s\r\n", ((JTextPane)cPermFocusOwner).getText());
                } else if (cPermFocusOwner instanceof JButton) {
                    System.out.printf("JButton: %s\r\n", ((JButton)cPermFocusOwner).getText());
                } else if (cFocusOwner instanceof JPasswordField) {
                    System.out.printf("JPasswordField: %s\r\n", ((JPasswordField)cPermFocusOwner).getText());
                }
            }
        }
    }

    protected void OnIsSecure() {
        this.UpdateData(false);
        if (this.GetIsSecure() && (this.GetPublicPort() < 0L || this.GetPublicPort() == 80L)) {
            this.SetPublicPort(443L);
        } else if (!(this.GetIsSecure() || this.GetPublicPort() >= 0L && this.GetPublicPort() != 443L)) {
            this.SetPublicPort(80L);
        }
        this.UpdateData(true);
    }

    static {
        if (CMainFrame.DEBUG) {
            // empty if block
        }
        DEBUG_TRACK_DLG_SIZE = false;
        if (CMainFrame.DEBUG) {
            // empty if block
        }
        DEBUG_FOCUS = false;
    }
}

