/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.gui.dialogs;

import com.rhinosoft.base.files.CFileSystemUtils;
import com.rhinosoft.fvjv.gui.dialogs.CDialog;
import com.rhinosoft.fvjv.gui.dialogs.CDialogMainPanel;
import com.rhinosoft.fvjv.gui.dialogs.CMsgBox;
import com.rhinosoft.fvjv.strings.CString;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;

public class CChangePasswordDlgMainPanel
extends CDialogMainPanel
implements ActionListener {
    private JPasswordField m_cOldPassword;
    private JPasswordField m_cNewPassword;
    private JPasswordField m_cNewPasswordEx;
    private JButton m_cOKBtn;
    private JButton m_cCancelBtn;

    public CChangePasswordDlgMainPanel() {
        this.InitVars();
    }

    private void InitVars() {
    }

    protected JPasswordField GetOldPasswordCtrl() {
        return this.m_cOldPassword;
    }

    protected JPasswordField GetNewPasswordCtrl() {
        return this.m_cNewPassword;
    }

    protected JPasswordField GetNewPasswordExCtrl() {
        return this.m_cNewPasswordEx;
    }

    protected JButton GetOKBtn() {
        return this.m_cOKBtn;
    }

    protected JButton GetCancelBtn() {
        return this.m_cCancelBtn;
    }

    @Override
    public void OnCreate() {
        super.OnCreate();
        JLabel cOldPassLabel = new JLabel(CString.LoadString("IDS_OLD_PASSWORD_LABEL"));
        JLabel cNewPassLabel = new JLabel(CString.LoadString("IDS_NEW_PASSWORD_LABEL"));
        JLabel cNewPassLabelEx = new JLabel(CString.LoadString("IDS_VERIFY_NEW_PASSWORD_LABEL"));
        this.m_cOldPassword = new JPasswordField();
        this.m_cNewPassword = new JPasswordField();
        this.m_cNewPasswordEx = new JPasswordField();
        this.AddEscapeKeyListener(this.m_cOldPassword);
        this.AddEscapeKeyListener(this.m_cNewPassword);
        this.AddEscapeKeyListener(this.m_cNewPasswordEx);
        this.m_cOKBtn = new JButton(CString.LoadString("IDS_OK"));
        this.SetBtnTxt(this.GetOKBtn(), CString.LoadString("IDS_OK", false));
        if (this.GetOKBtn() != null) {
            this.GetOKBtn().addActionListener(this);
            this.GetOKBtn().addKeyListener(this);
            CDialog rDlg = (CDialog)SwingUtilities.getAncestorOfClass(CDialog.class, this);
            if (rDlg != null && rDlg.getRootPane() != null) {
                rDlg.getRootPane().setDefaultButton(this.GetOKBtn());
            }
            this.GetOKBtn().requestFocus();
        }
        this.m_cCancelBtn = new JButton(CString.LoadString("IDS_CANCEL"));
        this.SetBtnTxt(this.GetCancelBtn(), CString.LoadString("IDS_CANCEL", false));
        if (this.GetCancelBtn() != null) {
            this.GetCancelBtn().addActionListener(this);
            this.GetCancelBtn().addKeyListener(this);
        }
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(cOldPassLabel, -1, -2, Short.MAX_VALUE).addComponent(this.GetOldPasswordCtrl(), -1, -2, Short.MAX_VALUE).addComponent(cNewPassLabel, -1, -2, Short.MAX_VALUE).addComponent(this.GetNewPasswordCtrl(), -1, -2, Short.MAX_VALUE).addComponent(cNewPassLabelEx, -1, -2, Short.MAX_VALUE).addComponent(this.GetNewPasswordExCtrl(), -1, -2, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.GetOKBtn(), -1, -2, -2).addComponent(this.GetCancelBtn(), -1, -2, -2)));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(cOldPassLabel, -1, -2, -2).addComponent(this.GetOldPasswordCtrl(), -1, -2, -2).addComponent(cNewPassLabel, -1, -2, -2).addComponent(this.GetNewPasswordCtrl(), -1, -2, -2).addComponent(cNewPassLabelEx, -1, -2, -2).addComponent(this.GetNewPasswordExCtrl(), -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup().addComponent(this.GetOKBtn(), -1, -2, -2).addComponent(this.GetCancelBtn(), -1, -2, -2)));
    }

    @Override
    public void actionPerformed(ActionEvent rEvent) {
        if (rEvent != null) {
            CDialog rDlg;
            if (rEvent.getSource() == this.GetOKBtn()) {
                boolean bOldPasswordValid = this.VerifyOldPassword(this.GetOldPassword());
                boolean bNewPasswordsValid = this.AreNewPasswordsValid();
                if (bOldPasswordValid && bNewPasswordsValid) {
                    CDialog rDlg2 = (CDialog)SwingUtilities.getAncestorOfClass(CDialog.class, this);
                    if (rDlg2 != null) {
                        rDlg2.OnClose(0);
                    }
                } else {
                    CDialog rDlg3 = (CDialog)SwingUtilities.getAncestorOfClass(CDialog.class, this);
                    CMsgBox dlg = new CMsgBox(rDlg3, true, -1L, -1, 0);
                    dlg.setTitle(CString.LoadString("IDS_CHANGE_PASSWORDS_FAILED_TITLE"));
                    if (rDlg3 != null && rDlg3.getIconImages() != null && rDlg3.getIconImages().size() > 0) {
                        dlg.setIconImage(rDlg3.getIconImages().get(0));
                    }
                    String sMainMsg = CString.LoadString("IDS_NEW_PASSWORDS_DIFFER_MSG");
                    if (!bOldPasswordValid) {
                        sMainMsg = CString.LoadString("IDS_NEED_OLD_PASSWORD_MSG");
                    }
                    dlg.SetMainMsg(sMainMsg);
                    Dimension dimSize = new Dimension(320, 120);
                    if (CFileSystemUtils.GetFileSysUtils().IsMac()) {
                        dimSize.width += 100;
                        dimSize.height += 50;
                    }
                    dlg.setPreferredSize(dimSize);
                    dlg.setResizable(false);
                    dlg.setVisible(true);
                    if (this.GetNewPasswordExCtrl() != null) {
                        this.GetNewPasswordExCtrl().selectAll();
                    }
                }
            } else if (rEvent.getSource() == this.GetCancelBtn() && (rDlg = (CDialog)SwingUtilities.getAncestorOfClass(CDialog.class, this)) != null) {
                rDlg.OnClose(2);
            }
        }
    }

    public String GetOldPassword() {
        String sRet = "";
        if (this.GetOldPasswordCtrl() != null) {
            sRet = new String(this.GetOldPasswordCtrl().getPassword());
        }
        return sRet;
    }

    public String GetNewPassword() {
        String sRet = "";
        if (this.GetNewPasswordCtrl() != null) {
            sRet = new String(this.GetNewPasswordCtrl().getPassword());
        }
        return sRet;
    }

    private boolean AreNewPasswordsValid() {
        boolean bIsValid = false;
        if (this.GetNewPasswordCtrl() != null && this.GetNewPasswordExCtrl() != null) {
            String sTemp1 = new String(this.GetNewPasswordCtrl().getPassword());
            String sTemp2 = new String(this.GetNewPasswordExCtrl().getPassword());
            bIsValid = this.VerifyNewPasswords(sTemp1, sTemp2);
        }
        return bIsValid;
    }

    private boolean VerifyOldPassword(String sOldPword) {
        return true;
    }

    private boolean VerifyNewPasswords(String sNewPword, String sVerifyPword) {
        boolean bIsValid = false;
        if (sNewPword != null && sVerifyPword != null && sNewPword.equals(sVerifyPword)) {
            bIsValid = true;
        } else if (sNewPword == null && sVerifyPword == null) {
            bIsValid = true;
        }
        return bIsValid;
    }
}

