/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.gui.dialogs;

import com.rhinosoft.base.files.CFile;
import com.rhinosoft.base.files.CPath;
import com.rhinosoft.base.gui.components.files.listing.CFileListModel;
import com.rhinosoft.base.gui.renderers.files.CFileListCellRenderer;
import com.rhinosoft.fvjv.strings.CString;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CFileTargetDlgPanel
extends JPanel
implements ListSelectionListener,
ActionListener {
    private JLabel m_cListLabel;
    private CFileListModel m_cListModel;
    private JList m_cList;
    private JLabel m_cPathLabel;
    private JTextField m_cPathField;
    private JButton m_cOK;
    private JButton m_cCancel;
    private CFileListCellRenderer m_cListRenderer;
    private String m_sTargetPath;
    private int m_nDlgRetCode;
    private boolean m_bIsLocal;

    public CFileTargetDlgPanel() {
        this.InitVars();
    }

    private void InitVars() {
        this.m_nDlgRetCode = 2;
        this.m_cListLabel = new JLabel(CString.LoadString("IDS_FILE_TARGET_DLG_LIST_LABEL"));
        this.m_cListModel = new CFileListModel(false);
        this.m_cListRenderer = new CFileListCellRenderer(true);
        this.m_cList = this.InitList(this.m_cListModel, this.m_cListRenderer);
        JScrollPane rScroll = new JScrollPane(this.m_cList);
        this.m_cPathLabel = new JLabel(CString.LoadString("IDS_FILE_TARGET_DLG_FIELD_LABEL"));
        this.m_cPathField = new JTextField();
        this.m_cOK = this.InitOKBtn();
        this.m_cCancel = this.InitCancelBtn();
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(this.GetListLabel(), -1, -2, Short.MAX_VALUE).addComponent(rScroll, -1, -2, Short.MAX_VALUE).addComponent(this.GetPathLabel(), -1, -2, Short.MAX_VALUE).addComponent(this.GetPathField(), -1, -2, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, Short.MAX_VALUE).addComponent(this.GetOKBtn(), -1, -2, -2).addComponent(this.GetCancelBtn(), -1, -2, -2)));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.GetListLabel(), -1, -2, -2).addComponent(rScroll, -1, -2, Short.MAX_VALUE).addComponent(this.GetPathLabel(), -1, -2, -2).addComponent(this.GetPathField(), -1, -2, -2).addGroup(layout.createParallelGroup().addComponent(this.GetOKBtn(), -1, -2, -2).addComponent(this.GetCancelBtn(), -1, -2, -2)));
    }

    private JList InitList(ListModel rModel, ListCellRenderer rRenderer) {
        JList rList = new JList(rModel);
        if (rList != null) {
            rList.setSelectionMode(0);
            rList.setCellRenderer(rRenderer);
            rList.addListSelectionListener(this);
        }
        return rList;
    }

    private JLabel GetListLabel() {
        return this.m_cListLabel;
    }

    private JList GetList() {
        return this.m_cList;
    }

    private CFileListModel GetModel() {
        return this.m_cListModel;
    }

    private JLabel GetPathLabel() {
        return this.m_cPathLabel;
    }

    private JTextField GetPathField() {
        return this.m_cPathField;
    }

    protected JButton GetOKBtn() {
        return this.m_cOK;
    }

    private JButton GetCancelBtn() {
        return this.m_cCancel;
    }

    private int GetTargetSize() {
        int nSize = 0;
        if (this.GetModel() != null) {
            nSize = this.GetModel().getSize();
        }
        return nSize;
    }

    private CFile GetTargetFile(int nIdx) {
        CFile fRet = null;
        if (this.GetModel() != null) {
            fRet = (CFile)this.GetModel().getElementAt(nIdx);
        }
        return fRet;
    }

    private void AddTargetDir(CFile fFile) {
        if (fFile != null) {
            if (this.GetModel() != null) {
                this.GetModel().AddFile(fFile, true);
            }
            this.m_bIsLocal = fFile.IsLocal();
        }
    }

    public void SetTargetDirs(Vector<CFile> afTargets) {
        if (afTargets != null) {
            if (this.GetModel() != null) {
                this.GetModel().RemoveAll(true);
            }
            this.m_bIsLocal = false;
            this.m_sTargetPath = null;
            this.m_nDlgRetCode = 2;
            if (this.GetPathField() != null) {
                this.GetPathField().setText("");
            }
            boolean bSelectFirstItem = false;
            Iterator<CFile> itr = afTargets.iterator();
            while (itr.hasNext()) {
                this.AddTargetDir(itr.next());
                bSelectFirstItem = true;
            }
            if (this.GetList() != null && bSelectFirstItem) {
                this.GetList().setSelectedIndex(0);
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        if (!event.getValueIsAdjusting() && event.getSource() == this.GetList()) {
            int nSelIdx = this.GetList().getSelectedIndex();
            CFile fSelFile = (CFile)this.GetModel().getElementAt(nSelIdx);
            if (fSelFile != null && this.GetPathField() != null) {
                this.GetPathField().setText(fSelFile.GetPath());
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        boolean bClose = false;
        if (event.getSource() == this.GetOKBtn()) {
            this.m_nDlgRetCode = 0;
            this.InitTargetPath();
            bClose = true;
        } else if (event.getSource() == this.GetCancelBtn()) {
            bClose = true;
        }
        if (bClose) {
            JDialog rDlg = (JDialog)SwingUtilities.getAncestorOfClass(JDialog.class, this);
            rDlg.setVisible(false);
            rDlg.dispose();
        }
    }

    private JButton CreateButton(String sText, boolean bAddActionListener) {
        JButton rBtn = new JButton(sText);
        if (rBtn != null && bAddActionListener) {
            rBtn.addActionListener(this);
        }
        return rBtn;
    }

    private JButton InitOKBtn() {
        return this.CreateButton(CString.LoadString("IDS_OK"), true);
    }

    private JButton InitCancelBtn() {
        return this.CreateButton(CString.LoadString("IDS_CANCEL"), true);
    }

    public String GetTargetPathString() {
        return this.m_sTargetPath;
    }

    public CPath GetTargetPath() {
        CPath rPath = null;
        String sPath = this.GetTargetPathString();
        if (sPath != null && !sPath.isEmpty()) {
            rPath = new CPath(sPath, true, this.m_bIsLocal);
        }
        return rPath;
    }

    public void InitTargetPath() {
        if (this.GetPathField() != null) {
            this.m_sTargetPath = this.GetPathField().getText();
        }
    }

    public int GetDlgRetCode() {
        return this.m_nDlgRetCode;
    }
}

