/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.gui.dialogs;

import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;

public class CLinkLabel
extends JLabel
implements MouseListener {
    private CMainFrame m_rMainFrame;
    private String m_sURL;

    public CLinkLabel(CMainFrame rMainFrame, String sURL) {
        this.InitVars(rMainFrame, sURL, null);
    }

    public CLinkLabel(CMainFrame rMainFrame, String sURL, String sText) {
        this.InitVars(rMainFrame, sURL, sText);
    }

    private void InitVars(CMainFrame rMainFrame, String sURL, String sText) {
        this.m_rMainFrame = rMainFrame;
        this.m_sURL = sURL;
        if (sText != null && !sText.isEmpty()) {
            this.setText(String.format("<html><A href=\"%s\">%s</A></html>", sURL, sText));
        }
        this.addMouseListener(this);
    }

    public String GetURL() {
        return this.m_sURL;
    }

    protected URL GetUsableURL() {
        try {
            return new URL(this.GetURL());
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(CLinkLabel.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private CMainFrame GetMainFrame() {
        return this.m_rMainFrame;
    }

    @Override
    public void mouseClicked(MouseEvent rMouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent rMouseEvent) {
        if (rMouseEvent != null) {
            Object rSource = rMouseEvent.getSource();
            if (this.GetURL() != null && !this.GetURL().isEmpty() && this.GetMainFrame() != null) {
                this.GetMainFrame().LaunchURL(this.GetUsableURL());
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent rMouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent rMouseEvent) {
        if (rMouseEvent != null) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        }
    }

    @Override
    public void mouseExited(MouseEvent rMouseEvent) {
        if (rMouseEvent != null) {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }
}

