/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.gui.dialogs;

import com.rhinosoft.base.CUtils;
import com.rhinosoft.base.files.CFileSystemUtils;
import com.rhinosoft.fvjv.gui.dialogs.CBaseLoginPanel;
import com.rhinosoft.fvjv.gui.dialogs.CConfirmChangePasswordFailedDlg;
import com.rhinosoft.fvjv.gui.dialogs.CConfirmLoginFailedDlg;
import com.rhinosoft.fvjv.gui.dialogs.CDialog;
import com.rhinosoft.fvjv.gui.dialogs.CMsgBox;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.net.CLogin;
import com.rhinosoft.fvjv.strings.CString;
import com.rhinosoft.fvjv.threads.CThreadMsg;
import java.awt.Dialog;
import java.awt.Dimension;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;

public class CLoginDlgMainPanel
extends CBaseLoginPanel {
    private JLabel m_cNewPasswordLabel;
    private JPasswordField m_cNewPasswordField;
    private JLabel m_cVerifyPasswordLabel;
    private JPasswordField m_cVerifyPasswordField;
    private boolean m_bIsChangeLogin;
    private CLogin m_rLogin;

    public CLoginDlgMainPanel() {
        this.InitVars();
    }

    private void InitVars() {
        this.m_rLogin = null;
        this.m_bIsChangeLogin = false;
    }

    private JLabel GetNewPasswordLabel() {
        return this.m_cNewPasswordLabel;
    }

    private JPasswordField GetNewPasswordField() {
        return this.m_cNewPasswordField;
    }

    private JLabel GetVerifyPasswordLabel() {
        return this.m_cVerifyPasswordLabel;
    }

    private JPasswordField GetVerifyPasswordField() {
        return this.m_cVerifyPasswordField;
    }

    @Override
    public void OnCreate() {
        JComponent[] aHideComps;
        super.OnCreate();
        String sMsg = String.format(CString.LoadString("IDS_LOGIN_DLG_MSG"), "FTP Voyager JV");
        if (this.IsChangeLogin()) {
            sMsg = CString.LoadString("IDS_LOGIN_DLG_CHANGE_PWORD_MSG");
        }
        if (this.GetMainMsgCtrl() != null) {
            this.GetMainMsgCtrl().setText(sMsg);
        }
        String sPwordLbl = CString.LoadString("IDS_PASSWORD_LABEL");
        if (this.IsChangeLogin()) {
            sPwordLbl = CString.LoadString("IDS_OLD_PASSWORD_LABEL");
        }
        if (this.GetPasswordLabel() != null) {
            this.GetPasswordLabel().setText(sPwordLbl);
        }
        this.m_cNewPasswordLabel = new JLabel(CString.LoadString("IDS_NEW_PASSWORD_LABEL"));
        this.m_cNewPasswordField = new JPasswordField();
        this.AddEscapeKeyListener(this.GetNewPasswordField());
        this.m_cVerifyPasswordLabel = new JLabel(CString.LoadString("IDS_VERIFY_NEW_PASSWORD_LABEL"));
        this.m_cVerifyPasswordField = new JPasswordField();
        this.AddEscapeKeyListener(this.GetVerifyPasswordField());
        String sOKBtnTxt = CString.LoadString("IDS_LOGIN_DLG_BTN_OK", false);
        if (this.IsChangeLogin()) {
            sOKBtnTxt = CString.LoadString("IDS_LOGIN_DLG_CHANGE_PWORD_OK_BTN", false);
        }
        this.SetBtnTxt(this.GetOKBtn(), sOKBtnTxt);
        String sCancelBtnTxt = CString.LoadString("IDS_CANCEL", false);
        if (this.IsChangeLogin()) {
            sCancelBtnTxt = CString.LoadString("IDS_LOGIN_DLG_CHANGE_PWORD_CANCEL_BTN", false);
        }
        this.SetBtnTxt(this.GetCancelBtn(), sCancelBtnTxt);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(false);
        if (this.GetHostField() != null) {
            Dimension dimPrefSize = this.GetHostField().getPreferredSize();
            dimPrefSize.width = 300;
            JComponent[] aSizeComps = new JComponent[]{this.GetHostLabel(), this.GetHostField(), this.GetPublicPortLabel(), this.GetPublicPortField(), this.GetUserLabel(), this.GetUserField(), this.GetPasswordLabel(), this.GetPasswordField(), this.GetNewPasswordLabel(), this.GetNewPasswordField(), this.GetVerifyPasswordLabel(), this.GetVerifyPasswordField(), this.GetLanguageLabel(), this.GetLanguageComboBox(), this.GetIsSecureCheckBox()};
            for (int nIdx = 0; nIdx < aSizeComps.length; ++nIdx) {
                JComponent rComp = aSizeComps[nIdx];
                if (rComp == null) continue;
                rComp.setPreferredSize(dimPrefSize);
            }
        }
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(this.GetMainMsgImage(), -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, -1).addComponent(this.GetMainMsgScrollCtrl(), -1, -2, Short.MAX_VALUE)).addComponent(this.GetHostLabel(), -1, -2, Short.MAX_VALUE).addComponent(this.GetHostField(), -1, -2, Short.MAX_VALUE).addComponent(this.GetPublicPortLabel(), -1, -2, Short.MAX_VALUE).addComponent(this.GetPublicPortField(), -1, -2, Short.MAX_VALUE).addComponent(this.GetUserLabel(), -1, -2, Short.MAX_VALUE).addComponent(this.GetUserField(), -1, -2, Short.MAX_VALUE).addComponent(this.GetPasswordLabel(), -1, -2, Short.MAX_VALUE).addComponent(this.GetPasswordField(), -1, -2, Short.MAX_VALUE).addComponent(this.GetNewPasswordLabel(), -1, -2, Short.MAX_VALUE).addComponent(this.GetNewPasswordField(), -1, -2, Short.MAX_VALUE).addComponent(this.GetVerifyPasswordLabel(), -1, -2, Short.MAX_VALUE).addComponent(this.GetVerifyPasswordField(), -1, -2, Short.MAX_VALUE).addComponent(this.GetLanguageLabel(), -1, -2, Short.MAX_VALUE).addComponent(this.GetLanguageComboBox(), -1, -2, Short.MAX_VALUE).addComponent(this.GetIsSecureCheckBox(), -1, -2, -2).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.GetOKBtn(), -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, -1).addComponent(this.GetCancelBtn(), -1, -2, -2)));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(this.GetMainMsgImage(), -1, -2, -2).addComponent(this.GetMainMsgScrollCtrl(), -2, -2, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 10, 10).addComponent(this.GetHostLabel(), -1, -2, -2).addComponent(this.GetHostField(), -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, -1).addComponent(this.GetPublicPortLabel(), -1, -2, -2).addComponent(this.GetPublicPortField(), -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, -1).addComponent(this.GetUserLabel(), -1, -2, -2).addComponent(this.GetUserField(), -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, -1).addComponent(this.GetPasswordLabel(), -1, -2, -2).addComponent(this.GetPasswordField(), -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, -1).addComponent(this.GetNewPasswordLabel(), -1, -2, -2).addComponent(this.GetNewPasswordField(), -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, -1).addComponent(this.GetVerifyPasswordLabel(), -1, -2, -2).addComponent(this.GetVerifyPasswordField(), -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, -1).addComponent(this.GetLanguageLabel(), -1, -2, -2).addComponent(this.GetLanguageComboBox(), -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, -1).addComponent(this.GetIsSecureCheckBox(), -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 20, 20).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, Short.MAX_VALUE).addGroup(layout.createParallelGroup().addComponent(this.GetOKBtn(), -1, -2, -2).addComponent(this.GetCancelBtn(), -1, -2, -2)));
        if (this.IsChangeLogin()) {
            aHideComps = new JComponent[]{this.GetUserLabel(), this.GetUserField(), null, null};
            if (this.GetPassword(false) != null) {
                aHideComps[2] = this.GetPasswordLabel();
                aHideComps[3] = this.GetPasswordField();
            }
            for (int nIdx = 0; nIdx < aHideComps.length; ++nIdx) {
                JComponent rComp = aHideComps[nIdx];
                if (rComp == null) continue;
                rComp.setVisible(false);
            }
        }
        aHideComps = new JComponent[]{this.GetHostLabel(), this.GetHostField(), this.GetPublicPortLabel(), this.GetPublicPortField(), this.GetLanguageLabel(), this.GetLanguageComboBox(), this.GetIsSecureCheckBox()};
        for (int nIdx = 0; nIdx < aHideComps.length; ++nIdx) {
            JComponent rComp = aHideComps[nIdx];
            if (rComp == null) continue;
            rComp.setVisible(false);
        }
        this.ShowPasswordCtrls(this.IsChangeLogin());
        if (this.IsChangeLogin()) {
            if (this.GetNewPasswordField() != null) {
                this.GetNewPasswordField().selectAll();
                this.GetNewPasswordField().requestFocusInWindow();
            }
        } else if (this.GetPasswordField() != null) {
            this.GetPasswordField().selectAll();
            this.GetPasswordField().requestFocusInWindow();
        }
        this.TrackDlgSize();
        this.RecalcLayout();
        this.TrackDlgSize();
    }

    private void ShowPasswordCtrls(boolean bShow) {
        JComponent[] aComps = new JComponent[]{this.GetNewPasswordLabel(), this.GetNewPasswordField(), this.GetVerifyPasswordLabel(), this.GetVerifyPasswordField()};
        for (int nIdx = 0; nIdx < aComps.length; ++nIdx) {
            JComponent rComp = aComps[nIdx];
            if (rComp == null) continue;
            rComp.setVisible(bShow);
        }
    }

    public void SetIsChangeLogin(boolean bIsChangeLogin) {
        this.m_bIsChangeLogin = bIsChangeLogin;
    }

    public boolean IsChangeLogin() {
        return this.m_bIsChangeLogin;
    }

    @Override
    protected void OnCancel() {
        if (this.GetNewPasswordField() != null) {
            this.GetNewPasswordField().setText(null);
        }
        if (this.GetVerifyPasswordField() != null) {
            this.GetVerifyPasswordField().setText(null);
        }
        super.OnCancel();
    }

    public String GetNewPassword() {
        String sPword = null;
        if (this.GetNewPasswordField() != null) {
            sPword = this.GetNewPasswordField().getText();
        }
        return sPword;
    }

    private boolean AreNewPasswordsValid() {
        boolean bIsValid = false;
        if (this.GetNewPasswordField() != null && this.GetVerifyPasswordField() != null) {
            String sTemp1 = new String(this.GetNewPasswordField().getPassword());
            String sTemp2 = new String(this.GetVerifyPasswordField().getPassword());
            if (sTemp1 != null && sTemp2 != null && sTemp1.equals(sTemp2)) {
                bIsValid = true;
            }
        }
        return bIsValid;
    }

    public void SetLogin(CLogin rLogin) {
        this.m_rLogin = rLogin;
    }

    protected CLogin GetLogin() {
        return this.m_rLogin;
    }

    @Override
    protected void OnOK() {
        CDialog rDlg;
        boolean bCanClose = false;
        if (this.GetLogin() != null) {
            if (this.IsChangeLogin()) {
                if (this.AreNewPasswordsValid()) {
                    int[] anRet = this.GetLogin().ChangePassword(this.GetIsSecure(false), this.GetHost(false), this.GetPublicPort(false), this.GetLogin().GetEncSessionID(), this.GetPassword(false), this.GetNewPassword(), this.GetCompressionType());
                    if (anRet != null && anRet.length == 2 && anRet[1] == 0) {
                        String sTitle = CString.LoadString("IDS_CONFIRM_CHANGE_PASSWORD_OK_TITLE");
                        String sMsg = CString.LoadString("IDS_CONFIRM_CHANGE_PASSWORD_OK_DEF_MSG");
                        JOptionPane.showMessageDialog(this, sMsg, sTitle, 1);
                        bCanClose = true;
                    } else {
                        bCanClose = false;
                        Dialog rDlg2 = (Dialog)SwingUtilities.getAncestorOfClass(Dialog.class, this);
                        CConfirmChangePasswordFailedDlg dlg = new CConfirmChangePasswordFailedDlg(rDlg2, true, -1L);
                        String sMsg = CString.LoadString("IDS_CONFIRM_CHANGE_PASSWORD_FAILED_DEF_MSG");
                        sMsg = String.format("%s\r\n\r\n%s", sMsg, CThreadMsg.GetSUError(anRet[1]));
                        dlg.SetMainMsg(sMsg);
                        String sBtnMsg = CString.LoadString("IDS_PROMPT_BTNS_WHAT_TO_DO");
                        dlg.SetBtnMsg(sBtnMsg);
                        dlg.SetDetailMsg(CThreadMsg.FormatErrorMsg(anRet[0], anRet[1]));
                        dlg.setVisible(true);
                        switch (dlg.GetExitCode()) {
                            case 0: {
                                this.OnOK();
                                break;
                            }
                        }
                        if (this.GetVerifyPasswordField() != null) {
                            this.GetVerifyPasswordField().selectAll();
                        }
                    }
                } else {
                    rDlg = (CDialog)SwingUtilities.getAncestorOfClass(CDialog.class, this);
                    CMsgBox dlg = new CMsgBox(rDlg, true, -1L, -1, 0);
                    dlg.setTitle(CString.LoadString("IDS_CHANGE_PASSWORDS_FAILED_TITLE"));
                    if (rDlg != null && rDlg.getIconImages() != null && rDlg.getIconImages().size() > 0) {
                        dlg.setIconImage(rDlg.getIconImages().get(0));
                    }
                    dlg.SetMainMsg(CString.LoadString("IDS_NEW_PASSWORDS_DIFFER_MSG"));
                    Dimension dimSize = new Dimension(320, 120);
                    if (CFileSystemUtils.GetFileSysUtils().IsMac()) {
                        dimSize.width += 100;
                        dimSize.height += 50;
                    }
                    dlg.setPreferredSize(dimSize);
                    dlg.setResizable(false);
                    dlg.setVisible(true);
                    if (this.GetVerifyPasswordField() != null) {
                        this.GetVerifyPasswordField().selectAll();
                    }
                }
            } else {
                String sPassword = this.GetPassword(false);
                if (sPassword == null) {
                    sPassword = "";
                }
                if (sPassword != null) {
                    if (this.GetLogin().Login(this.GetIsSecure(false), this.GetHost(false), this.GetPublicPort(false), this.GetUser(false), sPassword, this.GetLanguageCode(), this.GetCountryCode())) {
                        if (this.GetLogin().GetHTTPResponseCode() == 200 && (this.GetLogin().GetResult() == 0 || this.GetLogin().GetResult() == 202)) {
                            bCanClose = true;
                        } else {
                            bCanClose = false;
                            this.PrintFocusOwner();
                            Dialog rDlg3 = (Dialog)SwingUtilities.getAncestorOfClass(Dialog.class, this);
                            CConfirmLoginFailedDlg dlg = new CConfirmLoginFailedDlg(rDlg3, true, -1L);
                            String sMsg = CString.LoadString("IDS_CONFIRM_LOGIN_FAILED_DEF_MSG");
                            dlg.SetMainMsg(sMsg);
                            String sDetails = CThreadMsg.FormatErrorMsg(this.GetLogin().GetHTTPResponseCode(), this.GetLogin().GetResult());
                            dlg.SetDetailMsg(sDetails);
                            dlg.setVisible(true);
                            dlg.dispose();
                            dlg = null;
                            if (this.GetNewPasswordField() != null) {
                                this.GetNewPasswordField().selectAll();
                            }
                        }
                    } else {
                        Dialog rDlg4 = (Dialog)SwingUtilities.getAncestorOfClass(Dialog.class, this);
                        CConfirmLoginFailedDlg dlg = new CConfirmLoginFailedDlg(rDlg4, true, -1L);
                        String sMsg = CString.LoadString("IDS_CONFIRM_LOGIN_FAILED_DEF_MSG");
                        dlg.SetMainMsg(sMsg);
                        String sDetails = CThreadMsg.FormatErrorMsg(this.GetLogin().GetHTTPResponseCode(), this.GetLogin().GetResult());
                        dlg.SetDetailMsg(sDetails);
                        dlg.setVisible(true);
                        dlg.dispose();
                        dlg = null;
                    }
                }
            }
        } else if (DEBUG) {
            CUtils.ASSERT(this.getClass().getName(), CUtils.GetLineNumber(), "GetLogin() = null", true);
        }
        if (bCanClose && (rDlg = (CDialog)SwingUtilities.getAncestorOfClass(CDialog.class, this)) != null) {
            rDlg.OnClose(0);
        }
    }

    public int GetSUResult() {
        int nSUResult = 1;
        if (this.GetLogin() != null) {
            nSUResult = this.GetLogin().GetResult();
        }
        return nSUResult;
    }

    private int GetCompressionType() {
        int nCompressionType = 0;
        if (CMainFrame.GET_APP() != null) {
            nCompressionType = CMainFrame.GET_APP().GetCompressionType();
        }
        return nCompressionType;
    }
}

