/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.gui.dialogs;

import com.rhinosoft.base.files.CFileSystemUtils;
import com.rhinosoft.base.gui.CDateFormatStringVerifier;
import com.rhinosoft.base.gui.CRhinoProperties;
import com.rhinosoft.base.gui.events.CRhinoEvent;
import com.rhinosoft.fvjv.gui.dialogs.CFVJVPrefsTreePanel;
import com.rhinosoft.fvjv.gui.dialogs.CSeparator;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.strings.CString;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;

public class COptionsGeneral
extends CFVJVPrefsTreePanel
implements ActionListener {
    private JCheckBox m_cRemoveTransferedFiles;
    private CSeparator m_cDateFormattingSep;
    private JCheckBox m_cShowDST;
    private CDateFormatStringVerifier m_DateVerifier;
    private JCheckBox m_cUseDateFormat;
    private JTextField m_cDateFormat;
    private CSeparator m_cConfirmationsSep;
    private JCheckBox m_cConfirmUploadOverwrite;
    private JCheckBox m_cConfirmDownloadOverwrite;
    private JCheckBox m_cConfirmFileDelete;
    private JCheckBox m_cConfirmFolderDelete;
    private JCheckBox m_cConfirmLogout;
    private CSeparator m_cSearchSep;
    private JCheckBox m_cSearchLinkTargets;

    public COptionsGeneral(String sTitle, CMainFrame rMainFrame) {
        super(sTitle, rMainFrame);
        this.InitVars();
    }

    private void InitVars() {
        this.m_DateVerifier = new CDateFormatStringVerifier();
        SwingUtilities.updateComponentTreeUI(this);
    }

    @Override
    public void OnCreate() {
        super.OnCreate();
        this.m_cDateFormattingSep = new CSeparator();
        this.m_cConfirmationsSep = new CSeparator();
        this.m_cSearchSep = new CSeparator();
        this.m_cDateFormattingSep.setText(CString.LoadString("IDS_DATE_FORMAT_TITLE"));
        this.m_cConfirmationsSep.setText(CString.LoadString("IDS_OPTIONS_CONFIRM_PANEL"));
        this.m_cSearchSep.setText(CString.LoadString("IDS_SEARCH_MENU"));
        if (this.GetHeaderIconCtrl() != null) {
            this.GetHeaderIconCtrl().setVisible(false);
        }
        if (this.GetHeaderMsgCtrl() != null) {
            this.GetHeaderMsgCtrl().setText(String.format(CString.LoadString("IDS_OPTIONS_GENERAL_PANEL_INTRO"), "FTP Voyager JV"));
        }
        this.m_cRemoveTransferedFiles = new JCheckBox(CString.LoadString("IDS_REMOVE_TRANSFERRED_FILES"));
        this.m_cShowDST = new JCheckBox(CString.LoadString("IDS_SHOW_DST"));
        if (this.GetRemoveTransferredFilesCtrl() != null) {
            this.GetRemoveTransferredFilesCtrl().setSelected(false);
        }
        if (this.GetShowDSTCtrl() != null) {
            this.GetShowDSTCtrl().setSelected(COptionsGeneral.GetDefaultShowDST());
        }
        this.AddEscapeKeyListener(this.GetRemoveTransferredFilesCtrl());
        this.AddEscapeKeyListener(this.GetShowDSTCtrl());
        this.m_cUseDateFormat = new JCheckBox();
        if (this.GetUseDateFmtCtrl() != null) {
            Boolean bUseDateFmt;
            this.GetUseDateFmtCtrl().addActionListener(this);
            this.GetUseDateFmtCtrl().setText(CString.LoadString("IDS_USE_DATE_FORMAT"));
            if (this.GetMainFrame() != null && this.GetMainFrame().GetArchive() != null && (bUseDateFmt = this.GetMainFrame().GetArchive().GetValueBool("UseDateFormatString", false)) != null) {
                this.GetUseDateFmtCtrl().setSelected(bUseDateFmt);
            }
        }
        JLabel cDateLabel = new JLabel(CString.LoadString("IDS_DATE_FORMAT"));
        cDateLabel.setVerticalAlignment(0);
        cDateLabel.setVerticalTextPosition(0);
        this.m_cDateFormat = new JTextField();
        if (this.GetDateFmtCtrl() != null) {
            this.GetDateFmtCtrl().setAlignmentY(0.5f);
            if (this.GetDateFmtVerifier() != null) {
                this.GetDateFmtVerifier().AddWatch(this.GetDateFmtCtrl());
            }
        }
        int nEditCtrlWidth = 150;
        this.AddEscapeKeyListener(this.GetUseDateFmtCtrl());
        this.AddEscapeKeyListener(this.GetDateFmtCtrl());
        this.m_cConfirmUploadOverwrite = new JCheckBox(CString.LoadString("IDS_SHOW_CONFIRM_UPLOAD_OVERWRITE"));
        this.m_cConfirmDownloadOverwrite = new JCheckBox(CString.LoadString("IDS_SHOW_CONFIRM_DOWNLOAD_OVERWRITE"));
        this.m_cConfirmFileDelete = new JCheckBox(CString.LoadString("IDS_SHOW_CONFIRM_FILE_DELETE"));
        this.m_cConfirmFolderDelete = new JCheckBox(CString.LoadString("IDS_SHOW_CONFIRM_FOLDER_DELETE"));
        this.m_cConfirmLogout = new JCheckBox(CString.LoadString("IDS_SHOW_CONFIRM_LOGOUT_DLG"));
        if (this.GetConfirmUploadOverwriteCtrl() != null) {
            this.GetConfirmUploadOverwriteCtrl().setSelected(true);
        }
        if (this.GetConfirmDownloadOverwriteCtrl() != null) {
            this.GetConfirmDownloadOverwriteCtrl().setSelected(true);
        }
        if (this.GetConfirmFileDeleteCtrl() != null) {
            this.GetConfirmFileDeleteCtrl().setSelected(true);
        }
        if (this.GetConfirmFolderDeleteCtrl() != null) {
            this.GetConfirmFolderDeleteCtrl().setSelected(true);
        }
        if (this.GetConfirmLogoutCtrl() != null) {
            this.GetConfirmLogoutCtrl().setSelected(true);
        }
        this.AddEscapeKeyListener(this.GetConfirmUploadOverwriteCtrl());
        this.AddEscapeKeyListener(this.GetConfirmDownloadOverwriteCtrl());
        this.AddEscapeKeyListener(this.GetConfirmFileDeleteCtrl());
        this.AddEscapeKeyListener(this.GetConfirmFolderDeleteCtrl());
        this.m_cSearchLinkTargets = new JCheckBox(CString.LoadString("IDS_SEARCH_LINK_TARGETS"));
        if (this.GetSearchLinkTargets() != null) {
            this.GetSearchLinkTargets().setSelected(false);
        }
        this.AddEscapeKeyListener(this.GetSearchLinkTargets());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        cDateLabel.setPreferredSize(new Dimension(30, 20));
        this.GetDateFmtCtrl().setPreferredSize(new Dimension(50, 20));
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(this.GetTitleCtrl(), -1, -2, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.GetHeaderIconCtrl(), -1, -2, -2).addComponent(this.GetHeaderMsgCtrl(), -1, -2, Short.MAX_VALUE)).addComponent(this.GetHeaderSeparator(), -1, -2, Short.MAX_VALUE).addComponent(this.GetRemoveTransferredFilesCtrl(), -1, -2, -2).addComponent(this.m_cDateFormattingSep, -1, -2, Short.MAX_VALUE).addComponent(this.GetShowDSTCtrl(), -1, -2, -2).addComponent(this.GetUseDateFmtCtrl(), -1, -2, -2).addComponent(cDateLabel, -1, -2, Short.MAX_VALUE).addComponent(this.GetDateFmtCtrl(), -1, -2, Short.MAX_VALUE).addComponent(this.m_cConfirmationsSep, -1, -2, Short.MAX_VALUE).addComponent(this.GetConfirmUploadOverwriteCtrl(), -1, -2, -2).addComponent(this.GetConfirmDownloadOverwriteCtrl(), -1, -2, -2).addComponent(this.GetConfirmFileDeleteCtrl(), -1, -2, -2).addComponent(this.GetConfirmFolderDeleteCtrl(), -1, -2, -2).addComponent(this.GetConfirmLogoutCtrl(), -1, -2, -2).addComponent(this.m_cSearchSep, -1, -2, Short.MAX_VALUE).addComponent(this.GetSearchLinkTargets(), -1, -2, -2));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.GetTitleCtrl(), -1, -2, -2).addGap(10).addGroup(layout.createParallelGroup().addComponent(this.GetHeaderIconCtrl(), -1, -2, -2).addComponent(this.GetHeaderMsgCtrl(), -1, -2, -2)).addComponent(this.GetHeaderSeparator(), -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 5, 5).addComponent(this.GetRemoveTransferredFilesCtrl(), -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 10, 10).addComponent(this.m_cDateFormattingSep, -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 5, 5).addComponent(this.GetShowDSTCtrl(), -1, -2, -2).addComponent(this.GetUseDateFmtCtrl(), -1, -2, -2).addComponent(cDateLabel, -1, -2, -2).addComponent(this.GetDateFmtCtrl(), -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 15, 15).addComponent(this.m_cConfirmationsSep, -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 5, 5).addComponent(this.GetConfirmUploadOverwriteCtrl(), -1, -2, -2).addComponent(this.GetConfirmDownloadOverwriteCtrl(), -1, -2, -2).addComponent(this.GetConfirmFileDeleteCtrl(), -1, -2, -2).addComponent(this.GetConfirmFolderDeleteCtrl(), -1, -2, -2).addComponent(this.GetConfirmLogoutCtrl(), -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 10, 10).addComponent(this.m_cSearchSep, -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 5, 5).addComponent(this.GetSearchLinkTargets(), -1, -2, -2));
        this.LoadPage();
    }

    private JCheckBox GetSearchLinkTargets() {
        return this.m_cSearchLinkTargets;
    }

    private void LoadPage() {
        if (this.GetMainFrame() != null && this.GetMainFrame().GetArchive() != null) {
            boolean bVal;
            String sDateFmt;
            Boolean objBoolVal = null;
            objBoolVal = this.GetMainFrame().GetArchive().GetValueBool("TransferRemoveDone", false);
            if (objBoolVal != null && this.GetRemoveTransferredFilesCtrl() != null) {
                this.GetRemoveTransferredFilesCtrl().setSelected(objBoolVal);
            }
            if ((objBoolVal = this.GetMainFrame().GetArchive().GetValueBool("ShowDST", COptionsGeneral.GetDefaultShowDST())) != null && this.GetShowDSTCtrl() != null) {
                this.GetShowDSTCtrl().setSelected(objBoolVal);
            }
            if ((sDateFmt = this.GetMainFrame().GetArchive().GetValue("DateFormatString", CRhinoProperties.GetDefaultDatePattern())) != null && this.GetDateFmtCtrl() != null) {
                this.GetDateFmtCtrl().setText(sDateFmt);
            }
            if ((objBoolVal = this.GetMainFrame().GetArchive().GetValueBool("ConfirmUploadOverwrite", true)) != null && this.GetConfirmUploadOverwriteCtrl() != null) {
                this.GetConfirmUploadOverwriteCtrl().setSelected(objBoolVal);
            }
            if ((objBoolVal = this.GetMainFrame().GetArchive().GetValueBool("ConfirmDownloadOverwrite", true)) != null && this.GetConfirmDownloadOverwriteCtrl() != null) {
                this.GetConfirmDownloadOverwriteCtrl().setSelected(objBoolVal);
            }
            if ((objBoolVal = this.GetMainFrame().GetArchive().GetValueBool("ConfirmFileDel", true)) != null && this.GetConfirmFileDeleteCtrl() != null) {
                this.GetConfirmFileDeleteCtrl().setSelected(objBoolVal);
            }
            if ((objBoolVal = this.GetMainFrame().GetArchive().GetValueBool("ConfirmFolderDel", true)) != null && this.GetConfirmFolderDeleteCtrl() != null) {
                this.GetConfirmFolderDeleteCtrl().setSelected(objBoolVal);
            }
            if ((objBoolVal = this.GetMainFrame().GetArchive().GetValueBool("DoNotShowLogoutDlg", false)) != null) {
                bVal = objBoolVal;
                if (this.GetConfirmLogoutCtrl() != null) {
                    this.GetConfirmLogoutCtrl().setSelected(!bVal);
                }
            }
            if ((objBoolVal = this.GetMainFrame().GetArchive().GetValueBool("SearchLinkTargets", false)) != null) {
                bVal = objBoolVal;
                if (this.GetSearchLinkTargets() != null) {
                    this.GetSearchLinkTargets().setSelected(bVal);
                }
            }
        }
        this.UpdateDateCtrlState();
    }

    @Override
    public void SavePage() {
        super.SavePage();
        if (this.GetMainFrame() != null && this.GetMainFrame().GetArchive() != null) {
            boolean bIsSelected = false;
            if (this.GetRemoveTransferredFilesCtrl() != null) {
                bIsSelected = this.GetRemoveTransferredFilesCtrl().isSelected();
            }
            this.GetMainFrame().GetArchive().SetValue("TransferRemoveDone", bIsSelected, false);
            if (this.GetShowDSTCtrl() != null) {
                bIsSelected = this.GetShowDSTCtrl().isSelected();
            }
            this.GetMainFrame().GetArchive().SetValue("ShowDST", bIsSelected, COptionsGeneral.GetDefaultShowDST());
            if (this.GetUseDateFmtCtrl() != null) {
                this.GetMainFrame().GetArchive().SetValue("UseDateFormatString", this.GetUseDateFmtCtrl().isSelected(), false);
            }
            if (this.GetDateFmtCtrl() != null) {
                String sDateFmt = this.GetDateFmtCtrl().getText();
                if (this.GetDateFmtVerifier() != null && this.GetDateFmtVerifier().verify(this.GetDateFmtCtrl())) {
                    this.GetMainFrame().GetArchive().SetValue("DateFormatString", sDateFmt, CRhinoProperties.GetDefaultDatePattern());
                }
            }
            if (this.GetConfirmUploadOverwriteCtrl() != null) {
                bIsSelected = this.GetConfirmUploadOverwriteCtrl().isSelected();
            }
            this.GetMainFrame().GetArchive().SetValue("ConfirmUploadOverwrite", bIsSelected, true);
            if (this.GetConfirmDownloadOverwriteCtrl() != null) {
                bIsSelected = this.GetConfirmDownloadOverwriteCtrl().isSelected();
            }
            this.GetMainFrame().GetArchive().SetValue("ConfirmDownloadOverwrite", bIsSelected, true);
            if (this.GetConfirmFileDeleteCtrl() != null) {
                bIsSelected = this.GetConfirmFileDeleteCtrl().isSelected();
            }
            this.GetMainFrame().GetArchive().SetValue("ConfirmFileDel", bIsSelected, true);
            if (this.GetConfirmFolderDeleteCtrl() != null) {
                bIsSelected = this.GetConfirmFolderDeleteCtrl().isSelected();
            }
            this.GetMainFrame().GetArchive().SetValue("ConfirmFolderDel", bIsSelected, true);
            if (this.GetConfirmLogoutCtrl() != null) {
                bIsSelected = this.GetConfirmLogoutCtrl().isSelected();
            }
            this.GetMainFrame().GetArchive().SetValue("DoNotShowLogoutDlg", !bIsSelected, false);
            if (this.GetSearchLinkTargets() != null) {
                bIsSelected = this.GetSearchLinkTargets().isSelected();
            }
            this.GetMainFrame().GetArchive().SetValue("SearchLinkTargets", bIsSelected, false);
        }
    }

    public static boolean GetDefaultShowDST() {
        boolean bDefault = false;
        if (CFileSystemUtils.GetFileSysUtils().IsWindows()) {
            bDefault = true;
        }
        return bDefault;
    }

    private JCheckBox GetRemoveTransferredFilesCtrl() {
        return this.m_cRemoveTransferedFiles;
    }

    private JCheckBox GetShowDSTCtrl() {
        return this.m_cShowDST;
    }

    protected JTextField GetDateFmtCtrl() {
        return this.m_cDateFormat;
    }

    protected JCheckBox GetUseDateFmtCtrl() {
        return this.m_cUseDateFormat;
    }

    private CDateFormatStringVerifier GetDateFmtVerifier() {
        return this.m_DateVerifier;
    }

    protected JCheckBox GetConfirmUploadOverwriteCtrl() {
        return this.m_cConfirmUploadOverwrite;
    }

    protected JCheckBox GetConfirmDownloadOverwriteCtrl() {
        return this.m_cConfirmDownloadOverwrite;
    }

    protected JCheckBox GetConfirmFileDeleteCtrl() {
        return this.m_cConfirmFileDelete;
    }

    protected JCheckBox GetConfirmFolderDeleteCtrl() {
        return this.m_cConfirmFolderDelete;
    }

    protected JCheckBox GetConfirmLogoutCtrl() {
        return this.m_cConfirmLogout;
    }

    @Override
    public boolean ValidatePage() {
        boolean bIsValid = false;
        if (this.GetDateFmtVerifier() != null && this.GetDateFmtVerifier().verify(this.GetDateFmtCtrl())) {
            bIsValid = true;
        }
        return bIsValid;
    }

    @Override
    public void OnHelp() {
        if (this.GetMainFrame() != null) {
            String[] asInfo = new String[]{"Help-Dlg-Prefs-General.htm", "none"};
            CRhinoEvent rEvent = new CRhinoEvent(this.GetMainFrame(), 7000, asInfo);
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(rEvent);
        }
    }

    @Override
    public void actionPerformed(ActionEvent rActionEvent) {
        if (rActionEvent != null && rActionEvent.getSource() == this.GetUseDateFmtCtrl()) {
            this.UpdateDateCtrlState();
        }
    }

    private void UpdateDateCtrlState() {
        if (this.GetUseDateFmtCtrl() != null && this.GetDateFmtCtrl() != null) {
            this.GetDateFmtCtrl().setEnabled(this.GetUseDateFmtCtrl().isSelected());
        }
    }
}

