/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.gui.dialogs;

import com.rhinosoft.base.files.CFile;
import com.rhinosoft.base.files.CFileSystemUtils;
import com.rhinosoft.fvjv.gui.dialogs.CDialog;
import com.rhinosoft.fvjv.gui.dialogs.CDialogMainPanel;
import com.rhinosoft.fvjv.gui.dialogs.CPropertiesDlgMainPanel;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.strings.CString;
import java.awt.Dimension;
import java.awt.Frame;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class CPropertiesDlg
extends CDialog {
    public CPropertiesDlg(Frame wndOwner, boolean bIsModal, CFile[] afFiles) {
        super(wndOwner, bIsModal, -1L);
        this.InitVars(afFiles);
    }

    private void InitVars(CFile[] afFiles) {
        if (afFiles != null) {
            for (int nIdx = 0; nIdx < afFiles.length; ++nIdx) {
                CFile fNext = afFiles[nIdx];
                this.AddFile(fNext);
            }
        }
    }

    @Override
    protected CDialogMainPanel CreateMainPanel() {
        return new CPropertiesDlgMainPanel();
    }

    @Override
    public CPropertiesDlgMainPanel GetMainPanel() {
        CPropertiesDlgMainPanel rRet = null;
        CDialogMainPanel rMainPanel = super.GetMainPanel();
        if (rMainPanel instanceof CPropertiesDlgMainPanel) {
            rRet = (CPropertiesDlgMainPanel)rMainPanel;
        }
        return rRet;
    }

    @Override
    protected Dimension CreateInitialSize() {
        return new Dimension(380, 375);
    }

    private void AddFile(CFile fFile) {
        if (this.GetMainPanel() != null) {
            CFile fFirstFile;
            this.GetMainPanel().AddFile(fFile);
            String sWndTitle = CString.LoadString("IDS_FILE_PROPS_DLG_TITLE_MULTIPLE");
            Icon icoWndIcon = null;
            if (CMainFrame.GET_APP() != null) {
                icoWndIcon = CMainFrame.GET_APP().GetJarImage("CheckFile.png");
            }
            if (this.GetMainPanel().GetFileCount() > 0 && this.GetMainPanel().GetFileCount() == 1 && (fFirstFile = this.GetMainPanel().GetFile(0)) != null) {
                sWndTitle = String.format(CString.LoadString("IDS_FILE_PROPS_DLG_TITLE_FILE"), fFirstFile.GetDisplayName());
                icoWndIcon = fFirstFile.GetIcon16();
            }
            this.setTitle(sWndTitle);
            if (icoWndIcon != null) {
                this.setIconImage(new ImageIcon(CFileSystemUtils.GetFileSysUtils().IconToImage(icoWndIcon)).getImage());
            }
        }
    }

    @Override
    protected void OnCreate() {
        super.OnCreate();
    }

    @Override
    public void OnClose(int nExitCode) {
        boolean bCanExit = true;
        if (nExitCode == -1 && this.GetMainPanel() != null) {
            bCanExit = this.GetMainPanel().ValidatePage();
        }
        if (bCanExit) {
            super.OnClose(nExitCode);
        }
    }
}

